interrupt	equ	0feh	;interrupt for this function manager
dos		equ	021h	;ms-dos interrupt
fcb_1		equ	05ch	;location of default fcb
fcb_2		equ	06ch	;second default
command_line	equ	080h	;command line
false		equ	000h
true		equ	0ffh
;
direct_cin	equ	07h	;direct console input
disp_string	equ	09h	;display string
parse		equ	29h	;parse file name
set_memory	equ	4ah	;modify memory allocation for this task
exec		equ	4bh	;exec system call for load child process
finish		equ	4ch	;terminate program
current_disk	equ	19h	;find current selected disk
select_disk	equ	0eh	;select drive

	code segment
	assume cs:code,ds:code,es:code,ss:code
	org 100h
start:	jmp	entry_point
;
;data area
;
pathname	db	'DISK.OVL',0,0,0,0,0
		
d_copy		db	'DISKCOPY.COM',0,0,0,0,0,0
block_b		db	' B: B: ',13,10,0,0,0,0,0,0
block_a		db	' A: A: ',13,10,0,0,0,0,0,0

replace_disk	db	27,'E','Insert disk containing DISK.OVL and press space bar to continue.',13,10,'$'
memory_err	db	'memory arena trashed',13,10,'$'
err_memory	db	'Not enough memory to load program.',13,10,'$'
err_file	db	'File DISK.OVL not found on default drive.',13,10,'$'
err_environment	db	'Assigned program is not of executable format',13,10,'$'
loading		db	'Loading program ...',13,10,'$'

flag		db 	0

block	dw	0
	dw	0080h

mseg1	dw	?
	dw	5ch
mseg2	dw	?
	dw	6ch
mseg3	dw	?
;
;%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
;stack area
;
	dw	100 dup(?)		;reserve a stack segment
stak:	dw	10  dup (0)		;insurance agains stak under run
;
	
entry_point:
	cli				;turn off interrupts
	mov	sp,offset stak
	sti
;set up memory
	mov 	bx,offset last_address	;calculate memory required for this job
	shr	bx,1
	shr	bx,1
	shr	bx,1
	shr	bx,1
	inc	bx			;force next highest para
	mov	ah,set_memory		;now set our min memory requirements
	int	dos
	jnc	mem
	mov	dx,offset memory_err
	mov	ah,disp_string
	int	dos
	jmp	abort
;
mem:
	mov	bp,0h
	mov	al,flag
	cmp	al,1
	je	mess
	mov	byte ptr command_line[bp],0	;if first time give 0
	jmp	begin				;else give disk a 1

mess:
	mov	ah,disp_string
	mov	dx,offset loading
	int	dos
	mov	byte ptr command_line[bp],1
	
begin:
	mov 	ax,cs
	mov 	mseg1,ax
	mov 	mseg2,ax
	mov 	mseg3,ax
	mov	dx,offset pathname
	mov	bx,offset block
	mov	ah,exec
	mov	al,0			;set load and go option
	int	dos
	jnc	check_return
	cmp	ax,8			;not enough memory test
	jne	l_error_1
	mov	dx,offset err_memory
	mov	ah,disp_string
	int	dos
	jmp	load_ok
l_error_1:
	cmp	ax,2			;file not found test
	jne	l_error_2

	mov	al,flag			;is it first time
	cmp 	al,1
	jne	first_time

	mov	ah,disp_string		;if not first time replace disk
	mov	dx,offset replace_disk
	int	dos

 	mov	ah,7
	int	dos
	jmp	mem

first_time:
	mov	dx,offset err_file
	mov	ah,disp_string
	int	dos
	jmp	load_ok

l_error_2:				;must be bad evironment by defaul
	mov	dx,offset err_environment
	mov	ah,disp_string
	int	dos
	jmp	load_ok
;

check_return:
	mov	al,1
	mov	flag,al
	mov	al,0
	mov	ah,4dh
	int	dos			;if child returns 0 then exit
	cmp	al,1
	je	drive_a		;decide what disk wants to do
	cmp	al,2
	je	drive_b
	jmp	load_ok

drive_b:
	mov	bp,0
	mov	byte ptr fcb_1[bp],2
	mov	byte ptr fcb_2[bp],2
	jmp	do_exec
drive_a:
	mov	bp,0
	mov	byte ptr fcb_1[bp],1
	mov	byte ptr fcb_2[bp],1

do_exec:
	mov	ah,disp_string
	mov	dx,offset loading
	int	dos

	mov	bx,offset block
	mov	dx,offset d_copy
	mov	ah,exec
	mov	al,0			;set load and go option
	int	dos
	jmp     mem

load_ok:
	push	cs			;restore ds in case trashed by exec
	pop	ds
	push	cs
	pop	es
abort:	
	mov	ah,finish
	int	dos

;
last_address:
code	ends
	end start

