;	MSBASIC COMPILER TO GSX GRAPHICS INTERFACE PROGRAM
;
; REVISED:-
;	11/10/84
;	TO RESOLVE PROBLEMS DUE TO INSUFFICIENT STACK IN PROGRAMS
;	COMPILED WITH MSBASIC COMPILER.
;
;		PROVIDES FOR COMMUNICATION WITH GSX FROM COMPILED
;		BASIC USING CALLS TO 'GSX'
;		FORMAT:
;
;	CALL GSX(ARRAY1,ARRAY2,ARRAY3,ARRAY4,ARRAY5)
;

STAKSIZE	EQU	1024

;	MSBASIC COMPILER DOES NOT HAVE SUFFICIENT STACK FOR SOME GSX 
;	OPERATIONS SO A TEMPORARY STACK HAS BEEN IMPLEMENTED IN THIS
;	MODULE. THE EQUATE STAKSIZE ABOVE DETERMINES THE SIZE OF THE
;	TEMPORARY STACK. IF YOUR MEMORY LIMITS ARE TIGHT, THEN TRY 
;	DECREASING STAKSIZE (BUT DON'T FORGET TO RETEST YOUR PROGRAM
;	AFTERWARDS).
;
;	IF YOU ARE USING A COMPILER VERSION WHICH ALLOCATES SUFFICIENT
;	STACK SPACE (ie MICROSOFT BUSINESS BASIC), OR ARE NOT CHANGING
;	WORKSTATIONS DURING YOUR PROGRAM (OPEN WORKSTATION BEING THE
;	MOST STACK CONSUMING CALL TO GSX IF THE SPECIFIED DRIVER IS
;	DIFFERENT TO THE CURRENT ONE), THEN TRY REMOVING THE LINES OF
;	CODE COMMENTED ';*' BELOW TO SAVE MEMORY.

	EXTRA	SEGMENT PUBLIC 'EXTRA'
	EXTRA	ENDS

	STACK	SEGMENT PUBLIC 'STACK'
	STACK	ENDS

	DATA	SEGMENT	PUBLIC 'DATA'
	DATA	ENDS

	CODE	SEGMENT	PUBLIC 'CODE'

ASSUME	CS:CODE,DS:DATA,ES:EXTRA,SS:STACK
;
	PUBLIC	GSX
GSX	PROC	FAR
;
;	STACK ON ENTRY:
;			SP -> | RET OFFSET  |
;			    2 | RET SEGMENT |
;	 		    4 | ARRAY 5 OFF |
;			    6 | ARRAY 4 OFF |
;			    8 | ARRAY 3 OFF |
;			   10 | ARRAY 2 OFF |
;			   12 | ARRAY 1 OFF |
;
BEGIN:	PUSH	BP
	MOV	BP,SP			; POINT INTO STACK
	PUSH	AX			; SAVE THE WORLD
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI	
	PUSH	DS			; SAVE REGS
	PUSH	ES
	MOV	SI,DS			; SAVE DS IN SI
	MOV	AX,CS			; SET UP DS
	MOV	DS,AX

	MOV	BX,OFFSET ARRAY		; OFFSET OF TABLE FROM START
	MOV	DX,BX			; SAVE IN DX FOR GSX
	ADD	BP,14			; POINT TO ARRAY 1 OFFSET ON STACK
	MOV	CX,5			; FIVE POINTERS TO CONSTRUCT
SETUP:	MOV	AX,[BP]			; GET ARRAY OFFSET
	MOV	[BX],AX			; COPY INTO TABLE
	DEC	BP
	DEC 	BP			; POINT TO NEXT STACK ENTRY
	INC	BX
	INC 	BX			; SET-UP SEGMENT ADDRESS
	MOV	[BX],SI			; USING OLD DS SAVED IN SI
	INC	BX
	INC	BX			; BUMP TO NEXT ENTRY
	LOOP	SETUP			; FILL TABLE
	MOV	CX,473H			; GSX COMMAND

	CLI				;* SWITCH TO LOCAL STACK
	MOV	AX,SS			;*
	MOV	CS:WORD PTR OLDSS,AX	;*
	MOV	CS:WORD PTR OLDSP,SP	;*
	MOV	SP,OFFSET STAKTOP	;*
	MOV	AX,CS			;*
	MOV	SS,AX			;*
	STI				;*

	INT	224			; GO TO GSX

	CLI				;* BACK TO BASIC STACK
	MOV	AX,CS:WORD PTR OLDSS	;*
	MOV	SS,AX			;*
	MOV	SP,CS:WORD PTR OLDSP	;*
	STI				;*

	POP	ES
	POP	DS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POP	BP
	RET	10
;
GSX	ENDP
;
ARRAY	DW 10  DUP(0)			; ARRAY POINTERS FOR GSX

GSXSTAK	DW STAKSIZE DUP(0)		;* LOCAL STACK
STAKTOP:				;*
	DW 10	DUP(0)			;* IN CASE OF STACK OVER-RUN

OLDSS	DW	0			;* SAVE AREA FOR OLD STACK WHILST IN GSX
OLDSP	DW	0			;*

;

CODE	ENDS
	END	BEGIN

