
PAGE 66,132
TITLE XTPOR.ASM - TRANSPORTER INPUT/OUTPUT PORT ROUTINES
INCLUDE LEGAL.INC

;*	XTPOR.ASM - TRANSPORTER INPUT/OUTPUT ROUTINES
;
;	This module contains two routines to read/write a byte of data to the
;	transporter.  These "buffer" routines can be re-written to be able to
;	read/write I/O mapped or Memory mapped I/O depending on the type of card
;
;			MODULE HISTORY RECORD
;
; VER	DATE		AUTHOR		DESCRIPTION
;
; 1A	12/12/83	R MITCHELL	FIRST RELEASE

		NAME	XTPOR

		EXTRN	XTSEG:WORD

		PUBLIC	XTPORRD
		PUBLIC	XTPORWT

PORTIO	EQU	1

PAGE

PGROUP		GROUP	PROG


STACK		STRUC
		DW	?
		DW	?
PORT		DW	?
CHAR		DW	?
STACK		ENDS

PAGE
PROG	SEGMENT	BYTE	PUBLIC 'PROG'

	ASSUME	CS:PGROUP,ES:NOTHING

;*
;	 This procedure outputs a byte of data to the transporter through
;	 the port address provided.
;
;	 The call is   data = XTPORRD (port)
;
;	 where data = The returned data from the card
;	       port = The port address of the card

XTPORRD	PROC	NEAR

	PUSH	BP
	MOV	BP,SP

IFDEF PORTIO

	MOV	DX,[BP].PORT
	IN	AL,DX			; read the I/O port
	XOR	AH,AH

ELSE

;	 Memory mapped I/O is used

	PUSH	ES
	MOV	AX,XTSEG
	MOV	ES,AX

	XOR	AX,AX
	MOV	DI,[BP].PORT
	MOV	AL,ES:[DI]
	POP	ES

ENDIF

	POP	BP
	RET				; return in AL the data
XTPORRD	ENDP
PAGE
;*
;	This procedure writes a byte of data to the transporter via the port
;	address provided.
;
;	XTPORWT (port, data)
;	where port = The port address of the transporter
;	      data = the data byte to be output

XTPORWT	PROC	NEAR

	PUSH	BP
	MOV	BP,SP

IFDEF PORTIO

	MOV	DX,[BP].PORT		; Write to I/O ports
	MOV	AX,[BP].CHAR
	OUT	DX,AL

ELSE

	PUSH	ES
	MOV	AX,XTSEG
	MOV	ES,AX
	MOV	AX,[BP].CHAR
	MOV	DI,[BP].PORT		; write to memory
	MOV	ES:[DI],AL
	POP	ES

ENDIF

	POP	BP
	RET
XTPORWT	ENDP
PROG	ENDS
	END
