

PAGE 62,132
TITLE XTTIM.ASM - TRANSPORTER DRIVER CLOCK ROUTINES
INCLUDE LEGAL.INC

;*	XTTIM.ASM - TRANSPORTER DRIVER CLOCK ROUTINES
;
;	This module contains three routines, one for initialising the hardware
;	and the other two are entry points for interrupts.  XTCLK sets the clock
;	vector to point to the intercept routine NETCLK, which decrements the
;	variable XTTIM every clock tick and then passes control to the timeout
;	clock service routine.  Another function of this module is to enable any
;	of the LAN hardware and its interrupts.
;

;		MODULE HISTORY
;
; VER	DATE		AUTHOR		DESCRIPTION
;
; 2A	28/03/85	R MITCHELL	REMOVED THE HWR INDEPENDANT CODE
; 2B	18/04/85	R MITCHELL	IBM VERSION

		NAME	XTTIM

		EXTRN	XPINT:NEAR		; LAN ISR
		EXTRN	VGTIM:NEAR		; Time-out procedure

		EXTRN	XTSTKTIM:WORD		; tempory stack pointer

PAGE
;*
;	 Local Equates

CLOCKINT	EQU	01CH			; clock interrupt
LANINT		EQU	0AH			; LAN interrupt
HALFSEC		EQU	10			; No. of ticks per 1/2 second
IBMDISABLE	EQU	588			; interrupt disable of transporter
IBMCLEAR	EQU	589			; clear interrupt
IBMENABLE	EQU	590			; interrupt enable
IBMSTATUS	EQU	591			; interrupt status

INTMASK		EQU	0FBH			; interrupt level
PICCMD		EQU	20H			; 8259 PIC addresses
PICMASK		EQU	21H
SPECEOI		EQU	62H			; specific EOI for IRQ2

;*
;	 PUBLIC declarations

		PUBLIC	XTCLK
		PUBLIC	READYBIT
		PUBLIC	XTPSREAD
		PUBLIC	XTPSWRIT
		PUBLIC	XTPSTROB
		PUBLIC	XTPBREAD
		PUBLIC	XTPWLOCT
		PUBLIC	XTPWHICT
		PUBLIC	XTPRSTAT
		PUBLIC	XTSEG			; used for memory mapped I/O

DGROUP		GROUP	DATA
PGROUP		GROUP	PROG

DATA	SEGMENT	WORD	PUBLIC	'DATA'

	ASSUME	DS:DGROUP

;	 Omninet Port Addresses

XTPRSTAT	DW	584			; status port
XTPBREAD	DW	585			; read RAM
XTPSREAD	DW	587			; read RAM with increment
XTPSTROB	DW	585			; strobe port CAR
XTPWHICT	DW	584			; high counter
XTPWLOCT	DW	586			; low counter
XTPSWRIT	DW	587			; write RAM with increment
READYBIT	DW	080H			; ready line bit mask
XTSEG		DW	?			; initialise this to the segment
						; of the memory address if memory
						; mapped I/O is used 
TSSAVE	DW	?
TSPAVE	DW	?				; save users stack
DATA	ENDS

PAGE
PROG	SEGMENT	BYTE	PUBLIC 'PROG'

	ASSUME	CS:PGROUP,DS:DGROUP

XTNEXTV		DD	?		; address of next ISR in the chain
XTNEXTC		DD	?		; address of next clock ISR
XTTIM		DB	?		; timer

;	 This swaps the clock vector to point to the intercept routine below

XTCLK	PROC	NEAR

	PUSH	DS
	PUSH	ES

	MOV	CS:XTTIM, HALFSEC		; set off the timer

	MOV	AX, 3500H + CLOCKINT
	INT	21H				; get current clock vector
	MOV	WORD PTR CS:[XTNEXTC],BX	; remember old ISR clock address
	MOV	WORD PTR CS:[XTNEXTC+2],ES

	MOV	AX, 2500H + CLOCKINT
	PUSH	CS
	POP	DS	
	LEA	DX,NETCLK			; offset of new clock entry point
	INT	21H				; set our clock vector

	CLI					; disable ints. for this bit
	MOV	AX, 2500H + LANINT
	PUSH	CS
	POP	DS	
	LEA	DX,XTINT			; offset of LAN entry point
	INT	21H				; set our clock interrupt vector

	MOV	DX, IBMENABLE
	OUT	DX, AL				; enable the transporter

	MOV	DX, PICMASK
	IN	AL, DX				; read mask register of PIC
	AND	AL, INTMASK
	OUT	DX, AL				; enable interrupt on PIC
	STI
	POP	ES
	POP	DS
	RET
XTCLK	ENDP
PAGE
;*
;	 Hardware interrupt entry points these call a general ISR routine

XTINT:
	PUSH	AX
	PUSH	DX
	MOV	DX, IBMCLEAR
	OUT	DX, AL				; clear the interrupt on transporter
	MOV	AX, SPECEOI
	MOV	DX, PICCMD
	OUT	DX, AL				; clear the PIC
	CALL	XPINT				; call ISR
	POP	DX
	POP	AX
	IRET

;	JMP	DWORD PTR CS:XTNEXTV		; chain on to next ISR

;
;	 The new entry point for the clock ISR.
;	 This decrements the timer on time-out tell the upper layers of time-out

NETCLK:
	CMP	CS:XTTIM, 0
	JBE	CLK020				; jump every 1/2 second
	DEC	CS:XTTIM			; reduce counter

CLK010:
	CALL	XPINT				; sweep up in case ints are missed
	JMP	DWORD PTR CS:XTNEXTC		; chain to next clock ISR

CLK020:
	MOV	CS:XTTIM, HALFSEC		; reset timer
	PUSH	AX
	PUSH	DS
	MOV	AX, DGROUP
	MOV	DS, AX
	MOV	TSSAVE, SS			; set up temporary stack
	MOV	TSPAVE, SP
	MOV	SS, AX
	MOV	SP, XTSTKTIM
	PUSH	BP
	PUSH	ES
	MOV	ES, AX				; set ES to dgroup
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	CX
	PUSH	BX
	CALL	VGTIM				; inform of time-out
	POP	BX
	POP	CX
	POP	DX
	POP	SI
	POP	DI
	POP	ES
	POP	BP
	MOV	SS, TSSAVE
	MOV	SP, TSPAVE			; restore stack
	POP	DS
	POP	AX
	JMP	CLK010

PROG	ENDS
	END

