
PAGE 62,132
TITLE YTMOD.ASM - TRANSPORTER HARDWARE ROUTINES
INCLUDE LEGAL.INC

;*	YTMOD.ASM - TRANSPORTER HARDWARE ROUTINES
;
;	These procedures provide the basic routines to read and write data to
;	the transporter. 
;
;		MODULE HISTORY
;
; VER	DATE		AUTHOR		DESCRIPTION
;
; 1A	2/12/83		R MITCHELL	FIRST RELEASE

		NAME	YTMOD

		PUBLIC	YTREAD
		PUBLIC	YTWRIT
		PUBLIC	YTSETP

		EXTRN	XTPSWRIT:WORD
		EXTRN	XTPWLOCT:WORD
		EXTRN	XTPWHICT:WORD
		EXTRN	XTPSREAD:WORD
		EXTRN	XTPBREAD:WORD

PAGE
;*
;	 Local Equates and Structures

YTSTK		STRUC
		DW	?
		DW	?
YTSIZ		DW	?
YTADDR		DD	?
YTSTK		ENDS

SETPSTK		STRUC
		DW	?
		DW	?
HI_DATA		DW	?
LO_DATA		DW	?
SETPSTK		ENDS

PAGE

DGROUP		GROUP	DATA
PGROUP		GROUP	PROG

DATA		SEGMENT	WORD	PUBLIC 'DATA'
		ASSUME	DS:DGROUP

DATA		ENDS
PAGE

PROG	SEGMENT	BYTE	PUBLIC 'PROG'

	ASSUME	CS:PGROUP,DS:DGROUP

;*
;	 YT ROUTINES - YTREAD reads from the omninet card. the pointers addressing
;			the RAM must have been set by a YTSETP
;
;	 The procedure call is YTREAD (amount, address)
;
;	 where amount (word) = The length of data to transfer
;	       address (pointer) = A 32 bit address of where the data is

YTREAD	PROC	NEAR

	PUSH	BP
	MOV	BP,SP
	PUSH	ES

	LES	DI, [BP].YTADDR		; buffer address
	MOV	CX, [BP].YTSIZ		; amount of data
	JCXZ	RD020
	MOV	DX, XTPSREAD		; string read port
	CLD

RD010:
	IN	AL, DX			; read the data
	STOSB				; put in the buffer
	LOOP	RD010			; keep going until done

RD020:
	POP	ES
	POP	BP
	RET
YTREAD	ENDP
PAGE
;*
;	 YTWRIT - This procedure writes the data into the transporter RAM at
;		  the address set up by the call to YTSETP.
;
;	 The procedure call is YTWRIT (amount, address)
;
;	 where amount (word) = The length of data to transfer
;	       address (pointer) = A 32 bit address of where the data is

YTWRIT	PROC	NEAR

	PUSH	BP
	MOV	BP,SP
	PUSH	DS

	LDS	SI, [BP].YTADDR		; buffer address
	MOV	CX, [BP].YTSIZ		; amount of data
	JCXZ	WT020
	MOV	DX, ES:XTPSWRIT		; string write
	CLD

WT010:
	LODSB				; get the data
	OUT	DX, AL			; write the data
	LOOP	WT010			; keep going until done

WT020:
	POP	DS
	POP	BP
	RET
YTWRIT	ENDP
PAGE
;*
;	 YTSETP - This module sets the address counter on the transporter
;		  This is the start address in the transporter RAM from
;		  which the data is read or written.
;
;		The input parameters are YTSETP (hi, lo)
;
;		where  hi (byte) = the high part of the address into the RAM
;		       lo (byte) = the low part of the address

YTSETP	PROC	NEAR

	PUSH	BP
	MOV	BP, SP
	MOV	AX, [BP].LO_DATA
	MOV	DX, XTPWLOCT
	OUT	DX, AL			; output the low address

	MOV	AX, [BP].HI_DATA
	MOV	DX, XTPWHICT
	OUT	DX, AL			; output the high address
	MOV	SP, BP
	POP	BP
	RET
YTSETP	ENDP
PROG	ENDS
	END

