page	60, 132
Title	MS-DOS 3 Interface library for file handling in Compiled Basic
Subttl	(C) Copyright ACT (U.K.) Ltd. 1985			V3.1
name	DOS
Comment	+

	The following routines have been written to allow users of
	Compiled Microsoft Basic to access files on Point 32 systems
	safely.

	The routines shoud be used in place of the standard OPEN,
	GET, PUT and CLOSE verbs for relative (random) files.

	The routines are made freely available in order that software
	writers can get on with developing the logic of their software
	instead of getting bogged down in the low-level stuff.

	If, however, the routines don't quite suit your way of 
	working, or your language, then you are welcome to make
	changes to these routines, or use them as a model for your
	version.

	ACT makes no representations or warranties with respect to 
	the contents hereof and specifically disclaims any implied
	warranties of merchantability or fitness of these routines 
	for any particular purpose.

	It is the responsibility of the user of these routines to
	determine their applicability for their purpose. They are
	however, believed to be in a usable state.

	Amendment History:
		V1.0	Original version.
		V1.1	Remove Interrupt 24h handler, use LEA instead
			of OFFSET.
		V2.0	Add KILL, RENAME, CHATTR, MKDIR, RMDIR, CHDIR.
		V2.1	Bug fix in RENAME.
		V3.0	Stack switching to cure String Space Corrupt
			in large programs.
		V3.1	Ensure direction flag points in right direction.
+

;
;
	Public	DOSOPEN		;Open file
	Public	DOSGET		;Read record
	Public	DOSPUT		;Write record
	Public	DOSLOCK		;Lock record
	Public	DOSUNLOCK	;Unlock record
	Public	DOSCLOSE	;Close file
	Public	DOSNAME		;Get name of machine
	Public	DOSKILL		;Erase file
	Public	DOSRENAME	;Rename file
	Public	DOSCHATTR	;Get/Set attributes of file
	Public	DOSMKDIR	;Create subdirectory
	Public	DOSRMDIR	;Remove subdirectory
	Public	DOSCHDIR	;Change subdirectory

;----------------------------------------------------------------------------
;-----			Commonly Used Equates				-----
;----------------------------------------------------------------------------

Lf	equ	0AH		;line feed
Cr	equ	0DH		;carriage return
Space	equ	20H		;space
Hyphen	equ	2DH		;hyphen
FullStop equ	2EH		;period
ZeroChar equ	30H		;Decimal Zero
Colon	equ	3AH		;
.xlist
	include	DOSEQU.INC
	include	DOSMACS.INC
.list
;
;	Ensure our data segment and code segment will be grouped with
;	any others of the same type
;
Cgroup	GROUP	Code

;****************************************************************************
;*****				Code Segment				*****
;****************************************************************************

code	segment	Public	'Code'
	assume	CS:Cgroup

;
PathName	db	64 dup (?)	;copy of pathname
SubFunction	db	?		;used to differentiate various options
					;of similar functions
DOSVersion	db	0		;0 if DOS 2.x, 1 if DOS 3.x
;	The following line is included in order that the version
;	number can be picked up by the Microsoft program WHAT.EXE.
VersionText	db	'@(#) BASCOM DOS 3 Interface '
		db	'V3.1 6th January 86 '
		db	'(C) Apricot (UK) Ltd.',0
page
;
;
;	Open a data file on behalf of BASIC
;
;	Use:
;		CALL DOSOPEN ( MODE%, NAME$, ERRNUM%, HANDLE% )
;
;	where	MODE% can be:	0 for read only
;				1 for write only
;				2 for read/write
;				3 for create & read/write
;				4 for create NEW & read/write
;			0-3 can have additive access modes:
;				00h "compatibility" mode
;				10h "deny read"
;				20h "deny write"
;				30h "deny read/write"
;				40h "deny nothing"
;		NAME$		holds the path name of the file to open
;		ERRNUM%		is to hold any error number (0 if read OK)
;		HANDLE%		is the file handle returned for other routines.
;
;
DOSOPEN	PROC	FAR
;
;
	call	StackSwapIn		;change to our stack
	push	BP
	mov	AH,Get_Version
	int	DOS_Function
	sub	AL,2
	mov	CS:DOSVersion,AL
	mov	BP,SP
	mov	SI,12[BP]
	mov	AX,[SI]			;get Open Mode
	mov	CS:SubFunction,AL
	cmp	CS:DOSVersion,0
	jne	DOS3Open
DOS2Open:
	and	SubFunction,07h		;If DOS 2.x, additive modes not allowed
DOS3Open:
	mov	SI,10[BP]		;Get address of PathName string
	mov	CX,[SI]			;get length of string
	mov	SI,2[SI]		;Get address of actual PathName
	lea	DI,CS:PathName
	push	DS
	push	ES
	push	CS
	pop	ES
	rep movsb			;move pathname from Basic to this seg.
	xor	AL,AL
	stosb				;add Null to the end
	pop	ES
	push	CS
	pop	DS
	mov	AH,Open
	mov	AL,CS:SubFunction	;Get open mode
	mov	DL,AL
	and	DL,07h			;throw away additive mode
	cmp	DL,3
	jl	OpenModeOK		;J if read, write, read/write
	and	AL,0F0h			;keep open additive modes
	mov	AH,Create
	cmp	DL,3
	je	OpenModeOK		;J if create file mode
	cmp	CS:DOSVersion,0
	je	OpenModeOK		;J if DOS 2 (CreateNew not available)
	mov	AH,CreateNewFile
OpenModeOK:
	lea	DX,CS:PathName		;point to pathname in this segment
	int	DOS_Function		;OPEN the file
	pop	DS
	jc	OpenErr			;J if file not opened
	mov	DI,6[BP]
	stosw				;put handle back in BASIC and...
	xor	AX,AX
OpenErr:
	cmp	AL,1			;Was function recognised? If not,
	je	DOS2Open		;then we are on a local drive.
	call	ErrSet			;test for DOS 3 errors
	mov	DI,8[BP]		;set error reply
	stosw
	pop	BP
	call	StackSwapOut		;Back to Basic's stack and...
	ret	8			;  ...Back to BASIC
;
DOSOPEN	ENDP
page
;
;	Read data on behalf of BASIC
;
;	Use:
;		CALL DOSGET ( DATA$, LENGTH%, RECORDNO%, ERRNUM%, HANDLE% )
;
;	where 	DATA$		is already long enough to hold the data
;		LENGTH%		is the number of bytes to read
;		RECORDNO%	is the number of the record to read
;		ERRNUM%		is to hold any error number (0 if read OK)
;		HANDLE%		is the file handle returned from DOSOPEN 
;
DOSGET	PROC	FAR
;
	mov	CS:SubFunction,Read
	jmp	short DoTransfer
;
DOSGET	ENDP
;
;	Write data on behalf of BASIC
;
;	Use:
;		CALL DOSPUT ( DATA$, LENGTH%, RECORDNO%, ERRNUM%, HANDLE% )
;
;	where 	DATA$		is holds the data to be written
;		LENGTH%		is the number of bytes to write
;		RECORDNO%	is the number of the record to write
;		ERRNUM%		is to hold any error number (0 if written OK)
;		HANDLE%		is the file handle returned from DOSOPEN 
;
DOSPUT	PROC	FAR
;
	mov	CS:SubFunction,Write
DoTransfer:
	call	StackSwapIn		;change to our stack
	push	BP
	mov	BP,SP
	mov	SI,10[BP]		;Get address of record number
	mov	AX,[SI]			;get record number
	dec	AX			;record 0 is byte 0 in file
	mov	SI,12[BP]
	mul	word ptr [SI]		;DX:AX is byte within file
	mov	CX,DX
	mov	DX,AX			;CX:DX is byte within file
	mov	AH,LSeek
	mov	AL,0			;Move to absolute byte number...
	mov	SI,6[BP]
	mov	BX,[SI]			;Get handle of file
	int	DOS_Function		;move to the relevant byte in the file
	mov	SI,14[BP]		;Point to string descriptor
	mov	DX,2[SI]		;Get address of buffer
	mov	SI,12[BP]
	mov	CX,[SI]			;get length to write
	mov	AH,CS:SubFunction
	int	DOS_Function		;write to the file
	jc	TranErr			;J if error
	mov	DI,12[BP]
	stosw				;Update number of bytes read, since
	xor	AX,AX			;we need to spot end-of-file.
TranErr:
	call	ErrSet
	mov	DI,8[BP]		;set error reply
	stosw
	pop	BP
	call	StackSwapOut		;Back to Basic's stack and...
	ret	10			;  ...Back to BASIC
;
DOSPUT	ENDP
page
;
;	Lock a record on behalf of BASIC
;
;	Use:
;		CALL DOSLOCK ( LENGTH%, RECORDNO%, ERRNUM%, HANDLE% )
;
;	where 	LENGTH%		is the number of bytes to be locked
;		RECORDNO%	is the number of the record to lock
;		ERRNUM%		is to hold any error number (0 if locked OK)
;		HANDLE%		is the file handle returned from DOSOPEN 
;
DOSLOCK	PROC	FAR
;
	mov	CS:SubFunction,0
	jmp	short DoLocking
;
DOSLOCK	ENDP
;
;	Unlock a record on behalf of BASIC
;
;	Use:
;		CALL DOSUNLOCK ( LENGTH%, RECORDNO%, ERRNUM%, HANDLE% )
;
;	where 	LENGTH%		is the number of bytes to unlock
;		RECORDNO%	is the number of the record to unlock
;		ERRNUM%		is to hold any error number (0 if unlocked OK)
;		HANDLE%		is the file handle returned from DOSOPEN 
;
DOSUNLOCK	PROC	FAR
;
	mov	CS:SubFunction,1
DoLocking:
	call	StackSwapIn		;change to our stack
	push	BP
	mov	BP,SP
	mov	SI,6[BP]
	mov	BX,[SI]			;Get file handle
	mov	SI,10[BP]		;Get address of record number
	mov	AX,[SI]			;get record number
	dec	AX			;record 0 is byte 0 in file
	mov	SI,12[BP]
	mul	word ptr [SI]		;DX:AX is byte within file
	mov	CX,DX
	mov	DX,AX			;CX:DX is byte within file
	mov	SI,12[BP]		;Get length of record
	mov	DI,[SI]			;in DI
	xor	SI,SI			;not more than 64K
	mov	AH,LockOper
	mov	AL,CS:SubFunction	;subfunction - Lock or unlock
	int	DOS_Function
	jc	LockErr
LockNoErr:
	xor	AX,AX
LockErr:
	cmp	AL,1			;If function not supported,
	je	LockNoErr		;treat as if no error occurred
	call	ErrSet			;check other errors
	mov	DI,8[BP]		;set error reply
	stosw
	pop	BP
	call	StackSwapOut		;Back to Basic's stack and...
	ret	8			;  ...Back to BASIC
;
DOSUNLOCK	ENDP
page
;
;	Close a file on behalf of BASIC
;
;	Use:
;		CALL DOSCLOSE ( ERRNUM%, HANDLE% )
;
;	where 	ERRNUM%		is to hold any error number (0 if closed OK)
;		HANDLE%		is the file handle returned from DOSOPEN 
;
DOSCLOSE	PROC	FAR
;
	call	StackSwapIn		;change to our stack
	push	BP
	mov	BP,SP
	mov	SI,6[BP]		;Get address of handle
	mov	BX,[SI]
	mov	AH,Close
	int	DOS_Function
	jc	CloseErr		;J if error
	xor	AX,AX
CloseErr:
	call	ErrSet
	mov	DI,8[BP]		;set error reply
	stosw
	pop	BP
	call	StackSwapOut		;Back to Basic's stack and...
	ret	4			;  ...Back to BASIC
;
DOSCLOSE	ENDP
page
;
;	Erase a file on behalf of BASIC
;
;	Use:
;		CALL DOSKILL ( FILENAME$, ERRNUM% )
;
;	where 	FILENAME$	is the name of the file to be erased
;		ERRNUM%		is to hold any error number (0 if erased OK)
;
DOSKILL	PROC	FAR
;
	mov	CS:SubFunction,Unlink
	jmp	Short KillAndSubDir
;
DOSKILL	ENDP
;
;	Create a Subdirectory on behalf of BASIC
;
;	Use:
;		CALL DOSMKDIR ( PATHNAME$, ERRNUM% )
;
;	where 	PATHNAME$	is the name of the subdirectory to be created
;		ERRNUM%		is to hold any error number (0 if created OK)
;
DOSMKDIR	PROC	FAR
;
	mov	CS:SubFunction,MkDir
	jmp	Short KillAndSubDir
;
DOSMKDIR	ENDP

;
;	Erase a Subdirectory on behalf of BASIC
;
;	Use:
;		CALL DOSRMDIR ( PATHNAME$, ERRNUM% )
;
;	where 	PATHNAME$	is the name of the subdirectory to be removed
;		ERRNUM%		is to hold any error number (0 if removed OK)
;
DOSRMDIR	PROC	FAR
;
	mov	CS:SubFunction,RmDir
	jmp	Short KillAndSubDir
;
DOSRMDIR	ENDP
;
;	Change the current Subdirectory on behalf of BASIC
;
;	Use:
;		CALL DOSCHDIR ( PATHNAME$, ERRNUM% )
;
;	where 	PATHNAME$	is the name of the subdirectory to be created
;		ERRNUM%		is to hold any error number (0 if created OK)
;
DOSCHDIR	PROC	FAR
;
	mov	CS:SubFunction,ChDir
;
;
KillAndSubDir:
	call	StackSwapIn		;change to our stack
	push	BP
	mov	BP,SP
	mov	SI,8[BP]		;Get address of string descriptor
	mov	CX,[SI]			;get length of string
	mov	DX,2[SI]		;get address of string
	mov	DI,DX
	add	DI,CX
	push	word ptr [DI]		;remember byte past string
	mov	byte ptr [DI],0		;add Null to the end
	mov	AH,CS:SubFunction
	int	DOS_Function
	jc	KillErr			;J if error
	xor	AX,AX
KillErr:
	pop	word ptr [DI]		;replace word following string
	call	ErrSet
	mov	DI,6[BP]		;set error reply
	stosw
	pop	BP
	call	StackSwapOut		;Back to Basic's stack and...
	ret	4			;  ...Back to BASIC
;
DOSCHDIR	ENDP
page
;
;	Rename a file on behalf of BASIC
;
;	Use:
;		CALL DOSRENAME ( OLDNAME$, NEWNAME$, ERRNUM% )
;
;	where 	OLDNAME$	is the original pathname
;		NEWNAME$	is the new pathname (must be same drive!)
;		ERRNUM%		is to hold any error number (0 if renamed OK)
;
DOSRENAME	PROC	FAR
;
	call	StackSwapIn		;change to our stack
	push	BP
	mov	BP,SP
	mov	SI,8[BP]		;Get address of newname descriptor
	mov	CX,[SI]			;get length of newname string
	mov	SI,2[SI]		;get address of string
	lea	DI,CS:PathName		;Point to our working buffer
	push	ES			;save Basic's Extra Seg
	push	CS
	pop	ES			;Point to our code segment
	rep movsb			;move the new name to our buffer
	mov	byte ptr ES:[DI],0	;add Null to the end
	mov	SI,10[BP]		;Get pointer to oldname string
	mov	CX,[SI]			;get length of oldname string
	mov	SI,2[SI]		;get address of string
	mov	DX,SI			;Want DX here for DOS Call.
	add	SI,CX			;Point to end of string
	push	word ptr [SI]		;remember byte past string
	mov	byte ptr [SI],0		;add Null to the end
	mov	AH,Rename
	lea	DI,CS:PathName		;DS:DX is old name, ES:DI is new one
	int	DOS_Function		;Do the renaming
	jc	RenErr			;J if error
	xor	AX,AX			;else set reply 0
RenErr:
	pop	word ptr [SI]		;replace the bit of program we zeroised
	pop	ES			;and Basic's Extra Segment
	call	ErrSet			;Check any funny errors
	mov	DI,6[BP]		;set error reply
	stosw
	pop	BP
	call	StackSwapOut		;Back to Basic's stack and...
	ret	6			;  ...Back to BASIC
;
DOSRENAME	ENDP
page
;
;	Change the attributes of a file on behalf of BASIC
;
;	Use:
;		CALL DOSCHATTR ( FILENAME$, ATTRIB%, ERRNUM% )
;
;	where 	FILENAME$	is the name of the file to be adjusted
;		ATTRIB%		contains the attribute bits. If negative,
;				then the call will return the current
;				attributes without changing them.
;		ERRNUM%		is to hold any error number (0 if erased OK)
;
DOSCHATTR	PROC	FAR
;
	call	StackSwapIn		;change to our stack
	push	BP
	mov	BP,SP
	mov	SI,8[BP]
	mov	CX,[SI]			;get attribute word
	mov	AL,1
	cmp	CX,0
	jge	ChSet
	mov	AL,0
ChSet:
	mov	SI,10[BP]		;Get address of string descriptor
	mov	BX,[SI]			;get length of string
	mov	DX,2[SI]		;get address of string
	mov	DI,DX
	add	DI,BX
	push	word ptr [DI]		;remember byte past string
	mov	byte ptr [DI],0		;add Null to the end
	mov	BX,CX
	mov	AH,ChMod
	int	DOS_Function
	jc	ChmodErr		;J if error
	xor	AX,AX
ChmodErr:
	pop	word ptr [DI]		;replace word following string
	mov	SI,8[BP]		;set reply for enquiry mode
	mov	Word ptr [SI],CX
	call	ErrSet
	mov	DI,6[BP]		;set error reply
	stosw
	pop	BP
	call	StackSwapOut		;Back to Basic's stack and...
	ret	6			;  ...Back to BASIC
;
DOSCHATTR	ENDP
page
;
;	Get the machine name on behalf of Basic
;
;	Use:
;		CALL DOSNAME ( MACHINE$ )
;
;	where MACHINE$ is at least 16 characters long
;
;
DOSNAME		PROC	FAR
	call	StackSwapIn		;change to our stack
	push	BP
	mov	AH,Get_Version
	int	DOS_Function
	cmp	AL,3
	jl	NoName
	mov	BP,SP
	push	DS
	push	CS
	pop	DS
	lea	DX,CS:PathName
	mov	AH,UserOper
	mov	AL,0			;GetMachineName
	int	DOS_Function		;at DS:DX
	mov	SI,DX
	mov	DI,6[BP]		;Get address of Machine Name string
	mov	CX,ES:[DI]		;get length of string
	cmp	CX,16
	jl	LenOK			;J if not enough room
	mov	CX,16			;Max len of string
LenOK:
	mov	DI,ES:2[DI]		;get address of actual string
	rep movsb			;move string into Basic
	pop	DS
NoName:
	pop	BP
	call	StackSwapOut		;Back to Basic's stack and...
	ret	2
;
DOSNAME		ENDP
page
;
;	The following routine is used to set any MS-DOS 3.x errors
;
ErrSet:
	push	SI
	or	AX,AX			;any error already?
	je	ErrSetEx		;j if not
	cmp	AL,18			;If it is an MS-DOS 3.x error,
	jae	ErrSetEx		;then let the user deal with it. 
	cmp	CS:DOSVersion,0
	je	ErrSetEx		;skip if DOS 2.x
	mov	SI,AX			;save possible error code
	mov	AH,GetExtendedError
	push	ES			;GetExtendedError corrupts ES
	int	DOS_Function
	pop	ES
	or	AX,AX
	jnz	ErrSetEx		;J if original error was not right
	mov	AX,SI			;put original err back
ErrSetEx:
	pop	SI
	ret
page
;
;	The following routines swap stacks, since Compiled Basic's
;	stack is too small in certain circumstances to call DOS.
;
StackSwapIn:
	cld
	mov	BX,SS
	mov	CS:RealSS,BX
	mov	BX,SP
	mov	CS:RealSP,BX
	mov	CS:SaveES,ES
	mov	CS:SaveDS,DS
	push	CS
	pop	ES			;point ES at our stack segment
	lea	AX,LocalStack		;fix SP in the middle of the stack
	mov	SI,SP
	mov	DI,AX
	mov	CX,20
	rep movsw			;copy the stack to our stack
	mov	BX,CS
	mov	SS,BX			;set our SS
	mov	SP,AX			;set our SP
	mov	AX,CS:SaveDS		;put other segments back
	mov	DS,AX
	mov	AX,CS:SaveES
	mov	ES,AX
	ret				;continue processing
StackSwapOut:
	mov	CS:SaveES,ES
	mov	CS:SaveDS,DS
	push	CS
	pop	DS			;point DS at our stack segment
	mov	SI,SP			;DS:SI points to our stack
	mov	AX,CS:RealSS
	mov	ES,AX
	mov	DI,CS:RealSP		;ES:DI points to real stack
	mov	CX,20
	rep movsw			;copy our stack to Basic's
	mov	BX,CS:RealSP
	mov	SS,AX			;Put Basic's stack back in force
	mov	SP,BX
	mov	AX,CS:SaveDS
	mov	DS,AX			;restore segments.
	mov	AX,CS:SaveES
	mov	ES,AX
	ret

		dw	30 dup (?)	;our stack
LocalStack	label	word		;this is where SP will point.
		dw	22 dup (?)	;copy of Basic's stack.
RealSP		dw	?
RealSS		dw	?
SaveDS		dw	?
SaveES		dw	?
;
code	ends
	end
