;----------------------------------------------------------------------------
;
;	This file is a set of equates for MS-DOS functions etc.
;	These are the names for the MS-DOS functions as used in the
;	Microsoft Documentation.
;	Valid for versions of MS-DOS upto 3.10.
;
;	Version 1.3	Andrew Alston, ACT (UK) Ltd.
;
;----------------------------------------------------------------------------
;-----				MsDos Interrupts			-----
;----------------------------------------------------------------------------

prg_trm			equ	20H		;Msdos program terminate
DOS_Function		equ	21H		;function request
trm_adr			equ	22H		;terminate address
ctl_adr			equ	23H		;control C exit address
ftl_err			equ	24H		;fatal error abort vector
abs_dsr			equ	25H		;absolute disk read
abs_dsw			equ	26H		;absolute disk write
trm_res			equ	27H		;terminate but stay resident

;----------------------------------------------------------------------------
;-----			MsDos Function Requests				-----
;----------------------------------------------------------------------------

Abort			equ	00H	;program terminate (abort)
Std_Con_Input		equ	01H	;keyboard input
Std_Con_Output		equ	02H	;video output
Std_Aux_Input		equ	03H	;auxilliary input
Std_Aux_output		equ	04H	;auxilliary output
Std_printer_output	equ	05H	;printer output
Raw_Con_IO		equ	06H	;direct console I/O
Raw_Con_Input		equ	07H	;direct keyboard input
Std_Con_Input_No_Echo	equ	08H	;keyboard input without echo
Std_Con_String_Output	equ	09H	;print string
Std_Con_String_Input	equ	0AH	;buffered keyboard input
Std_Con_Input_status	equ	0BH	;keyboard status
Std_Con_Input_Flush	equ	0CH	;keyboard input with buffer flush
Disk_Reset		equ	0DH	;disk reset
Set_Default_Drive	equ	0EH	;select disk
Fcb_Open		equ	0FH	;open file
Fcb_Close		equ	10H	;close file
Fcb_search_First 	equ	11H	;search for first entry
Fcb_search_next		equ	12H	;search for next entry
Fcb_delete		equ	13H	;delete file
Fcb_Seq_Read		equ	14H	;sequential read
Fcb_Seq_Write		equ	15H	;sequential write
Fcb_create		equ	16H	;create a file
Fcb_rename		equ	17H	;rename a file
Get_Default_drive	equ	19H	;current disk
Set_DMA			equ	1AH	;set disk transfer address
allc_addr		equ	1BH	;allocation table address
Fcb_random_read		equ	21H	;random read
Fcb_random_write	equ	22H	;random write
Get_Fcb_file_length	equ	23H	;file size
Get_Fcb_position	equ	24H	;set random record field
Set_Interrupt_Vector	equ	25H	;set vector
Create_Process_Data_blk	equ	26H	;create new program segment
Fcb_random_Read_block	equ	27H	;random block read
Fcb_random_Write_Block	equ	28H	;random block write
Parse_file_Descriptor	equ	29H	;parse file name
Get_date		equ	2AH	;get date
Set_date		equ	2BH	;set date
Get_time		equ	2CH	;get time
Set_time		equ	2DH	;set time
Set_Verify_On_Write	equ	2EH	;set/reset verify flag
; Extended Functionality Group
Get_DMA			equ	2FH	;Get current disk transfer address
Get_Version		equ	30H	;Get version of MS-DOS
Keep_Process		equ	31H	;terminate but stay resident
get_dpb			equ	32H	;Get DPB			***
Set_Control_C_Trapping	equ	33H	;set/reset control/C trapping
Get_InDOS_Flag		equ	34H	;ask if we are in dangerous DOS
Get_Interrupt_Vector	equ	35H	;get interrupt vector
Get_Drive_Freespace	equ	36H	;get drive freespace
Char_Oper		equ	37H	;change incompatible configuration params
International		equ	38H	;get country-dependent characters
;------------------------------------------------------------------------------
; XENIX calls
;------------------------------------------------------------------------------
;	Directory Group:
MKDir			equ	39H	;make directory
RMDir			equ	3AH	;remove directory
CHDir			equ	3BH	;change current directory
;	File Group:
Create			equ	3CH	;create a new file
Open			equ	3DH	;open file for read or write
Close			equ	3EH	;close a file
Read			equ	3FH	;read s	equentially
Write			equ	40H	;write sequentially
Unlink			equ	41H	;delete file
LSeek			equ	42H	;move data pointer down file
CHMod			equ	43H	;set file properties
IOCtl			equ	44H	;send/receive I/O control info to device
XDup			equ	45H	;duplicate a handle
XDup2			equ	46H	;force handle duplication
Current_Dir		equ	47H	;get text of current directory name
;	Memory Group:
Alloc			equ	48H	;get a memory block
Dealloc			equ	49H	;free a memory block
Setblock		equ	4AH	;adjust an existing allocated block
;	Process Group:
Exec			equ	4BH	;load & execute a program
Exit			equ	4CH	;return from daughter process
Wait			equ	4DH	;await daughter process
;	More Files:
Find_First		equ	4EH	;find matching handle
Find_Next		equ	4FH	;find next matching handle
;	Special System Group:
Set_curr_pdb		equ	50H	;				***
Get_curr_pdb		equ	51H	;				***
Get_invars		equ	52H	;				***
Set_pdb			equ	53H	;				***
Get_Verify_On_Write		equ	54H	;get value of verify
Dup_pdb			equ	55H	;				***
;	More Files:
Rename		equ	56H	;move a file from one handle to another
File_Times		equ	57H	;get & set file times.
AllocOper		equ	58h
;
GetExtendedError	equ	59H	;Get extended error from MS-DOS 3.x
CreateTempFile		equ	5AH	;Create a temporary file
CreateNewFile		equ	5BH	;Create a (guaranteed new) file
LockOper		equ	5CH	;Lock & Unlock range of a file
UserOper		equ	5EH	;Net info set & change.
AssignOper		equ	5Fh	;On, Off, Get, Set & cancel
PathParse		equ	61h
GetCurrentPSP		equ	62h
Hongeul			equ	63h	;I wonder what this is?

;---------------------------------------------------------------------------
