page	55, 132
title	MS-DOS 3.x Record Locking Demonstration Program
subttl	Copyright (C) 1984	A.C.T. (U.K.) Ltd.
name	LIBTEST2
;****************************************************************************
;*****	This program demonstrates the record locking facilities of	*****
;*****	MS-DOS 3.x. 							*****
;*****	Written 1984 by Andrew Alston (U.K.) Ltd.			*****
;*****									*****
;*****									*****
;****************************************************************************

	extrn	DOSOPEN		: far
	extrn	DOSCLOSE	: far
	extrn	DOSGET		: far
	extrn	DOSPUT		: far
	extrn	DOSLOCK		: far
	extrn	DOSUNLOCK	: far

;----------------------------------------------------------------------------
;-----			Commonly Used Equates				-----
;----------------------------------------------------------------------------

Bel	equ	07H		;Make a noise
BS	equ	08H		;Backspace
Lf	equ	0AH		;line feed
Cr	equ	0DH		;carriage return
Esc	equ	1BH		;Escape
Space	equ	20H		;space
Hyphen	equ	2DH		;hyphen
FullStop equ	2EH		;period
Colon	equ	3AH		;

	include	DOSEQU.INC
;

;----------------------------------------------------------------------------
;-----			Equates, Structures & Macros			-----
;----------------------------------------------------------------------------


	include	DOSMACS.INC
;
;	Ensure our data segment and code segment will be grouped with
;	any others of the same type
;
Dgroup	GROUP	Data			
Cgroup	GROUP	Code

;****************************************************************************
;*****				Data Segment				*****
;****************************************************************************

Data	SEGMENT	Public	'Data'

RecBuff		db	256 dup (0)
Handle		dw	0
Reply		dw	0
Reclen		dw	128
ReadLen		dw	128
RecNo		dw	0
Mode		dw	2

PathNameGet	db	65,0
PathName	db	66 dup (?)

Header		db	esc,'E',esc,'(',esc,'0'
		db	'@(#) Test MS-DOS 3 file and record locking V2.0'
		db	esc,')',esc,'1',Cr,Lf,Lf,'$'
PathEnq		db	Cr,Lf,'Path name of test file? $'
ModeEnq		db	Cr,Lf,'Opening mode (2 digits) : $'
NotFound	db	Cr,Lf,'File can not be opened - error $'
CrLf		db	Cr,Lf,'$'
RecKey		db	Cr,Lf,'Enter record key (A-Z) or Return to end : $'
FailedLock	db	Cr,Lf,'That record has been locked',Cr,Lf,'$'
FailedLockZZ	db	Cr,Lf,'Cannot Lock record - error $'
FailedRead	db	Cr,Lf,'Cannot read record - error $'
PastEof		db	Cr,Lf,'Record is past end of file.$'
Continue	db	Cr,Lf,'Hit any key to continue...$'
PathNameDesc	dw	?
PathNameDesc2	dw	?
RecBuffDesc	dw	129
RecBuffDesc2	dw	?
DispFlag	db	?

Data	ENDS

;****************************************************************************
;*****				Code Segment				*****
;****************************************************************************

code	segment	Public	'Code'
	assume	CS:Cgroup, DS:Dgroup
;
LIBTEST2	PROC	Near
;
;	This program is intended to allow use of the
;	Record Locking features of MS-DOS 3.x
;
; ************************* INITIALISATION ****************
	mov	DX,Data
	mov	DS,DX
	mov	ES,DX
	display	Header
Getname:
	display	PathEnq
	get_string 64,PathNameGet
	mov	BL,PathNameGet[1]
	xor	BH,BH
	mov	PathNameDesc,BX
	lea	BX,PathName[1]
	add	BX,PathNameDesc
	xor	AL,AL
	mov	Byte ptr [BX],AL
	display	ModeEnq
M1:
	read_kbd_echo
	xor	AH,AH
	sub	AL,30H
	cmp	AL,10
	jl	M1OK
	display_char BS
	jmp	M1
M1OK:
	mov	cx,4
	shl	AX,CL
	mov	Mode,AX
M2:
	read_kbd_echo
	xor	AH,AH
	sub	AL,30H
	cmp	AL,10
	jl	M2OK
	display_char BS
	jmp	M2
M2OK:
	or	Mode,AX
	display	CrLf
	lea	DX,MODE
	push	DX
	lea	DX,PathName
	mov	PathNameDesc2,DX
	lea	DX,PathNameDesc
	push	DX
	lea	DX,Reply
	push	DX
	lea	DX,Handle
	push	DX
	call	DOSOPEN
	cmp	Reply,0
	je	DoReading
	display	NotFound
	mov	SI,Reply
	call	Deci4
	jmp	Getname
;********************* END OF RUN ***********************
EndOfRun:
	lea	DX,handle
	push	DX
	lea	DX,Reply
	push	DX
	call	DOSCLOSE
	mov	AH,Exit
	int	DOS_Function

;********************** MAIN LOOP ************************

DoReading:

	display	RecKey
	read_kbd_echo
	cmp	AL,Cr
	je	EndOfRun
TestAgen:
	cmp	AL,41H
	jl	DoReading
	cmp	AL,5BH
	jl	KeyOK
	sub	AL,20H
	jmp	Testagen
KeyOK:
	sub	AL,40H
	xor	AH,AH
	mov	RecNo,AX
	lea	DX,RecLen
	push	DX
	lea	DX,RecNo
	push	DX
	lea	DX,Reply
	push	DX
	lea	DX,Handle
	push	DX
	call	DOSLOCK
	cmp	reply,0
	je	LockedOK
	cmp	reply,80
	jl	CantLock
	display	FailedLock
	jmp	DoReading
CantLock:
	display	FailedLockZZ
	mov	SI,Reply
	call	Deci4
LockedOK:
	push	RecLen
	pop	ReadLen
	lea	DX,RecBuff
	mov	RecBuffDesc2,DX
	lea	DX,RecBuffDesc
	push	DX
	lea	DX,ReadLen
	push	DX
	lea	DX,RecNo
	push	DX
	lea	DX,Reply
	push	DX
	lea	DX,Handle
	push	DX
	call	DOSGET				;Get the record
	cmp	reply,0
	je	ReadOK
	display	FailedRead
	mov	SI,Reply
	call	Deci4
	jmp	DoReading
ReadOK:
	mov	SI,ReadLen
	cmp	SI,0
	jne	SomeRead			;Ok if some read.
	display	PastEof 
	call	DoUnlock
	jmp	DoReading
SomeRead:
	display	CrLf
	mov	CX,ReadLen
	lea	SI,RecBuff
BuffOut:
	mov	DL,[SI]
	inc	SI
	mov	AH,Std_Con_Output
	int	DOS_Function
	loop	Buffout
	display	Continue
	read_kbd_echo
	call	DoUnlock
	jmp	DoReading
;
DoUnlock:
	lea	DX,RecLen
	push	DX
	lea	DX,RecNo
	push	DX
	lea	DX,Reply
	push	DX
	lea	DX,Handle
	push	DX
	call	DOSUNLOCK
	ret
;
;
;----------------------------------------------------------------------------
;-----		Subroutine to convert binary to decimal.		-----
;-----		Entry with DI containing most significant 16 bits	-----
;-----			   SI containing least significant 16 bits	-----
;----------------------------------------------------------------------------
;
Deci4:		;Variant for 4-digit o/p from SI only
        MOV     BYTE PTR DispFlag,1
	xor	DI,DI
Decimal:
        XOR     AX,AX
        MOV     BX,AX
        MOV     BP,AX
        MOV     CX,32
CONVLP:
        SHL     SI,1
        RCL     DI,1
        XCHG    AX,BP
        CALL    CONVWRD
        XCHG    AX,BP
        XCHG    AX,BX
        CALL    CONVWRD
        XCHG    AX,BX
        ADC     AL,0
        LOOP    CONVLP
        ; Conversion complete
        MOV     CX,1310H        ;Print 3-digit number with 2 leading blanks
        CMP     BYTE PTR DispFlag,0
        JNZ     FOURDIG
        MOV     CX,1810H        ;Print 8-digit number with 2 leading blanks
        XCHG    DX,AX
        CALL    DIGIT
        XCHG    AX,BX
        CALL    OUTWORD
FOURDIG:
        MOV     AX,BP
        CALL    OUTWORD
	mov	DL,20H
	call	PrtChr
        MOV     BYTE PTR DispFlag,0
RET2:   RET

OUTWORD:
        PUSH    AX
        MOV     DL,AH
        CALL    OUTBYTE
        POP     DX
OUTBYTE:
        MOV     DH,DL
        SHR     DL,1
        SHR     DL,1
        SHR     DL,1
        SHR     DL,1
        CALL    DIGIT
        MOV     DL,DH
DIGIT:
        AND     DL,0FH
        JZ      BLANKZER
        MOV     CL,0
BLANKZER:
        DEC     CH
        AND     CL,CH
        OR      DL,30H
        SUB     DL,CL
        CMP     BYTE PTR DispFlag,0
        JZ      PRTCHR
        CMP     DL,30H
        JL      RET2
PRTCHR:
        MOV     AH,Std_Con_Output
        INT     DOS_Function
        RET

CONVWRD:
        ADC     AL,AL
        DAA
        XCHG    AL,AH
        ADC     AL,AL
        DAA
        XCHG    AL,AH
        RET

PRINTCNT:
        LODSB
        MOV     DL,AL
        INT     DOS_Function
        LOOP    PRINTCNT
        RET
;
LIBTEST2	ENDP
;
Code	ends
;
;****************************************************************************
;*****				Stack Segment				*****
;****************************************************************************
stack	SEGMENT	stack	'Stack'
	assume	ss:stack
stack	ends	
;
end	LIBTEST2
