page		55, 132
Name		RELSPL
Title		Release Point 32 spool file on behalf of Compiled Basic
SubTtl		(C) 1985 Apricot (UK) Ltd.
Comment	*

The following routine is intended to close the current spoolfile
on a Point 32 station, and open a new spoolfile on the same server.

It is intended to be called from Compiled Basic programs, and assumes
that the assignment for the current printer was made without use of
any password.

Use:

	10 DEV$ = "PRN"		'or "AUX"
	20 ERRC% = 0
	30 CALL RELSPL ( DEV$, ERRC% )

The error reply variable will be set as follows:

	0	No error
	1	Incorrect DOS Version
	2	Network not loaded
	3	Not on Point 32.
	4	NET PAUSE PRDR in operation
	5	Printer could not be re-opened
	6	Name not "PRN" or "AUX"
	255	Other error.

*

.xlist
	include	DOSEQU.INC
.list

	public	RELSPL
Dgroup	GROUP	Data

Data	segment	Public	'Data'

Source		db	5 dup (0)
FindSource	db	9 dup (0)
FindDest	db	64 dup (0)
PrinterRealName	db	'LPT1'
AuxName		db	'AUX'
PrnName1	db	'PRN'
PrnName2	db	'prn'
AuxName1	db	'AUX'
AuxName2	db	'aux'
OurName		db	0,0,0

Data	ends

Cgroup	GROUP	Code

code	segment	Public	'Code'
	assume	CS:Cgroup, DS:Dgroup

RELSPL	PROC	FAR
	cld
	push	BP
	mov	BP,SP			;save BP
	push	ES	 		;and segments
	push	DS
	mov	AH,Get_Version
	int	DOS_Function	 	;find the version of DOS
	cmp	AL,3
	jge	DosOk			;OK if DOS 3 or more
	mov	AL,01			;else error 1
	jmp	SetError
DOSOk:
	mov	SI,[BP+08] 		;get address of device string
	mov	AL,[SI]			;get length of device name string
	cmp	AL,3
	jz	LengthOk		;J if length OK
	mov	AL,6
	jmp	SetError		;else error 6
LengthOk:
	inc	SI
	inc	SI	 		;point to string itself
	mov	BX,[SI]
	mov	SI,BX
	lea	DI,OurName
	mov	CX,3
	rep	movsb			;copy string to our area
	mov	CX,3
	lea	SI,OurName
	lea	DI,PrnName1
	rep	cmpsb
	je	FoundName		;J if "PRN"
	mov	CX,3
	lea	SI,OurName
	lea	DI,PrnName2
	rep	cmpsb
	je	FoundName		;J if "prn"
	mov	CX,3
	lea	SI,OurName
	lea	DI,AuxName1
	rep	cmpsb
	je	FoundName2		;J if "AUX"
	mov	CX,3
	lea	SI,OurName
	lea	DI,AuxName2
	rep	cmpsb
	je	FoundName2		;J if "aux"
	mov	AL,06
	jmp	SetError		;else error 6
FoundName:
	lea	SI,PrinterRealName	;if "PRN" or "prn", use "LPT1"
	jmp	GotaName
FoundName2:
	lea	SI,AuxName		;if "AUX" or "aux", use "AUX"
GotaName:
	mov	CX,4
	lea	DI,Source
	rep movsb			;move the right name to Source area
	xor	BX,BX			;start with index zero
	push	BX
TrySearch:
	mov	AH,AssignOper
	mov	AL,02			;GetAssignListEntry
	lea	SI,FindSource
	lea	DI,FindDest
	int	DOS_Function
	jnb	EntryFound		;OK if entry found
	cmp	AX,1
	jnz	NotNetNone		;Not too bad if DOS call understood
	mov	AL,3
	pop	BX
	jmp	SetError		;error 3 if DOS call unknown
NotNetNone:
	cmp	AX,12h
	je	InvalidAccess		;J if invalid access
	mov	AL,0FFh
	pop	BX
	jmp	SetError		;else set error 255
InvalidAccess:
	mov	AL,4
	pop	BX
	jmp	SetError		;set error 4
EntryFound:
	cmp	BL,3
	jz	PrinterFound		;J if it's a printer
TryAnother:
	pop	BX
	inc	BX
	push	BX
	jmp	TrySearch		;else keep looking
PrinterFound:
	mov	CX,4
	lea	DI,Source
	lea	SI,FindSource
	rep	cmpsb
	jne	TryAnother		;J if this is not the one for us
	pop	BX			;get the Index Number back
	mov	AH,AssignOper
	mov	AL,4			;CancelMacro
	lea	SI,Source
	int	DOS_Function		;close the printer alias
	jnb	ClosedOk		;j if done
	mov	AL,0FFh
	jmp	SetError		;else set error 255
ClosedOK:
	mov	AH,AssignOper
	mov	AL,3			;DefineMacro
	mov	BL,3			;it's a printer
	xor	CX,CX
	lea	SI,FindSource
	lea	DI,FindDest
	int	DOS_Function		;assign the printer
	jnb	NoError			;J if OK
	mov	AL,5
	jmp	SetError		;else set error 5
NoError:
	xor	AL,AL			;No error
SetError:
	xor	AH,AH
	mov	DI,[BP+06]		;get address of error variable
	mov	ES:[DI],AX		;set the error
	pop	DS
	pop	ES
	pop	BP
	ret	4			;Back to BASIC

RELSPL	ENDP
;
Code	ends
;
end
