;	MSBASIC COMPILER TO GSX GRAPHICS INTERFACE PROGRAM
;
;		PROVIDES FOR COMMUNICATION WITH GSX FROM COMPILED
;		BASIC USING CALLS TO 'GSX'
;		FORMAT:
;
;	CALL GSX(ARRAY1,ARRAY2,ARRAY3,ARRAY4,ARRAY5)
;
	DATA	SEGMENT	'DATA' PUBLIC
	DATA	ENDS

	CODE	SEGMENT	'CODE' PUBLIC

ASSUME	CS:CODE,DS:DATA
;
	PUBLIC	GSX
GSX	PROC	FAR
;
;	STACK ON ENTRY:
;			SP -> | RET OFFSET  |
;			    2 | RET SEGMENT |
;	 		    4 | ARRAY 5 OFF |
;			    6 | ARRAY 4 OFF |
;			    8 | ARRAY 3 OFF |
;			   10 | ARRAY 2 OFF |
;			   12 | ARRAY 1 OFF |
;
BEGIN:	PUSH	BP
	MOV	BP,SP		;POINT INTO STACK
	PUSH	AX		;SAVE THE WORLD
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI	
	PUSH	DS		;SAVE REGS
	PUSH	ES
	MOV	SI,DS		;SAVE DS IN SI
	MOV	AX,CS		;SET UP DS
	MOV	DS,AX
	MOV	BX,OFFSET ARRAY	;OFFSET OF TABLE FROM START
	MOV	DX,BX		;SAVE IN DX FOR GSX
	ADD	BP,14		;POINT TO ARRAY 1 OFFSET ON STACK
	MOV	CX,5		;FIVE POINTERS TO CONSTRUCT
SETUP:	MOV	AX,[BP]		;GET ARRAY OFFSET
	MOV	[BX],AX		;COPY INTO TABLE
	DEC	BP
	DEC 	BP		;POINT TO NEXT STACK ENTRY
	INC	BX
	INC 	BX		;SET-UP SEGMENT ADDRESS
	MOV	[BX],SI		;USING OLD DS SAVED IN SI
	INC	BX
	INC	BX		;BUMP TO NEXT ENTRY
	LOOP	SETUP		;FILL TABLE
	MOV	CX,473H		;GSX COMMAND
	INT	224		;GO TO GSX
	POP	ES
	POP	DS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POP	BP
	RET	10
;
GSX	ENDP
;
ARRAY	DW 10 DUP(0)		;ARRAY POINTERS FOR GSX
;

CODE	ENDS
	END	BEGIN

