Page	100,132
;************************************************************************
;*									*
;*	EMIBM.ASM							*
;*									*
;*	<C> Apricot Advanced Technology Ltd 1985			*
;*	Initial version  Jonathan Mackenzie 08-06-85			*
;*									*
;*	Version : 1.47							*
;*									*
;*	Modification history:						*
;*	15/7/85 num pad + and - keys swapped				*
;*		ver 1.1 issued						*
;*	15/7/85 int F1 and int 29 now not				*
;*		connected. Should be able to run			*
;*		Apricot applications without unload			*
;*		ver 1.2 issued						*
;*	17/7/85 bug in int 17 'report status'				*
;*		fixed. Ver 1.3 issued					*
;*	22/8/85 int 16 func 1 crash fixed				*
;*		ver 1.3.1 issued					*
;*									*
;*	22/9/85								*
;*		Int 14 now correctly sets bit 7 as			*
;*		error code ( bug 318/7 )				*
;*		Also see QA report 318					*
;*		Ver 1.3.2 issued 3/10/85				*
;*									*
;*	All further modifications by A. Alston.				*
;*									*
;*	19/12/85	V1.40						*
;*		Set video mode now clears screen			*
;*									*
;*	1/1/86		V1.41						*
;*		Int 12h handler (memory size) installed			*
;*									*
;*	1/7/86		V1.41a						*
;*		Int 11h handler (equipment list) installed.		*
;*		Int 10h/0Fh now reports monochrome, not 16		*
;*		greyscales.						*
;*									*
;*	2/7/86		V1.42						*
;*		Keyboard adjusted for closer emulation			*
;*		Interrupt 10h now restored correctly			*
;*		Converted to .COM file to reduce store usage		*
;*									*
;*	24/11/87	V1.43						*
;*		Additional support for int 11h handler (number of	*
;*		disks and 8087 support).				*
;*		Environment freed at startup.				*
;*									*
;*	01/02/88	V1.44						*
;*		Add functions 0FEh and 0FFh to int 10h handler, to	*
;*		provide TopView compatibility.				*
;*		Add Int 15h handler. Deals with 85h (SYSREQ),		*
;*		88h (Extended memory size) (returns 0)			*
;*		C0h (Returns pointer to config block).			*
;*									*
;*	21/07/88	V1.45						*
;*		Add screen dump function (int 5) on			*
;*		shift/multiply key.					*
;*									*
;*	15/08/88	V1.46						*
;*		Enable Apricot Calculator on right-hand			*
;*		MicroScreen key.					*
;*		Implement divide by zero trap (int 0) to give		*
;*		address of failing instruction.				*
;*									*
;*	28/02/89	V1.47						*
;*		Enhance information left in bottom end of RAM.		*
;*		In particular, screen information is set up,		*
;*		and the Equipment List is set up if the machine		*
;*		is NOT a PC or Xi, where the 8089 uses this area.	*
;*		Add call to INT 28h when checking for keyboard		*
;*		data. This allows KEYFAKE to supply data when		*
;*		needed.							*
;*									*
;************************************************************************
.8087				;Coprocessor code is present.
	include	LEGAL.INC


;	PROGRAM CODE EQUATES

SCR_DRV		EQU	0ECh

PAGE
;===========================================================================
; PROGRAM CODE SECTION
;===========================================================================

PROG	SEGMENT	BYTE
ASSUME	CS:PROG, DS:PROG
	org	100h
StartPoint:
	JMP	EMIBM			; jump over our signature to start routine

		DB	'EMIBM'			; program signature

PAGE
;=============================================================================
;= int_10
;=============================================================================
;JOB		int_10 - interrupt handler for int 10h
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:
;OUTPUT		:
;ERRORS		:	In this initial implementation, there is no facility
;			to switch active display pages. All calls referencing
;			a display page other than zero ( default ) will
;			be pointed to the default page.
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_10
INT_10	PROC	NEAR
;=========  INT 10H INTERRUPT ROUTINE ENTRY POINT HERE =================

	JMP	SHORT	IT10

		; *** NOTE ***
		; THe following data area is information needed by a second
		; invocation of EMIBM to be able to unload the previous
		; copy from memory. If altering this data structure be
		; sure to check the routines that connect and disconnect
		; the int 10 vector.

		DB	'EMIBM'		; this prog signature
INT10_SAV	DD	0		; old vector save
CNF_S_BIOS	DB	0		; save value of CNF_s_bioserr

IT10:				; analyse value in AH ( callers code )
	sti				; Turn on interrupts
	CMP	AH, 3			; read cursor pos ?
	JNZ	IT20
	JMP	IT900
IT20:	CMP	AH, 2			; set cursor pos ?
	JNZ	IT30
	JMP	IT300
IT30:	CMP	AH, 14			; write tty ?
	JNZ	IT40
	JMP	IT400
IT40:	CMP	AH, 9			; write attr/char ?
	JNZ	IT50
	JMP	IT500
IT50:	CMP	AH, 6			; scroll page up ?
	JNZ	IT60
	JMP	IT600
IT60:	CMP	AH, 7			; scroll page down ?
	JNZ	IT70
	JMP	IT700
IT70:	CMP	AH, 8			; read attr/char ?
	JNZ	IT80
	JMP	IT800
IT80:	CMP	AH, 10			; write char ?
	JNZ	IT90
	JMP	IT200
IT90:	CMP	AH, 1			; set cursor ?
	JNZ	IT100
	JMP	IT1000
IT100:	CMP	AH, 15			; current video state ?
	JNZ	IT110
	JMP	IT1100
IT110:	CMP	AH, 11			; set pallette ?
	JNZ	IT120
	JMP	IT1200
IT120:	CMP	AH, 5			; sel page ?
	JNZ	IT130
	JMP	IT1300
IT130:	CMP	AH, 0			; set mode ?
	JNZ	IT131
	JMP	IT1400
IT131:	CMP	AH, 0FEh		; get video buffer?
	JNZ	IT132
	JMP	IT14FE
IT132:	CMP	AH, 0FFh		; Update video buffer?
	JNZ	IT140
	JMP	IT14FF
IT140:	JMP	IT7999			; quit, AH code no good
;================================================
IT200:				; AH = 10, write char at current curpos
				; BH = display page
				; CX = count of chars to write
				; AL = char to write
				; this handler tested 26/6/85 jon
				; first, save all registers
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
				; recover DS, save int 10 call parms
	push	CS
	pop	DS
	MOV	DS:TEMP1, CX		; save char count in TEMP1
	MOV	DS:TEMP2, AX		; save char to write in TEMP2
				; turn the cursor off
	MOV	CL, 0Eh			; 'cursor off' code
	MOV	CH, 0			; screen i.d.
	MOV	DI, DS:IMAGE_ID		; image i.d. to DI
	INT	SCR_DRV			; and turn the cursor off
				; find & copy the current cursor position
	MOV	AH, DS:C_ROWY		; cursor y co-ord
	MOV	AL, DS:C_COLX		; cursor x co-ord
IT210:	MOV	DS:TEMP3, AX		; save curpos in TEMP3
				; read char & attribs at x,y ( AL,AH )
	MOV	CX, 0006		; CH=0, CL=6 (scrn id, rd char)
	MOV	DI, DS:IMAGE_ID		; set the image i.d.
	INT	SCR_DRV			; and read the character
				; write new char with old attribs
	MOV	DX, AX			; DH=attribs, DL=char ( read )
	MOV	AX, DS:TEMP2		; retrive write char
	MOV	DL, AL			; old attribs, new char in DX
	MOV	AX, DS:TEMP3		; cursor position to AX
	MOV	CX, 0004		; CH=0,CL=4 (scrn id, wrt chr )
	MOV	SI, 0			; point to default font
	MOV	DI, DS:IMAGE_ID		; image i.d. to DI
	INT	SCR_DRV			; write the char
				; check for a multi-char call and increase
				; x-y to point to next cell if needed
	DEC	DS:TEMP1		; reduce character count
	JZ	IT230			; if it's zero, we quit
	MOV	AX, TEMP3		; retrive char x-y position
	INC	AL			; bump the column (x)
	CMP	AL, 80			; off the edge ?
	JL	IT220			; no, put next char there
	MOV	AL, 0			; else reset col to zero
	INC	AH			; and bump the row
	CMP	AH, 25			; off the bottom ?
	JL	IT220			; no, next char can go there
	MOV	AH, 0			; else row (y) reset to zero
IT220:	JMP	IT210			; loop back to print next char
IT230:				; all finished, turn the cursor back on at
				; the original position ( this call may have
				; printed a string but will not update the
				; cursor x,y co-ordinates )
	cmp	DS:CursorOn,0
	je	IT290			; J if cursor is supposed to be off
	MOV	CL, 0Dh			; 'cursor on' code
	MOV	CH, 0			; screen i.d. is zero
	MOV	AH, DS:C_ROWY		; set ORIGINAL y co-ord
	MOV	AL, DS:C_COLX		; set ORIGINAL x co-ord
	MOV	DI, DS:IMAGE_ID		; DI = image i.d.
	INT	SCR_DRV			; turn the cursor back on
IT290:
				; dropthru to pop reg's & exit
	POP	DS
	POP	SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	JMP	IT7999
;================================================
IT300:				; AH = 2, set cursor position
				; DH, DL = row, column ( 0,0 = upper left )
				; BH = display page
				; this handler tested 25/6/85 jon.
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS			; save DS value
	push	CS
	pop	DS
	CMP	DH, 25			; is row 0-24 ?
	JL	IT310			; yes, continue
	MOV	DH, 24			; no, set 24 as max
IT310:	CMP	DL, 80			; is col 0-79 ?
	JL	IT320			; yes, continue
	MOV	DL, 79			; no, set 79 as max
IT320:
	MOV	DS:C_ROWY, DH		; save this as last known ..
	MOV	DS:C_COLX, DL		; .. cursor position
	MOV	CX, 000Eh		; scrn id, cursor off
	MOV	DI, DS:IMAGE_ID		; set the image i.d.
	PUSH	DX			; DX trashed by next call !
	PUSH	DI			; save image id
	INT	SCR_DRV			; call int EC to turn curs off
	POP	DI			; recover image id
	POP	AX			; AH,AL = row, col
	cmp	DS:CursorOn,0
	je	IT321			; J if cursor is supposed to be off
	MOV	CX, 000Dh		; scrn id, cursor on
	INT	SCR_DRV			; call int EC to turn cursor
IT321:
	JMP	IT290
;================================================
IT400:				; AH = 14, write tty
				; AL = char to write
				; BH = display page
				; this handler tested 1/7/85 jon
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	push	CS
	pop	DS
				; store the passed vars
	MOV	DS:TEMP1, AX		; save char to write
	MOV	DS:TEMP2, BX		; save the display page
				; check for STOP key
	push	AX
	push	BX
	push	CX
	push	DX
LookForStop:
;	mov	AL,CS:StopChanged	; Has the stop key been pressed?
;	xor	CS:StopChanged,AL	; Clear flag if so
;	test	AL,AL
;	jz	NoStopKey		; J if STOP not pressed recently.
	mov	BX,32h
	mov	CX,0Fh
	mov	DX,0FF00h
	int	0FCh			; Get keyboard status
	test	AL,02h			; Is stop on?
	jnz	LookForStop		; If so, go & wait for user to press again
NoStopKey:
	pop	DX
	pop	CX
	pop	BX
	pop	AX
				; check for a bell
	CMP	AL, 7			; was it a bell ?
	JNZ	IT405			; nope, try next
	MOV	BX, 38h			; sound generator code
	MOV	CX, 9			; 'bell'
	INT	0FCh			; sound the bell
	JMP	IT495			; and exit
IT405:				; all others affect cursor, so kill it
	MOV	CX, 000Eh		; 'cursor off' code, scrn i.d.
	MOV	DI, DS:IMAGE_ID		; image i.d.
	INT	SCR_DRV			; turn the cursor off
	MOV	AX, DS:TEMP1		; and recover the char (AL)
				; check for a carriage return
	CMP	AL, 0Dh			; was it a cr ?
	JA	IT435			; above means must be printable
	JNZ	IT410			; no, try next
	MOV	DS:C_COLX, 0		; yep, set cursor to col 0
	JMP	IT490			; & quit through cursor rewrite
IT410:				; check for a backspace
	CMP	AL, 8			; was it a backspace ?
	JNZ	IT425			; nope, try next
	CMP	DS:C_COLX, 0		; already at col zero ?
	JNZ	IT420			; no, do a backspace
	JMP	IT490			; yes, cursor rewrite & quit
IT420:	DEC	DS:C_COLX		; move cursor back 1
	JMP	IT490			; exit thru cursor on
IT425:				; check for a linefeed
	CMP	AL, 0Ah			; was it lf ?
	JNZ	IT435			; no, try next
	INC	DS:C_ROWY		; bump row number
	JMP	IT440			; exit thru scroll check
IT435:				; handle all else as normal chars
	MOV	AH, DS:C_ROWY		; cursor y co-ord
	MOV	AL, DS:C_COLX		; cursor x co-ord
	MOV	CX, 0006		; CH=0, CL=6 (scrn id, rd char)
	MOV	DI, DS:IMAGE_ID		; set the image i.d.
	INT	SCR_DRV			; and read the character
				; give old attributes new char
	MOV	BX, DS:TEMP1		; get char to write (BL)
	MOV	AL, BL			; combine with old attribs
				; write out new char at current curpos
	MOV	DX, AX			; DH=attribs, DL=char
	MOV	AH, DS:C_ROWY		; get cursor row
	MOV	AL, DS:C_COLX		; .. and column
	MOV	CX, 0004		; CH=0,CL=4 (scrn id, wrt chr )
	MOV	SI, 0			; point to default font
	MOV	DI, DS:IMAGE_ID		; image i.d. to DI
	INT	SCR_DRV			; write the char
				; update cursor x,y to new position
	INC	DS:C_COLX		; increment column count
	CMP	DS:C_COLX, 80		; off rh edge ?
	JL	IT490			; no, that's it then
	MOV	DS:C_COLX, 0		; else new col is zero
	INC	DS:C_ROWY		; bump the row count
IT440:	CMP	DS:C_ROWY, 24		; off bottom of screen ?
	JL	IT490			; no, exit then
	MOV	DS:C_ROWY, 23		; else new row is 23
				; read attribute for new blank line
	MOV	CX, 0006h		; scrn id, read char
	MOV	AX, 174Fh		; from row 23 col 79
	MOV	DI, DS:IMAGE_ID		; image id
	INT	SCR_DRV
				; scroll the screen up
	MOV	CL, 0Ah			; ..and dropthru to scroll
	MOV	CH, 0			; screen up
	MOV	DX, AX			; recover attributes for blank
	MOV	DL, 0			; line
	MOV	SI, 0
	MOV	DI, DS:IMAGE_ID
	INT	SCR_DRV			; scroll the screen up
IT490:				; print cursor at new position
	cmp	DS:CursorOn,0
	je	IT495			; J if cursor is supposed to be off
	MOV	CL, 0Dh
	MOV	CH, 0
	MOV	AH, DS:C_ROWY
	MOV	AL, DS:C_COLX
	MOV	DI, DS:IMAGE_ID
	INT	SCR_DRV
IT495:				; last exit point here
	JMP	IT290
;================================================
IT500:			; AH = 9, write attr/char at cursor pos
			; BH = display page
			; CX = count of chars to write
			; AL = char to write
			; BL = attributes
			; this handler tested 27/6/85 jon
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	push	CS
	pop	DS
	MOV	DS:TEMP1, CX		; save char count in TEMP1
	MOV	CH, BL			; attributes to CH
	MOV	CL, AL			; char to CL
	MOV	DS:TEMP2, CX		; save attribs/char in TEMP2
				; turn the cursor off
	MOV	CX, 000Eh		; scrn id, cursor off
	MOV	DI, DS:IMAGE_ID		; image i.d. to DI
	INT	SCR_DRV			; and turn the cursor off
				; find & copy the current cursor position
	MOV	AH, DS:C_ROWY		; cursor y co-ord
	MOV	AL, DS:C_COLX		; cursor x co-ord
IT510:	MOV	DS:TEMP3, AX		; save curpos in TEMP3
				; write out the char/attribs
	MOV	CX, 0004		; scrn id, write char/attribs
	MOV	DX, DS:TEMP2		; recover char/attribs
	MOV	SI, 0			; point to default font
	MOV	DI, DS:IMAGE_ID		; image i.d. to SI
	INT	SCR_DRV			; write char/attributes
				; check for a multi-char call and increase
				; x-y to point to next cell if needed
	DEC	DS:TEMP1		; reduce character count
	JZ	IT530			; if it's zero, we quit
	MOV	AX, TEMP3		; retrive char x-y position
	INC	AL			; bump the column (x)
	CMP	AL, 80			; off the edge ?
	JL	IT520			; no, put next char there
	MOV	AL, 0			; else reset col to zero
	INC	AH			; and bump the row
	CMP	AH, 25			; off the bottom ?
	JL	IT520			; no, next char can go there
	MOV	AH, 0			; else row (y) reset to zero
IT520:	JMP	IT510			; loop back to print next char
IT530:				; all finished, turn the cursor back on at
				; the original position ( this call may have
				; printed a string but will not update the
				; cursor x,y co-ordinates )
	cmp	DS:CursorOn,0
	je	IT531			; J if cursor is supposed to be off
	MOV	CX, 000Dh		; scrn id, cursor on
	MOV	AH, DS:C_ROWY		; set ORIGINAL y co-ord
	MOV	AL, DS:C_COLX		; set ORIGINAL x co-ord
	MOV	DI, DS:IMAGE_ID		; DI = image i.d.
	INT	SCR_DRV			; turn the cursor back on
IT531:
				; dropthru to pop reg's & exit
	JMP	IT290
;================================================
IT600:				; AH = 6, scroll active page up
				; AL = number of lines ( 0 = blank window )
				; CH,CL=row,col upper lh corner of scroll
				; DH,DL=row,col lower rh corner of scroll
				; BH = attribute to be used on blank line
				; this handler tested 1/7/85 jon
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	push	CS
	pop	DS
			; save caller's parms
	XOR	AH, AH			; set call code to zero
	MOV	DS:TEMP1, AX		; save no. of lines (AL)
	MOV	DS:TEMP2, BX		; save new blank line atr (BH)
				; validate upper l.h. co-ordinates
	CMP	CH, 25
	JL	IT601
	MOV	CH, 24
IT601:	CMP	CL, 80
	JL	IT602
	MOV	CL, 79
IT602:			; validate lower r.h. co-ordinates
	CMP	DH, 25
	JL	IT603
	MOV	DH, 24
IT603:	CMP	DL, 80
	JL	IT604
	MOV	DL, 79
			; save the scroll co-ordinates
IT604:	MOV	DS:TEMP3, CX		; upper l.h. row(CH), col (CL)
	MOV	DS:TEMP4, DX		; lower r.h. row(DH), col (DL)
			; turn the cursor off
	MOV	CL, 0Eh			; 'cursor off' code
	MOV	CH, 0			; screen i.d.
	MOV	DI, DS:IMAGE_ID		; image id to DI
	INT	SCR_DRV			; turn the cursor off
			; decide whether to blank or scroll window
	MOV	AX, DS:TEMP1		; recover no. of lines
	CMP	AL, 0			; clear whole window ?
	JZ	IT610			; yes, just a 'smear' call
	JMP	IT680			; no, do a block move
IT610:			; clear the window with a 'smear'
	MOV	CL, 8			; 'smear block' code
	MOV	CH, 0			; screen i.d. is 0
	MOV	DX, DS:TEMP2		; DH = attribs of area
	MOV	DL, ' '			; DL = fill char ( space )
	MOV	AX, DS:TEMP3		; top lh co-ords
	MOV	BX, DS:TEMP4		; bot rh co-ords
	MOV	SI, 0			; use default font
	MOV	DI, DS:IMAGE_ID		; set the image id
	INT	SCR_DRV			; smear that block
	JMP	IT690			; and exit
IT680:			; set up parms for block move call
	MOV	AX, DS:TEMP3		; top left hand col in AL
	MOV	DX, DS:TEMP4		; bottom r.h. col in DL
	SUB	DL, AL			; width = r.h. - l.h.
	INC	DL			; treat int EC x extent as base 1
	SUB	DH, AH			; height = bottom - top
	MOV	BX, DS:TEMP3		; top l.h. co-ords to BX
	MOV	AX, BX			; .. and to AX
	INC	AH			; source is 1 row below dest
	MOV	CL, 0Bh			; 'move block' code
	MOV	CH, 0			; screen i.d.
	MOV	DI, DS:IMAGE_ID		; set the image i.d.
	INT	SCR_DRV			; move that block
			; 'smear' the bottom line of block
	MOV	CL, 08h			; 'smear block' code
	MOV	CH, 0			; screen i.d.
	MOV	DX, DS:TEMP2		; retrive attributes
	MOV	DL, ' '			; char is a space
	MOV	AX, DS:TEMP3		; retrive top l.h. co-ords
	MOV	BX, DS:TEMP4		; retrive bot. r.h. co-ords
	MOV	AH, BH			; start row = finish row
	MOV	SI, 0			; point to default font
	MOV	DI, DS:IMAGE_ID		; set the image id
	INT	SCR_DRV			; smear bot line of scrld block
			; try for a loop count
	DEC	DS:TEMP1		; decrement the loop count
	JZ	IT690			; if zero quit
	JMP	IT680			; else loop around
IT690:
			; turn the cursor back on again
	cmp	DS:CursorOn,0
	je	IT691			; J if cursor is supposed to be off
	MOV	CL, 0Dh			; 'cursor on' code
	MOV	CH, 0			; screen id
	MOV	AH, DS:C_ROWY		; set 'y' co-ord
	MOV	AL, DS:C_COLX		; set 'x' co-ord
	MOV	DI, DS:IMAGE_ID		; set image i.d.
	INT	SCR_DRV			; turn cursor back on
IT691:
			; .. and exit popwise
	JMP	IT290
;================================================
IT700:			; AH = 7, scroll active page down
			; AL = no of lines ( 0 = blank window )
			; CH,CL=row,col upper lh corner of scroll
			; DH,DL=row,col lower rh corner of scroll
			; BH = attribute to be used on blank line
			; this handler tested 1/7/85 jon
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	push	CS
	pop	DS
			; save caller's parms
	XOR	AH, AH			; set call code to zero
	MOV	DS:TEMP1, AX		; save no. of lines (AL)
	MOV	DS:TEMP2, BX		; save new blank line atr (BH)
			; validate upper l.h. co-ordinates
	CMP	CH, 25
	JL	IT701
	MOV	CH, 24
IT701:	CMP	CL, 80
	JL	IT702
	MOV	CL, 79
IT702:			; validate lower r.h. co-ordinates
	CMP	DH, 25
	JL	IT703
	MOV	DH, 24
IT703:	CMP	DL, 80
	JL	IT704
	MOV	DL, 79
IT704:			; save the scroll co-ordinates
	MOV	DS:TEMP3, CX		; upper l.h. row(CH), col (CL)
	MOV	DS:TEMP4, DX		; lower r.h. row(DH), col (DL)
			; turn the cursor off
	MOV	CL, 0Eh			; 'cursor off' code
	MOV	CH, 0			; screen i.d.
	MOV	DI, DS:IMAGE_ID		; image id to DI
	INT	SCR_DRV			; turn the cursor off
			; decide whether to blank or scroll window
	MOV	AX, DS:TEMP1		; recover no. of lines
	CMP	AL, 0			; clear whole window ?
	JZ	IT710			; yes, just a 'smear' call
	JMP	IT780			; no, do a block move
IT710:			; clear the window with a 'smear'
	MOV	CL, 8			; 'smear block' code
	MOV	CH, 0			; screen i.d. is 0
	MOV	DX, DS:TEMP2		; DH = attribs of area
	MOV	DL, ' '			; DL = fill char ( space )
	MOV	AX, DS:TEMP3		; top lh co-ords
	MOV	BX, DS:TEMP4		; bot rh co-ords
	MOV	SI, 0			; use default font
	MOV	DI, DS:IMAGE_ID		; set the image id
	INT	SCR_DRV			; smear that block
	JMP	IT690			; and exit
IT780:			; set up parms for block move call
	MOV	AX, DS:TEMP3		; top left hand col in AL
	MOV	DX, DS:TEMP4		; bottom r.h. col in DL
	SUB	DL, AL			; width = r.h. - l.h.
	INC	DL			; make int EC x extent base 1
	SUB	DH, AH			; height = bottom - top
	MOV	BX, DS:TEMP3		; top l.h. co-ords to BX
	MOV	AX, BX			; .. and to AX
	INC	BH			; dest is 1 row below source
	MOV	CL, 0Bh			; 'move block' code
	MOV	CH, 0			; screen i.d.
	MOV	DI, DS:IMAGE_ID		; set the image i.d.
	INT	SCR_DRV			; move that block
			; 'smear' the top line of block
	MOV	CL, 08h			; 'smear block' code
	MOV	CH, 0			; screen i.d. is 0
	MOV	DX, DS:TEMP2		; recover attributes
	MOV	DL, ' '			; char is a space
	MOV	AX, DS:TEMP3		; top l.h. co-ords
	MOV	BX, DS:TEMP4		; bot r.h. co-ords
	MOV	BH, AH			; make bot row = top row
	MOV	SI, 0			; use default font
	MOV	DI, DS:IMAGE_ID		; set image i.d.
	INT	SCR_DRV			; smear that block
			; try for a loop count
	DEC	DS:TEMP1		; decrement the loop count
	JZ	IT790			; if zero quit
	JMP	IT780			; else loop around
IT790:			; turn the cursor back on again
	cmp	DS:CursorOn,0
	je	IT791			; J if cursor is supposed to be off
	MOV	CL, 0Dh			; 'cursor on' code
	MOV	CH, 0			; screen id
	MOV	AH, DS:C_ROWY		; set 'y' co-ord
	MOV	AL, DS:C_COLX		; set 'x' co-ord
	MOV	DI, DS:IMAGE_ID		; set image i.d.
	INT	SCR_DRV			; turn cursor back on
IT791:
			; .. and exit popwise
	JMP	IT290
;================================================
IT800:			; AH = 8, read attr/char at curpos
			; BH = display page
			; on exit AL = char, AH = attributes
			; tested 28/6/85 jon
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
	push	CS
	pop	DS
			; find current cursor position
	MOV	AH, DS:C_ROWY		; cursor y co-ord
	MOV	AL, DS:C_COLX		; cursor x co-ord
			; read char & attribs at x,y ( AL,AH )
	MOV	CX, 0006		; CH=0, CL=6 (scrn id, rd char)
	MOV	DI, DS:IMAGE_ID		; set the image i.d.
	INT	SCR_DRV			; and read the character.
	POP	DS			; Fortunately for us the int
	POP	SI			; EC call has left char in AL
	POP	DI			; and attribs in AH, which is
	POP	DX			; exactly what we want, so just
	POP	CX			; quit now.
	POP	BX
	JMP	IT7999
;================================================
IT900:			; AH = 3, read cursor position
			; BH = display page
			; on exit DH,DL=row,col
			; CH = cursor start line
			; CL = cursor stop line
			; tested 27/6/85 ?
	PUSH	DS			; save DS
	push	CS
	pop	DS
	MOV	DH, DS:C_ROWY		; 'y' to DH
	MOV	DL, DS:C_COLX		; 'x' to DL
	MOV	CX, DS:IBMCursor	; a full block
	POP	DS			; recover DS
	JMP	IT7999
;================================================
IT1000:			; AH = 1, set cursor type
			; CH, bits 0-4 = start line for cursor
			; CL, bits 0-4 = end line for cursor
			; *** NOTE. Cursor type is not alterable
			; in this implementation
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	DS
			; recover DS, save int 10 call parms
	push	CS
	pop	DS
	mov	IBMCursor,CX
	test	CH,20h
	jnz	IT1010			;J if want cursor off wanted.
	mov	AL,CH
	mov	AH,CL			;Move scan lines to correct place for BIOS 3
	mov	CX,0Ch			;Set cursor type on screen id 0
	mov	DL,1			;Cursor type is HARD.
	mov	DI,DS:IMAGE_ID
	int	SCR_DRV
	MOV	CL, 0Dh			; 'cursor on' code
	MOV	CH, 0			; screen id
	MOV	AH, DS:C_ROWY		; set 'y' co-ord
	MOV	AL, DS:C_COLX		; set 'x' co-ord
	MOV	DI, DS:IMAGE_ID		; set image i.d.
	INT	SCR_DRV			; turn cursor back on
	mov	DS:CursorOn,1		; Remember cursor is on.
	JMP	IT290
IT1010:
	MOV	CL, 0Eh			; 'cursor off' code
	MOV	CH, 0			; screen id
	MOV	DI, DS:IMAGE_ID		; set image i.d.
	INT	SCR_DRV			; turn cursor back on
	mov	DS:CursorOn,0		; Remember cursor is off.
	JMP	IT290
;================================================
IT1100:			; AH = 15, return current video state
			; on exit AL = current mode
			; AH = no of screen cols
			; BH = current active display page
	MOV	AL, 7			; 80x25 B & W
	MOV	AH, 80			; 80 columns
	MOV	BH, 0			; current display page
	JMP	IT7999
;================================================
IT1200:			; AH = 11, set colour pallette
			; BH = colour id ( 0-127 )
			; BL = value for that id
			; *** NOTE. Not doing colour yet
	JMP	IT7999
;================================================
IT1300:			; AH = 5, select active display page
			; AL = new page value
			; *** NOTE. Only supporting page 0 here
	JMP	IT7999
;================================================
IT1400:			; AH = 0, set mode
			; AL = mode value
			; *** NOTE. Only supporting mode 7 here
	push	DX
	push	BX
	push	CX
	push	SI
	push	DI
	mov	CX,0Eh
	xor	DI,DI
	int	0ECh			; Turn cursor off
	mov	CX,08h			; smear block
	mov	DX,20h			; with spaces
	xor	DI,DI
	xor	SI,SI
	xor	AX,AX			; Top left
	mov	BX,(24*256)+79		; Bottom right
	int	0ECh			; Smear the block.

	pop	DI
	pop	SI
	pop	CX
	pop	BX
	mov	AH,2
	xor	DX,DX
	int	10h			; call the set cursor position
	pop	DX


	JMP	IT7999
;================================================
IT14FE:				; AH = 0FEh, return video buffer address.
	xor	DI,DI
	mov	ES,DI
	les	DI,Dword Ptr ES:[726h]
	JMP	IT7999
;================================================
IT14FF:				; AH = 0FFh, update video buffer.
	push	AX
	push	BX
	push	CX
	push	DX
	push	SI
	push	DI
	mov	SI,0
	mov	CX,3
	int	0ECh
	pop	DI
	pop	SI
	pop	DX
	pop	CX
	pop	BX
	pop	AX
	JMP	IT7999
;================================================
IT7999:		IRET
INT_10		ENDP
PAGE
;=============================================================================
;= int_00
;=============================================================================
;JOB		int_00 - interrupt handler for int 00h
;ACTION		Allow user to trap divide by zero - usually caused
;		by application using dud info from pointers area of RAM.
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	none
;OUTPUT		:	none
;REG USE	:
;STACK USE	:	2 words.
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_00
INT_00	PROC	NEAR
;=========  INT 00H INTERRUPT ROUTINE ENTRY POINT HERE =================

	JMP	SHORT	IT00
INT00_SAV	dd	0			; old vector save

IT00_Mess	db	0Dh,0Ah,'Divide by zero (at '
IT00_Addr	db	'xxxx:xxxx): Press any key to abort. $'

IT00:
	push	BP
	mov	BP,SP
	push	AX
;	push	BX
;	push	CX
	push	DX
	push	DI
	push	DS
;	push	ES
	mov	AX,CS
	mov	DS,AX
;	mov	ES,AX
	mov	AX,[BP+4]
	mov	DI,Offset IT00_Addr
	call	Hex
	inc	DI
	mov	AX,[BP+2]
	call	Hex
	mov	AH,9
	mov	DX,Offset IT00_Mess
	int	21h
	mov	AX,0C01h
	int	21h			;Flush buffer & input
;	pop	ES
	pop	DS
	pop	DI
	pop	DX
;	pop	CX
;	pop	BX
	pop	AX
	pop	BP
	jmp	Dword Ptr CS:INT00_SAV
INT_00		ENDP

;----------------------------------------------------------------------------
;-----		Subroutine to convert binary to Hex at CS:DI		-----
;-----		Entry with number in AX					-----
;----------------------------------------------------------------------------
;	Corrupts: AX,DX

Hex	Proc	Near
	push	CX
	mov	CX,4
;	jmp	short HexLoop
;Hex2:
;	push	CX
;	mov	CX,2
;	mov	AH,AL
HexLoop:
	push	CX
	mov	DL,AH
	mov	CL,4
	shl	AX,CL
	shr	DL,CL
	push	AX
	add	DL,'0'
	cmp	DL,'9'
	jle	HexOk
	add	DL,7
HexOk:
	mov	AL,DL
	mov	CS:[DI],AL
	inc	DI
	pop	AX
	pop	CX
	loop	HexLoop
	pop	CX
	ret
Hex	Endp
PAGE
;=============================================================================
;= int_11
;=============================================================================
;JOB		int_11 - interrupt handler for int 11h
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	none
;OUTPUT		:	AX = Configuration of machine.
;				This version returns a word reflecting
;				the number of drives and 8087 status.
;REG USE	:
;STACK USE	:	2 words.
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_11
INT_11	PROC	NEAR
;=========  INT 11H INTERRUPT ROUTINE ENTRY POINT HERE =================

	JMP	SHORT	IT11

INT11_SAV	DD	0			; old vector save
ConfigWord	dw	0100001001111101b
		;	5432109876543210

		;	14-15	1 printer fitted.
		;	13	no serial printer (PCjr only)
		;	12	no game IO
		;	9-11	1 Serial port fitted.
		;	8	DMA present (but is not IBM compatible)
		;	6,7	2 disk drives (adjusted at load time)
		;	4,5	80 * 25 monochrome screen
		;	2,3	Motherboard has at least 256K.
		;	1	No 8087 (adjusted at load time)
		;	0	Disk drives are present.

IT11:
		mov	AX,CS:ConfigWord

IT11999:	IRET
INT_11		ENDP
PAGE
;=============================================================================
;= int_12
;=============================================================================
;JOB		int_12 - interrupt handler for int 12h
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	none
;OUTPUT		:	AX = RAM Size of machine in Kbytes.
;				This is derived from the pointers area
;				of RAM at 0:402h
;REG USE	:
;STACK USE	:	2 words.
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_12
INT_12	PROC	NEAR
;=========  INT 12H INTERRUPT ROUTINE ENTRY POINT HERE =================

	JMP	SHORT	IT12

INT12_SAV	DD	0		; old vector save

IT12:
		push	DS
		xor	AX,AX
		mov	DS,AX
		mov	AX,Word ptr DS:[402h]; get store size from low RAM
		push	CX		; It's in units of 16 bytes
		mov	CL,6		; so convert to Kbytes.
		shr	AX,CL
		pop	CX
		pop	DS
IT12999:	IRET
INT_12		ENDP

PAGE
;=============================================================================
;= int_13
;=============================================================================
;JOB		int_13 - interrupt handler for int 13h
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	none
;OUTPUT		:	none
;REG USE	:
;STACK USE	:	2 words.
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_13
INT_13	PROC	FAR
;=========  INT 13H INTERRUPT ROUTINE ENTRY POINT HERE =================

	JMP	SHORT	IT13
INT13_SAV	dd	0			; old vector save

IT13:
if 1
	mov	AH,80h			;Set "Time out"
	stc				; & return with error flagged.
else
	push	BP
	push	BX
	push	CX
	push	DX
	push	DI
	push	DS
	push	ES
	mov	AX,CS
	mov	DS,AX
	mov	ES,AX






	pop	ES
	pop	DS
	pop	DI
	pop	DX
	pop	CX
	pop	BX
	pop	BP
endif
	ret	2
INT_13		ENDP
PAGE
;=============================================================================
;= int_14		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		RS232
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	AH = 0	Initialise RS232 port
;				AL = parms as follows :
;		bits 5,6,7 = baud rate
;		000b = 110 baud		100b = 1200 baud
;		001b = 150 baud		101b = 2400 baud
;		010b = 300 baud		110b = 4800 baud
;		011b = 600 baud		111b = 9600 baud

;		bits 4,3 = parity
;		X0b = none	01b = odd	11b = even

;		bit 2 = no of stopbits
;		0b = 1 stopbit		1b = 2 stopbits

;		bits 1,0 = char length
;		10b = 7 bits		11b = 8 bits

;			AH = 1	transmit char over serial line
;				char is in AL ( preserved ). On exit bit 7
;				of AH is set if unable to xmit. If bit 7 is
;				clear then rest of bits reflect normal status

;			AH = 2	receive char from comms line ( wait )
;				char is returned in AL. On exit AH contains
;				either bit 7 on, which indicates an error,
;				or the current status, except that the only
;				bits left on are the error bits ( 1,2,3,4,7,).
;			AH = 3 return comms line status in AX
;				AH = line status as follows :
;					bit 7 = time out or general err
;					bit 6 = tx reg empty
;					bit 5 = tx buf empty
;					bit 4 = break detect
;					bit 3 = framing error
;					bit 2 = parity error
;					bit 1 = overrun error
;					bit 0 = rx data avail
;				AL ( modem status )
;					bits 4 & 5 supported
;OUTPUT		:
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_14
INT_14	PROC	NEAR

	JMP	SHORT	IS10
INT14_SAV	DD	0
IS10:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DS
	PUSH	ES
	PUSH	DI
	CMP	AH, 0			; initialise port ?
	JZ	IS20			; yes, do that
	JMP	IS100			; no, try next
 IS20:			; initialise the serial port
	push	CS
	pop	DS
	MOV	DS:TEMP1, AX		; save call parms
	MOV	BX, 34h			; 'serial' code
	MOV	CX, 0
	INT	0FCh			; init the serial driver
			; xlat IBM baud code to Apricot baud code
	MOV	AX, DS:TEMP1		; retrieve call parms
	XOR	AH, AH			; ensure AH is 0
	MOV	CL, 5			; bits to lose
	SHR	AL, CL			; now in range 0-7
	MOV	BX, OFFSET BAUD_TAB	; start of xlat table
	ADD	BX, AX			; add offs for our rate
	XOR	DX, DX			; DH = 0
	MOV	DL, DS:[BX]		; get the value
			; set transmit baud rate ( in DX )
	MOV	BX, 34h			; 'serial' code
	MOV	CX, 4			; set xmit baud rate
	INT	0FCh			; do it
			; set receive baud rate ( still in DX )
	INC	CX			; CX = 5 ( set rx baud )
	INT	0FCh			; do it
			; set bits per character
	MOV	AX, DS:TEMP1		; retrive call parms
	AND	AL, 3			; lose all but bits 0,1
	MOV	DX, 8			; set default of 8 bits
	CMP	AL, 2			; 7 bit chars ?
	JNZ	IS30			; no, as you were
	MOV	DX, 7			; else set seven
IS30:	MOV	BX, 34h			; 'serial' code
	MOV	CX, 6			; set xmit bits per char
	INT	0FCh			; do it
	MOV	CX, 7			; set rx bits per char
	INT	0FCh			; do it
			; set number of stop bits
	MOV	AX, DS:TEMP1		; retreive parms
	AND	AL, 04h			; lose all but bit 2
	MOV	CL, 2			; bits to shift
	SHR	AL, CL			; 0=1, 1 = 2 stopbits
	MOV	DX, 1			; set 1 stopbit as default
	CMP	AL, 0			; do we need 2 stopbits ?
	JZ	IS40			; no, that's it
	MOV	DX, 3			; else set 2 stopbits
IS40:	MOV	BX, 34h			; 'serial' code
	MOV	CX, 8			; 'set stopbits' code
	INT	0FCh			; do it
			; set parity
	MOV	AX, DS:TEMP1		; retrive parms
	AND	AL, 18h			; get bits 3,4
	MOV	CL, 3			; bits to shift
	SHR	AL, CL			; AX = 0-3
	MOV	DX, 2			; set even parity initially
	CMP	AL, 2			; AL is 0,1 or 3
	JA	IS50			; it was 3, so quit
	MOV	DL, AL			; else parity is direct xlat
IS50:	MOV	BX, 34h			; 'serial' code
	MOV	CX, 9			; 'set parity' code
	INT	0FCh			; do it
			; update the sio
	MOV	CX, 3			; 'update' code
	INT	0FCh			; do it
			; Set the CNF_s_bioserr byte to 1 ( disable bios retries )
	XOR	BX, BX
	MOV	ES, BX			; set ES = 0
	MOV	DI, WORD PTR ES:[700h]	; ptr offs to DI
	MOV	BX, WORD PTR ES:[702h]	; ptr seg to BX
	MOV	ES, BX			; ES:DI -> bios config table
	MOV	BH, 1
	MOV	ES:[DI+42h], BH		; CNF_s_bioserr = 1

	JMP	IS500

IS100:
	CMP	AH, 1			; transmit a char ?
	JZ	IS110			; yes, do that
	JMP	IS200			; no, try next
IS110:			; transmit a character
	MOV	DL, AL			; swap char to DL
	XOR	AH, AH			; start with zero retcode
	MOV	BX, 34h			; 'serial' code
	MOV	CX, 1			; 'xmit char' code
	INT	0FCh			; do it
	CMP	AX, 0			; did it go ?
	JZ	IS120			; yes, it did
	MOV	AH, 80h			; else set bit 7 of AH ( err )
IS120:	MOV	AL, DL			; replace xmit char
	JMP	IS500

IS200:
	CMP	AH, 2			; receive a character ?
	JZ	IS210			; yes, do that
	JMP	IS300			; no, try next
IS210:			; receive a character
	MOV	BX, 34h			; 'serial' code
	MOV	CX, 2			; 'rx char' code
	MOV	DS:TEMP4, 0FFFFh	; set a timeout counter
IS220:	INT	0FCh			; do it
	CMP	AH, 0			; did we get one ?
	JNZ	IS230			; no, try for timeout
	JMP	IS500			; yes, just quit
IS230:	DEC	DS:TEMP4		; shave the timeout count
	JNZ	IS220			; and try again
	MOV	AH, 80h			; set error code
	JMP	IS500			; .. and quit


IS300:
	CMP	AH, 3			; return comms line status ?
	JZ	IS310			; yes, do that
	JMP	IS500			; just quit then
IS310:			; return comms line status
	XOR	DX, DX			; start retcode at zero
	MOV	BX, 34h			; 'serial' code
	MOV	CX, 01Bh		; 'lookahead' code
	INT	0FCh			; do it
	CMP	AH, 0			; anything there ?
	JNZ	IS320			; no, skip
	OR	DX, 0100h		; set 'rx avail' bit
IS320:	MOV	CX, 12h			; 'dsr status' code
	INT	0FCh			; do it
	CMP	AX, 0			; dsr bit = 1 ?
	JZ	IS330			; no, skip
	OR	DX, 0020h		; set dsr bit in retcode
IS330:	MOV	CX, 10h			; 'cts status' code
	INT	0FCh			; do it
	CMP	AX, 0			; cts bit = 1 ?
	JZ	IS340			; no, skip
	OR	DX, 0010h		; set cts bit in retcode
IS340:
	MOV	AX, DX			; swap to true retcode
	JMP	IS500			; .. and quit

IS500:			; common exit point here
	POP	DI
	POP	ES
	POP	DS
	POP	DX
	POP	CX
	POP	BX
	IRET

INT_14	ENDP
PAGE
;=============================================================================
;= int_15
;=============================================================================
;JOB		int_15 - interrupt handler for int 15h
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:
;-----------------------------------------------------------------------------
;OUTPUT		:	AH = 88h
;			AX = Size of extended memory in Kbytes (Zero).
;		:	AH = C0h
;			ES:BX points to configuration block.
;REG USE	:
;STACK USE	:	2 words.
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_15
INT_15	PROC	FAR
;=========  INT 15H INTERRUPT ROUTINE ENTRY POINT HERE =================

	JMP	SHORT	IT15

INT15_SAV	DD	0		; old vector save

IT15:
		push	DS
		cmp	AH,80h
		jb	IT1598		;J if not defined handler.
		cmp	AH,88h
		jne	IT15n88		;J if not extended memory size req.
		xor	AX,AX
		clc
		jmp	Short IT1599
IT15n88:
		cmp	AH,0C0h
		jb	IT1599
		cmp	AH,0C0h
		jne	IT15nC0
		push	CS
		pop	ES
		mov	BX,Offset ConTab;Exits with ES:BX pointer to config block
IT15nC0:
		clc
		jmp	Short IT1599
IT1598:
		mov	AH,86h
		stc
IT1599:
		pop	DS
IT15999:	ret	2
INT_15		ENDP

PAGE
;=============================================================================
;= int_16		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		keyboard
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	AH = 0	read next ascii char struck from kbd.
;				result in AL, scan code in AH
;			AH = 1	set Z flag to indicate if an ascii char
;				is available to be read.
;				ZF = 1 no code available
;				ZF = 0 code is available
;			AH = 2	return current shift status in AL
;				bit 7 = ins state
;				bit 6 = caps state
;				bit 5 = num state
;				bit 4 = scroll state
;				bit 3 = alt_shift
;				bit 2 = ctrl_shift
;				bit 1 = left_shift
;				bit 0 = right_shift
;			AH = 5	place byte in keyboard buffer from CL.
;			AH = 3	Set "typematic" rate & delay.
;			AH =10h	Extended read
;			AH =11h	Extended ASCII status
;			AH =12h	Return extended shift status in AX
;OUTPUT		:
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_16
INT_16	PROC	NEAR

	JMP	SHORT	IK10
INT16_SAV	DD	0
IK10:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	cmp	AH,12h			; extended shift enquiry?
	je	IK20			; J if so.
	CMP	AH, 2			; is it status enquiry ?
	JZ	IK20			; yes, do that
	JMP	IK100			; else try next
			; return current shift status in AL
IK20:	push	AX			; remember command.
	MOV	BX, 32h			; point to keyboard
	MOV	CX, 0Fh			; 'get status' code
	MOV	DX, 0FF00h		; return it unaffected
	INT	0FCh			; get that status
	MOV	BL, 0			; target status byte
	TEST	AX, 0800h		; was right shift on ?
	JZ	IK25			; no
	OR	BL,00000001b		; set right shift bit
IK25:	TEST	AX, 0100h		; was left shift key on ?
	JZ	IK30			; no
	OR	BL,00000010b		; set left shift bit
IK30:	TEST	AX, 0200h		; was ctrl key on ?
	JZ	IK35			; no
	OR	BL,00000100b		; set ctrl bit
IK35:	TEST	AX, 0400h		; was alt key on ?
	JZ	IK40			; no
	OR	BL,00001000b		; set alt key bit
IK40:	TEST	AX, 2			; was stop key on ?
	JZ	IK45			; no
	OR	BL,00010000b		; set stop bit
IK45:	TEST	AX, 0080h		; was caps lock on ?
	JZ	IK50			; no
	OR	BL,01000000b		; set caps lock bit
IK50:
	cmp	CS:NUM_LOCK,0
	je	IK51
	or	BL,00100000b
IK51:
	MOV	AL, BL			; return status in AL
	pop	BX			;Get command back from stack.
	MOV	AH,BH			; replace the call code
	cmp	AH,12h
	jne	IK99
	xor	AH,AH			;Flush extention bits
IK99:
	JMP	IK300			; .. and quit

IK100:
	CMP	AH, 1	; set Z flag if char is available
	JNZ	IK200
	PUSH	BP			; save BP
	MOV	BP, SP
	int	28h			; Wake up keyboard faker if running.
	MOV	BX, 32h			; 'keyboard' code
	MOV	CX, 0Ch			; look ahead
	INT	0FCh
	CMP	AH, 0			; anything there ?
	JZ	IK110			; yes, got one
	OR	WORD PTR [BP+12], 0040h	; turn ZF to 1 on stack
	POP	BP			; restore caller's BP
	JMP	IK300			; and quit
IK110:	AND	WORD PTR [BP+12], 0FFBFh; turn ZF to 0 on stack
	POP	BP			; restore caller's BP
	JMP	IK250			; quit through xlat routine
IK200:			; return next char in AL ( wait if needed )
	CMP	AH, 0
	JNZ	IK260			; call code no good
	int	28h			; Wake up keyboard faker if running.
	MOV	BX, 32h			; 'keyboard' code
	MOV	CX, 0Bh			; get next key, waiting ..
	INT	0FCh			; .. if necessary.
IK250:	PUSH	DS			; save orig DS
	push	CS
	pop	DS
	MOV	BX, OFFSET KEY_XLAT_TAB	; get start of table
	XOR	AH, AH			; clear the high byte
	SHL	AX, 1			; *2 for words
	ADD	BX, AX			; add to offset
	MOV	AX, [BX]		; get scan code & ascii
	POP	DS			; restore caller's DS
	jmp	IK300
IK260:			; set typematic speeds
;	cmp	AX,0305h
;	jne	IK290

IK290:			; plonk byte in keyboard buffer
	cmp	AH,5
	jne	IK300
	mov	DL,CL			;Move ASCII byte
	xor	DH,DH
	mov	BX,32h
	mov	CX,8
	int	0FCh			;Call control device to do the job
	and	AL,01h			;Mask reply to match IBM spec
IK300:
	POP	DX
	POP	CX
	POP	BX
	IRET

INT_16	ENDP
PAGE
;=============================================================================
;= int_17		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		INT 17 interrupt service routine.
;ACTION		Responsible for IBM type printer i-o
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:	Uses int FC
;-----------------------------------------------------------------------------
;INPUT		:	AH = 0 ( print char )
;			AL = char to print.
;OUTPUT		:	status and/or error code in AH. AL preserved
;INPUT		:	AH = 1 ( initialise printer port )
;OUTPUT		:	AH returns printer status
;INPUT		:	AH = 2 ( read printer status )
;OUTPUT		:	AH returns printer status
;ERRORS		:	None.
;REG USE	:	AX, BX
;STACK USE	:	2 words.
;RAM USE	:	None.
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_17
INT_17	PROC	NEAR

	JMP	SHORT	IP10
INT17_SAV	DD	0
IP10:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	CMP	AH, 0			; print char ?
	JNZ	IP30			; no, try next
	MOV	BX, 35h			; control device - printer
	MOV	CX, 7			; print char code
	MOV	DL, AL			; move char to DL
	INT	0FCh			; print that char
	CMP	AX, 0			; any errors ?
	JZ	IP20			; no, continue
	MOV	AH, 19h			; set error code for caller
	JMP	IP25			; skip the ack set
IP20:	MOV	AH, 10h			; set 'ack' code for caller
IP25:	MOV	AL, DL			; replace print char
	JMP	IP100			; and quit

IP30:	CMP	AH, 1			; initialize port ?
	JNZ	IP60			; no, try next
	MOV	BX, 35h			; printer code
	MOV	CX, 0			; init driver
	INT	0FCh			; do it
	MOV	CX, 6			; set device par/ser
	MOV	DX, 0			; set to parallel
	INT	0FCh			; do it
	MOV	CX, 5			; set auto lf after cr
	MOV	DX, 0			; disable it
	INT	0FCh			; do it
	MOV	CX, 0Ah			; return output status
	INT	0FCh			; do it
	CMP	AX, 0			; any errors ?
	JZ	IP40			; no, continue
	MOV	AH, 18h			; set 'no paper' code
	JMP	IP100			; and quit
IP40:	MOV	AH, 90h			; not busy, selected
	JMP	IP100			; and quit

IP60:	CMP	AH, 2			; report status ?
	JNZ	IP100			; no, just quit
	MOV	BX, 35h			; printer code
	MOV	CX, 0Ah			; 'get status' code
	INT	0FCh			; do it
	CMP	AX, 0			; any errors ?
	JNZ	IP65			; yes, check them
	MOV	AH, 90h			; set not busy, selected
	JMP	IP100			; .. and quit
IP65:	MOV	AL, 18h			; set error code
					; and dropthru
IP100:	POP	DX
	POP	CX
	POP	BX
	IRET
INT_17	ENDP
PAGE
;=============================================================================
;= int_5		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		INT 5 interrupt service routine.
;ACTION		Responsible for IBM type print screen service
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:	Uses int 17h
;-----------------------------------------------------------------------------
;INPUT		:	None
;OUTPUT		:	None
;ERRORS		:	None.
;REG USE	:	None
;STACK USE	:	n words.
;RAM USE	:	None.
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_5
INT_5	PROC	NEAR

	JMP	SHORT	PP10
INT5_SAV	DD	0
PP10:
	PUSH	AX
	mov	AL,7			;Send Esc & to the standard
	pushf
	call	Dword Ptr INTF1_SAV	; screen driver. This causes a
	mov	AL,27			;Send Esc & to the standard
	pushf
	call	Dword Ptr INTF1_SAV	; screen driver. This causes a
	mov	AL,'&'			; dump of the current System
	pushf
	call	Dword Ptr INTF1_SAV	; Virtual Screen (i.e. ours.)
	push	BX
	push	CX
	mov	AH,3
	int	10h
	mov	AH,1
	int	10h
	pop	CX
	pop	BX
	POP	AX
	IRET
INT_5	ENDP
PAGE
;=============================================================================
;= int_1A		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Service clock requests
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	AH = 0	read current clock setting
;OUTPUT		:	CX = high portion of count
;			DX = low portion of count
;			AL = 0 if timer has not passed 24 hours
;			since it was last read.
;			AL <> 0 if timer has passed 24 hours since
;			it was last read.

;INPUT		:	AH = 1 set the timer counts
;OUTPUT		:	CX = high portion of count
;			DX = low portion of count
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_1A
INT_1A	PROC	NEAR

	JMP	SHORT	IC10
INT1A_SAV	DD	0
IC10:
	CMP	AH, 0			; read the time ?
	JNZ	IC20			; no, try next
			; reading the timer
	MOV	CX, CS:TOD_HI		; put high portion in CX
	MOV	DX, CS:TOD_LO		; put low portion in DX
	MOV	AL, CS:TOD_FLG		; put oflo flag in AL
	MOV	CS:TOD_FLG, 0		; reset oflo flag
	JMP	IC100			; .. and quit
IC20:			; setting the timer
	CMP	AH, 1			; set the time ?
	JNZ	IC100			; no, quit then
	MOV	CS:TOD_HI, CX		; set high portion = CX
	MOV	CS:TOD_LO, DX		; set low portion = DX
	MOV	CS:TOD_FLG, 0		; reset oflo flag
IC100:					; dropthru to quit
	IRET

INT_1A	ENDP
;=========================================================
;	CLOCK VARIABLE STORAGE - saved in pgroup for speed
;=========================================================
TOD_FLG		DB	0
TOD_HI		DW	0
TOD_LO		DW	0
TOD_TICKS	DW	0
;=============================
PAGE
;=============================================================================
;= int 29		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Dummy int 29 handler
;ACTION		Jump immediately to int F1 handler
;-----------------------------------------------------------------------------
PUBLIC	INT_29
INT_29	PROC	NEAR

	JMP	SHORT	IX10
INT29_SAV	DD	0
IX10:	JMP	INT_F1

INT_29	ENDP
PAGE
;=============================================================================
;= int_e6		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Toggle the state of DS:NUM_LOCK, catch SYSREQ etc.
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:
;OUTPUT		:
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_E6
INT_E6	PROC	NEAR

	JMP	SHORT	IE5
INTE6_SAV	DD	0
IE5:	CMP	AL, 12			; is it for us ?
	JNZ	IE100			; nope
			; toggle the state of num_lock
	NOT	BYTE PTR CS:NUM_LOCK	; toggle num lock state
	MOV	AL, 0			; alter key code to null
					; .. and dropthru for exit
IE100:
	cmp	AL,11
	jne	IE101
	push	AX
	mov	AH,85h
	int	15h			;Call user's SYSREQ handler.
	pop	AX
	jmp	short IE699
IE101:
	cmp	AL,5			;Is this the STOP key?
	jne	IE699
	xor	CS:StopChanged,AL	; If so, remember it.
IE699:
	JMP	CS:DWORD PTR [INTE6_SAV]; jump to orig address

INT_E6	ENDP
PAGE
;=============================================================================
;= int_f1		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Int F1 interrupt service routine. *** NOTE This routine
;		is also connected to int 29h
;ACTION		Pipe all esc.seq. handler calls through int 10h, write tty
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	AL = char to print
;OUTPUT		:	None. All registers preserved
;ERRORS		:	None
;REG USE	:	AX, BX
;STACK USE	:	2 words
;RAM USE	:	None
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_F1
INT_F1 PROC	NEAR
	JMP	SHORT	IV10
INTF1_SAV	DD	0
IV10:
	PUSH	AX
	PUSH	BX
	MOV	AH, 14
	MOV	BH, 0
	INT	10h
	POP	BX
	POP	AX
	IRET
INT_F1	ENDP
PAGE
;=============================================================================
;= int_f9		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		Catch numeric keys while num_lock on
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:
;OUTPUT		:
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_F9
INT_F9	PROC	NEAR

	JMP	SHORT	IF5
INTF9_SAV	DD	0
IF5:	CLI				; disable interrupts
	PUSH	DS			; save caller's DS
	push	CS
	pop	DS
	CMP	BYTE PTR DS:NUM_LOCK, 0	; is num lock on ?
	JZ	IF99			; no, exit now
	CMP	AL, 0CBh		; was it naughty '9' ?
	JNZ	IF10			; no, keep going
	MOV	BL, 39h			; xlat to proper '9'
	MOV	AX, 0FFFFh		; set 'pass to dos' code
	JMP	IF100			; .. and exit
IF10:	CMP	AL, 0E4h		; was it naughty '1' ?
	JNZ	IF20			; no, keep going
	MOV	BL, 31h			; xlat to proper '1'
	MOV	AX, 0FFFFh		; set 'pass to dos' code
	JMP	IF100			; .. and quit
IF20:	CMP	AL, 0C8h		; was it naughty '3' ?
	JNZ	IF100			; no, just quit then
	MOV	BL, 33h			; xlat to proper '3'
	MOV	AX, 0FFFFh		; set 'pass to dos' code
	jmp	short IF100		; dropthru and quit
IF99:
	cmp	BL,0FEh			;Is this the Screen Print key?
	jne	IF101
	int	5			; Start screen dump
	xor	AX,AX			; & ignore key.
	pop	DS
	iret
IF101:
	cmp	BL,0FDh			;Is this the Calculator key?
	jne	IF100
;	int	5			; Start screen dump
	xor	AX,AX			; & ignore key.
	pop	DS
	iret
IF100:
	POP	DS			; recover caller's DS
	STI				; enable interrupts
	JMP	CS:DWORD PTR [INTF9_SAV]; jump to orig address

INT_F9	ENDP
PAGE
;=============================================================================
;= int_ff		*** INTERRUPT SERVICE ROUTINE
;=============================================================================
;JOB		System timer pipe
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:
;OUTPUT		:
;ERRORS		:
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	INT_FF
INT_FF	PROC	NEAR

	JMP	SHORT	IA10
INTFF_SAV	DD	0
IA10:
	PUSH	AX			; save AX for the moment
	MOV	AX, CS:TOD_TICKS	; get 'ticks' word
	INC	AL			; bump the 'ticks' count
	ADD	AL, AH			; add the flag ( 1 or 0 )
	CMP	AL, 3			; ticks count reached ?
	JZ	IA20			; yes, handle it
	SUB	AL, AH			; else take flag away again
	JMP	IA100			; and quit
IA20:	INT	01Ch			; cause 'user' interrupt
	XOR	AH, 1			; toggle ticks count flag
	XOR	AL, AL			; zeroise ticks count
	INC	CS:TOD_LO		; bump low count
	JNO	IA30			; no oflo, skip hi bump
	INC	CS:TOD_HI		; bump hi count
IA30:	CMP	CS:TOD_HI, 17h		; close to 24 hours ?
	JNZ	IA100			; not close enough
	CMP	CS:TOD_LO, 0FE80h	; on the button ?
	JNZ	IA100			; no, not quite
			; 24 'hours' elapsed, reset clock
	MOV	CS:TOD_LO, 0
	MOV	CS:TOD_HI, 0
	MOV	CS:TOD_FLG, 1		; toggle oflo flag
IA100:
	MOV	CS:TOD_TICKS, AX	; replace ticks count
	POP	AX
	JMP	CS:DWORD PTR [INTFF_SAV]; quit thru bios

INT_FF	ENDP
;
;
;
;==========================
; - END OF MAIN PROGRAM CODE
;==========================
PAGE
;=============================================================================
;================
; - DATA
;================

COM_PARM	DB	0		; command line parameter code
PARM1		DB	'NO',0		; allowable command line
PARM2		DB	'VERBOSE',0	; parms
FTAB_SEG	DW	0		; ptr to format struc segment
FTAB_OFFS	DW	0		; ptr to format struc offset
C_ROWY		DB	0		; cursor position storage
C_COLX		DB	0
IBMCursor	dw	31		;IBM start & end lines for cursor
IMAGE_ID	DW	0
TEMP1		DW	0		; These four locations are
TEMP2		DW	0		; used as temporary storage
TEMP3		DW	0		; because the int EC calls
TEMP4		DW	0		; kill so many reg's
NUM_LOCK	DB	0		; num lock key state (1 or 0)
CursorOn	db	1		; Set zero if cursor is off.
StopChanged	db	0		; Set Non-zero when STOP pressed
ConTab		db	8,0AAh,01,3,0,0,0,0,0




; ===========================================
;	BAUD RATE TRANSLATION TABLE
; ===========================================
BAUD_TAB	DB	3,5,6,7,8,10,12,14

; ==========================================
; 	KEYBOARD TRANSLATION TABLE
; ==========================================

;	The emulator takes the 'ASCII' value returned from the standard
;	keyboard table, and translates it to the relevant ASCII code and
;	scan code by a simple lookup in this table.
;	E.g. Control-C would return AX=2E03h (the fourth entry in the table).

KEY_XLAT_TAB	LABEL	BYTE
	db	00h,03h
	db	01h,1Eh		; AL, Ah
	db	02h,30h
	db	03h,2Eh
	db	04h,20h
	db	05h,12h
	db	06h,21h
	db	07h,22h
	db	08h,0eh		; ?
	db	09h,0fh
	db	0Ah,24h
	db	0Bh,25h
	db	0Ch,26h
	db	0Dh,1ch		; AL, Ah
	db	0Eh,31h
	db	0Fh,18h
;	Offset 10h
	db	10h,19h,11h,10h,12h,13h,13h,1Fh
	db	14h,14h,15h,16h,16h,2Fh,17h,11h
	db	18h,2Dh,19h,15h,1Ah,2Ch,1Bh,01h
	db	1Ch,2Bh,1Dh,1Bh,1Eh,07h,1Fh,0Ch
;	Offset 20h
	db	20h,39h,21h,02h,22h,28h,23h,04h
	db	24h,05h,25h,06h,26h,08h,27h,28h
	db	28h,0Ah,29h,0Bh,2Ah,09h,2Bh,0Dh
	db	2Ch,33h,2Dh,0Ch,2Eh,34h,2Fh,35h
;	Offset 30h
	db	30h,0Bh,31h,02h,32h,03h,33h,04h
	db	34h,05h,35h,06h,36h,07h,37h,08h
	db	38h,09h,39h,0Ah,3Ah,27h,3Bh,27h
	db	3Ch,33h,3Dh,0Dh,3Eh,34h,3Fh,35h
;	Offset 40h
	db	40h,03h,41h,1Eh,42h,30h,43h,2Eh
	db	44h,20h,45h,12h,46h,21h,47h,22h
	db	48h,23h,49h,17h,4Ah,24h,4Bh,25h
	db	4Ch,26h,4Dh,32h,4Eh,31h,4Fh,18h
;	Offset 50h
	db	50h,19h,51h,10h,52h,13h,53h,1Fh
	db	54h,14h,55h,16h,56h,2Fh,57h,11h
	db	58h,2Dh,59h,15h,5Ah,2Ch,5Bh,1Ah
	db	5Ch,2Bh,5Dh,1Bh,5Eh,07h,5Fh,0Ch
;	Offset 60h
	db	60h,29h,61h,1Eh,62h,30h,63h,2Eh
	db	64h,20h,65h,12h,66h,21h,67h,22h
	db	68h,23h,69h,17h,6Ah,24h,6Bh,25h
	db	6Ch,26h,6Dh,32h,6Eh,31h,6Fh,18h
;	Offset 70h
	db	70h,19h,71h,10h,72h,13h,73h,1Fh
	db	74h,14h,75h,16h,76h,2Fh,77h,11h
	db	78h,2Dh,79h,15h,7Ah,2Ch,7Bh,1Ah
	db	7Ch,2Bh,7Dh,1Bh,7Eh,29h,7Fh,0Eh
;	Offset 80h
;	alt keys 1..9 , 0 - = ,A..Z
	db	00,78h,00,79h,00,7ah,00,7bh
	db	00,7ch,00,7dh,00,7eh,00,7fh
	db	00,80h,00,81h,00,82h,00,83h
	db	00,1eh,00,30h,00,2eh,00,20h
;	Offset 90h
	db	00,12h,00,21h,00,22h,00,23h
	db	00,17h,00,24h,00,25h,00,26h
	db	00,32h,00,31h,00,18h,00,19h
	db	00,10h,00,13h,00,1fh,00,14h
;	Offset A0h
	db	00,16h,00,2fh,00,11h,00,2dh
	db	00,15h,00,2ch

; alt f1 - f10
	db	00,68h,00,69h,00,6ah,00,6bh
	db	00,6ch,00,6dh,00,6eh,00,6fh
	db	00,70h,00,71h
;	Offset B0h
	db	00,00
	db	00,3Bh			;F1 - F10
	db	00,3Ch
	db	00,3Dh
	db	00,3Eh
	db	00,3Fh
	db	00,40h
	db	0h,41h
	db	0h,42h
	db	0h,43h
	db	0h,44h
	db	10	DUP (?)
;	Offset C0h
	db	0h,73h			;Control/Left arrow
	db	0h,4Dh			;Right arrow
	db	36h,4Dh
	db	0h,74h			;Control/Right arrow
	db	0h,50h			;Down Arrow
	db	032h,50h
	db	0h,48h			;Up Arrow
	db	038h,48h
	db	0h,51h			;PgDn
	db	033h,51h
	db	0h,76h			;Control/PgDn
	db	0h,49h			;PgUp
	db	039h,49h
	db	0h,84h			;Control/PgUp
	db	0h,77h			;Control/Home
	db	0h,47h			;Home
;	Offset D0h
	db	037h,47h
	db	0h,52h			;Insert
	db	030h,52h
	db	0h,53h			;Delete
	db	02eh,53h
	db	0h,72h			;Echo (Control/PrtScr)
	db	02ah,37h
	db	01bh,1ah
	db	08h,23h
	db	4	DUP (?)
	db	0dh,32h
	db	0ah,1Ch
	db	035h,4Ch
	db	02Dh,4Ah		; num pad -
	db	02Bh,4Eh
;	Offset E0h
	db	09h,017h
	db	0h,0Fh			;Shift/Tab
	db	0h,4Bh			;Left arrow
	db	034h,4Bh
	db	0h,4Fh			;End
	db	031h,4Fh
	db	0h,75h			;Control/End
; 0e7 shift f1 - f10
	db	0h,54h,0h,55h,0h,56h,0h,57h
	db	0h,58h,0h,59h,0h,5ah,0h,5bh
	db	0h,5ch
;	Offset F0h
	db	0h,5dh
;
; f1	contrl f1 - f10
	db	0h,5eh,0h,5fh,0h,60h,0h,61h
	db	0h,62h,0h,63h,0h,64h,0h,65h
	db	0h,66h,0h,67h 
; fb
	db      0h,00
	db	0h,00
	db	0FDh,00			; Calculator ON
	db	0FEh,0			; The PRINT SCREEN key.
	db	0h,00

ENDBYTE	db	'THE END'		; THIS MUST BE LAST BIT
;					  OF DATA YOU WISH TO KEEP

;		*** This lot will be thrown away once we have loaded.
HD$		db	'EMIBM Version 1.47 - $'
HI$		db	'Apricot IBM Emulator active.',13,10
		db	'Copyright (C) Apricot (Advanced Technology) Ltd.',13,10
		db	'Parts copyright (C) 1986-9 by MicroExpansions Ltd.',13,10,10,'$'
IN$		db	'Error: Emulator already in memory.',7,13,10,'$'
CF$		db	'Error: Unable to find original copy in memory.',7,13,10,'$'
US$		db	'Error in usage: type EMIBM or EMIBM NO',7,13,10,'$'
TATA$		db	'Emulator terminated and removed from memory.',13,10,'$'
BIOS_Wrong	db	'Error: Incorrect BIOS version',7,13,10,'$'

	db	'@(#) IBM BIOS Emulator	V1.47	Modified by Andy Alston',0
;=============================================================================
;= emibm
;=============================================================================
;JOB	This is the main EMIBM.COM routine
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	op-sys calls
;-----------------------------------------------------------------------------
;INPUT		:	CS = code seg
;			DS = psp
;			ES = psp
;			SS = code seg
;OUTPUT		:	'errorlevel' return code is always zero
;ERRORS		:	Displays error messages by screen driver calls.
;REG USE	:	just about everything
;STACK USE	:	SP started at end of PSP.
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
EMIBM	PROC	NEAR
				; Set up the runtime environment
	mov	AX,CS
	MOV	SS, AX			; likewise for SS
	mov	SP,0FEh			; Set up all the stack

			; analyze command line parms
	CALL	CHK_PARMS		; check cmnd line parms
	MOV	DS:COM_PARM, AL		; store result code
	CMP	AL, 1			; no parms ?
	JNZ	B40			; no, try next option
	JMP	B110			; yes, go do rest of load
B40:	CMP	AL, 3			; or 'verbose' typed ?
	JNZ	B50			; no, try next option
	JMP	B110			; yes, do rest of load
B50:	CMP	AL, 2			; was 'no' typed ?
	JNZ	B60			; no, that's it for now
	JMP	B100			; yes, try and unload
B60:			; arrive here through incorrect usage
	MOV	DX, OFFSET HD$		; version header
	CALL	PRT_MSG			; print it
	MOV	DX, OFFSET US$		; 'wrong usage' message
	CALL	PRT_MSG			; print it
	JMP	B1999			; and exit saving nothing
B100:			; 'no' handler ( unload )
	CALL	UNLOAD
	JMP	B1999			; and quit
B110:			; continue here for load / verbose
			; verbose option is for the moment ignored - it
			; is meant to print out the level of support the
			; emulator will give to an IBM application.

			; check to see we are not already loaded
	CALL	CHK_LOAD		; inspect int 10h vector code
	CMP	AX, 0			; is nothing there ?
	JZ	B120			; nothing, continue
	MOV	DX, OFFSET HD$		; else, 'emibm error'
	CALL	PRT_MSG			; print it
	MOV	DX, OFFSET IN$		; 'already here'
	CALL	PRT_MSG			; print it
	JMP	B1999			; terminate completely

B120:			; ... CHECK THE BIOS VERSION NUMBER !!!!!

	push	ES
	xor	BX,BX
	mov	ES,BX
	mov	BX,400h
	cmp	byte ptr ES:[BX],31h
	pop	ES
	jae	B121			; J if BIOS is OK.
	mov	DX,Offset BIOS_Wrong
	call	PRT_MSG
	jmp	B1999
B121:
			; establish screen format structure pointers
	MOV	CL, 0			; 'format enquiry' code
	MOV	CH, 0			; screen id always 0 ?
	MOV	DL, 2			; extended format request
	INT	SCR_DRV			; call int ECh
	MOV	DS:FTAB_SEG, DX		; seg addr of format struc
	MOV	DS:FTAB_OFFS, SI	; offs addr of format struc
			; reset screen ( for int 10 handler )
	MOV	CL, 1			; 'enable screen' code
	MOV	CH, 0			; screen id
	MOV	BL, 0			; format number
	MOV	BH, 01			; primary font, IBM mono
	MOV	DX, 0			; set virtual image address
	MOV	SI, 0			; = 0:0 ( use default )
	INT	SCR_DRV			; do it
	MOV	DS:IMAGE_ID, DX		; save image id
			; print the sign-on message
	MOV	DX, OFFSET HD$
	CALL	PRT_MSG
	MOV	DX, OFFSET HI$
	CALL	PRT_MSG
			; kill cursor positioning by the int F1 handler
	MOV	AL, 27			; 'ESC'
	INT	0F1h
	MOV	AL, 'x'			; 'x'
	INT	0F1h
	MOV	AL, '5'			; '5'
	INT	0F1h
			; set bios kbd drvr into mode locking for ALT key
	MOV	BX, 32h			; 'keyboard' code
	MOV	CX, 10h			; mode locking
	MOV	DX, 1			; turn it on
	INT	0FCh			; call the bios
			; connect the int 10h vector
	MOV	DI, OFFSET INT10_SAV	; point to vector storage
	MOV	AL, 10h			; vector number to get
	MOV	DX, OFFSET INT_10	; DS:DX = addr int_10
	CALL	CON_VEC
			; connect the int 5 vector (print screen)
	MOV	DI, OFFSET INT5_SAV
	MOV	AL, 5h
	MOV	DX, OFFSET INT_5
	CALL	CON_VEC
			; connect the int 11h vector
	MOV	DI, OFFSET INT11_SAV
	MOV	AL, 11h
	MOV	DX, OFFSET INT_11
	CALL	CON_VEC
			; connect the int 12h vector
	MOV	DI, OFFSET INT12_SAV
	MOV	AL, 12h
	MOV	DX, OFFSET INT_12
	CALL	CON_VEC
			; connect the int 13h vector
	MOV	DI, OFFSET INT13_SAV
	MOV	AL, 13h
	MOV	DX, OFFSET INT_13
	CALL	CON_VEC
			; connect the int 14h vector
	MOV	DI, OFFSET INT14_SAV
	MOV	AL, 14h
	MOV	DX, OFFSET INT_14
	CALL	CON_VEC
			; connect the int 14h vector
	MOV	DI, OFFSET INT15_SAV
	MOV	AL, 15h
	MOV	DX, OFFSET INT_15
	CALL	CON_VEC
			; connect the int 16h vector
	MOV	DI, OFFSET INT16_SAV	; point to vector storage
	MOV	AL, 16h			; vector number to get
	MOV	DX, OFFSET INT_16; DS:DX = addr int_16
	CALL	CON_VEC
			; connect the int 17h vector
	MOV	DI, OFFSET INT17_SAV	; point to vector storage
	MOV	AL, 17h			; vector number to get
	MOV	DX, OFFSET INT_17	; DS:DX = addr int_17
	CALL	CON_VEC
			; connect the int 1Ah vector
	MOV	DI, OFFSET INT1A_SAV
	MOV	AL, 1Ah
	MOV	DX, OFFSET INT_1A
	CALL	CON_VEC
			; connect the int 29h routine
	MOV	DI, OFFSET INT29_SAV
	MOV	AL, 29h
	MOV	DX, OFFSET INT_29
	CALL	CON_VEC
			; connect the int E6 vector
	MOV	DI, OFFSET INTE6_SAV	; point to vector storage
	MOV	AL, 0E6h		; vector number to get
	MOV	DX, OFFSET INT_E6	; DS:DX = addr int_E6
	CALL	CON_VEC
			; connect the int F1 routine
	MOV	DI, OFFSET INTF1_SAV
	MOV	AL, 0F1h
	MOV	DX, OFFSET INT_F1
	CALL	CON_VEC
			; connect the int F9h vector
	MOV	DI, OFFSET INTF9_SAV	; point to vector storage
	MOV	AL, 0F9h		; vector number to get
	MOV	DX, OFFSET INT_F9	; DS:DX = addr int_F9
	CALL	CON_VEC
			; connect the int FFh vector
	MOV	DI, OFFSET INTFF_SAV	; point to vector storage
	MOV	AL, 0FFh		; vector number to get
	MOV	DX, OFFSET INT_FF	; DS:DX = addr int_FF
	CALL	CON_VEC
;	Connect Divide Overflow vector
	MOV	DI, OFFSET INT00_SAV	; point to vector storage
	MOV	AL, 0			; vector number to get
	MOV	DX, OFFSET INT_00	; DS:DX = addr int_00
	CALL	CON_VEC
			; Save the CNF_s_bioserr byte ( for serial comms )
	XOR	AX, AX
	MOV	ES, AX			; set ES = 0
	MOV	DI, ES:[700h]		; ptr offs to DI
	MOV	BX, ES:[702h]		; ptr seg to BX
	MOV	ES, BX			; ES:DI -> bios config table
	MOV	AL, ES:[DI+42h]		; AL = CNF_s_bioserr
	MOV	CS:[CNF_S_BIOS], AL	; save it
			; set up the sound driver for int 10 handler
	MOV	BX, 38h			; control device code
	MOV	CX, 0			; init sound driver
	INT	0FCh			; do it
			; set the initial cursor position to 23,0
	MOV	AX, 1700h
	MOV	DS:C_ROWY, AH
	MOV	DS:C_COLX, AL
			; deallocate environment requirement
	push	ES
	MOV	ES,DS:[2Ch]		; get environment seg addr
	MOV	AH,49h			; 'free up memory' code
	INT	21h			; do it
	pop	ES

			; terminate & stay resident exit point
	mov	AH,1
	mov	CX,0C0Dh
	int	10h			; Set cursor size

	call	SetEquipment		; Set up Equipment List.

;	call	SetScreenSeg		; Claim B800:0 etc.

	MOV	DX, OFFSET ENDBYTE	; highest DS offset
	MOV	CL, 4			; bits to shift
	SHR	DX, CL			; conv to paras
	INC	DX			; plus one for safety
	MOV	AH, 31h			; 'keep process' code
	MOV	AL, 0			; errorlevel = 0
	INT	21h			; au revior........

;======================= debug exit point ========================
; exit leaving binary value in AL as a char on the screen for
; debug purposes. Not normally used.
	MOV	DL, AL
	ADD	DL, 30h		; conv to printable
	MOV	AH, 2		; temp. print
	INT	21h
;===================  terminate non-resident exit point  ====================
B1999:
	MOV	AL, 0
	MOV	AH, 4Ch			; terminate completely
	INT	21h

EMIBM	ENDP

Control87	dw	?
;
;	Deal with number of disk drives etc. for config. word.
;
SetEquipment	Proc
	push	ES
	xor	AX,AX
	mov	ES,AX			;Point at low RAM
;
	mov	Byte Ptr ES:[449h],7	;Current mode
	mov	Word Ptr ES:[44Ah],80	;No. of cols
	mov	Word Ptr ES:[44Ch],4000	;Bytes on screen
	mov	Word Ptr ES:[44Eh],0	;Offset within screen RAM
	mov	Byte Ptr ES:[462h],0	;Active page
	mov	Word Ptr ES:[463h],3B4h	;6845 address
	mov	Byte Ptr ES:[465h],0
	mov	Byte Ptr ES:[466h],0
;
	mov	AL,ES:[401h]
	mov	CS:ConTab+2,AL
	mov	AL,ES:[400h]
	mov	CS:ConTab+3,AL
	mov	AL,ES:[416h]		;Get number of floppy drives.
	pop	ES
	and	Byte Ptr DS:ConfigWord,00111110b;Remove existing floppy count
	mov	AH,AL			;Take a copy
	dec	AL			;Number of floppies-1
	ror	AL,1
	ror	AL,1
	test	AH,AH
	jz	DoneConfig1
	or	AL,1			;Add "floppies exist"
	or	Byte Ptr DS:ConfigWord,AL;Set in the number of floppy drives
DoneConfig1:
	fninit				;Initialise 8087 if present
	xor	AX,AX			;Insert clock cycles and..
	mov	CS:Control87,AX		;Zeroise test location.
	fnstcw	CS:Control87
	mov	AX,CS:Control87
	cmp	AX,-1			;For some reason, a Xen sets the
	jne	Real8087		; control word to all ones!
	xor	AL,AL
Real8087:
	and	AL,0000010b		;Mask out a flag
	or	Byte Ptr DS:ConfigWord,AL;Set in the 8087 flag.
	push	ES
	xor	AX,AX
	mov	ES,AX
	cmp	Byte Ptr ES:[401h],0
	je	Has8089			;Don't zap the 8089 control.
	mov	AX,ConfigWord
	mov	ES:[410h],AX
Has8089:
	pop	ES
	ret
SetEquipment	Endp
PAGE
;=============================================================================
;= con_vec
;=============================================================================
;JOB		Connect an interrupt routine
;ACTION		Save the old vector in pos provided by caller
;		Connect new routine
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	dos func int 21h codes 35h ( get vector )
;					       25h ( set vector )
;-----------------------------------------------------------------------------
;INPUT		:	DI = CS offset of vector save area ( 4 bytes )
;			AL = interrupt number
;			DX = offset from current CS of interrupt routine
;OUTPUT		:	none
;ERRORS		:	none
;REG USE	:	all preserved
;STACK USE	:	10 words including int calls
;RAM USE	:	leaves old vector in save area
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	CON_VEC
CON_VEC	PROC	NEAR

	PUSH	AX			; general sort of
	PUSH	BX			; register save thingy
	PUSH	DX			; here
	PUSH	DI
	PUSH	ES
			; get the vector. DI already set to vector
			; save offset. AL already set to interrupt
			; number
	PUSH	AX			; save AL for later
	MOV	AH, 35h			; 'get vector' code
	INT	21h			; ES:BX will contain vector
	MOV	CS:[DI], BX		; store offset
	MOV	AX, ES			; swap ES to AX for store
	MOV	CS:[DI+2], AX		; and store segment word
	POP	AX			; recover trashed AL reg
			; now set the new vector ( which is assumed
			; to be CS:DX )
	PUSH	DS			; save orig DS
	PUSH	CS			; and make it a copy
	POP	DS			; of current CS
	MOV	AH, 25h			; 'set vector' code
	INT	21h			; set AL int number = DS:DX
	POP	DS			; recover orig DS

	POP	ES
	POP	DI
	POP	DX
	POP	BX
	POP	AX
	RET

CON_VEC	ENDP
PAGE
;=============================================================================
;= dis_vec
;=============================================================================
;JOB		disconnect an interrupt routine
;ACTION		Get old vector from routine address + 2
;		Connect old vector
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	dos func int 21h codes 35h ( get vector )
;					       25h ( set vector )
;-----------------------------------------------------------------------------
;INPUT		:	AL = interrupt number
;OUTPUT		:	none
;ERRORS		:	*** Note. Relies on old vector being saved +2 bytes
;			away from current vector address
;REG USE	:	AX trashed
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	DIS_VEC
DIS_VEC	PROC	NEAR

	PUSH	BX
	PUSH	DX
	PUSH	ES
	PUSH	DS
			; get the vector pointed to by AL
	PUSH	AX			; save AL for later
	MOV	AH, 35h			; 'get vector' code
	INT	21h			; ES:BX will contain vector
			; retreive the old vector address
	MOV	AX, ES:[BX+4]		; segment to AX
	MOV	DX, ES:[BX+2]		; offset to DX
	MOV	DS, AX			; DS:DX = old vector now
	POP	AX			; recover trashed AL reg
	MOV	AH, 25h			; 'set vector' code
	INT	21h			; set AL int number = DS:DX

	POP	DS
	POP	ES
	POP	DX
	POP	BX
	RET

DIS_VEC	ENDP
PAGE
;=============================================================================
;= unload
;=============================================================================
;JOB		Remove original copy of emibm from memory, free up arena.
;ACTION		Check that we actually have something to unload,
;		find start of orig emibm psp through int 10h vector,
;		recover original vectors and replace them,
;		deallocate mem from psp.
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	int 21h funcs 49h, 25h
;		calls	chk_load
;-----------------------------------------------------------------------------
;INPUT		:	none
;OUTPUT		:	none
;ERRORS		:	produces its own error messages ( assumption is that
;			caller will terminate after this call, errors or not )
;REG USE	:	AX, DX, ES, BX, SI, DS.
;STACK USE	:	2 words max
;RAM USE	:	frees previous emibm arena if found
;LENGTH		:	83h
;CYCLES		:
;=============================================================================
PUBLIC	UNLOAD
UNLOAD		PROC	NEAR
			; check for something to unload
	CALL	CHK_LOAD		; look for emibm code
	CMP	AX, 1			; was it there ?
	JZ	U20			; yes, continue
	MOV	DX, OFFSET HD$		; 'emibm ver x.x -'
	CALL	PRT_MSG			; print it
	MOV	DX, OFFSET CF$		; 'can't find orig copy'
	CALL	PRT_MSG			; print it
	JMP	U100			; and quit
U20:			; find start address of the int 10 routine
	MOV	AH, 35h			; 'get vector' code
	MOV	AL, 10h			; vector number
	INT	21h			; get that vector (in ES:BX)
	MOV	DS:TEMP1, BX		; save offset
	MOV	DS:TEMP2, ES		; save segment
			; find and save orig psp seg address
	MOV	DS:TEMP3, ES
			; Replace the CNF_s_bioserr byte ( for serial comms )
	MOV	DH, ES:[BX+11]		; saved val to DH
	XOR	AX, AX
	MOV	ES, AX			; set ES = 0
	MOV	DI, ES:[700h]		; ptr offs to DI
	MOV	BX, ES:[702h]		; ptr seg to BX
	MOV	ES, BX			; ES:DI -> bios config table
	MOV	ES:[DI+42h], DH		; replace CNF_s_bioserr with saved value
	mov	ES,DS:TEMP2
	mov	BX,DS:TEMP1
			; replace orig int 10 vector ( as a special )
	PUSH	DS			; save DS
	MOV	DX, ES:[BX+7]		; offset
	MOV	DS, ES:[BX+9]		; seg
	MOV	AH, 25h			; set vector ( in DS:DX )
	MOV	AL, 10h			; vector number
	INT	21h			; do it
	POP	DS
			; replace the normal vectors
	MOV	AL, 0h
	CALL	DIS_VEC
	MOV	AL, 5h
	CALL	DIS_VEC
	MOV	AL, 11h
	CALL	DIS_VEC
	MOV	AL, 12h
	CALL	DIS_VEC
	MOV	AL, 13h
	CALL	DIS_VEC
	MOV	AL, 14h
	CALL	DIS_VEC
	MOV	AL, 15h
	CALL	DIS_VEC
	MOV	AL, 16h
	CALL	DIS_VEC
	MOV	AL, 17h
	CALL	DIS_VEC
	MOV	AL, 1Ah
	CALL	DIS_VEC
	MOV	AL, 29h
	CALL	DIS_VEC
	MOV	AL, 0E6h
	CALL	DIS_VEC
	MOV	AL, 0F1h
	CALL	DIS_VEC
	MOV	AL, 0F9h
	CALL	DIS_VEC
	MOV	AL, 0FFh
	CALL	DIS_VEC
			; deallocate orig mem requirement
	MOV	AX, DS:TEMP3
	MOV	ES, AX
	PUSH	ES			; save ES for call ( j.i.c.)
	MOV	AH, 49h			; 'free up memory' code
	INT	21h			; do it
	POP	ES			; recover ES
			; re-enable the esc handler
	MOV	AL, 27
	INT	0F1h
	MOV	AL, 'z'
	INT	0F1h
			; print the 'unloaded' message
	MOV	DX, OFFSET HD$		; 'emibm ver x.x'
	CALL	PRT_MSG			; print it
	MOV	DX, OFFSET TATA$	; 'unloaded, etc'
	CALL	PRT_MSG			; print it
U100:			; proc exit point
	RET				; and quit

UNLOAD		ENDP
PAGE
;=============================================================================
;= chk_parms
;=============================================================================
;JOB		Check parms in psp against known strings
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		:	ES points to start of psp
;OUTPUT		:	AX = 1 means no parms typed
;			AX = 2 means NO typed
;			AX = 3 means VERBOSE typed
;ERRORS		:	AX = 0 is invalid parms code
;REG USE	:
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC		CHK_PARMS
CHK_PARMS	PROC	NEAR
			;point at psp text area & examine for chars
	CALL	CONV_CHRS		; convert a-z to A-Z
	XOR	CX, CX			; CX = 0
	MOV	DI, 80h			; address no of chars typed
	MOV	CL, ES:[DI]		; chars typed count to CX
	CMP	CL, 0			; anything typed ?
	JNZ	C20			; got parms, go test 'em
C15:
	MOV	AX, 1			; nothing there retcode
	JMP	C100			; quit already
C20:			;strip leading spaces
	INC	DI			; point to next parm char
	MOV	AL, ES:[DI]		; stick it in acc
	CMP	AL, ' '			; is it a space ?
	JNE	C30			; no, exit this loop
	dec	CX
	JMP	SHORT	C20		; .. and loop round
C30:			;arrive here with DI -> first real char
			; try for NO
	jcxz	C15			; No parameter left to scan
	MOV	BX, DI			; save the DI value for later
	MOV	SI, OFFSET PARM1	; get the first parm
	MOV	CX, 3			; parm length +1 ?
	REPZ	CMPS BYTE PTR [DI], [SI]; compare it
	JCXZ	C42			; we found 'NO'
			; try for VERBOSE
	MOV	DI, BX			; restore DI
	MOV	SI, OFFSET PARM2
	MOV	CX, 8
	REPZ	CMPS BYTE PTR [DI], [SI]
	JCXZ	C44			; we found 'VERBOSE'

	JMP	C99			; error exit if dropthru

C42:	MOV	AX, 2			; set NO
	JMP	C50
C44:	MOV	AX, 3			; set VERBOSE
					; dropthru ...

C50: 			; check next char after valid parm match
	MOV	CL, ES:[DI-1]		; get the char into CL
	CMP	CL, ' '			; compare with space
	JB	C56			; below is O.K.
	JMP	C99			; above or equal is error
C56:	JMP	C100			; .. and exit

C99:	XOR	AX, AX			; error exit point
C100:	RET

CHK_PARMS	ENDP
PAGE
;=============================================================================
;= conv_chrs
;=============================================================================
;JOB		Convert lowercase to uppercase chars in psp text area
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:
;SOFTWARE	:
;-----------------------------------------------------------------------------
;INPUT		: ES points to start of psp
;OUTPUT		: none
;ERRORS		: none
;REG USE	: BX, AL ( not preserved )
;STACK USE	: none
;RAM USE	: affects last 100h bytes of psp
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	CONV_CHRS
CONV_CHRS	PROC	NEAR

	MOV	BX, 81h			; point to first char in psp
D10:	MOV	AL, ES:[BX]		; pull it into al
	CMP	AL, 'Z'			; is is > 'Z' ?
	JB	D20			; no, skip it
	SUB	AL, 20h			; yes, conv to upper case
	MOV	ES:[BX], AL		; stick it back in psp
D20:	INC	BX			; bump the pointer
	CMP	BX, 0CFh		; end of buffer ?
	JNZ	D10			; no, loop back
	RET				; yes, quit

CONV_CHRS	ENDP
PAGE
;===========================================================================
;= chk_load
;=============================================================================
;JOB		Check for EMIBM already connected to int 10h
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	none
;-----------------------------------------------------------------------------
;INPUT		: none
;OUTPUT		:	AX = 0 if nothing in mem
;ERRORS		:	AX = 1 if emulator already there
;REG USE	:	DS ( preserved )
;			SI, AX, BX ( destroyed )
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	CHK_LOAD
CHK_LOAD	PROC	NEAR

	PUSH	DS
			; obtain the interrupt 10h vector
	MOV	AH, 35h			; 'get vector' code
	MOV	AL, 10h			; get the int 10h vector
	INT	21h			; ES:BX point to int handler
	PUSH	ES			; make DS = ES
	POP	DS			; so DS = segment
	MOV	SI, BX			; and SI = offset
	ADD	SI, 2			; skip the short jump
			; now inspect the bytes pointed to by DS:SI
	LODSB				; get a byte from DS:[SI]
	CMP	AL, 'E'			; was it 'E' ?
	JNZ	E10			; no, quit now
	LODSB				; get next byte
	CMP	AL, 'M'			; was it 'M' ?
	JNZ	E10			; no, quit now
	LODSB				; etc, etc
	CMP	AL, 'I'
	JNZ	E10
	LODSB
	CMP	AL, 'B'
	JNZ	E10
	LODSB
	CMP	AL, 'M'
	JNZ	E10
	MOV	AX, 1			; yes, set 'sig found' code
	JMP	E20			; and return
E10:
	XOR	AX, AX			; set 'no sig found' code
E20:					; .. and dropthru
	POP	DS
	RET

CHK_LOAD	ENDP
PAGE
;=============================================================================
;= prt_msg
;=============================================================================
;JOB		Print a text string on screen
;ACTION
;-----------------------------------------------------------------------------
;CPU		:	8086
;HARDWARE	:	none
;SOFTWARE	:	int 21 call
;-----------------------------------------------------------------------------
;INPUT		: 	DS:DX point to start of message
;			message should end with '$'
;OUTPUT		: none
;ERRORS		: none
;REG USE	: AX ( preserved )
;STACK USE	:
;RAM USE	:
;LENGTH		:
;CYCLES		:
;=============================================================================
PUBLIC	PRT_MSG
PRT_MSG		PROC	NEAR

	PUSH	AX
	MOV	AH, 9
	INT	21h
	POP	AX
	RET

PRT_MSG		ENDP


PROG	Ends

	end	StartPoint
