1000 '*************************************************************************
1010 '*                                                                       *
1020 '* PLOTTER DRIVER         Version 1.03  September 1983                   *
1040 '*                                                                       *
1050 '*                        (C) ACT (Pulsar) & ACT (Office Products) Ltd   *
1060 '*                                                                       *
1070 '*************************************************************************
1080 '
1090 ' SET UP ALL THE STRING AND NUMERIC PARAMETERS
1100 '
1110 DEFINT A-Z
1120 FS$=CHR$(28)
1130 GS$=CHR$(29)
1140 RS$=CHR$(30)
1150 ESC$=CHR$(27)
1160 CLS$=ESC$+"E"
1170 BEL$=CHR$(7)
1180 DR!=ATN(1)/45
1185 MISK$=CHR$(27)+"A"+CHR$(27)+"l"
1190 FLINE=0
1200 ERRM=0
1210 WARN=0
1220 WRTYP=0
1230 '
1240 ' START PLOTTING
1250 '
1260 PRINT ESC$+"y4"                              ' SET UNDERLINE CURSOR
1270 PRINT CLS$
1280 PRINT SPC(29) "PLOT ---- version 1.03"       ' VERSION NO.
1290 PRINT
1300 PRINT SPC(15) "(C) ACT (Pulsar) & ACT (Office Products) Ltd  1983"
1310 PRINT
1320 PRINT
1330 '
1340 ' GET THE FILE NAME AND IF ALL IS WELL, OPEN IT FOR INPUT
1350 '
1360 INPUT "Enter the name of the plot file [.PLT] ";FPLOT$
1370 IF FPLOT$="" THEN GOTO 2000                               ' BACK TO MS-DOS
1371 FOR ZZ1=1 TO LEN(FPLOT$)
1372 IF MID$(FPLOT$,ZZ1,1)="." THEN APLT$="Y"
1373 NEXT ZZ1
1375 IF APLT$="Y" GOTO 1390
1380 FPLOT$=FPLOT$+".PLT"
1390 ON ERROR GOTO 2340
1400 OPEN "I",1,FPLOT$
1410 ON ERROR GOTO 0
1420 '
1430 ' FIND OUT THE TYPE OF PLOTTER IN USE
1440 '
1450 IF EOF(1) THEN ERRM=9 : GOTO 2090
1460 LINE INPUT#1,COM$
1470 FLINE=FLINE+1
1480 '
1490 ' LOAD THE KEY WORD INTO KEY$
1500 '
1510 GOSUB 5210 : GOSUB 5370 : KEY$=TMP$
1520 '
1530 ' DECIDE ON THE PLOTTER TYPE
1540 '
1550 IF KEY$="WRITER-80" THEN WRTYP=80
1560 IF KEY$="WRITER-81" THEN WRTYP=81
1570 IF KEY$=""          THEN 1420
1580 '
1590 ' CHECK THE PLOTTER TYPE
1600 '
1610 IF WRTYP=0 THEN ERRM=1 : GOTO 2090
1620 '
1630 ' FORCE THE PLOTTER INTO GRAPHICS MODE
1640 ' 
1650 LPRINT RS$
1660 '
1670 ' GET THE INSTRUCTION
1680 '
1690 IF EOF(1) THEN WARN=1 : GOTO 2230
1700 LINE INPUT#1,COM$
1710 FLINE=FLINE+1
1720 '
1730 ' LOAD THE KEY WORD INTO KEY$, STRIPPING OFF ALL LEADING SPACES   
1740 '
1750 GOSUB 5210 : GOSUB 5370 : KEY$=TMP$
1760 '
1770 ' DECODE INSTRUCTIONS
1780 '
1790 IF KEY$="DEVEND"  THEN 2000
1800 IF KEY$="MOVETO"  THEN 2420
1810 IF KEY$="LINETO"  THEN 2510
1820 IF KEY$="MOVEBY"  THEN 2600
1830 IF KEY$="LINEBY"  THEN 2690
1840 IF KEY$="PEN"     THEN 2780
1850 IF KEY$="CIRCLE"  THEN 2870
1860 IF KEY$="ARC"     THEN 3110
1870 IF KEY$="BAR"     THEN 3480
1880 IF KEY$="FILL"    THEN 3680
1890 IF KEY$="LINE"    THEN 3950
1900 IF KEY$="HOME"    THEN 4110
1910 IF KEY$="STEP"    THEN 4160
1920 IF KEY$="PRINT"   THEN 4240
1930 IF KEY$="SET"     THEN 4310
1940 IF KEY$="AXIS"    THEN 4600
1950 IF KEY$="MARKER"  THEN 4710
1960 IF KEY$="BORDER"  THEN 4780
1970 IF KEY$="DEFINE"  THEN 4960
1980 IF KEY$="DIRECT"  THEN 5140
1985 IF KEY$="EJECT"   THEN 5800
1990 IF KEY$=""        THEN 1660 ELSE ERRM=2 : GOTO 2090
2000 '
2010 ' DEVICE END ROUTINE
2020 '
2030 CLOSE
2040 '
2050 ' FINI  -  BACK TO MS-DOS
2060 '
2070 PRINT ESC$+"x4"     ' SET BLOCK CURSOR
2080 END
2090 '
2100 ' JB ERROR TRAP
2110 '
2120 PRINT BEL$
2130 PRINT
2140 PRINT "$ FATAL ERROR at line ";FLINE;", ";
2150 IF ERRM=1 THEN PRINT "Plotter type not specified."
2160 IF ERRM=2 THEN PRINT "Undefined plotter operation."
2170 IF ERRM=3 THEN PRINT "Parameter out of range."
2180 IF ERRM=4 THEN PRINT "Invalid option ";PAR$;" in ";KEY$;" statement."
2190 IF ERRM=5 THEN PRINT "Invalid operation for ACT WRITER";WRTYP;"."
2200 IF ERRM=9 THEN PRINT "No data in input file."
2210 PRINT
2220 GOTO 2000
2230 '
2240 ' JC WARNINGS
2250 '
2260 PRINT BEL$
2270 PRINT
2280 PRINT "$ WARNING at line ";FLINE;", ";
2290 IF WARN=1 THEN PRINT "No DEVEND, logical end of file assumed." : GOTO 2000
2300 IF WARN=2 THEN PRINT "Attempt to print a blank line, operation ignored."
2310 IF WARN=3 THEN PRINT KEY$;" not yet implemented for ACT WRITER";WRTYP;"."
2320 PRINT
2330 GOTO 1660
2340 '
2350 ' JE FILE-NOT-FOUND ERROR
2360 ' 
2370 PRINT BEL$
2380 PRINT
2390 PRINT "$ File not found."
2400 PRINT
2410 RESUME 1330
2420 '
2430 ' MOVETO MACRO
2440 '
2450 GOSUB 5210 : PAR1=TMP
2460 IF PAR1<-9999 OR PAR1>9999 THEN ERRM=3 : GOTO 2090
2470 GOSUB 5210 : PAR2=TMP
2480 IF PAR2<-9999 OR PAR2>9999 THEN ERRM=3 : GOTO 2090
2490 LPRINT "M";PAR1;",";PAR2
2500 GOTO 1660
2510 '
2520 ' LINETO MACRO
2530 '
2540 GOSUB 5210 : PAR1=TMP
2550 IF PAR1<-9999 OR PAR1>9999 THEN ERRM=3 : GOTO 2090
2560 GOSUB 5210 : PAR2=TMP
2570 IF PAR2<-9999 OR PAR2>9999 THEN ERRM=3 : GOTO 2090
2580 LPRINT "D";PAR1;",";PAR2
2590 GOTO 1660
2600 '
2610 ' MOVEBY MACRO
2620 '
2630 GOSUB 5210 : PAR1=TMP
2640 IF PAR1<-9999 OR PAR1>9999 THEN ERRM=3 : GOTO 2090
2650 GOSUB 5210 : PAR2=TMP
2660 IF PAR2<-9999 OR PAR2>9999 THEN ERRM=3 : GOTO 2090
2670 LPRINT "R";PAR1;",";PAR2
2680 GOTO 1660
2690 '
2700 ' LINEBY MACRO
2710 '
2720 GOSUB 5210 : PAR1=TMP
2730 IF PAR1<-9999 OR PAR1>9999 THEN ERRM=3 : GOTO 2090
2740 GOSUB 5210 : PAR2=TMP
2750 IF PAR2<-9999 OR PAR2>9999 THEN ERRM=3 : GOTO 2090
2760 LPRINT "J";PAR1;",";PAR2
2770 GOTO 1660
2780 '
2790 ' PEN CHANGE MACRO
2800 '
2810 GOSUB 5210 : PAR1=TMP
2820 IF PAR1<0 THEN ERRM=3 : GOTO 2090
2830 IF WRTYP=80 AND PAR1>3 THEN ERRM=3 : GOTO 2090
2840 IF WRTYP=81 AND PAR1>5 THEN ERRM=3 : GOTO 2090
2850 LPRINT "C";PAR1
2860 GOTO 1660
2870 '
2880 ' CIRCLE MACRO
2890 '
2900 GOSUB 5210 : PAR1=TMP
2910 IF PAR1<-9999 OR PAR1>9999 THEN ERRM=3 : GOTO 2090
2920 GOSUB 5210 : PAR2=TMP
2930 IF PAR2<-9999 OR PAR2>9999 THEN ERRM=3 : GOTO 2090
2940 GOSUB 5210 : PAR3=TMP
2950 IF PAR3<0 OR PAR3>9999 THEN ERRM=3 : GOTO 2090
2960 IF WRTYP=80 THEN 3000
2970 IF WRTYP=81 THEN 3030
2980 WARN=3
2990 GOTO 2230
3000 LPRINT "W";PAR1;",";PAR2;",";PAR3;",";0;",";360;",";1
3010 LPRINT "M";PAR1;",";PAR2
3020 GOTO 1660
3030 LPRINT "M";PAR1+PAR3;",";PAR2
3040 FOR I=1 TO 360
3050     X=PAR3*COS(I*DR!)
3060     Y=PAR3*SIN(I*DR!)
3070     LPRINT "D";PAR1+X;",";PAR2+Y
3080 NEXT I
3090 LPRINT "M";PAR1;",";PAR2
3100 GOTO 1660
3110 '
3120 ' ARC MACRO
3130 '
3140 GOSUB 5210 : PAR1=TMP
3150 IF PAR1<-9999 OR PAR1>9999 THEN ERRM=3 : GOTO 2090
3160 GOSUB 5210 : PAR2=TMP
3170 IF PAR2<-9999 OR PAR2>9999 THEN ERRM=3 : GOTO 2090
3180 GOSUB 5210 : PAR3=TMP
3190 IF PAR3<0 OR PAR3>9999 THEN ERRM=3 : GOTO 2090
3200 GOSUB 5210 : PAR4=TMP
3210 IF PAR4<0 OR PAR4>360 THEN ERRM=3 : GOTO 2090
3220 GOSUB 5210 : PAR5=TMP
3230 IF PAR5<0 OR PAR5>360 THEN ERRM=3 : GOTO 2090
3240 GOSUB 5210 : PAR6=TMP
3250 IF PAR6<0 OR PAR6>1 THEN ERRM=3 : GOTO 2090
3260 IF WRTYP=80 THEN 3300
3270 IF WRTYP=81 THEN 3320
3280 WARN=3
3290 GOTO 2230
3300 LPRINT "W";PAR1;",";PAR2;",";PAR3;",";PAR4;",";PAR5;",";PAR6
3310 GOTO 1660
3320 IF PAR4<PAR5 AND PAR6=1 THEN PAR5=PAR5-360
3330 IF PAR4>PAR5 AND PAR6=0 THEN PAR5=PAR5+360
3340 ST=1
3350 IF PAR6=1 THEN ST=-1
3390 X=PAR3*COS(PAR4*DR!)
3400 Y=PAR3*SIN(PAR4*DR!)
3410 LPRINT "M";PAR1+X;",";PAR2+Y
3420 FOR I=PAR4+ST TO PAR5 STEP ST
3430     X=PAR3*COS(I*DR!)
3440     Y=PAR3*SIN(I*DR!)
3450     LPRINT "D";PAR1+X;",";PAR2+Y
3460 NEXT I
3470 GOTO 1660
3480 '
3490 ' BAR/HISTOGRAM MACRO
3500 '
3510 GOSUB 5210 : PAR1=TMP
3520 IF PAR1<-9999 OR PAR1>9999 THEN ERRM=3 : GOTO 2090
3530 GOSUB 5210 : PAR2=TMP
3540 IF PAR2<-9999 OR PAR2>9999 THEN ERRM=3 : GOTO 2090
3550 GOSUB 5210 : PAR3=TMP
3560 IF PAR3<-9999 OR PAR3>9999 THEN ERRM=3 : GOTO 2090
3570 GOSUB 5210 : PAR4=TMP
3580 IF PAR4<-9999 OR PAR4>9999 THEN ERRM=3 : GOTO 2090
3590 IF WRTYP=80 THEN 3630
3600 IF WRTYP=81 THEN 3650
3610 WARN=3
3620 GOTO 2230
3630 LPRINT "T";PAR1;",";PAR2;",";PAR3;",";PAR4
3640 GOTO 1660
3650 LPRINT "M";PAR1;",";PAR2
3660 LPRINT "D";PAR1;",";PAR4;",";PAR3;",";PAR4;",";PAR3;",";PAR2;",";PAR1;",";PAR2
3670 GOTO 1660
3680 '
3690 ' FILL A BAR WITH A SELECTED HASH PATTERN
3700 '
3710 GOSUB 5210 : PAR1=TMP
3720 IF PAR1<-9999 OR PAR1>9999 THEN ERRM=3 : GOTO 2090
3730 GOSUB 5210 : PAR2=TMP
3740 IF PAR2<-9999 OR PAR2>9999 THEN ERRM=3 : GOTO 2090
3750 GOSUB 5210 : PAR3=TMP
3760 IF PAR3<-9999 OR PAR3>9999 THEN ERRM=3 : GOTO 2090
3770 GOSUB 5210 : PAR4=TMP
3780 IF PAR4<-9999 OR PAR4>9999 THEN ERRM=3 : GOTO 2090
3790 GOSUB 5210 : PAR5=TMP
3800 IF PAR5<0 OR PAR5>2 THEN ERRM=3 : GOTO 2090
3810 GOSUB 5210 : PAR6=TMP
3820 IF PAR6<1 OR PAR6>9999 THEN ERRM=3 : GOTO 2090
3830 GOSUB 5210 : PAR7=TMP
3840 IF PAR7<0 THEN ERRM=3 : GOTO 2090
3850 IF WRTYP=80 AND PAR7>3 THEN ERRM=3 : GOTO 2090
3860 IF WRTYP=81 AND PAR7>5 THEN ERRM=3 : GOTO 2090
3870 HITE=PAR4-PAR2
3880 WDTH=PAR3-PAR1
3890 LPRINT "C";PAR7
3900 LPRINT "M";PAR1;",";PAR2
3910 IF PAR5=2 THEN GOSUB 5460 : GOSUB 5580
3920 IF PAR5=0 THEN GOSUB 5460
3930 IF PAR5=1 THEN GOSUB 5580
3940 GOTO 1660
3950 '
3960 ' DEFINE LINE CHARACTERISTICS
3970 '
3980 GOSUB 5210 : GOSUB 5370 : PAR$=TMP$
3990 IF PAR$="SCALE" THEN 4030
4000 IF PAR$="TYPE"  THEN 4070
4010 ERRM=4
4020 GOTO 2090
4030 GOSUB 5210 : PAR1=TMP
4040 IF PAR1<1 OR PAR1>127 THEN ERRM=3 : GOTO 2090
4050 LPRINT "B";PAR1
4060 GOTO 1660
4070 GOSUB 5210 : PAR1=TMP
4080 IF PAR1<0 OR PAR1>1 THEN ERRM=3 : GOTO 2090
4090 LPRINT "L";PAR1
4100 GOTO 1660
4110 '
4120 ' MOVE PEN TO THE HOME POSITION
4130 '
4140 LPRINT "H"
4150 GOTO 1660
4160 '
4170 ' SET STEP RATE
4180 '
4190 IF WRTYP<>80 THEN ERRM=5 : GOTO 2090
4200 GOSUB 5210 : PAR1=TMP
4210 IF PAR1<0 OR PAR1>1 THEN ERRM=3 : GOTO 2090
4220 LPRINT "G";PAR1
4230 GOTO 1660
4240 '
4250 ' PLOTTER PRINT FACILITY
4260 '
4270 GOSUB 5310 : PAR$=COM$
4280 IF PAR$=" " THEN WARN=2 : GOTO 2230
4290 LPRINT "P";PAR$
4300 GOTO 1660
4310 '
4320 ' SET PLOTTER PARAMETERS
4330 '
4340 GOSUB 5210 : GOSUB 5370 : PAR$=TMP$
4350 IF PAR$="ORIGIN" THEN 4410
4360 IF PAR$="DIREC"  THEN 4450
4370 IF PAR$="SIZE"   THEN 4490
4380 IF PAR$="MODE"   THEN 4530
4390 ERRM=4
4400 GOTO 2090
4410 GOSUB 5210 : PAR1=TMP
4420 GOSUB 5210 : PAR2=TMP
4430 LPRINT "I";PAR1;",";PAR2
4440 GOTO 1660
4450 GOSUB 5210 : PAR1=TMP
4460 IF PAR1<0 OR PAR1>3 THEN ERRM=3 : GOTO 2090
4470 LPRINT "Q";PAR1
4480 GOTO 1660
4490 GOSUB 5210 : PAR1=TMP
4500 IF PAR1<1 OR PAR1>255 THEN ERRM=3 : GOTO 2090
4510 LPRINT "S";PAR1
4520 GOTO 1660
4530 GOSUB 5210 : PAR1=TMP
4540 IF PAR1<0 OR PAR1>2 THEN ERRM=3 : GOTO 2090
4550 IF WRTYP=80 AND PAR1=2 THEN ERRM=3 : GOTO 2090
4560 IF PAR1=0 THEN LPRINT RS$
4570 IF PAR1=1 THEN LPRINT FS$
4580 IF PAR1=2 THEN LPRINT GS$
4590 GOTO 1660
4600 '
4610 ' DRAW GRAPH AXIS
4620 '
4630 GOSUB 5210 : PAR1=TMP
4640 IF PAR1<0 OR PAR1>1 THEN ERRM=3 : GOTO 2090
4650 GOSUB 5210 : PAR2=TMP
4660 IF PAR2<0 OR PAR2>9999 THEN ERRM=3 : GOTO 2090
4670 GOSUB 5210 : PAR3=TMP
4680 IF PAR3<1 OR PAR3>255 THEN ERRM=3 : GOTO 2090
4690 LPRINT "X";PAR1;",";PAR2;",";PAR3
4700 GOTO 1660
4710 '
4720 ' PLOT A MARKER 
4730 '
4740 GOSUB 5210 : PAR1=TMP
4750 IF PAR1<0 OR PAR1>5 THEN ERRM=3 : GOTO 2090
4760 LPRINT "N";PAR1
4770 GOTO 1660
4780 '
4790 ' DRAW A BORDER IN A SPECIFIC PEN COLOUR
4800 '
4810 GOSUB 5210 : PAR1=TMP
4820 IF PAR1<0 THEN ERRM=3 : GOTO 2090
4830 IF WRTYP=80 AND PAR1>3 THEN ERRM=3 : GOTO 2090
4840 IF WRTYP=81 AND PAR1>5 THEN ERRM=3 : GOTO 2090
4850 GOSUB 5210 : PAR2=TMP
4860 IF PAR2<0 OR PAR2>9999 THEN ERRM=3 : GOTO 2090
4870 IF WRTYP=80 THEN 4890 ELSE GOSUB 5210 : PAR3=TMP
4880 IF PAR3<0 OR PAR3>1 THEN ERRM=3 : GOTO 2090
4890 LPRINT "M";PAR2;",";PAR2
4900 LPRINT "C";PAR1
4910 IF WRTYP=80 THEN HITE=2032-(2*PAR2) : WDTH=1920-(2*PAR2)
4920 IF WRTYP=81 AND PAR3=0 THEN HITE=1860-(2*PAR2) : WDTH=2600-(2*PAR2)
4930 IF WRTYP=81 AND PAR3=1 THEN HITE=2160-(2*PAR2) : WDTH=2880-(2*PAR2)
4940 LPRINT "J";WDTH;",";0;",";0;",";HITE;",";-WDTH;",";0;",";0;",";-HITE
4950 GOTO 1660
4960 '
4970 ' DEFINE PLOTTER CHARACTERISTICS
4980 '
4990 GOSUB 5210 : GOSUB 5370 : PAR$=TMP$
5000 IF PAR$="LINES" THEN 5040
5010 IF PAR$="AREA"  THEN 5090
5020 ERRM=4
5030 GOTO 2090
5040 IF WRTYP<>80 THEN ERRM=5 : GOTO 2090
5050 GOSUB 5210 : PAR1=TMP
5060 IF PAR1<0 OR PAR1>1 THEN ERRM=3 : GOTO 2090
5070 LPRINT "U";PAR1
5080 GOTO 1660
5090 IF WRTYP<>81 THEN ERRM=5 : GOTO 2090
5100 GOSUB 5210 : PAR1=TMP
5110 IF PAR1<0 OR PAR1>1 THEN ERRM=3 : GOTO 2090
5120 LPRINT "F";PAR1
5130 GOTO 1660
5140 '
5150 ' DIRECTLY OUTPUT STRING TO THE PLOTTER
5160 '
5170 GOSUB 5210 : GOSUB 5370 : PAR$=TMP$
5180 IF PAR$=" " THEN WARN=2 : GOTO 2230
5190 LPRINT PAR$
5200 GOTO 1660
5210 '
5220 ' FIND A NUMERIC OR STRING PARAMETER
5230 '
5240 GOSUB 5310 ' TO STRIP OFF ANY LEADING SPACES
5250 TEMP$=COM$
5260 IF LEFT$(TEMP$,1)<>" " THEN TEMP$=RIGHT$(TEMP$,LEN(TEMP$)-1) : GOTO 5260
5270 TMP$=LEFT$(COM$,LEN(COM$)-LEN(TEMP$))
5280 TMP=VAL(TMP$)
5290 COM$=RIGHT$(COM$,LEN(COM$)-(LEN(TMP$)+1))
5300 RETURN
5310 '
5320 ' STRIP LEADING SPACES FROM THE COMMAND STRING
5330 '
5340 IF LEFT$(COM$,1)=" " THEN COM$=RIGHT$(COM$,LEN(COM$)-1) : GOTO 5340
5350 COM$=COM$+" "
5360 RETURN
5370 '
5380 ' CONVERT ALL LOWER CASE INPUT INTO UPPER CASE
5390 '
5400 XLEN=LEN(TMP$)
5410 FOR I=1 TO XLEN
5420     X=ASC(MID$(TMP$,I,1))
5430     IF X>96 AND X<123 THEN MID$(TMP$,I,1)=CHR$(X-32)
5440 NEXT I
5450 RETURN
5460 '
5470 ' HORIZONTAL FILL PATTERN
5480 '
5490 FOR II=PAR6 TO HITE-PAR6 STEP PAR6*2
5500     LPRINT "R";0;",";PAR6
5510     LPRINT "J";WDTH;",";0
5520     IF HITE<=II+PAR6 THEN 5550
5530     LPRINT "R";0;",";PAR6
5540     LPRINT "J";-WDTH;",";0
5550 NEXT II
5560 LPRINT "M";PAR1;",";PAR2
5570 RETURN
5580 '
5590 ' VERTICAL FILL PATTERN
5600 '
5610 FOR II=PAR6 TO WDTH-PAR6 STEP PAR6*2
5620     LPRINT "R";PAR6;",";0
5630     LPRINT "J";0;",";HITE
5640     IF WDTH<=II+PAR6 THEN 5670
5650     LPRINT "R";PAR6;",";0
5660     LPRINT "J";0;",";-HITE
5670 NEXT II
5680 LPRINT "M";PAR1;",";PAR2
5690 RETURN
5800 '
5810 ' EJECT
5815 '
5817 IF WRTYP=81 THEN ERRM=5:GOTO 2090
5820 LPRINT CHR$(29);
5825 LPRINT CHR$(27)+CHR$(34);
5830 LPRINT CHR$(12);
5835 LPRINT CHR$(27)+CHR$(39);
5840 LPRINT CHR$(30);
5850 GOTO 1660
                                                                                                               