10 '
20 '      Program to convert BBC BASIC into GW BASIC
30 '
40 '      (C) Copyright ALFRAGAN LTD./GB Computer Products Ltd.(1985)
50 '
60 '      Version 1.2
70 '      Amended :
80 '
90 '    CONSTANTS,FUNCTIONS ETC
100 '    -----------------------
110 DIM CONVA%(120),CCAT%(64),KC%(122)
120 DIM COL164%(16),COL163%(16),COL162%(16),COL44%(4),COL43%(4),COL42%(4)
130 COMMON DRIVE$,WARN%,WFILE$,CONVA%(),COL164%(),COL163%(),COL162%(),COL44%(),COL43%(),COL42%(),CCAT%(),KC%()
140 COMMON SCALEX$,SCALEY$,CFLAG%,XSCALE!,YSCALE!,YSIZE$
150 COMMON BBCA$,BBCB$,BBCC$,BBCD$,BBCE$,BBCF$,BBCG$,BBCH$,BBCI$,BBCJ$,BBCK$
160 COMMON BBCL$,BBCM$,BBCN$,BBCO$,BBCP$,BBCQ$,BBCR$,BBCS$,BBCT$,BBCU$,BBCV$
170 COMMON BBCW$,BBCX$,BBCY$,BBCZ$
180 COMMON GWA$,GWB$,GWC$,GWD$,GWE$,GWF$,GWG$,GWH$,GWI$,GWJ$,GWK$,GWL$,GWM$
190 COMMON GWN$,GWO$,GWP$,GWQ$,GWR$,GWS$,GWT$,GWU$,GWV$,GWW$,GWX$,GWY$,GWZ$
200 WIDTH 255
210 ESC$=CHR$(27)
220 ESCY$=ESC$+CHR$(89)    'esc+"Y"
230 RCLEAR$=ESC$+CHR$(84)  'clear to right of cursor
240 INVVID$=ESC$+CHR$(112) 'inverse video
250 NORVID$=ESC$+CHR$(113) 'normal video
260 DEF FNCUR$(A,B)=ESCY$+CHR$(31+A)+CHR$(31+B)
270 '
280 '    Conversion Array
290 '
300 CONVA%(1)=100    'ABS
310 CONVA%(2)=8      'ACS
320 CONVA%(3)=9      'ADVAL
330 CONVA%(4)=68     'AND
340 CONVA%(5)=375    'ASC
350 CONVA%(6)=10     'ASN
360 CONVA%(7)=400    'ATN
370 CONVA%(8)=500    'AUTO
380 CONVA%(9)=11     'BGET
390 CONVA%(10)=12    'BPUT
400 CONVA%(11)=9     'CALL
410 CONVA%(12)=1300  'CHAIN
420 CONVA%(13)=67    'CHR
430 CONVA%(14)=1800  'CLEAR
440 CONVA%(15)=2000  'CLG
450 CONVA%(16)=1972  'CLOSE
460 CONVA%(17)=2000  'CLS
470 CONVA%(18)=14    'COLOUR
480 CONVA%(19)=2473  'COS
490 CONVA%(20)=9     'COUNT
500 CONVA%(21)=3071  'DATA
510 CONVA%(22)=16    'DEF
520 CONVA%(23)=17    'DEG
530 CONVA%(24)=3701  'DELETE
540 CONVA%(25)=3800  'DIM
550 CONVA%(26)=18    'DIV
560 CONVA%(27)=3919  'DRAW
570 CONVA%(28)=4100  'ELSE
580 CONVA%(29)=66    'END
590 CONVA%(30)=12000 'ENDPROC
600 CONVA%(31)=21    'ENVELOPE
610 CONVA%(32)=4303  'EOF
620 CONVA%(33)=16100 'EOR
630 CONVA%(34)=4600  'ERL
640 CONVA%(35)=4769  'ERR
650 CONVA%(36)=4800  'ERROR
660 CONVA%(37)=9     'EVAL
670 CONVA%(38)=4900  'EXP
680 CONVA%(39)=7803  'EXT
690 CONVA%(40)=23    'FALSE
700 CONVA%(41)=24    'FN
710 CONVA%(42)=5400  'FOR
720 CONVA%(43)=25    'GCOL
730 CONVA%(44)=26    'GET
740 CONVA%(45)=5700  'GOSUB
750 CONVA%(46)=5800  'GOTO
760 CONVA%(47)=9     'HIMEM
770 CONVA%(48)=6000  'IF
780 CONVA%(49)=28    'INKEY
790 CONVA%(50)=29    'INPUT
800 CONVA%(51)=6530  'INSTR
810 CONVA%(52)=6659  'INT
820 CONVA%(53)=6900   'LEFT
830 CONVA%(54)=7075   'LEN
840 CONVA%(55)=7100  'LET
850 CONVA%(56)=7301  'LIST
860 CONVA%(57)=9     'LISTO
870 CONVA%(58)=7900  'LN
880 CONVA%(59)=7500  'LOAD
890 CONVA%(60)=32    'LOCAL
900 CONVA%(61)=7933  'LOG
910 CONVA%(62)=9     'LOMEM
920 CONVA%(63)=8400   'MID
930 CONVA%(64)=63    'MOD
940 CONVA%(65)=35    'MODE
950 CONVA%(66)=3936  'MOVE
960 CONVA%(67)=9100  'NEW
970 CONVA%(68)=9200  'NEXT
980 CONVA%(69)=61    'NOT
990 CONVA%(70)=70    'OFF
1000 CONVA%(71)=2300  'OLD
1010 CONVA%(72)=9600  'ON
1020 CONVA%(73)=4     'OPENIN
1030 CONVA%(74)=4     'OPENOUT
1040 CONVA%(75)=9     'OPT
1050 CONVA%(76)=62    'OR
1060 CONVA%(77)=9     'PAGE
1070 CONVA%(78)=39    'PI
1080 CONVA%(79)=3940  'PLOT
1090 CONVA%(80)=10641 'POINT
1100 CONVA%(81)=10805 'POS
1110 CONVA%(82)=42    'PRINT
1120 CONVA%(83)=43    'PROC
1130 CONVA%(84)=44    'PTR
1140 CONVA%(85)=60    'RAD
1150 CONVA%(86)=11445 'READ
1160 CONVA%(87)=11520 'REM
1170 CONVA%(88)=11606 'RENUMBER
1180 CONVA%(89)=46    'REPEAT
1190 CONVA%(90)=47    'REPORT
1200 CONVA%(91)=11800 'RESTORE
1210 CONVA%(92)=12000 'RETURN
1220 CONVA%(93)=12100 'RIGHT
1230 CONVA%(94)=48    'RND
1240 CONVA%(95)=74    'RUN
1250 CONVA%(96)=12600 'SAVE
1260 CONVA%(97)=12800 'SGN
1270 CONVA%(98)=12973 'SIN
1280 CONVA%(99)=10449 'SOUND
1290 CONVA%(100)=13202 'SPC
1300 CONVA%(101)=13300 'SQR
1310 CONVA%(102)=13400 'STEP
1320 CONVA%(103)=13600'STOP
1330 CONVA%(104)=65   'STR
1340 CONVA%(105)=13950'STRING
1350 CONVA%(106)=51   'TAB
1360 CONVA%(107)=14373'TAN
1370 CONVA%(108)=14400'THEN
1380 CONVA%(109)=52   'TIME
1390 CONVA%(110)=14764'TO
1400 CONVA%(111)=9    'TOP
1410 CONVA%(112)=54   'TRACE
1420 CONVA%(113)=55   'TRUE
1430 CONVA%(114)=6056 'UNTIL
1440 CONVA%(115)=9    'USR
1450 CONVA%(116)=15200'VAL
1460 CONVA%(117)=58   'VDU
1470 CONVA%(118)=2600 'VPOS
1480 CONVA%(119)=15807'WIDTH
1490 '
1500 '    BBC command table
1510 '
1520 BBCA$="ABS     ACS     ADVAL   AND     ASC     ASN     ATN     AUTO    "
1530 BBCB$="BGET    BPUT    "
1540 BBCC$="CALL    CHAIN   CHR     CLEAR   CLG     CLOSE   CLS     COLOUR  COS     COUNT   "
1550 BBCD$="DATA    DEF     DEG     DELETE  DIM     DIV     DRAW    "
1560 BBCE$="ELSE    END     ENDPROC ENVELOPEEOF     EOR     ERL     ERR     ERROR   EVAL    EXP     EXT     "
1570 BBCF$="FALSE   FN      FOR     "
1580 BBCG$="GCOL    GET     GOSUB   GOTO    "
1590 BBCH$="HIMEM   "
1600 BBCI$="IF      INKEY   INPUT   INSTR   INT     "
1610 BBCJ$=""
1620 BBCK$=""
1630 BBCL$="LEFT    LEN     LET     LIST    LISTO   LN      LOAD    LOCAL   LOG     LOMEM   "
1640 BBCM$="MID     MOD     MODE    MOVE    "
1650 BBCN$="NEW     NEXT    NOT     "
1660 BBCO$="OFF     OLD     ON      OPENIN  OPENOUT OPT     OR      "
1670 BBCP$="PAGE    PI      PLOT    POINT   POS     PRINT   PROC    PTR     "
1680 BBCR$="RAD     READ    REM     RENUMBERREPEAT  REPORT  RESTORE RETURN  RIGHT   RND     RUN     "
1690 BBCS$="SAVE    SGN     SIN     SOUND   SPC     SQR     STEP    STOP    STR     STRING  "
1700 BBCT$="TAB     TAN     THEN    TIME    TO      TOP     TRACE   TRUE    "
1710 BBCU$="UNTIL   USR     "
1720 BBCV$="VAL     VDU     VPOS    "
1730 BBCW$="WIDTH   "
1740 BBCX$=""
1750 BBCY$=""
1760 BBCZ$=""
1770 '
1780 '    GW command table
1790 GWA$="ABS    AND    ASC    ATN    AUTO   "
1800 GWB$="BASE   BEEP   BLOAD  BSAVE  "
1810 GWC$="CALL   CALLS  CDBL   CHAIN  CHDIR  CHR    CINT   CIRCLE CLEAR  CLOSE  CLS    COLOR  COMMON CONT   COS    CSNG   CSRLIN CVD     CVI    CVS    "
1820 GWD$="DATA   DATE   DEF    DEFDBL DEFINT DEFSNG DEFSTR DELETE DIM    DRAW   "
1830 GWE$="EDIT   ELSE   END    EOF    EQV    ERASE  ERL    ERR    ERROR  EXP    "
1840 GWF$="FIELD  FILES  FIX    FN     FOR    FRE    "
1850 GWG$="GET    GOSUB  GOTO   "
1860 GWH$="HEX    "
1870 GWI$="IF     IMP    INKEY  INP    INPUT  INSTR  INT    "
1880 GWJ$=""
1890 GWK$="KEY    KILL   "
1900 GWL$="LEFT   LEN    LET    LINE   LIST   LLIST  LOAD   LOC    LOCATE LOF    LOG    LPOS   LPRINT LSET   "
1910 GWM$="MERGE  MID    MKD    MKDIR  MKI    MKS    MOD    "
1920 GWN$="NAME   NEW    NEXT   NOT    "
1930 GWO$="OCT    OFF    ON     OPEN   OPTION OR     OUT    "
1940 GWP$="PAINT  PALETTEPEEK   PLAY   PMAP   POINT  POKE   POS    PRESET PRINT  PSET   PUT    "
1950 GWQ$=""
1960 GWR$="RANDOMIREAD   REM    RENUM  RESET  RESTORERESUME  RETURN RIGHT  RMDIR  RND    RSET   RUN    "
1970 GWS$="SAVE   SCREEN SGN    SIN    SOUND  SPACE  SPC    SQR    STEP   STICK  STOP   STR    STRIG  STRING SWAP   SYSTEM "
1980 GWT$="TAB    TAN    THEN   TIME   TIMER  TO     TROFF  TRON   "
1990 GWU$="USING  USR    "
2000 GWV$="VAL    VARPTR VIEW   "
2010 GWW$="WAIT   WEND   WHILE  WIDTH  WINDOW WRITE  "
2020 GWX$="XOR    "
2030 GWY$=""
2040 GWZ$=""
2050 '
2060 '    16 colour conversion array for 2 planes
2070 '
2080 COL162%(1)=0    'black
2090 COL162%(2)=1    'red
2100 COL162%(3)=2    'green - becomes blue
2110 COL162%(4)=1    'yellow     "    red
2120 COL162%(5)=2    'blue
2130 COL162%(6)=1    'magenta   "    red
2140 COL162%(7)=2    'cyan      "    blue
2150 COL162%(8)=3    'white
2160 COL162%(9)=0    'flash black/white - becomes black
2170 COL162%(10)=1   'flash red/cyan         "    red
2180 COL162%(11)=2   'flash green/magenta    "    blue
2190 COL162%(12)=1   'flash yellow/blue      "    red
2200 COL162%(13)=2   'flash blue/yellow      "    blue
2210 COL162%(14)=1   'flash magenta/green     "   red
2220 COL162%(15)=2   'flash cyan/red          "   blue
2230 COL162%(16)=3   'flash white/black       "   white
2240 '
2250 '    16 colour conversion array for 3 planes
2260 '
2270 COL163%(1)=0   'black
2280 COL163%(2)=1   'red
2290 COL163%(3)=2   'green
2300 COL163%(4)=3   'yellow
2310 COL163%(5)=4   'blue
2320 COL163%(6)=5   'magenta
2330 COL163%(7)=6   'cyan
2340 COL163%(8)=7   'white
2350 COL163%(9)=0   'flash black/white
2360 COL163%(10)=1  'flash red/cyan
2370 COL163%(11)=2  'flash green/magenta
2380 COL163%(12)=3  'flash yellow/blue
2390 COL163%(13)=4  'flash blue/yellow
2400 COL163%(14)=5  'flash magenta/green
2410 COL163%(15)=6  'flash cyan/red
2420 COL163%(16)=7  'flash white/black
2430 '
2440 '   16 colour conversion array for 4 planes
2450 '
2460 COL164%(1)=0   'black 
2470 COL164%(2)=12  'red 
2480 COL164%(3)=10  'green 
2490 COL164%(4)=14  'yellow 
2500 COL164%(5)=9   'blue 
2510 COL164%(6)=13  'magenta 
2520 COL164%(7)=11  'cyan 
2530 COL164%(8)=15  'white 
2540 COL164%(9)=0   'flash black/white
2550 COL164%(10)=12 'flash red/cyan
2560 COL164%(11)=10 'flash green/magenta
2570 COL164%(12)=14 'flash yellow/blue
2580 COL164%(13)=9  'flash blue/yellow
2590 COL164%(14)=13 'flash magenta/green
2600 COL164%(15)=11 'flash cyan/red
2610 COL164%(16)=15 'flash white/black
2620 '
2630 '    4 colour conversion array for 2 planes
2640 '
2650 COL42%(1)=0      'black
2660 COL42%(2)=1      'red
2670 COL42%(3)=2      'yellow - not available so is blue
2680 COL42%(4)=3      'white
2690 '
2700 '    4 colour conversion array for 3 planes
2710 '
2720 COL43%(1)=0       'black
2730 COL43%(2)=1       'red
2740 COL43%(3)=3       'yellow
2750 COL43%(4)=7       'white
2760 '
2770 '    4 colour conversion array for 4 planes
2780 '
2790 COL44%(1)=0    'black
2800 COL44%(2)=12   'red
2810 COL44%(3)=14   'blue
2820 COL44%(4)=15   'white
2830 '
2840 '    Character category table :-
2850 '  Category 0 = end of line
2860 '           1   numeric
2870 '           2   alpha
2880 '           3   space
2890 '           4   comma & semicolon
2900 '           5   hash
2910 '           6   open parenthesis
2920 '           7   dollar
2930 '           8   quotes
2940 '           9   anything else
2950 '          10   close parenthesis
2960 '          11   colon
2970 '          12 * - + /
2980 '          13   equals
2990 '
3000 CCAT%(1)=3:CCAT%(2)=9:CCAT%(3)=8:CCAT%(4)=5     'space ! " #
3010 CCAT%(5)=7:CCAT%(6)=9:CCAT%(7)=9:CCAT%(8)=9     '$ % & '
3020 CCAT%(9)=6:CCAT%(10)=10:CCAT%(11)=12:CCAT%(12)=12 '( ) * +
3030 CCAT%(13)=4:CCAT%(14)=12:CCAT%(15)=9:CCAT%(16)=12 ', - . /
3040 CCAT%(17)=1:CCAT%(18)=1:CCAT%(19)=1:CCAT%(20)=1 '0 1 2 3
3050 CCAT%(21)=1:CCAT%(22)=1:CCAT%(23)=1:CCAT%(24)=1 '4 5 6 7
3060 CCAT%(25)=1:CCAT%(26)=1:CCAT%(27)=11:CCAT%(28)=4 '8 9 : ;
3070 CCAT%(29)=9:CCAT%(30)=13:CCAT%(31)=9:CCAT%(32)=9 '< = > ?
3080 CCAT%(33)=9:CCAT%(34)=2:CCAT%(35)=2:CCAT%(36)=2 '@ A B C
3090 CCAT%(37)=2:CCAT%(38)=2:CCAT%(39)=2:CCAT%(40)=2 'D E F G
3100 CCAT%(41)=2:CCAT%(42)=2:CCAT%(43)=2:CCAT%(44)=2 'H I J K
3110 CCAT%(45)=2:CCAT%(46)=2:CCAT%(47)=2:CCAT%(48)=2 'L M N O
3120 CCAT%(49)=2:CCAT%(50)=2:CCAT%(51)=2:CCAT%(52)=2 'P Q R S
3130 CCAT%(53)=2:CCAT%(54)=2:CCAT%(55)=2:CCAT%(56)=2 'T U V W
3140 CCAT%(57)=2:CCAT%(58)=2:CCAT%(59)=2:CCAT%(60)=9 'X Y Z [
3150 CCAT%(61)=9:CCAT%(62)=9:CCAT%(63)=9:CCAT%(64)=9 '  ] ^ 
3160 '
3170 '     KEY NUMBER TO CHARACTER TABLE
3180 '     -----------------------------
3190 KC%(1)=0   :KC%(2)=0   :KC%(3)=0   'shift ctrl 
3200 KC%(4)=0   :KC%(5)=0   :KC%(6)=0
3210 KC%(7)=0   :KC%(8)=0   :KC%(9)=0
3220 KC%(10)=0  :KC%(11)=0  :KC%(12)=0
3230 KC%(13)=0  :KC%(14)=0  :KC%(15)=0
3240 KC%(16)=0  :KC%(17)=81 :KC%(18)=51 '   Q 3
3250 KC%(19)=52 :KC%(20)=53 :KC%(21)=0  '4 5  f4
3260 KC%(22)=56 :KC%(23)=0  :KC%(24)=45 '8 f7 -
3270 KC%(25)=94 :KC%(26)=0  :KC%(27)=0  '^ left arrow
3280 KC%(28)=0  :KC%(29)=0  :KC%(30)=0
3290 KC%(31)=0  :KC%(32)=0  :KC%(33)=0  '      f0
3300 KC%(34)=87 :KC%(35)=69 :KC%(36)=84 'W E T
3310 KC%(37)=55 :KC%(38)=73 :KC%(39)=57 '7 I 9
3320 KC%(40)=48 :KC%(41)=95 :KC%(42)=0  '0 _ down arrow
3330 KC%(43)=0 :KC%(44)=0 :KC%(45)=0
3340 KC%(46)=0 :KC%(47)=0 :KC%(48)=0
3350 KC%(49)=49:KC%(50)=50:KC%(51)=68 '1 2 D
3360 KC%(52)=82:KC%(53)=54:KC%(54)=85 'R 6 U
3370 KC%(55)=79:KC%(56)=80:KC%(57)=91 'O P [
3380 KC%(58)=0 :KC%(59)=0 :KC%(60)=0  'up arrow
3390 KC%(61)=0 :KC%(62)=0 :KC%(63)=0
3400 KC%(64)=0 :KC%(65)=0 :KC%(66)=65 '  caps lock A
3410 KC%(67)=88:KC%(68)=70:KC%(69)=89 ' X F Y
3420 KC%(70)=74:KC%(71)=75:KC%(72)=64 'J K @
3430 KC%(73)=58:KC%(74)=13:KC%(75)=0  ': return
3440 KC%(76)=0 :KC%(77)=0 :KC%(78)=0
3450 KC%(79)=0 :KC%(80)=0 :KC%(81)=0  '     shift lock
3460 KC%(82)=83:KC%(83)=67:KC%(84)=71 'S C G
3470 KC%(85)=72:KC%(86)=78:KC%(87)=76 'H N L
3480 KC%(88)=59:KC%(89)=93:KC%(90)=127'; ] delete
3490 KC%(91)=0 :KC%(92)=0 :KC%(93)=0
3500 KC%(94)=0 :KC%(95)=0 :KC%(96)=0
3510 KC%(97)=0 :KC%(98)=90:KC%(99)=32 'tab Z space
3520 KC%(100)=86:KC%(101)=66:KC%(102)=77 'V B M
3530 KC%(103)=96:KC%(104)=46:KC%(105)=47 '' . /
3540 KC%(106)=0 :KC%(107)=0 :KC%(108)=0  'copy
3550 KC%(109)=0 :KC%(110)=0 :KC%(111)=0
3560 KC%(112)=0 :KC%(113)=27:KC%(114)=0  ' esc f1
3570 KC%(115)=0 :KC%(116)=0 :KC%(117)=0  'f2 f3 f5
3580 KC%(118)=0 :KC%(119)=0 :KC%(120)=0  'f6 f8 f9
3590 KC%(121)=92:KC%(122)=0              'back slash right arrow
3600 '
3610 '      GET USER DETAILS
3620 '      ----------------
3630 GOSUB 3860        'output screen
3640 GOSUB 3740        'set scaling factors
3650 GOSUB 4640          'enable line 25
3660 PRINT FNCUR$(25,1);SPACE$(78);
3670 GOSUB 4670          'disable line 25
3680 ON ERROR GOTO 4500
3690 CHAIN DRIVE$+"B-TRAN1"
3700 GOSUB 4000:GOTO 3680
3710 '
3720 '      SET GRAPHICS SCALING FACTORS
3730 '      ----------------------------
3740 ON CFLAG%+1 GOSUB 3790,3800,3810,3810,3820
3750 X$=STR$(XSCALE!):GOSUB 4430:SCALEX$=X$
3760 X$=STR$(YSCALE!):GOSUB 4430:SCALEY$=X$
3770 X$=STR$(YSIZE%):GOSUB 4430:YSIZE$=X$
3780 RETURN
3790 XSCALE!=5/8:YSCALE!=25/64:YSIZE%=400:RETURN
3800 XSCALE!=1/4:YSCALE!=1/4:YSIZE%=256:RETURN
3810 XSCALE!=1/2:YSCALE!=1/4:YSIZE%=256:RETURN
3820 XSCALE!=1/2:YSCALE!=1/4:YSIZE%=256:RETURN
3830 '
3840 '    OUTPUT INITIAL SCREEN
3850 '    ---------------------
3860 PRINT ESC$+CHR$(69)         'clear screen
3870 PRINT FNCUR$(2,19);INVVID$"B-TRAN :- BBC BASIC TO GW BASIC CONVERSION";NORVID$
3872 PRINT FNCUR$(21,1);STRING$(78,45)
3874 PRINT "Press ESC to return to operating system"
3880 GOSUB 4640          'enable line 25
3890 PRINT FNCUR$(25,1)"R1.2 (C) Alfragan Ltd./David Ball,1985: Worldwide distribution ACT(UK) Ltd.";RCLEAR$
3900 GOSUB 4670          'disable line 25
3910 PRINT FNCUR$(10,13)"Are you using a colour monitor Y/N ?          [ ]"
3920 PRINT FNCUR$(11,7);"If you answer No then COLOUR statements will not be converted"
3930 PRINT FNCUR$(10,60);:GOSUB 4100:CFLAG%=YN%  'get colour flag
3940 GOSUB 4370:IF OK%=1 THEN 3910
3950 IF YN%=0 THEN CFLAG%=0:GOTO 4000
3960 PRINT FNCUR$(13,13);"How many colours are available - 4,8 or 16 ?  [  ]"
3970 GOSUB 4200             'get no.of colours
3980 IF OK%=1 THEN 3960     'j if invalid answer
3990 CFLAG%=N%\4            'set screen flag
4000 PRINT FNCUR$(15,13)"Give drive letter which holds B-TRAN programs [ ]"
4010 PRINT FNCUR$(16,20)"Press RETURN if on default drive"
4020 PRINT FNCUR$(15,60);
4030 GOSUB 4150         'get character
4040 IF K%=13 THEN DRIVE$="":GOTO 4060 ELSE DRIVE$=K$+":"
4050 GOSUB 4370:IF OK%=1 THEN 4000
4060 RETURN
4070 '
4080 '    GET COLOUR/SCREEN DETAILS
4090 '    -------------------------
4100 GOSUB 4150       'get character
4110 IF K$="y" OR K$="Y" THEN YN%=1:RETURN
4120 IF K$="n" OR K$="N" THEN YN%=0:RETURN
4130 PRINT CHR$(7);
4140 GOTO 3910
4150 K$=INKEY$
4160 IF LEN(K$)=0 THEN 4150
4170 K%=ASC(K$)
4172 IF K%=27 THEN PRINT ESC$+CHR$(69):SYSTEM
4180 IF K%<>8 THEN PRINT K$;
4190 RETURN
4200 PRINT FNCUR$(13,60);
4210 N%=0:CP%=1:OK%=0
4220 GOSUB 4150                 'get character
4230 IF K%=13 OR K%=9 THEN 4300 'j if return or tab
4240 IF K%=8 THEN GOSUB 4330:GOTO 4220 'action backspace
4250 IF K%<48 OR K%>57 THEN PRINT CHR$(7);:GOSUB 4350:GOTO 4220 'j if non-numeric
4260 N%=N%*10+K%-48              'build up field
4270 CP%=CP%+1
4280 IF CP%<=2 THEN 4220 
4290 GOSUB 4370:IF OK%=1 THEN GOSUB 4350:GOTO 4220
4300 IF N%=4 OR N%=8 OR N%=16 THEN RETURN
4310 PRINT CHR$(7);
4320 OK%=1:RETURN
4330 IF CP%<2 THEN RETURN ELSE CP%=CP%-1
4340 N%=N%\10
4350 PRINT CHR$(8)" "CHR$(8);
4360 RETURN
4370 GOSUB 4150:OK%=0     'get character
4380 IF K%=13 THEN RETURN 'j if return
4390 IF K%=8 THEN CP%=CP%-1:OK%=1:RETURN 'action backspace
4400 PRINT CHR$(7);:PRINT CHR$(8)" "CHR$(8);:GOTO 4370
4410 '      DROP TRAILING SPACES
4420 '       -------------------
4430 WHILE LEFT$(X$,1)=" "
4440   X$=RIGHT$(X$,LEN(X$)-1)
4450 WEND
4460 RETURN
4470 '
4480 '    ERRONEOUS DRIVE GIVEN
4490 '    ---------------------
4500 MESS$="B-TRAN not found on given drive":GOSUB 4550
4510 RESUME 3700
4520 '
4530 '    REPORT ERROR
4540 '    ------------
4550 MC$=" - press any key to try again"
4560 PRINT FNCUR$(22,10);INVVID$;MESS$;MC$;RCLEAR$
4570 PRINT CHR$(7)        'bleep
4580 GOSUB 4150           'get input
4590 PRINT FNCUR$(22,10);NORVID$;SPACE$(70)
4600 RETURN
4610 '
4620 '      ENABLE/DISABLE LINE 25
4630 '      ----------------------
4640 PRINT ESC$+CHR$(106);
4650 PRINT ESC$+CHR$(120)+CHR$(49)
4660 RETURN
4670 PRINT ESC$+CHR$(107);
4680 PRINT ESC$+CHR$(121)+CHR$(49)
4690 RETURN

4650 PRINT ESC$+CHR$(120)+CHR$(49)
4660 RETURN
4670 PRINT ESC$+CHR$(107);
4680 PRINT ESC$+CHR$(121)+CHR$(4