10 '
20 '      Program to convert BBC BASIC into GW BASIC
30 '
40 '      (C) Copyright Alfragan Ltd./GB Computer Products Ltd.(1985)
50 '
60 '      Version 1.2
70 '      Amended :
80 '
90 '    CONSTANTS,FUNCTIONS ETC
100 '    -----------------------
110 DIM CONVA%(120),COL164%(16),COL163%(16),COL162%(16),COL44%(4),COL43%(4),COL42%(4),CCAT%(64),KC%(122)
120 COMMON DRIVE$,WARN%,WFILE$,CONVA%(),COL164%(),COL163%(),COL162%(),COL44%(),COL43%(),COL42%(),CCAT%(),KC%()
130 COMMON SCALEX$,SCALEY$,CFLAG%,XSCALE!,YSCALE!,YSIZE$
140 COMMON BBCA$,BBCB$,BBCC$,BBCD$,BBCE$,BBCF$,BBCG$,BBCH$,BBCI$,BBCJ$
150 COMMON BBCK$,BBCL$,BBCM$,BBCN$,BBCO$,BBCP$,BBCQ$,BBCR$,BBCS$,BBCT$
160 COMMON BBCU$,BBCV$,BBCW$,BBCX$,BBCY$,BBCZ$
170 COMMON GWA$,GWB$,GWC$,GWD$,GWE$,GWF$,GWG$,GWH$,GWI$,GWJ$,GWK$,GWL$,GWM$
180 COMMON GWN$,GWO$,GWP$,GWQ$,GWR$,GWS$,GWT$,GWU$,GWV$,GWW$,GWX$,GWY$,GWZ$
190 WIDTH 255
200 ESC$=CHR$(27)
210 RCLEAR$=ESC$+CHR$(84)  'clear to right of cursor
220 INVVID$=ESC$+CHR$(112) 'inverse video
230 NORVID$=ESC$+CHR$(113) 'normal video
240 INN$="(If no name is given then "
250 DEF FNCUR$(A,B)=ESC$+CHR$(89)+CHR$(31+A)+CHR$(31+B)
260 DEF FNCSTR$=MID$(CURRLINE$,STCP%,ICP%-STCP%)
270 DEF FNKMID$=MID$(CURRLINE$,ICP%,1)
280 DIM BBCABC%(26),GWABC%(26) 'BBC & GW command no.arrays
290 DIM REPLINE$(10) 'REPEAT line nos.
300 DIM GWVAR%(24)   'GW command variables
310 BBC%=1:GW%=2     'input & outputfile nos.
320 WF%=3:CWF%=6     'work & warnings file nos.
330 PWF%=4:FWF%=5    'PROC & FN list workfile nos.
340 GSUB$="GOSUB      "
350 COMMA$=",":SP0$="":SP1$=" ":COLON$=":":QUOTE$=CHR$(34):IV$=MKI$(0):PRNT$="PRINT "
360 X%=1
370 FOR N%=1 TO 26    'work out no.of commands for each letter
380   ON N% GOSUB 500,510,520,530,540,550,560,570,580,590,600,610,620,630,640,650,660,670,680,690,700,710,720,730,740,750
390   BBCABC%(N%)=X% 'set 1st command no for this letter
400   X%=LEN(X$)/8+X% 'add in no.of commands this letter
410 NEXT N%
420 X%=1
430 FOR N%=1 TO 26
440   ON N% GOSUB 760,770,780,790,800,810,820,830,840,850,860,870,880,890,900,910,920,930,940,950,960,970,980,990,1000,1010
450   GWABC%(N%)=X%   'set 1st command no.for this letter
460   X%=LEN(Y$)/7+X% 'add in no.of commands this letter
470 NEXT N%
480 GOTO 1040
490 '
500 X$=BBCA$:RETURN    'get BBC command table string
510 X$=BBCB$:RETURN
520 X$=BBCC$:RETURN
530 X$=BBCD$:RETURN
540 X$=BBCE$:RETURN
550 X$=BBCF$:RETURN
560 X$=BBCG$:RETURN
570 X$=BBCH$:RETURN
580 X$=BBCI$:RETURN
590 X$=BBCJ$:RETURN
600 X$=BBCK$:RETURN
610 X$=BBCL$:RETURN
620 X$=BBCM$:RETURN
630 X$=BBCN$:RETURN
640 X$=BBCO$:RETURN
650 X$=BBCP$:RETURN
660 X$=BBCQ$:RETURN
670 X$=BBCR$:RETURN
680 X$=BBCS$:RETURN
690 X$=BBCT$:RETURN
700 X$=BBCU$:RETURN
710 X$=BBCV$:RETURN
720 X$=BBCW$:RETURN
730 X$=BBCX$:RETURN
740 X$=BBCY$:RETURN
750 X$=BBCZ$:RETURN
760 Y$=GWA$:RETURN     'get GW command table string
770 Y$=GWB$:RETURN
780 Y$=GWC$:RETURN
790 Y$=GWD$:RETURN
800 Y$=GWE$:RETURN
810 Y$=GWF$:RETURN
820 Y$=GWG$:RETURN
830 Y$=GWH$:RETURN
840 Y$=GWI$:RETURN
850 Y$=GWJ$:RETURN
860 Y$=GWK$:RETURN
870 Y$=GWL$:RETURN
880 Y$=GWM$:RETURN
890 Y$=GWN$:RETURN
900 Y$=GWO$:RETURN
910 Y$=GWP$:RETURN
920 Y$=GWQ$:RETURN
930 Y$=GWR$:RETURN
940 Y$=GWS$:RETURN
950 Y$=GWT$:RETURN
960 Y$=GWU$:RETURN
970 Y$=GWV$:RETURN
980 Y$=GWW$:RETURN
990 Y$=GWX$:RETURN
1000 Y$=GWY$:RETURN
1010 Y$=GWZ$:RETURN
1020 '    INITIALISATION
1030 '    --------------
1040 CHANNO%=0:FCT%=0 'clear file channel nos.
1050 HIREC%=0:ACODE%=0 'clear workfile record no.
1060 ESC%=0:WARN%=0   'clear termination/warning flags
1070 LPRIN$=SP0$      'disable printer
1080 INKN$=SP0$:INKS$=SP0$:INKT$=SP0$ 'clear INKEY lists
1090 '
1100 '   MAIN LOOP
1110 '   ---------
1120 GOSUB 1400         'output main screen
1130 GOSUB 1770         'open files
1140 IF OK%<>0 THEN 1120 'j if open failed
1150 REPLINE$=SP0$:REPPTR%=0 'clear REPEAT line flag
1160 MODE%=7            'set default mode
1170 GOSUB 2940         'get next input line
1180 IF OK%=1 THEN 1212 'j if end of input
1190 GOSUB 4400         'translate to GW format
1200 IF GOK%=1 THEN GOSUB 3920 'write output to workfile
1210 GOTO 1170
1212 PRINT FNCUR$(23,25)"   PRODUCING GW OUTPUT FILE   "
1220 GOSUB 3630         'convert workfile to final GW output
1230 CLOSE BBC%,GW%,WF%,PWF%,FWF% 'close files
1240 IF WARN%<>0 THEN CLOSE CWF%
1250 IF HIREC%=0 THEN 1290 'j if files unopened
1260 KILL "WORKFILE.TEM"
1270 KILL "PROCWORK.TEM"
1280 KILL "FNWORK.TEM"
1290 GOSUB 1640       'output end of run screen
1300 GOSUB 2300       'await input
1310 IF K$="l" OR K$="L" THEN CHAIN DRIVE$+"B-TRANWL"
1320 ON ERROR GOTO 1360
1330 KILL WFILE$
1340 IF K%<>13 THEN 1040 'j if not RETURN
1350 SYSTEM
1360 RESUME NEXT
1370 '
1380 '    OUTPUT MAIN SCREEN
1390 '    ------------------
1400 GOSUB 1580           'output heading
1410 PRINT FNCUR$(8,3);INVVID$;
1420 PRINT " Give name of BBC Basic file to be converted [.BBC] :-"
1430 PRINT FNCUR$(9,3);NORVID$;INN$"input will be taken from keyboard)"
1440 PRINT FNCUR$(11,3);INVVID$;
1450 PRINT " Give (different) file name for the GW Basic [.BAS] :-"
1460 PRINT FNCUR$(12,3);NORVID$;INN$"output will be to screen)"
1470 PRINT FNCUR$(14,4)"Press ESC to terminate the conversion."
1480 PRINT FNCUR$(8,58);
1490 F%=1:GOSUB 2080      'get input file name
1500 IF ESC%=1 THEN 1230
1510 IF FSTOP%=0 AND INNAME$<>SPACE$(L%) THEN MID$(INNAME$,CP%,4)=".BBC"
1520 PRINT FNCUR$(11,58);
1530 F%=2:GOSUB 2080      'get output file name
1540 IF ESC%=1 THEN 1230
1550 IF FSTOP%=0 AND OUTNAME$<>SPACE$(L%) THEN FSTOP%=CP%:MID$(OUTNAME$,CP%,4)=".BAS"
1560 IF INNAME$=OUTNAME$ AND INNAME$<>SPACE$(L%) THEN MESS$="FILES HAVE SAME NAME":GOSUB 16040:GOTO 1520
1570 RETURN
1580 PRINT ESC$+CHR$(69); 'clear screen
1590 PRINT FNCUR$(2,19);"B-TRAN :- BBC BASIC TO GW BASIC CONVERSION"
1600 RETURN
1610 '
1620 '   OUTPUT END OF RUN SCREEN
1630 '   ------------------------
1640 GOSUB 1580           'output heading
1650 PRINT FNCUR$(12,21);INVVID$;"CONVERSION OF ";INNAME$;
1660 IF ESC%=0 THEN PRINT " COMPLETED"; ELSE PRINT " TERMINATED";
1670 IF WARN%=0 THEN 1690 'j if no conversion warnings
1680 PRINT FNCUR$(14,24)"NO.OF CONVERSION WARNINGS = ";WARN%
1690 PRINT NORVID$
1700 IF WARN%<>0 THEN PRINT FNCUR$(16,26)"Press 'L' to list warnings"
1710 PRINT FNCUR$(18,25);"Press RETURN to exit to system"
1720 PRINT FNCUR$(20,18);"Press any other key to do another conversion"
1730 RETURN
1740 '
1750 '    OPEN FILES
1760 '    ----------
1770 OK%=0
1780 ON ERROR GOTO 2010
1790 IF INNAME$=SPACE$(L%) THEN 1820 'j if keyboard input
1800 OPEN "I",BBC%,INNAME$  'open BBC file
1810 IF OK%=1 THEN RETURN
1820 IF OUTNAME$=SPACE$(L%) THEN 1850 'j if screen output
1830 OPEN "O",GW%,OUTNAME$  'open GW file
1840 IF OK%=1 THEN RETURN
1850 ON ERROR GOTO 0
1860 OPEN "R",WF%,"WORKFILE.TEM",64
1870 FIELD WF%,4 AS WFLINE$,2 AS WFFORW$,2 AS WFBACK$,2 AS WFLEN$,52 AS WFDATA$
1880 OPEN "R",PWF%,"PROCWORK.TEM",128
1890 FIELD PWF%,2 AS PWFLEN$,40 AS PWFPROC$,4 AS PWFLINE$,2 AS PWFNEXT$,2 AS PWFCONT$,72 AS PWFUSED$,2 AS PWFPARP$,2 AS PWFBACK$
1900 FIELD PWF%,126 AS PWFPARAM$,2 AS PWFPCONT$
1910 HIPROC%=0:LASTPROC%=0  'show empty file
1920 OPEN "R",FWF%,"FNWORK.TEM",128
1930 FIELD FWF%,2 AS FWFLEN$,40 AS FWFNAME$,4 AS FWFLINE$,2 AS FWFNEXT$,2 AS FWFCONT$,72 AS FWFUSED$,2 AS FWFPARP$,2 AS FWFBACK$,2 AS FWFEQP$
1940 FIELD FWF%,126 AS FWFPARAM$,2 AS FWFPCONT$
1950 HIFN%=0:LASTFN%=0      'show is empty file
1960 IF OUTNAME$<>SPACE$(L%) THEN WFILE$=LEFT$(OUTNAME$,FSTOP%-1)+".war"
1970 IF INNAME$<>SPACE$(L%) AND OUTNAME$<>SPACE$(L%) THEN 2000                 
1980 PRINT FNCUR$(15,1);STRING$(78,45)
1990 PRINT FNCUR$(16,1);
2000 RETURN
2010 MESS$="FILE NOT FOUND":GOSUB 16040
2020 OK%=1
2030 RESUME NEXT
2040 RETURN
2050 '
2060 '    GET FILE NAME
2070 '    -------------
2080 L%=14
2090 CP%=1:FLD$=SPACE$(L%)  'set character pointer
2100 FSTOP%=0:ESC%=0        'clear . flag
2110 GOSUB 2300             'get next character
2120 IF K%=13 THEN 2230     'j if return
2130 IF K%=8 THEN GOSUB 2250:GOTO 2110 'action backspace
2140 IF K%>31 AND K%<127 THEN 2170 'j if normal character
2150 IF K%=27 THEN ESC%=1:RETURN 'check for ESC
2160 PRINT CHR$(7);:GOTO 2110
2170 MID$(FLD$,CP%,1)=K$    'build up field
2180 CP%=CP%+1              'step character pointer
2190 PRINT K$;              'echo to screen
2200 IF K%=46 THEN FSTOP%=CP% 'set . flag
2210 GOTO 2110
2220 IF CP%<=L% THEN 2110   'loop till full field
2230 ON F% GOSUB 2340,2350,2360
2240 RETURN
2250 IF CP%=1 THEN RETURN   'ignore if 1st character
2260 CP%=CP%-1              'step back a character
2270 MID$(FLD$,CP%,1)=SP1$
2280 PRINT K$" "K$;         'backspace & spacefill
2290 RETURN
2300 K$=INKEY$
2310 IF LEN(K$)=0 THEN 2300 'loop till input received
2320 K%=ASC(K$)
2330 RETURN
2340 INNAME$=FLD$:RETURN
2350 OUTNAME$=FLD$:RETURN
2360 CURRLINE$=LEFT$(FLD$,CP%-1):RETURN
2370 '
2380 '    REPORT WARNINGS
2390 '    ---------------
2400 GOSUB 2410:RETURN    'report warning
2410 WARN%=WARN%+1
2420 IF OUTNAME$=SPACE$(14) THEN PRINT LINENO$" *Warn":RETURN
2430 LSET WLINE$=LINENO$:LSET WAR$=MKI$(WAR%)
2440 IF WARN%=1 THEN OPEN "R",CWF%,WFILE$,8:FIELD CWF%,6 AS WLINE$,2 AS WAR$
2450 LSET WLINE$=LINENO$:LSET WAR$=MKI$(WAR%)
2460 PUT CWF%,WARN%+1
2470 LSET WAR$=MKI$(WARN%):PUT CWF%,1
2480 RETURN
2490 '
2500 '    SEARCH FOR LINE IN WORKFILE
2510 '    ---------------------------
2520 A$=GSUB$
2530 USEDL!=CVS(Z$):WREC%=USEDL!/10:Y$=SP0$ 'get approx.record no.
2540 IF WREC%>HIREC% THEN WREC%=HIREC%
2550 GET WF%,WREC%          'get workfile record
2560 IF CVI(WFBACK$)<>0 THEN WREC%=WREC%-1:GOTO 2550
2570 IF CVS(WFLINE$)=USEDL! THEN 2610 'j if found
2580 IF CVS(WFLINE$)>USEDL! THEN WREC%=WREC%-1:GOTO 2540
2590 IF CVI(WFFORW$)<>0 THEN WREC%=WREC%+1:GET WF%,WREC%:GOTO 2590
2600 WREC%=WREC%+1:GOTO 2540
2610 SWREC%=WREC%:WFLEN%=CVI(WFLEN$) 'keep start record no.
2620 Y$=Y$+WFDATA$
2650 IF CVI(WFFORW$)=0 THEN 2672
2660 WREC%=CVI(WFFORW$)
2670 GET WF%,WREC%:GOTO 2620
2672 Y%=INSTR(Y$,A$)
2674 IF Y%<>0 THEN Y$=LEFT$(Y$,WFLEN%)
2676 RETURN
2690 A$=RIGHT$(Y$,LEN(Y$)-Y%-1):Y$=LEFT$(Y$,Y%+1)
2700 Y$=Y$+LINENO$+CHR$(46)+PROCNAME$+RIGHT$(A$,LEN(A$)-6):GOTO 2720
2710 MID$(Y$,Y%+6,5)=LINENO$  'put in line no.
2720 GET WF%,SWREC%           'get 1st record
2730 LSET WFDATA$=LEFT$(Y$,52)
2740 LSET WFLEN$=MKI$(LEN(Y$))
2750 PUT WF%,SWREC%
2760 IF LEN(Y$)<=52 THEN RETURN
2770 Y$=RIGHT$(Y$,LEN(Y$)-52)
2780 SWREC%=CVI(WFFORW$)
2790 IF SWREC%=0 THEN RETURN ELSE 2720
2800 '
2810 '    GET LINE NO.
2820 '    ------------
2830 STYPE%=1:GOSUB 17030   'look for numeric
2840 IF OK%=1 THEN RETURN
2850 GOSUB 16880            'look for non-numeric
2860 LINENO$=FNCSTR$:LINENO!=VAL(LINENO$)
2880 IF OUTNAME$=SPACE$(14) THEN 2900
2890 PRINT FNCUR$(23,28)"CONVERTING LINE NO. ";LINENO$;
2900 OK%=0:RETURN
2910 '
2920 '    GET NEXT INPUT LINE
2930 '    -------------------
2940 IF INNAME$=SPACE$(14) THEN 3040 'j if keyboard input
2950 K$=INKEY$
2960 IF LEN(K$)=0 THEN 2980 'j if no input
2970 IF K$=CHR$(27) THEN ESC%=1:GOTO 3400 'check for ESC
2980 IF EOF(BBC%) THEN 3400
2990 LINE INPUT #BBC%,CURRLINE$  'read next input line
3000 LL%=LEN(CURRLINE$)     'set line length
3010 OK%=0:COMCT%=0
3020 ER%=0:BRKT%=0:FIRST%=ICP%:VSTART%=0:FCOM%=0:FSTART%=ICP%+1
3030 RETURN
3040 PRINT CHR$(62);
3050 F%=3:L%=254:GOSUB 2090 'get input line
3060 IF ESC%=1 THEN 3400 ELSE PRINT:GOTO 3000 'check for end
3070 '
3080 '    GET VARIABLE
3090 '    ------------
3100 GOSUB 16870:IF OK%=1 THEN RETURN 'look for non-space
3110 IF CCAT%(K%-31)=1 THEN STYPE%=1 ELSE  STYPE%=99
3120 GOSUB 16880:GOTO 2900 'look for end of variable
3140 '
3150 '    CHECK VARIABLE NAME AGAINST GW COMMANDS
3160 '    ---------------------------------------
3170 VSTART%=LEN(OBUFF$)+1
3180 ON CH% GOSUB 760,770,780,790,800,810,820,830,840,850,860,870,880,890,900,910,920,930,940,950,960,970,980,990,1000,1010
3190 VLEN%=ICP%-STCP%
3200 GOSUB 3790:IF OK%=1 THEN OK%=0:GOTO 3390 'check for FN/PROC name
3210 GOSUB 3500:IF OK%=1 THEN OK%=0:GOTO 3390 'check for LOCAL name
3220 SL%=LEN(Y$)            'get length of table string
3230 IF SL%=0 THEN 3400
3240 SP%=1:GWL%=0           'initialise pointer
3250 N%=2
3260 NK%=ASC(MID$(COMMAND$,N%,1))
3270 IF NK%>96 THEN NK%=NK%-32:GWL%=1 'check for lower case
3280 NK$=CHR$(NK%)
3290 NGWK$=MID$(Y$,SP%+N%-1,1) 'get next GW letter
3300 IF NGWK$=SP1$ THEN 3370 'j if end of GW
3310 IF NGWK$>NK$ THEN 3400 'j if not found
3320 IF NGWK$=NK$ THEN 3350 'j if match so far
3330 SP%=SP%+7              'step to next GW command
3340 IF SP%>SL% THEN 3400 ELSE 3250
3350 N%=N%+1
3360 IF N%<8 THEN 3260 ELSE 3380
3370 IF NK$<>SP1$ THEN 3400
3380 IF GWL%=0 THEN Z$="GW." ELSE Z$="GWL."
3390 IF VSTART%=0 THEN RETURN ELSE 5160
3400 OK%=1:RETURN
3410 BREX$=BREX$+Z$:RETURN
3420 BREX$=BREX$+FNCSTR$:COK%=0:RETURN
3430 '
3440 '    CHECK FOR LOCAL VARIABLE NAME
3450 '    -----------------------------
3460 X$=FNKMID$
3470 IF X$=CHR$(36) OR X$=CHR$(37) THEN XLEN%=VLEN%+1 ELSE XLEN%=VLEN%
3480 N%=1:RETURN
3500 IF LEN(LOLIST$)=0 THEN 2900 'j if no LOCALS
3510 GOSUB 3460
3520 LLEN%=VAL(MID$(LOLIST$,N%,2)) 'get length of LOCAL
3530 LLINE%=VAL(MID$(LOLIST$,N%+LLEN%+2,2)) 'get line no.length
3540 IF LLEN%=XLEN% THEN 3570      'j if possible match
3550 N%=N%+LLEN%+LLINE%+4          'step to next entry
3560 IF N%>LEN(LOLIST$) THEN 2900 ELSE 3520
3570 IF MID$(LOLIST$,N%+2,LLEN%)<>MID$(CURRLINE$,STCP%,XLEN%) THEN 3550
3580 Z$="GW"+MID$(LOLIST$,N%+LLEN%+4,LLINE%)+CHR$(46)
3590 GWL%=2:GOTO 3400
3600 '
3610 '    PRODUCE FINAL GW OUTPUT
3620 '    -----------------------
3630 REC%=1
3640 WHILE REC%<=HIREC%      'loop till all dealt with
3650   GET WF%,REC%          'get workfile record
3652   IF CVI(WFBACK$)<>0 THEN 3730
3660   OBUFF$=LEFT$(WFDATA$,CVI(WFLEN$))
3670   WHILE CVI(WFFORW$)<>0 'check for continuation
3690     GET WF%,CVI(WFFORW$) 'get continuation record
3700     Z$=LEFT$(WFDATA$,CVI(WFLEN$)):GOSUB 17590
3710   WEND
3720   IF OUTNAME$=SPACE$(14) THEN PRINT OBUFF$ ELSE PRINT #GW%,OBUFF$
3730   REC%=REC%+1
3740 WEND
3750 RETURN
3760 '
3770 '    CHECK FOR FUNCTION/PROCEDURE PARAM.NAME
3780 '    ---------------------------------------
3790 OK%=0:IF FCT%=0 OR DPROCFLAG%=1 THEN RETURN 'j if not defining FN/PROC
3800 IF DPROCFLAG%=2 THEN GET FWF%,FCT%:Y$=FWFPARAM$ ELSE GET PWF%,FCT%:Y$=PWFPARAM$
3810 GOSUB 3460
3820 LLEN%=VAL(MID$(Y$,N%,2)) 'get variable length
3830 IF LLEN%=0 THEN 2900 'j if end of list
3840 IF LLEN%=XLEN% THEN 3860
3850 N%=N%+LLEN%+2:GOTO 3820
3860 IF MID$(Y$,N%+2,LLEN%)<>MID$(CURRLINE$,STCP%,XLEN%) THEN 3850
3870 Z$="GW"+PLINE$+CHR$(46):GOTO 3400
3880 '
3890 '    WRITE WORKFILE RECORD
3900 '    ---------------------
3910 OBUFF$=LEFT$(OBUFF$,LEN(OBUFF$)-1)
3920 IF OUTNAME$=SPACE$(14) THEN PRINT OBUFF$
3930 Y$=OBUFF$:HIREC%=HIREC%+1:REC%=HIREC%:X!=LINENO!:LSET WFFORW$=IV$
3940 BACK%=0               'clear backward pointer
3950 LSET WFLINE$=MKS$(X!) 'set line no.
3960 WFLEN%=LEN(Y$)       'get line length
3970 IF WFLEN%>52 THEN RMLEN%=WFLEN%-52 ELSE RMLEN%=0
3980 LSET WFLEN$=MKI$(WFLEN%) 'set data length
3990 LSET WFDATA$=LEFT$(Y$,WFLEN%)
4000 IF RMLEN%=0 THEN LSET WFFORW$=IV$:GOTO 4020
4010 IF CVI(WFFORW$)=0 OR REC%=HIREC% THEN HIREC%=HIREC%+1:LSET WFFORW$=MKI$(HIREC%)
4020 LSET WFBACK$=MKI$(BACK%) 'set backward pointer
4030 PUT WF%,REC%
4040 IF RMLEN%=0 THEN RETURN  'exit if all written
4050 Y$=RIGHT$(Y$,LEN(Y$)-52)
4060 BACK%=REC%:REC%=CVI(WFFORW$):GOTO 3950 'set backward pointer
4070 '
4080 '    LOOK FOR MATCHED PARENTHESIS
4090 '    ----------------------------
4100 ICP%=ICP%+1      'step over (
4110 GOSUB 16870:IF OK%=1 THEN RETURN 'look for non-space
4120 STCP%=ICP%:STCH%=CH%
4130 PCOUNT%=1:GWNO%=0:BSTCP%=STCP%:BREX$=SP0$:GOTO 4150 'initialise parenthesis count
4140 ICP%=ICP%+1
4150 IF ICP%>LL% THEN GOSUB 3420:GOTO 3400
4160 K$=FNKMID$:K%=ASC(K$)  'get next character
4170 IF K%>96 THEN K%=K%-32 'get category array offset
4180 IF K%=40 THEN PCOUNT%=PCOUNT%+1:GOTO 4230 'j if (
4190 IF K%=41 THEN PCOUNT%=PCOUNT%-1:GOTO 4230 'j if )
4200 IF K%>64 AND K%<91 THEN GOSUB 4240:GOTO 4160
4210 IF K%<>44 THEN 4140    'j if not ,
4220 IF PCOUNT%=1 THEN GOSUB 3420:GOTO 2900
4230 IF PCOUNT%=0 THEN GOSUB 3420:GOTO 3400 ELSE 4140
4240 COMMAND$=SPACE$(8):Y%=ICP%:Z%=STCP%:CH%=K%-64:STYPE%=2:GOSUB 16340 'look for non-alpha
4250 STCH%=STCH%+33:GOSUB 16620:STCH%=STCH%-33:IF OK%=1 THEN 4300 'j if not BBC command
4260 BREX$=BREX$+MID$(CURRLINE$,BSTCP%,STCP%-BSTCP%)
4270 GOSUB 17300 'check for requirements
4280 IF OK%<>0 THEN COK%=OK%:GOSUB 4660
4290 STCP%=ICP%:RETURN
4300 VSTART%=0:CH%=STCH%:STCP%=Z%:GOSUB 3180
4310 IF OK%=1 THEN RETURN
4320 GWVAR%(GWNO%*3+1)=GWL%*1000+Y%
4330 GWVAR%(GWNO%*3+2)=ICP%
4340 GWVAR%(GWNO%*3+3)=N%+LLEN%+4
4350 GWNO%=GWNO%+1
4360 RETURN
4370 '
4380 '    TRANSLATE TO GW FORMAT
4390 '    ----------------------
4400 OBUFF$=SP0$:GOK%=1 'clear output buffer
4410 ICP%=1:PRFLAG%=0   'initialise input pointer & PRINT flag
4420 GOSUB 2830         'get line no.
4430 IF OK%=1 THEN GOK%=0:GOTO 4650 'j if not found
4440 GOSUB 17570:FSTART%=LEN(OBUFF$)+2 'copy line no.
4450 IF ACODE%=1 THEN GOSUB 16870:LL%=0 'ignore assembler code
4460 IF K%<>32 OR ACODE%=1 THEN OBUFF$=OBUFF$+SP1$
4470 SUFFIX%=0       'clear verb end flag
4480 IF ICP%>LL% THEN OBUFF$=OBUFF$+"REM":GOTO 4640 'j if no command
4490 FIRST%=0
4500 IF K%=58 AND SUFFIX%=56 THEN GOSUB 14810
4510 IF K%=58 THEN ICP%=ICP%+1:X%=LEN(OBUFF$)-LEN(LINENO$):FIRST%=0:COMCT%=COMCT%+1
4520 IF K%=58 AND RIGHT$(OBUFF$,X%)<>SPACE$(X%) THEN GOSUB 17600
4530 GOSUB 16190:IF OK%=1 THEN 4610 'look for BBC command
4550 GOSUB 16620        'check it in command table
4560 IF OK%=1 THEN GOSUB 3170:GOTO 4610 'j if not found
4570 IF FCOM%=0 THEN FCOM%=LEN(OBUFF$) 'keep start of command
4580 GOSUB 17300        'check if special action required
4590 IF OK%<>0 THEN COK%=0:GOSUB 4660 ELSE 4490 'j if is
4600 IF OK%=20 THEN 4630 ELSE 4500
4610 IF LL%<>0 THEN GOSUB 17570  'copy to output
4620 IF ICP%<=LL% THEN 4500 'j if more
4630 IF SUFFIX%=56 THEN GOSUB 14810 'j if UNTIL
4640 IF ACODE%=1 AND K%=93 THEN ACODE%=0
4650 RETURN
4660 IF OK%>40 THEN SOK%=OK%-40:GOTO 4690
4670 ON OK% GOSUB 9980,14120,8210,10820,11760,13200,15950,4740,4790,4880,4930,4790,4790,5460,4790,5900,7920,7970,8010,13150,8130,4790,8310,8350,8740,8860,4790,9000,9560,9690,4790,10050,10170,4790,10360,10690,4790,4790,11030,11070
4680 RETURN
4690 ON SOK% GOSUB 11580,11800,12390,12910,13020,13270,13370,13420,13660,14260,14410,14480,4790,14610,14690,14740,4790,14880,9810,12970,10730,10980,10290,14560,14200,8050,5040,4830,8260,10780,5860,5390,5800,13610,9890
4700 RETURN
4710 '
4720 '    ACS
4730 '
4740 GOSUB 10200  'get argument
4750 Z$="-ATN("+ARG$+"/SQR(-"+ARG$+"*"+ARG$+"+1))+1.5708":GOTO 5160
4760 '
4770 '    ADVAL/BPUT/CALL/COUNT/EVAL/HIMEM/LISTO/LOMEM/OPT/PAGE/TOP/USR
4780 '
4790 GOTO 8150
4800 '
4810 '    AND
4820 '
4830 IF INVOP%=0 OR BRKT%=1 THEN Z$="AND" ELSE Z$="OR NOT"
4840 GOTO 5160
4850 '
4860 '    ASN
4870 '
4880 GOSUB 10200  'get argument
4890 Z$="ATN("+ARG$+"/SQR(-"+ARG$+"*"+ARG$+"+1))":GOTO 5160
4900 '
4910 '    BGET
4920 '
4930 GOSUB 4960:IF OK%=1 THEN 4950
4940 Z$="INPUT$(1,#"+X$+CHR$(41):GOTO 5160
4950 WAR%=4:GOTO 2400
4960 STYPE%=5:GOSUB 17030 'look for #
4970 IF OK%=1 THEN 5000
4980 ICP%=ICP%+1          'step over #
4990 GOSUB 14010:OK%=0    'get channel no.
5000 RETURN
5010 '
5020 '    CHR$
5030 '
5040 IF ICP%+1>LL% OR MID$(CURRLINE$,ICP%+1,1)<>"$" THEN RETURN 
5050 Z$="CHR$"
5060 ICP%=ICP%+2           'step over $
5070 GOSUB 16870:IF OK%=1 THEN RETURN  'search for non-space
5080 IF K%=40 THEN ICP%=ICP%+1 'step over (
5090 GOSUB 3100:IF OK%=1 THEN RETURN 'get field
5100 IF PRFLAG%<>0 AND MODE%=7 THEN 5180 'j to check colour char.
5110 OBUFF$=OBUFF$+Z$+CHR$(40)
5120 GOSUB 17570           'copy number
5130 Z$=CHR$(41)
5140 IF K%=32 THEN GOSUB 16870 'look for non-space
5150 IF OK%=0 AND K%=41 THEN ICP%=ICP%+1
5160 IF COK%=0 THEN GOSUB 17590 ELSE GOSUB 3410
5170 RETURN
5180 GOSUB 12250:IF OK%=1 THEN XVAL$=X$:GOTO 5280
5190 X%=XVAL%
5200 IF X%<128 OR X%>159 THEN 5110 'j if not colour definition
5210 X%=X%-127             'get offset from 128
5220 IF X%=9 THEN WAR%=1:GOTO 5350 'j if flash foreground
5230 IF X%=14 THEN WAR%=2:GOTO 5350 'j if double height chars.
5240 IF X%>16 AND X%<25 THEN X%=X%-16 'amend if graphics
5250 IF X%>24 THEN WAR%=3:GOTO 5350 'j if graphics control
5260 COL%=X%:ON CFLAG% GOSUB 5720,5730,5730,5740
5270 XVAL$=STR$(COL%):GOSUB 12340
5280 Z$="COLOR "+XVAL$   'get colour
5290 IF LEN(OBUFF$)<PRFLAG%+7 THEN OBUFF$=LEFT$(OBUFF$,PRFLAG%)
5300 IF RIGHT$(OBUFF$,1)<>COLON$ AND FIRST%<>0 THEN GOSUB 17600
5310 GOSUB 17590
5320 PRFLAG%=LEN(OBUFF$)
5330 IF ICP%<=LL% THEN GOSUB 17600:GOSUB 17610:PRFLAG%=PRFLAG%+1
5340 Z$=SP0$:GOTO 5140
5350 GOSUB 2410:GOTO 5340 'report warning
5360 '
5370 '      CLOSE
5380 '
5390 STYPE%=1:GOSUB 17030 'look for numeric
5400 IF OK%=1 THEN 5430
5410 GOSUB 16880:X%=VAL(FNCSTR$) 'get no.
5420 IF X%<>0 THEN Z$=SP1$:GOSUB 17590:GOSUB 17570
5430 RETURN
5440 '    COLOUR
5450 '
5460 IF CFLAG%=0 THEN WAR%=15:GOTO 8140
5470 GOSUB 16870 'look for non-space
5480 Z$="COLOR ":GOSUB 17590
5490 IF OK%=1 OR K%<48 OR K%>57 THEN 5540
5500 STYPE%=1:GOSUB 16880 'look for non-numeric
5510 COL%=VAL(FNCSTR$)
5520 IF COL%>127 THEN COL%=COL%-128:Z$=" ," ELSE Z$=SP1$ 'check for background
5530 ON MODE%+1 GOSUB 5560,5640,5700,5560,5560,5640,5560,5700
5540 RETURN
5550 '    mode 0/3/4/6
5560 IF COL%=0 THEN 5580
5570 ON CFLAG% GOSUB 5600,5610,5610,5620
5580 XVAL$=STR$(COL%):GOSUB 12340
5590 Z$=Z$+XVAL$:GOTO 5160
5600 COL%=3:RETURN
5610 COL%=7:RETURN
5620 COL%=15:RETURN
5630 '    mode 1/5
5640 COL%=COL%+1:ON CFLAG% GOSUB 5660,5670,5670,5680
5650 GOTO 5580
5660 COL%=COL42%(COL%):RETURN
5670 COL%=COL43%(COL%):RETURN
5680 COL%=COL44%(COL%):RETURN
5690 '    mode 2/7
5700 COL%=COL%+1:ON CFLAG% GOSUB 5720,5730,5730,5740
5710 GOTO 5580
5720 COL%=COL162%(COL%):RETURN
5730 COL%=COL163%(COL%):RETURN
5740 COL%=COL164%(COL%):RETURN
5750 '
5760 '      COS/SIN/TAN
5770 '
5780 GOSUB 16870:IF OK%=1 OR K%=40 THEN RETURN
5790 GOSUB 17580:RETURN
5800 GOSUB 5780
5810 IF K%=40 THEN GOSUB 10200:Z$=CHR$(40)+BREX$+CHR$(41):GOTO 5160
5820 STYPE%=CCAT%(K%-31):GOSUB 16880
5830 GOSUB 17570:Z$=CHR$(41):GOTO 5160
5840 '   DATA
5850 '
5860 STYPE%=11:GOSUB 17030:GOTO 10000 'look for :
5870 '
5880 '    DEF
5890 '
5900 DPROCFLAG%=1:FCT%=1  'set definition flag
5910 GOSUB 16870 'look for non-space
5920 RETURN
5930 '
5940 '   1. Function
5950 GOSUB 7490 'get function name
5960 IF LASTFN%=0 THEN 6000 'j if 1st time
5970 GOSUB 6530           'look for existing record
5980 IF OK%=0 THEN 6340   'j if found
5990 GOSUB 6610           'chain to last entry
6000 GOSUB 6080           'write new record
6010 LASTFN%=HIFN%:REC%=HIFN%
6020 GOSUB 6650 'action any params.
6030 DPROCFLAG%=2
6040 GOSUB 16870:IF OK%=1 THEN 8150 'look for non-space
6050 IF K%=58 THEN 8160
6060 IF K%<>61 THEN ICP%=ICP%+1:GOTO 6040 'j if not =
6070 GOSUB 6200:Z$=":RETURN":GOTO 5160
6080 HIFN%=HIFN%+1
6090 LSET FWFLEN$=MKI$(PROCLEN%) 'set name length
6100 LSET FWFNAME$=PROCNAME$    'set FN name
6110 LSET FWFLINE$=MKS$(PLINE!) 'set line no.
6120 LSET FWFCONT$=IV$     'clear continuation
6130 LSET FWFNEXT$=IV$     'clear next
6140 LSET FWFBACK$=MKI$(LASTFN%) 'set backward pointer
6150 LSET FWFUSED$=SPACE$(72) 'clear used line nos.
6160 LSET FWFPARP$=IV$:FCT%=0 'clear parameter block pointer
6170 LSET FWFEQP$=IV$  'clear =string$ block pointer
6180 PUT FWF%,HIFN%
6190 RETURN
6200 HIFN%=HIFN%+1:ICP%=ICP%+1:B$="GW"+PLINE$+CHR$(46)+PROCNAME$
6210 BLEN%=3+PROCLEN%+LEN(LINENO$)
6220 Z$=B$+CHR$(61):GOSUB 17590
6230 A$=SP0$
6240 STYPE%=2:GOSUB 17030:IF OK%=1 THEN 6280
6250 GOSUB 17570:A$=A$+FNCSTR$
6260 STYPE%=99:GOSUB 16880  'look for end of variable
6270 GOSUB 3170:GOSUB 17570:A$=A$+FNCSTR$:GOTO 6240
6280 IF DPROCFLAG%=2 THEN A$=B$ ELSE BLEN%=LEN(A$)
6290 LSET FWFPARAM$=A$:LSET FWFPCONT$=MKI$(BLEN%)
6300 PUT FWF%,HIFN%
6310 GET FWF%,REC%
6320 LSET FWFEQP$=MKI$(HIFN%):GOSUB 6810
6330 GOSUB 17570:RETURN
6340 GOSUB 6650           'action any parameters
6350 X%=1
6360 IF FCT%<>0 THEN GET FWF%,FCT%:FWFPAR$=FWFPARAM$:FWFPCONT%=CVI(FWFPCONT$):GET FWF%,REC%
6370 IF X%>72 THEN 6460  'j if no more
6380 Z$=MID$(FWFUSED$,X%,4)
6390 IF Z$=SPACE$(4) THEN 6490 'j if empty entry
6400 GOSUB 2520:GOSUB 2710 'get lines entry & update
6410 IF FCT%=0 THEN 6440  'j if no params.
6420 GOSUB 7210           'look for =
6430 V$=FWFPAR$:GOSUB 7290 'update workfile
6440 A$="GW"+SPACE$(6):GOSUB 2530:GOSUB 2690
6450 X%=X%+4:GOTO 6370
6460 IF CVI(FWFCONT$)=0 THEN 6490 'j if no continuation
6470 GET FWF%,CVI(FWFCONT$):GOTO 6350
6490 GET FWF%,REC%
6500 LSET FWFLINE$=MKS$(PLINE!) 'set line no.
6510 LSET FWFUSED$=SPACE$(72) 'clear used on lines
6520 PUT FWF%,REC%:GOTO 6030
6530 REC%=1
6540 IF REC%=0 THEN 3400  'j not found
6550 GET FWF%,REC%
6560 X%=CVI(FWFLEN$)      'get names length
6570 IF X%<>PROCLEN% THEN 6590  'j if not found
6580 IF LEFT$(FWFNAME$,X%)=PROCNAME$ THEN FCT%=CVI(FWFPARP$):OK%=0:RETURN
6590 REC%=CVI(FWFNEXT$):GOTO 6540 'get next entry
6610 GET FWF%,LASTFN%
6620 LSET FWFNEXT$=MKI$(HIFN%+1) 'set pointer to new entry
6630 PUT FWF%,LASTFN%
6640 RETURN
6650 GOSUB 16870:IF OK%=1 THEN RETURN
6660 IF K%=40 THEN 6700  'j if (
6670 IF K%=61 THEN RETURN ELSE 6650
6680 IF OK%=1 THEN RETURN
6690 LSET FWFPARAM$=SPACE$(126)
6700 GOSUB 16870 'look for non-space
6710 PARCT%=0:XA%=1
6720 GOSUB 4100           'look for , or )
6730 Y$=FWFPARAM$:GOSUB 7730 'put param.in list
6740 LSET FWFPARAM$=Y$
6750 IF K%=44 THEN 6720 'j if ,
6760 ICP%=ICP%+1
6770 HIFN%=HIFN%+1:FCT%=HIFN%
6780 PUT FWF%,HIFN%       'write param.block
6790 GET FWF%,REC%
6800 LSET FWFPARP$=MKI$(HIFN%) 'set param.block pointer
6810 PUT FWF%,REC%
6820 RETURN
6830 '
6840 '   2. Procedure
6850 GOSUB 7490 'get procedure name
6860 IF LASTPROC%=0 THEN 6940 'j if 1st time
6870 GOSUB 7580           'search for existing record
6880 IF OK%=0 THEN 7100   'j if found
6890 GOSUB 6900:GOTO 6940 'chain to last entry
6900 GET PWF%,LASTPROC%
6910 LSET PWFNEXT$=MKI$(HIPROC%+1) 'set pointer to new entry
6920 PUT PWF%,LASTPROC%
6930 RETURN
6940 GOSUB 6990           'write new record
6950 LASTPROC%=HIPROC%
6960 REC%=HIPROC%
6970 GOSUB 7660    'action parameters
6980 DPROCFLAG%=3:GOTO 8150
6990 HIPROC%=HIPROC%+1
7000 LSET PWFLEN$=MKI$(PROCLEN%) 'set name length
7010 LSET PWFPROC$=PROCNAME$ 'set procedure name
7020 LSET PWFLINE$=MKS$(PLINE!) 'set line no.
7030 LSET PWFCONT$=IV$    'set continuation pointer
7040 LSET PWFNEXT$=IV$    'set forward pointer
7050 LSET PWFBACK$=MKI$(LASTPROC%) 'set backward pointer
7060 LSET PWFUSED$=SPACE$(76) 'clear used line nos.
7070 LSET PWFPARP$=IV$:FCT%=0 'clear parameter block pointer
7080 PUT PWF%,HIPROC%
7090 RETURN
7100 GOSUB 7660           'action any params
7110 X%=1
7120 IF FCT%<>0 THEN GET PWF%,FCT%:PWFPAR$=PWFPARAM$:PWFPCONT%=CVI(PWFPCONT$):GET PWF%,REC%
7130 IF X%>72 THEN 7420   'j if all looked at
7140 Z$=MID$(PWFUSED$,X%,4) 'get used in line no.
7150 IF Z$=SPACE$(4) THEN 7450 'j if end of entries
7160 GOSUB 2520:GOSUB 2710 'get lines entry & update
7170 IF FCT%=0 THEN 7200 'j if no params.
7180 GOSUB 7210          'look for =
7190 V$=PWFPAR$:GOSUB 7290 'update workfile
7200 X%=X%+4:GOTO 7130
7210 VY%=Y%
7220 VY%=VY%-1
7230 IF VY%=0 THEN 7280
7240 IF MID$(WFDATA$,VY%,1)<>CHR$(61) THEN 7220 'look for =
7250 PARCT%=PARCT%-1       'count down on params.
7260 IF PARCT%<>0 THEN 7220
7270 Y$=LEFT$(WFDATA$,VY%-1)
7280 RETURN
7290 Z%=1
7300 ZLEN%=VAL(MID$(V$,Z%,2)) 'get param.length
7310 IF ZLEN%=0 THEN 7390  'j if last param.
7320 NVY%=VY%
7330 Y$=Y$+"GW"+LINENO$+"."+MID$(V$,Z%+2,ZLEN%)
7340 Z%=Z%+2+ZLEN%         'step to next entry
7350 VY%=VY%+1
7360 IF VY%>=Y% THEN 7380
7370 IF MID$(WFDATA$,VY%,1)<>CHR$(61) THEN 7350
7380 Y$=Y$+MID$(WFDATA$,NVY%,VY%-NVY%):GOTO 7300
7390 Y$=Y$+MID$(WFDATA$,Y%,CVI(WFLEN$)-Y%+1)
7400 X!=USEDL!:REC%=SWREC%:GOSUB 3940 'write workfile record
7410 RETURN
7420 IF CVI(PWFCONT$)=0 THEN 7450 'j if no more branch aheads
7430 GET PWF%,CVI(PWFCONT$) 'get continuation record
7440 GOTO 7110
7450 GET PWF%,REC%         'get main record
7460 LSET PWFLINE$=MKS$(PLINE!) 'set line no.
7470 LSET PWFUSED$=SPACE$(72) 'clear branch aheads
7480 PUT PWF%,REC%:GOTO 6980
7490 Z$=SP0$
7500 STYPE%=2:GOSUB 17030  'search for alpha
7510 IF OK%=1 THEN GOSUB 17570:RETURN
7520 STYPE%=99:GOSUB 16880 'search for non-alpha numeric
7530 IF K%=36 THEN ICP%=ICP%+1
7540 PROCNAME$=FNCSTR$
7550 PROCLEN%=LEN(PROCNAME$)
7560 PLINE!=LINENO!:IF DPROCFLAG%=1 THEN PLINE$=LINENO$
7570 RETURN
7580 REC%=1
7590 IF REC%=0 THEN 3400 'j not found
7600 GET PWF%,REC%
7610 X%=CVI(PWFLEN$)      'get names length
7620 IF X%<>PROCLEN% THEN 7640 'j if not found
7630 IF LEFT$(PWFPROC$,X%)=PROCNAME$ THEN FCT%=CVI(PWFPARP$):OK%=0:RETURN
7640 REC%=CVI(PWFNEXT$)   'get next entry
7650 GOTO 7590
7660 GOSUB 17020          'look for (
7670 IF OK%=1 THEN RETURN
7680 LSET PWFPARAM$=SPACE$(126)
7690 GOSUB 16870 'look for non-space
7700 PARCT%=0:XA%=1       'clear param.count
7710 GOSUB 4100           'look for , or )
7720 Y$=PWFPARAM$:GOSUB 7730:GOTO 7800
7730 X$=FNCSTR$:GOSUB 17640:X%=LEN(X$)
7740 MID$(Y$,XA%,2)=STR$(X%) 'set length
7750 MID$(Y$,XA%+2,X%)=X$
7760 XA%=XA%+2+X%  'step pointer
7770 MID$(Y$,XA%,2)=IV$
7780 PARCT%=PARCT%+1      'step param.count
7790 RETURN
7800 LSET PWFPARAM$=Y$
7810 IF K%=44 THEN 7710  'j to look for next param.
7820 ICP%=ICP%+1          'step over )
7830 HIPROC%=HIPROC%+1:FCT%=HIPROC%
7840 PUT PWF%,HIPROC%     'write parameter block
7850 GET PWF%,REC%
7860 LSET PWFPARP$=MKI$(HIPROC%) 'set param.block pointer
7870 PUT PWF%,REC%
7880 RETURN
7890 '
7900 '    DEG
7910 '
7920 GOSUB 10200    'get argument
7930 Z$=ARG$+"*180/3.14159265":GOTO 5160
7940 '
7950 '    DIV
7960 '
7970 Z$=CHR$(92):GOTO 5160
7980 '
7990 '    DRAW
8000 '
8010 PLOT%=5:GOTO 11120 'j for PLOT 5
8020 '
8030 '    END
8040 '
8050 Z$="END"
8060 IF ICP%+4>LL% OR MID$(CURRLINE$,ICP%+1,4)<>"PROC" THEN 5160
8070 ICP%=ICP%+5:DPROCFLAG%=0
8080 LOLIST$=SP0$         'clear local variable list
8090 Z$="RETURN":GOTO 5160
8100 '
8110 '    ENVELOPE
8120 '
8130 WAR%=10
8140 GOSUB 2410
8150 STYPE%=11:GOSUB 17030 'look for :
8160 IF K%<>58 THEN Z$="REM" ELSE Z$=SP0$
8170 STCP%=ICP%:GOTO 5160
8180 '
8190 '    EOF/EXT
8200 '
8210 GOSUB 17020:IF OK%=1 THEN 2410 'look for (
8220 GOSUB 4110:GOTO 10000 'look for matched )
8230 '
8240 '    ERR/ERROR
8250 '
8260 IF ICP%+2>LL% OR MID$(CURRLINE$,ICP%+1,2)<>"OR" THEN RETURN
8270 Z$="OR":ICP%=ICP%+3:ER%=1:GOTO 5160
8280 '
8290 '    FALSE
8300 '
8310 Z$="FALSE":GOTO 5160
8320 '
8330 '    FN
8340 '
8350 IF DPROCFLAG%=1 THEN 5950 'j if defining function
8360 GOSUB 7490:VSTART%=FSTART%:VLEN%=LEN(OBUFF$)-VSTART%:GOSUB 8940 'get function name
8370 IF LASTFN%=0 THEN 8430 'j if 1st entry
8380 GOSUB 6530           'look for existing entry
8390 PWFL$=STR$(CVS(FWFLINE$))
8400 IF OK%=0 AND CVS(FWFLINE$)<>0 THEN SUBL!=CVS(FWFLINE$):GOTO 8610
8410 IF OK%=0 THEN 8450  'j if existing entry
8420 GOSUB 6610           'chain to last entry
8430 PLINE!=0:GOSUB 6080  'create new FN file entry
8440 LASTFN%=HIFN%:REC%=HIFN%
8450 X%=1
8460 IF CVI(FWFCONT$)<>0 THEN REC%=CVI(FWFCONT$):GET FWF%,REC%:GOTO 8460
8470 IF X%>72 THEN 8580   'j if no more entries
8480 Z$=MID$(FWFUSED$,X%,4)
8490 IF Z$=SPACE$(4) THEN 8510 'j if empty entry
8500 X%=X%+4:GOTO 8470
8510 Z$=FWFUSED$
8520 MID$(Z$,X%,4)=MKS$(LINENO!) 'put in line no.
8530 LSET FWFUSED$=Z$
8540 PUT FWF%,REC%
8550 YA$=GSUB$:Z$=SP0$
8560 GOSUB 16870:IF K%<>40 THEN Z$=Z$+YA$:ICP%=STCP%:GOSUB 17590 ELSE GOSUB 12610 'look for (
8570 GOSUB 8660:Z$="GW"+SPACE$(6):GOTO 5160 'look for params
8580 LSET FWFCONT$=MKI$(HIFN%+1) 'point to new record
8590 PUT FWF%,REC%
8600 GOSUB 6080:GOTO 8450   'create new entry
8610 GOSUB 12870
8620 REC%=CVI(FWFEQP$):FCT%=CVI(FWFPARP$)
8630 IF FCT%=0 THEN GOSUB 12850:GOSUB 8660:GOTO 8690 'j if no params.
8640 GET FWF%,FCT%
8650 V$=FWFPARAM$:GOSUB 12730:GOSUB 8660:GOTO 8690
8660 FSTART%=LEN(OBUFF$)+2
8670 Z$=COLON$+VSTORE$:GOSUB 17590
8680 RETURN
8690 GET FWF%,REC%
8700 Z$=LEFT$(FWFPARAM$,CVI(FWFPCONT$)):GOTO 5160
8710 '
8720 '    GCOL
8730 '
8740 IF CFLAG%=0 THEN WAR%=16:GOTO 8140
8750 GOSUB 13950:GOSUB 12260 'get action
8760 IF OK%=0 THEN GALT%=XVAL%
8770 Z$="COLOR "
8780 GOSUB 14010:GOSUB 12260 'get colour
8790 IF OK%=1 THEN 8820
8800 IF XVAL%>127 THEN XVAL%=XVAL%-128:Z$=Z$+CHR$(44)
8810 GOSUB 15490
8820 Z$=Z$+X$:GOTO 5160
8830 '
8840 '    GET
8850 '
8860 IF MID$(CURRLINE$,ICP%+1,1)=CHR$(36) THEN X$=CHR$(36):ICP%=ICP%+2 ELSE X$=SP0$
8870 IF X$=SP0$ THEN Z$="ASC(" ELSE Z$=SP0$
8880 Z$=Z$+"INPUT$(1)"
8890 IF X$=SP0$ THEN Z$=Z$+CHR$(41)
8900 GOTO 5160
8910 '
8920 '    INKEY
8930 '
8940 IF VSTART%=0 THEN X%=LEN(OBUFF$)-FCOM% ELSE 8970
8950 VSTORE$=MID$(OBUFF$,FCOM%+1,X%)
8960 OBUFF$=LEFT$(OBUFF$,FCOM%):GOTO 8990
8970 VSTORE$=MID$(OBUFF$,VSTART%,VLEN%+1)
8980 OBUFF$=LEFT$(OBUFF$,VSTART%-1)
8990 SLINE!=LINENO!:RETURN
9000 GOSUB 8940
9010 SOBUFF$=OBUFF$
9020 IF ICP%+1>LL% OR MID$(CURRLINE$,ICP%+1,1)<>CHR$(36) THEN 9260
9030 GOSUB 9200
9040 IF INKS$=SP0$ THEN GOSUB 9500:LINENO!=SLINE!-2:INKS$=STR$(LINENO!):GOSUB 9140:OBUFF$=SOBUFF$
9050 ZY$=INKS$:GOSUB 9410
9060 IF VSTART%=0 THEN Z$=SP0$ ELSE Z$=CHR$(61)
9070 Z$=Z$+"GW.IN.X$":GOTO 5160
9080 Z$=XVAL$+SP1$:GOSUB 17590
9090 Z$="FOR GW."+XVAL$+"=0 TO GW.IN.D:":GOSUB 17590
9100 GOSUB 9130
9110 Z$="IF LEN(GW.IN.X$)<>0 THEN GW."+XVAL$+"=GW.IN.D"
9120 GOSUB 17590:RETURN
9130 Z$="GW.IN.X$=INKEY$:":GOSUB 17590:RETURN
9140 OBUFF$=SP0$
9150 XVAL$=INKS$:GOSUB 12340
9160 GOSUB 9080:GOSUB 3920:GOSUB 9170:GOSUB 3920:RETURN
9170 LINENO!=SLINE!-1:Z$=STR$(LINENO!):GOSUB 9490
9180 OBUFF$=Z$+" NEXT:RETURN"
9190 RETURN
9200 AE%=0:GOSUB 17020:IF OK%=1 THEN RETURN  'look for (
9210 ICP%=ICP%+1:GOSUB 16870 'step over (
9220 IF K%=45 THEN AE%=1:ICP%=ICP%+1 'check for -
9230 STYPE%=10:GOSUB 17030 'look for )
9240 GOSUB 17630:VAR$=X$
9250 GOSUB 17680:RETURN 'step over )
9260 IF VSTART%<>0 THEN VSTORE$=LEFT$(VSTORE$,LEN(VSTORE$)-1)
9270 GOSUB 9200:IF AE%=1 THEN WAR%=14:GOSUB 2410 ELSE 9320
9280 GOSUB 12260:IF OK%=1 THEN 9320 'check if numeric
9290 K$=STR$(KC%(XVAL%)) 'get sought character
9292 IF KC%(XVAL%)=0 THEN WAR%=19:GOSUB 2410
9300 IF INKT$=SP0$ THEN GOSUB 9500:LINENO!=SLINE!-3:INKT$=STR$(LINENO!):GOSUB 9450:OBUFF$=SOBUFF$
9310 Z$="GW.IN.D="+K$+COLON$:ZY$=INKT$:GOSUB 9420:GOTO 9340
9320 IF INKN$=SP0$ THEN GOSUB 9500:LINENO!=SLINE!-2:INKN$=STR$(LINENO!):GOSUB 9380:OBUFF$=SOBUFF$
9330 ZY$=INKN$:GOSUB 9410
9340 IF VSTART%=0 THEN Z$=SP0$ ELSE Z$=CHR$(61)
9350 Z$=Z$+"GW.IN.X":GOTO 5160
9360 OBUFF$=SP0$:GOSUB 12340
9370 Z$=XVAL$+" GW.IN.X=-1:":GOSUB 17590:RETURN
9380 XVAL$=INKN$:GOSUB 9360:GOSUB 9090
9390 Z$=":GW.IN.X=ASC(GW.IN.X$)":GOSUB 17590:GOSUB 3920
9400 GOSUB 9170:GOSUB 3920:RETURN
9410 Z$="GW.IN.D="+VAR$+COLON$
9420 GOSUB 17590
9430 Z$="GOSUB"+ZY$+COLON$+VSTORE$
9440 GOSUB 17590:LINENO!=SLINE!:RETURN
9450 XVAL$=INKT$:GOSUB 9360:GOSUB 9130
9460 Z$="IF LEN(GW.IN.X$)=0 THEN RETURN":GOSUB 9520
9470 LINENO!=SLINE!-2:Z$=STR$(LINENO!):GOSUB 9490:Z$=Z$+" IF ASC(GW.IN.X$)=GW.IN.D THEN GW.IN.X=GW.IN.D":GOSUB 9520
9480 LINENO!=SLINE!-1:Z$=STR$(LINENO!):GOSUB 9490:Z$=Z$+" RETURN":GOSUB 17590:GOSUB 3920:RETURN
9490 Z$=RIGHT$(Z$,LEN(Z$)-1):RETURN
9500 LINENO!=SLINE!-4:Z$=STR$(LINENO!):GOSUB 9490:Z$=Z$+" GOTO "+LINENO$:OBUFF$=SP0$
9510 GOSUB 9520:RETURN
9520 GOSUB 17590:GOSUB 3920:OBUFF$=SP0$:RETURN
9530 '
9540 '    INPUT
9550 '
9560 Z$="INPUT "      'set default 
9570 GOSUB 11830      'action command
9580 GOSUB 17590:GOSUB 16870 'look for non-space
9590 IF OK%=1 OR K%<>34 THEN 9640
9600 STYPE%=8:GOSUB 17030 'look for closing "
9610 GOSUB 16870:IF OK%=1 THEN RETURN 'look for non-space
9620 IF K%=44 THEN 9640 ELSE OBUFF$=OBUFF$+COMMA$
9630 RETURN
9640 IF K%=44 THEN MID$(CURRLINE$,ICP%,1)=CHR$(59)
9650 RETURN
9660 '
9670 '    INSTR
9680 '
9690 GOSUB 17020 'search for (
9700 IF OK%=1 THEN GOSUB 17570:RETURN
9710 GOSUB 4100   'look for , or )
9720 IF OK%=0 THEN GWNO%=0:GOSUB 4140
9730 Z1$=FNCSTR$
9740 IF OK%=1 THEN Z$="(1," ELSE Z$=CHR$(40):Z1$=COMMA$+Z1$
9750 GOSUB 17590
9760 IF OK%=0 THEN GOSUB 4100:GOSUB 17570
9770 Z$=Z1$:GOTO 5160
9780 '
9790 '    INT
9800 '
9810 GOSUB 16870   'look for non-space
9820 IF K%=40 THEN RETURN
9830 GOSUB 17580
9840 GOSUB 16870:GOSUB 17030 'look for space
9850 GOSUB 17570:Z$=CHR$(41):GOTO 5160
9860 '
9870 '    ASC/LEN
9880 '
9890 GOSUB 5780
9900 IF K%=40 THEN GOSUB 17580:GOSUB 4100:GOSUB 17590:GOTO 10000
9910 STYPE%=7:GOSUB 17030 'look for $
9930 IF OK%=0 THEN ICP%=ICP%+1
9940 GOTO 9850
9950 '
9960 '    LIST/DELETE
9970 '
9980 STYPE%=4:GOSUB 17030 'look for comma
9990 IF OK%=0 THEN MID$(CURRLINE$,ICP%,1)=CHR$(45)
10000 GOSUB 17570      'copy in
10010 RETURN
10020 '
10030 '    LOCAL
10040 '
10050 LOLIST$=SP0$     'initialise string
10060 GOSUB 10100      'get next variable
10070 IF OK%=1 THEN 8150  'exit at end
10080 LOLIST$=LOLIST$+STR$(LEN(X$))+X$+STR$(LEN(LINENO$))+LINENO$
10090 GOTO 10060
10100 GOSUB 16870:IF OK%=1 THEN RETURN 'look for non-space
10110 STYPE%=4:GOSUB 17030 'look for ,
10120 X$=FNCSTR$
10130 OK%=0:GOTO 13990
10140 '
10150 '    LOG
10160 '
10170 GOSUB 10200       'get argument
10180 GOSUB 17580:Z$=ARG$+")/LOG(10)"
10190 GOTO 5160
10200 GOSUB 17020 'look for (
10210 IF OK%=1 THEN ARG$=SP0$:GOTO 10240
10220 GOSUB 4100     'look for matched )
10230 ARG$=BREX$
10240 GOSUB 17680      'step over )
10250 RETURN
10260 '
10270 '    MOD
10280 '
10290 K$=MID$(CURRLINE$,ICP%+1,1)
10300 IF K$="E" THEN Z$=SP0$ ELSE Z$="MOD"
10310 GOSUB 17590
10320 IF K$<>"E" THEN RETURN ELSE ICP%=ICP%+2
10330 '
10340 '    MODE
10350 '
10360 STYPE%=1:GOSUB 17030 'search for numeric
10370 IF OK%=1 THEN 10410
10380 GOSUB 16880          'search for non-numeric
10390 MODE%=VAL(FNCSTR$)
10400 IF MODE%<8 THEN 10420
10410 MODE%=7              'set default mode
10420 ON MODE%+1 GOSUB 10460,10490,10520,10550,10580,10610,10580,10640
10430 XVAL$=STR$(SCRMODE%):GOSUB 12340
10440 Z$="SCREEN"+STR$(SCR%)+COMMA$+XVAL$:GOTO 5160
10450 '    Mode 0
10460 COLS%=2:SCRMODE%=0  '2 colours
10470 SCR%=2:RETURN       'graphics
10480 '    Mode 1
10490 COLS%=4:SCRMODE%=1  '4 colours
10500 GOTO 10470
10510 '    Mode 2
10520 COLS%=16:SCRMODE%=1 '16 colours
10530 GOTO 10470
10540 '    Mode 3
10550 COLS%=2:SCRMODE%=0  '2 colours
10560 SCR%=0:RETURN       'text only
10570 '    Mode 4/6
10580 COLS%=2:SCRMODE%=0  '2 colours
10590 GOTO 10470
10600 '    Mode 5
10610 COLS%=4:SCRMODE%=1  '4 colours
10620 GOTO 10470
10630 '    Mode 7
10640 COLS%=15:SCRMODE%=1 '15 colours
10650 GOTO 10560
10660 '
10670 '    MOVE
10680 '
10690 PLOT%=4:GOTO 11120 'j for PLOT 4
10700 '
10710 '    NOT
10720 '
10730 IF INVOP%<>0 AND BRKT%=0 THEN OBUFF$=LEFT$(OBUFF$,LEN(OBUFF$)-5):Z$=SP0$ ELSE Z$="NOT"
10740 STCP%=ICP%:GOTO 14760
10750 '
10760 '    OFF
10770 '
10780 RETURN
10790 '
10800 '    OPENIN/OPENOUT
10810 '
10820 CHANNO%=CHANNO%+1 'step file no.
10830 Z$=STR$(CHANNO%)+COLON$:GOSUB 17590
10840 STYPE%=8:GOSUB 17030 'look for "
10850 IF OK%=1 THEN RETURN
10860 ICP%=ICP%+1       'step over "
10870 GOSUB 17030       'look for closing "
10880 ZA$=FNCSTR$
10890 IF OK%=1 THEN 10920 ELSE ICP%=ICP%+1 'step over "
10900 GOSUB 16870:IF OK%=1 THEN 10920 'look for non-space
10910 GOSUB 17680    'step over )
10920 Z$="OPEN "+QUOTE$:GOSUB 17590
10930 IF BBCNO%=73 THEN X$="I" ELSE X$="O"
10940 Z$=X$+QUOTE$+COMMA$+MID$(OBUFF$,VSTART%,VLEN%)+COMMA$+QUOTE$+ZA$+QUOTE$:GOTO 5160
10950 '
10960 '    OR
10970 '
10980 IF INVOP%=0 OR BRKT%=1 THEN Z$="OR" ELSE Z$="AND NOT"
10990 GOTO 5160
11000 '
11010 '    PI
11020 '
11030 Z$="3.14159265":GOTO 5160
11040 '
11050 '    PLOT
11060 '
11070 STYPE%=1:GOSUB 17030 'look for numeric
11080 IF OK%=1 THEN RETURN
11090 GOSUB 16880          'look for non-numeric
11100 PLOT%=VAL(FNCSTR$)
11110 ICP%=ICP%+1
11120 OBUFF$=OBUFF$+SP1$
11130 Z$=QUOTE$:REL$=SP0$
11140 GOSUB 13950:XCOORD$=X$
11150 GOSUB 13950:YCOORD$=X$
11160 C$=SP0$
11170 ON (PLOT% MOD 8)+1 GOSUB 11200,11240,11260,11280,11300,11320,11520,11540
11180 RETURN
11190 '   Plot 0
11200 GOSUB 11210:GOTO 11300
11210 IF LEFT$(XCOORD$,1)=CHR$(45) THEN REL$=CHR$(45) ELSE REL$=CHR$(43)
11220 RETURN
11230 '    Plot 1
11240 GOSUB 11210:GOTO 11320
11250 '    Plot 2
11260 GOSUB 11210:GOTO 11320
11270 '    Plot 3
11280 GOSUB 11210:GOTO 11320
11290 '    Plot 4
11300 Z$=Z$+CHR$(66)
11310 '    Plot 5
11320 Z$=Z$+CHR$(77)+REL$
11330 GOSUB 17590:GOSUB 11450
11340 IF OK%=0 THEN Z$=QUOTE$
11350 GOTO 5160
11360 GOSUB 12260
11370 IF Y$=SCALEY$ AND REL$=SP0$ THEN XVAL%=1024-XVAL%:ZA$=YSIZE$+CHR$(45) ELSE ZA$=SP0$
11380 IF OK%=0 THEN XVAL$=STR$(INT(XVAL%*N!)):GOSUB 12340:Z$=XVAL$:GOTO 11440
11390 IF OK%=1 THEN Z$=QUOTE$+"+STR$("+ZA$+"INT("+Y$+CHR$(42)
11400 GOSUB 13880
11410 IF AE%=1 THEN Z$=Z$+CHR$(40)
11420 Z$=Z$+X$+"))"
11430 IF AE%=1 THEN Z$=Z$+CHR$(41)
11440 RETURN
11450 X$=XCOORD$:Y$=SCALEX$:N!=XSCALE!:GOSUB 11360
11460 GOSUB 17590:IF OK%=0 THEN Z$=COMMA$ ELSE Z$="+"+QUOTE$+COMMA$
11470 GOSUB 17590
11480 X$=YCOORD$:Y$=SCALEY$:N!=YSCALE!:GOSUB 11360
11490 GOSUB 17590:Z$=SP0$
11500 RETURN
11510 '    Plot 6
11520 GOTO 11320
11530 '    Plot 7
11540 GOTO 11320
11550 '
11560 '    POINT
11570 '
11580 GOSUB 17020:IF OK%=1 THEN RETURN 'look for (
11590 GOSUB 4100           'look for , or )
11600 X$=FNCSTR$:GOSUB 13880 'check for formula
11610 Z$=CHR$(40)+SCALEX$+CHR$(42):GOSUB 17590
11620 IF AE%=1 THEN Z$=CHR$(40) ELSE Z$=SP0$
11630 Z$=Z$+X$
11640 IF AE%=1 THEN Z$=Z$+CHR$(41)
11650 GOSUB 17590
11660 IF OK%=1 THEN RETURN
11670 GOSUB 4100:Z$=CHR$(44)+SCALEY$+CHR$(42):GOSUB 17590
11680 X$=FNCSTR$:GOSUB 13880 'check for formula
11690 IF AE%=1 THEN Z$=CHR$(40) ELSE Z$=SP0$
11700 Z$=Z$+X$
11710 IF AE%=1 THEN Z$=Z$+CHR$(41)
11720 GOSUB 17590:RETURN
11730 '
11740 '    POS
11750 '
11760 Z$="(1)":GOTO 5160
11770 '
11780 '    PRINT
11790 '
11800 Z$=LPRIN$+PRNT$     'set default command
11810 PRFLAG%=LEN(OBUFF$) 'set PRINT flag
11820 GOSUB 11830:GOTO 5160 'action command
11830 GWCOM$=Z$:PCOM$=Z$  'keep default command
11840 FLOC%=0             'clear 1st LOCATE flag
11850 GOSUB 16870:IF OK%=1 THEN 12080 'search for non-space
11860 IF ICP%+2>LL% THEN 12080
11870 IF MID$(CURRLINE$,ICP%,3)<>"TAB" THEN 12080
11880 '
11890 '    PRINT/INPUT TAB
11900 '
11910 IF FLOC%<>0 THEN GOSUB 17600
11920 OBUFF$=OBUFF$+"LOCATE "
11930 GOSUB 17020:IF OK%=1 THEN 12080  'search for (
11940 GOSUB 4100            'look for , or )
11950 SOK%=OK%:GOSUB 12130:GOSUB 12260
11960 GOSUB 12320:COL$=XVAL$ 'get column no.
11970 IF SOK%<>0 THEN 12090  'j if not ,
11980 GOSUB 4100:GOSUB 12250 'look for matched )
11990 GOSUB 12320:ROW$=XVAL$ 'get row no.
12000 IF OK%=0 AND XVAL%>24 THEN WAR%=17:GOSUB 2410
12010 IF GWCOM$=SP0$ THEN GWCOM$=PCOM$
12020 FLOC%=1                  'set LOCATE flag
12030 Z$=ROW$+COMMA$+COL$+COLON$+GWCOM$
12040 PRFLAG%=LEN(OBUFF$)+LEN(Z$)-LEN(GWCOM$)
12050 IF K%=32 THEN GOSUB 16870 'skip to non-space
12060 GOSUB 17680    'step over )
12070 IF FNKMID$=CHR$(59) THEN ICP%=ICP%+1 'step over ;
12080 RETURN
12090 Z$=GWCOM$+"TAB("+COL$+CHR$(41)
12100 PRFLAG%=LEN(OBUFF$)+LEN(Z$)
12110 IF FLOC%=0 THEN X%=7 ELSE X%=8
12120 OBUFF$=LEFT$(OBUFF$,LEN(OBUFF$)-X%):GOTO 12050
12130 IF GWNO%=0 THEN X$=FNCSTR$:RETURN ELSE X$=SP0$  'j if no command variables
12140 FOR N%=1 TO GWNO%*3 STEP 3
12150   ICP%=GWVAR%(N%) MOD 1000:STCP%=BSTCP%:X$=X$+FNCSTR$
12160   ON GWVAR%(N%)\1000+1 GOSUB 12220,12230,12240
12170   X$=X$+Y$
12180   STCP%=GWVAR%(N%) MOD 1000:ICP%=GWVAR%(N%+1):X$=X$+FNCSTR$
12190   BSTCP%=GWVAR%(N%+1)
12200 NEXT N%:RETURN
12220 Y$="GW.":RETURN
12230 Y$="GWL.":RETURN
12240 Y$="GW"+MID$(LOLIST$,GWVAR%(N%+2),LLINE%)+CHR$(46):RETURN
12250 X$=FNCSTR$
12260 GOSUB 17640:X%=1:OK%=0
12270 IF X%>LEN(X$) THEN XVAL%=VAL(X$):RETURN
12280 XC%=ASC(MID$(X$,X%,1))
12290 IF XC%=45 THEN 12310
12300 IF XC%<48 OR XC%>57 THEN 3400
12310 X%=X%+1:GOTO 12270
12320 IF OK%=1 THEN XVAL$=X$+"+1":RETURN
12330 XVAL$=STR$(XVAL%+1)
12340 XVAL$=RIGHT$(XVAL$,LEN(XVAL$)-1)
12350 RETURN
12360 '
12370 '    PROC
12380 '
12390 IF DPROCFLAG%=1 THEN 6850 'j if defining procedure
12400 GOSUB 7490            'get procedure name
12410 IF LASTPROC%=0 THEN 12470 'j if 1st entry
12420 GOSUB 7580            'search for name in PROC file
12430 PWFL$=STR$(CVS(PWFLINE$))
12440 IF OK%=0 AND CVS(PWFLINE$)<>0 THEN SUBL!=CVS(PWFLINE$):GOTO 12680
12450 IF OK%=0 THEN 12490   'j if is existing entry
12460 GOSUB 6900            'chain to last entry
12470 PLINE!=0:GOSUB 6990   'create new PROC file entry
12480 LASTPROC%=HIPROC%:REC%=HIPROC%
12490 X%=1
12500 IF CVI(PWFCONT$)<>0 THEN REC%=CVI(PWFCONT$):GET PWF%,REC%:GOTO 12500
12510 IF X%>72 THEN 12650   'j if no more entries
12520 Z$=MID$(PWFUSED$,X%,4)
12530 IF Z$=SPACE$(4) THEN 12550 'j if empty entry
12540 X%=X%+4:GOTO 12510
12550 Z$=PWFUSED$
12560 MID$(Z$,X%,4)=MKS$(LINENO!) 'put in line no.
12570 LSET PWFUSED$=Z$
12580 PUT PWF%,REC%
12590 YA$=GSUB$:Z$=SP0$
12600 GOSUB 16870:IF K%<>40 THEN 12850
12610 GOSUB 4100            'look for , or )
12620 Z$=Z$+CHR$(61)+FNCSTR$+COLON$
12630 IF K%=41 THEN 12840 'j if end of params
12640 GOTO 12610
12650 LSET PWFCONT$=MKI$(HIPROC%+1) 'point to new record
12660 PUT PWF%,REC%
12670 GOSUB 6990:GOTO 12490 'create new record
12680 GOSUB 12870
12690 FCT%=CVI(PWFPARP$)  'get param.block record
12700 IF FCT%=0 THEN 12850 'j if no params.expected
12710 GET PWF%,FCT% 'get param.block
12720 V$=PWFPARAM$
12730 X%=1
12740 XLEN%=VAL(MID$(V$,X%,2))
12750 IF XLEN%=0 THEN 12860 'j if no more params.
12760 Z$=Z$+"GW"+RIGHT$(PWFL$,LEN(PWFL$)-1)+CHR$(46)+MID$(V$,X%+2,XLEN%)+CHR$(61)
12770 IF X%<>1 THEN 12800    'j if not 1st time
12780 GOSUB 17020   'look for (
12790 IF OK%=1 THEN 12850
12800 GOSUB 4100             'look for , or )
12810 Z$=Z$+FNCSTR$+COLON$
12820 IF K%<>44 THEN 12840 'j if end
12830 X%=X%+2+XLEN%:GOTO 12740 'step to next entry
12840 ICP%=ICP%+1          'step over )
12850 Z$=Z$+YA$
12860 STCP%=ICP%:GOTO 5160
12870 Z$=SP0$:YA$="GOSUB"+STR$(SUBL!):RETURN
12880 '
12890 '    PTR
12900 '
12910 STYPE%=5:GOSUB 17030  'look for #
12920 IF OK%=0 THEN ICP%=ICP%+1 'step over it
12930 Z$="GW.PTR.":GOTO 5160
12940 '
12950 '    RAD
12960 '
12970 GOSUB 10200  'get argument
12980 Z$=ARG$+"*3.14159265/180":GOTO 5160
12990 '
13000 '    READ
13010 '
13020 STYPE%=2:GOSUB 17030 'search for alpha
13030 GOSUB 17570          'copy upto variable
13040 IF OK%=1 THEN RETURN
13050 GOSUB 16880          'search for non-alpha
13060 IF K%=36 OR K%=37 THEN GOSUB 3170 'check variable name
13070 GOSUB 17570          'copy variable
13080 IF K%=58 THEN RETURN
13090 GOSUB 16870 'search fo non-space
13100 GOSUB 17570
13110 IF K%=58 THEN RETURN ELSE 13020
13120 '
13130 '    REM
13140 '
13150 GOSUB 17540    'copy rest of line
13160 RETURN
13170 '
13180 '    RENUMBER
13190 '
13200 STYPE%=4:GOSUB 17030 'look for comma
13210 IF OK%=1 THEN RETURN
13220 GOSUB 17570          'copy upto ,
13230 Z$=COMMA$:GOTO 5160
13240 '
13250 '    REPEAT
13260 '
13270 REPPTR%=REPPTR%+1    'step array pointer
13280 REPLINE$(REPPTR%)=LINENO$ 'keep line no.
13290 IF COMCT%=0 THEN 8150 ELSE GOSUB 3910 'j if 1st command on line
13300 LINENO!=LINENO!+1:XVAL$=STR$(LINENO!):GOSUB 12340:LINENO$=XVAL$
13310 REPLINE$(REPPTR%)=LINENO$
13320 OBUFF$=LINENO$+SP1$
13330 GOTO 8150
13340 '
13350 '    REPORT
13360 '
13370 Z$=PRNT$+QUOTE$+"ERROR NO."+QUOTE$+";STR$(ERR);"+QUOTE$+" ON LINE "+QUOTE$+";STR$(ERL)"
13380 GOTO 5160
13390 '
13400 '    RND
13410 '
13420 GOSUB 17020:IF OK%=1 THEN Z$="RND":GOTO 13540 'search for (
13430 ICP%=ICP%+1          'step over (
13440 GOSUB 16870 'search for non-space
13450 IF K%=45 THEN RMZ%=1 ELSE RMZ%=0
13460 GOSUB 4110  'look for matched )
13470 IF RMZ%=0 THEN GOSUB 12250 ELSE GOSUB 17620:Z$=":RANDOMIZE ":GOTO 13510
13480 IF OK%=1 THEN 13500
13490 IF XVAL%=0 OR XVAL%=1 THEN Z$="RND(":RMZ%=2:GOTO 13510
13500 Z$="INT(RND*"
13510 Z$=Z$+BREX$:GOSUB 17590 'copy in factor
13520 GOSUB 17680    'step over )
13530 ON RMZ%+1 GOSUB 13550,13560,13570
13540 GOTO 5160
13550 Z$="+1)":RETURN
13560 Z$=SPO$:RETURN
13570 Z$=CHR$(41):RETURN
13580 '
13590 '    RUN
13600 '
13610 IF ER%=0 THEN Z$="RUN " ELSE Z$="GOTO 0"
13620 GOTO 5160
13630 '
13640 '    SOUND
13650 '
13660 GOSUB 13950:CHAN$=X$  'get channel no.
13670 GOSUB 13950:AMP$=X$   'get amplitude
13680 GOSUB 13950:PITCH$=X$ 'get pitch
13690 GOSUB 13880          'check for * - + /
13700 GOSUB 14010:DUR$=X$   'keep duration
13710 GOSUB 12260:IF OK%=0 AND XVAL%<0 THEN WAR%=6:GOSUB 2410
13720 Z$=SP1$+QUOTE$+"MB N":GOSUB 17590
13730 X$=PITCH$:GOSUB 12260:SOK%=OK% 'check if numeric
13740 IF OK%=0 THEN XVAL$=STR$(XVAL%\4+15):GOSUB 12340:Z$=XVAL$:GOTO 13800
13750 Z$=QUOTE$+"+STR$("
13760 IF AE%<>0 THEN Z$=Z$+CHR$(40)
13770 Z$=Z$+PITCH$
13780 IF AE%<>0 THEN Z$=Z$+CHR$(41)
13790 Z$=Z$+"\4+15)"
13800 GOSUB 17590
13810 X$=DUR$:GOSUB 12260 'check if numeric
13820 IF SOK%=1 AND OK%=0 THEN Z$="+"+QUOTE$:GOSUB 17590
13830 IF OK%=0 THEN XVAL$=STR$(INT(48/(XVAL%+.5))):GOSUB 12340:Z$=" L"+XVAL$+QUOTE$:GOTO 5160
13840 IF SOK%=0 THEN Z$=QUOTE$:GOSUB 17590
13850 Z$="+"+QUOTE$+" L"+QUOTE$+"+STR$(48\("
13860 Z$=Z$+DUR$+"+0.5))"
13870 GOTO 5160
13880 X%=1:AE%=0
13890 WHILE X%<=LEN(X$)
13900 K%=ASC(MID$(X$,X%,1))
13910 IF K%>96 THEN K%=K%-32
13920 IF CCAT%(K%-31)=12 THEN AE%=1
13930 X%=X%+1
13940 WEND:RETURN
13950 X$=SP0$:GOSUB 16870 'look for non-space
13960 IF OK%=1 THEN RETURN
13970 STYPE%=4:GOSUB 17030   'look for comma
13980 X$=FNCSTR$
13990 IF K%<>58 THEN ICP%=ICP%+1
14000 RETURN
14010 X$=SP0$:X%=0
14020 GOSUB 16870:Y%=ICP%:GOTO 14070   'look for non-space
14030 IF OK%=1 THEN 14080
14040 Z%=CCAT%(K%-31)
14050 IF K%=58 OR (Z%=2 AND X%=0) THEN 14080
14060 IF Z%=2 THEN X%=0 ELSE X%=1
14070 GOSUB 17030:GOSUB 16870:GOTO 14030 'look for space
14080 STCP%=Y%:X$=FNCSTR$:RETURN
14090 '
14100 '    SPC
14110 '
14120 GOSUB 17020  'look for (
14130 IF OK%=1 THEN RETURN
14140 STYPE%=10:GOSUB 17030 'look for )
14150 IF OK%=0 THEN ICP%=ICP%+1
14160 GOTO 10000
14170 '
14180 '    STR
14190 '
14200 IF MID$(CURRLINE$,ICP%+1,3)="ING" THEN Z$="STRING":Z%=1 ELSE Z$="STR":Z%=0
14210 GOSUB 17590
14220 IF Z%=0 THEN RETURN ELSE ICP%=ICP%+4
14230 '
14240 '    STRING
14250 '
14260 STYPE%=4:GOSUB 17030  'search for comma
14270 IF OK%=1 THEN GOSUB 17570:RETURN
14280 ICP%=ICP%+1:GOSUB 17570 'step over ,
14290 GOSUB 16870  'search for non-space
14300 IF OK%=1 THEN RETURN
14310 IF K$<>QUOTE$ THEN 14350
14320 ICP%=ICP%+1:GOSUB 17570 'step over "
14330 STYPE%=8:GOSUB 17030  'look for end "
14340 IF STCP%=ICP%-1 THEN 14360
14350 WARN%=5:GOSUB 2410
14360 IF K$=QUOTE$ THEN ICP%=ICP%+1
14370 GOTO 10000
14380 '
14390 '    TAB
14400 '
14410 Z$=SP0$:GWCOM$=SP0$
14420 GOSUB 16870  'look for non-space
14430 IF OK%=1 THEN 12080
14440 GOSUB 11910:GOTO 5160 'get column no.
14450 '
14460 '    TIME
14470 '
14480 GOSUB 16870  'look for non-space
14490 X$="((VAL(LEFT$(TIME$,2))*3600)+(VAL(MID$(TIME$,4,2))*60)+(VAL(RIGHT$(TIME$,2))))*100"
14500 IF OK%=1 THEN 14520
14510 IF K%=61 THEN Z$="GW.TIME="+X$+CHR$(43):ICP%=ICP%+1:GOTO 5160
14520 GOSUB 17580:Z$=X$+"-GW.TIME)":GOTO 5160
14530 '
14540 '    TO
14550 '
14560 IF K$<>CHR$(80) THEN RETURN
14570 ICP%=ICP%+1
14580 '
14590 '    TRACE
14600 '
14610 GOSUB 16870:IF OK%=1 THEN RETURN  'look for non-space
14620 IF MID$(CURRLINE$,ICP%,2)="ON" THEN Z$="TRON"
14630 IF MID$(CURRLINE$,ICP%,3)="OFF" THEN Z$="TROFF"
14640 STYPE%=CH%:GOSUB 16880 'look for end of statement
14650 GOTO 5160
14660 '
14670 '    TRUE
14680 '
14690 Z$="NOT FALSE":GOTO 5160
14700 GOTO 5160
14710 '
14720 '    UNTIL
14730 '
14740 SUFFIX%=OK%:INVOP%=1 'set invert operator flag
14750 Z$=" NOT"
14760 GOSUB 17590
14770 GOSUB 16870:IF OK%=1 THEN RETURN 'look for non-space
14780 IF K%=40 THEN BRKT%=1 ELSE ICP%=ICP%-1
14790 GOSUB 17570
14800 RETURN
14810 Z$=" THEN "+REPLINE$(REPPTR%) 'add j to top of loop
14820 REPLINE$=SP0$:INVOP%=0 'clear invert operator flag
14830 REPPTR%=REPPTR%-1     'amend array pointer
14840 SUFFIX%=0:GOTO 5160
14850 '
14860 '    VDU
14870 '
14880 STYPE%=1:GOSUB 17030 'look for numeric
14890 IF OK%=1 THEN 8150
14900 GOSUB 16880          'look for non-numeric
14910 X%=VAL(FNCSTR$)
14920 IF X%<32 THEN 14940  'j if special action
14930 Z$=PRNT$+"CHR$("+STR$(X%)+");":GOTO 5160
14940 IF K%=44 THEN ICP%=ICP%+1 'step over ,
14950 ON X%+1 GOTO 14970,14990,15010,15040,14970,14970,14970,15070,15090,15120,15140,15160,15180,15200,14970,15220,15240,15260,15290,15310,15520,14970,15540,15560,15580,15670,15690,14970,15710,15820,15850,15870
14960 '    VDU 0/4/5/6/14/21/27/29
14970 WAR%=18:GOTO 8140
14980 '    VDU 1
14990 Z$="L"+PRNT$:GOTO 5160
15000 '    VDU 2
15010 LPRIN$="L"    'enable printer
15020 GOTO 8150
15030 '    VDU 3
15040 LPRIN$=SP0$    'disable printer
15050 GOTO 8150
15060 '    VDU 7
15070 Z$="BEEP":GOTO 5160
15080 '    VDU 8
15090 ZA$="4"
15100 Z$=PRNT$+"CHR$(27);CHR$(4"+ZA$+");":GOTO 5160
15110 '    VDU 9
15120 ZA$="3":GOTO 15100
15130 '    VDU 10
15140 ZA$="2":GOTO 15100
15150 '    VDU 11
15160 ZA$="1":GOTO 15100
15170 '    VDU 12
15180 Z$="CLS":GOTO 5160
15190 '    VDU 13
15200 GOTO 15090
15210 '    VDU 15
15220 GOTO 8150
15230 '    VDU 16
15240 GOTO 15180
15250 '    VDU 17
15260 STYPE%=1:GOSUB 17030 'look for colour no.
15270 IF OK%=1 THEN RETURN ELSE 5470
15280 '    VDU 18
15290 GOTO 8740
15300 '    VDU 19
15310 GOSUB 13950 'get logical colour
15320 IF OK%=1 THEN 15410
15330 GOSUB 12260:IF OK%=1 THEN LC$=X$:GOTO 15350
15340 GOSUB 15490:LC$=X$
15350 GOSUB 13950        'get actual colour
15360 IF OK%=1 THEN 15410
15370 GOSUB 12260:IF OK%=1 THEN 15400
15380 COL%=XVAL%:GOSUB 15470:GOSUB 15510
15390 STYPE%=11:GOSUB 17030 'look for :
15400 Z$="PALETTE "+LC$+COMMA$+X$:GOTO 5160
15410 WAR%=4:GOTO 2400
15420 IF COL%=0 THEN RETURN
15430 ON CFLAG% GOSUB 5600,5610,5610,5620
15440 RETURN
15450 COL%=COL%+1:ON CFLAG% GOSUB 5660,5670,5670,5680
15460 RETURN
15470 COL%=COL%+1:ON CFLAG% GOSUB 5720,5730,5730,5740
15480 RETURN
15490 COL%=XVAL%
15500 ON MODE%+1 GOSUB 15420,15450,15470,15420,15420,15450,15420,15470
15510 X$=STR$(COL%):GOSUB 17660:RETURN
15520 GOTO 14970
15530 '    VDU 22
15540 GOTO 10360
15550 '    VDU 23
15560 WAR%=9:GOTO 8140
15570 '    VDU 24
15580 SWREC%=0:GOSUB 15730    'get coordinates
15590 Z$="VIEW SCREEN (":GOSUB 17590
15600 XCOORD$=LX$:YCOORD$=TY$:GOSUB 11450
15610 IF OK%=1 THEN Z$=Z$+"+"+QUOTE$
15620 Z$=Z$+")-(":GOSUB 17590
15630 XCOORD$=RX$:YCOORD$=BY$:GOSUB 11450
15640 GOSUB 17590:IF OK%=1 THEN Z$="+"+QUOTE$+CHR$(41)+QUOTE$ ELSE Z$=CHR$(41)
15650 GOTO 5160
15660 '    VDU 25
15670 Z$="DRAW ":GOSUB 17590 :GOTO 11070
15680 '    VDU 26
15690 Z$="VIEW:VIEW "+PRNT$+COLON$:GOSUB 17590:GOTO 15850
15700 '    VDU 28
15710 SWREC%=1:GOSUB 15730    'get coordinates
15720 Z$="VIEW "+PRNT$+TY$+" TO "+BY$:GOTO 5160
15730 GOSUB 15780:LX$=XVAL$ 'get left edge
15740 GOSUB 15780:BY$=XVAL$ 'get bottom
15750 GOSUB 15780:RX$=XVAL$ 'get right edge
15760 GOSUB 15780:TY$=XVAL$ 'get top
15770 RETURN
15780 GOSUB 13950:GOSUB 12260
15790 IF SWREC%=1 THEN GOSUB 12320 ELSE XVAL$=X$ 'add 1 to value
15800 RETURN
15810 '    VDU 29
15820 GOSUB 15750
15830 GOTO 14970
15840 '    VDU 30
15850 Z$="LOCATE 1,1":GOTO 5160
15860 '    VDU 31
15870 SWREC%=1:GOSUB 15780:COL$=XVAL$ 'get column no.
15880 GOSUB 15780:ROW$=XVAL$ 'get line no.
15890 Z$="LOCATE "+ROW$+CHR$(44)+COL$:GOSUB 17590
15900 IF K$=COMMA$ THEN GOSUB 13950:Z$=COLON$+PRNT$+"CHR$("+X$+");":GOSUB 17590:GOTO 15900
15910 RETURN
15920 '
15930 '    WIDTH
15940 '
15950 STYPE%=1:GOSUB 17030 'search for numeric
15960 IF OK%=1 THEN RETURN
15970 GOSUB 17570          'copy upto numeric
15980 GOSUB 16880          'search for non-numeric
15990 GOSUB 12250:IF OK%=0 AND XVAL%=0 THEN X$="80"
16000 Z$=X$+":WIDTH L"+PRNT$+X$:GOTO 5160
16010 '
16020 '    SEND ERROR MESSAGE
16030 '    ------------------
16040 MC$=" - PRESS ANY KEY TO TRY AGAIN"
16050 PRINT FNCUR$(22,10);INVVID$;MESS$;MC$;RCLEAR$
16060 PRINT CHR$(7);:GOSUB 2300 'bleep
16080 PRINT FNCUR$(22,10);NORVID$;SPACE$(70)
16090 RETURN
16100 PRINT ESC$+CHR$(106) 'save cursor
16110 PRINT ESC$+CHR$(120)+CHR$(49); 'enable line 25
16120 RETURN
16130 PRINT ESC$+CHR$(107) 'return cursor
16140 PRINT ESC$+CHR$(121)+CHR$(49); 'disable line 25
16150 RETURN
16160 '
16170 '    GET BBC COMMAND
16180 '    ---------------
16190 COMMAND$=SPACE$(8)   'clear command field
16200 GOSUB 16870          'search for non-space
16210 GOSUB 17570          'copy spaces
16220 IF FIRST%<>0 THEN 16260
16230 IF K%=91 THEN 16560 'j if [
16240 IF K%=42 THEN 17730 'action * command
16250 IF K%=61 THEN 16390 'j if =
16260 IF K%=63 THEN 16440 'j if ?
16262 IF K%=64 THEN WAR%=20:GOTO 8140 'j if @
16270 IF K%=33 THEN WAR%=12:GOTO 8140 'j if ! or $
16280 FIRST%=ICP%
16290 STYPE%=2:GOSUB 17030 'look for alpha
16300 IF OK%=1 THEN RETURN
16310 GOSUB 17570       'copy in precede chars.
16320 IF K%=63 THEN 16440 'j if ?
16330 GOSUB 16340:RETURN 
16340 GOSUB 16880          'search for non-alpha
16350 X%=ICP%-STCP%        'get string length
16360 IF X%>8 THEN X%=8    'limit for command comparison
16370 MID$(COMMAND$,1,X%)=MID$(CURRLINE$,STCP%,X%)
16380 OK%=0:RETURN
16390 GOSUB 6200:Z$=":RETURN":GOSUB 17590
16400 DPROCFLAG%=0:STCP%=ICP%:GOTO 3400
16410 '
16420 '    INDIRECTION OPERATORS
16430 '    ---------------------
16440 IF FIRST%=0 THEN Z$="POKE " ELSE Z$="PEEK("
16450 GOSUB 17590:ICP%=ICP%+1:WAR%=13:GOSUB 2410
16460 IF FIRST%<>0 THEN 16500 'j if PEEK
16470 STYPE%=13:GOSUB 17030 'look for =
16480 GOSUB 17570:Z$=CHR$(44):GOSUB 17590 'output value
16490 ICP%=ICP%+1:GOTO 16290
16500 STYPE%=3:GOSUB 17030 'get value
16510 GOSUB 17570:Z$=CHR$(41):GOSUB 17590 'output value
16520 GOTO 16290
16530 '
16540 '    ASSEMBLER CODE
16550 '    --------------
16560 WAR%=11:GOSUB 2410 'report untranslatable
16570 OBUFF$=OBUFF$+"REM$":ACODE%=1
16580 LL%=0:GOTO 3400
16590 '
16600 '    CHECK COMMAND EXISTS
16610 '    --------------------
16620 IF COMMAND$=SPACE$(8) THEN 3400 'j if command not found
16630 CH%=STCH%-33           'get alpha as offset from 1
16640 ON CH% GOSUB 500,510,520,530,540,550,560,570,580,590,600,610,620,630,640,650,660,670,680,690,700,710,720,730,740,750
16650 SL%=LEN(X$)            'get table string length
16660 IF SL%=0 THEN 16830    'j if no commands
16670 BBCNO%=BBCABC%(CH%)    'get command no.
16680 SP%=1                  'initialise pointer
16690 N%=2
16700 NK$=MID$(COMMAND$,N%,1) 'get next command letter
16710 NBBCK$=MID$(X$,SP%+N%-1,1) 'get next BBC letter
16720 IF NBBCK$=SP1$ THEN 16790 'exit if end of command
16730 IF NBBCK$>NK$ THEN 16830 'j if not found
16740 IF NBBCK$=NK$ THEN 16770 'j if match so far
16750 SP%=SP%+8              'step to next BBC command
16760 IF SP%>SL% THEN 16830 ELSE 16690
16770 N%=N%+1                'step pointer
16780 IF N%<9 THEN 16700
16790 BBCNO%=BBCNO%+(SP%-1)/8 'calculate command no.
16800 OK%=0
16810 ICP%=STCP%+N%-1        'reset input pointer
16820 RETURN
16830 BBCNO%=0:GOTO 3400
16840 '
16850 '    SEARCH FOR CHARACTER CATEGORY
16860 '    -----------------------------
16870 STYPE%=3        'look for non-space
16880 STCP%=ICP%:STCH%=CH% 'keep start pointer and type
16890 GOTO 16910
16900 ICP%=ICP%+1     'step to next character
16910 IF ICP%>LL% THEN 3400 'j if end
16920 K$=FNKMID$      'get next character
16930 K%=ASC(K$)
16940 IF K%=95 THEN K%=46:K$=CHR$(46)
16950 IF K%>96 THEN K%=K%-32 'get category
16960 IF CCAT%(K%-31)=STYPE% THEN 16900
16970 IF STYPE%=99 THEN 17010 'j if variable search
16980 OK%=0
16990 CH%=K%-31
17000 RETURN
17010 IF CCAT%(K%-31)=1 OR CCAT%(K%-31)=2 OR K%=46 THEN 16900 ELSE 16980
17020 STYPE%=6          'look for (
17030 STCP%=ICP%:STCH%=CH%   'keep start pointer & category
17040 QUOTE%=0:GOTO 17060
17050 ICP%=ICP%+1
17060 IF ICP%>LL% THEN 3400  'j if not found
17070 K$=FNKMID$      'get next character
17080 K%=ASC(K$)
17090 IF K%=34 THEN 17170    'j if "
17100 IF K%=39 THEN 17230    'j if '
17110 IF K%=58 AND QUOTE%=0 THEN OK%=1:GOTO 3020 'j if :
17120 IF K%=63  AND QUOTE%=0 THEN 16980 'j if ?
17130 IF K%=95 THEN K$=CHR$(46):K%=46:MID$(CURRLINE$,ICP%,1)=K$ 'action _
17140 IF K%>96 THEN K%=K%-32 'get category array offset
17150 IF CCAT%(K%-31)<>STYPE% THEN 17050 'j if not found
17160 GOTO 16980
17170 IF BBCNO%=73 OR BBCNO%=74 OR BBCNO%=104 THEN 16980 'j if OPEN
17180 IF QUOTE%=0 THEN QUOTE%=STYPE%:STYPE%=8:GOTO 17050
17190 STYPE%=QUOTE%:QUOTE%=0
17200 ICP%=ICP%+1            'step over "
17210 GOSUB 17570            'copy string
17220 IF STYPE%=8 THEN 16980 ELSE 17030
17230 IF PRFLAG%=0 OR STYPE%=8 THEN 17140
17240 GOSUB 17570:GOSUB 17600
17250 GOSUB 17610
17260 ICP%=ICP%+1:GOTO 17030
17270 '
17280 '    GET GW COMMAND
17290 '    --------------
17300 SPEC%=CONVA%(BBCNO%)  'get command specification
17310 GWNO%=(SPEC%\100) MOD 200 'get GW command no.
17320 OK%=SPEC% MOD 100     'get special requirements flag
17330 KR$=RIGHT$(OBUFF$,1)
17340 IF KR$<>SP1$ AND KR$<>COLON$ THEN Z$=SP1$:GOSUB 17590
17350 IF GWNO%=0 THEN 17480 'j if no GW command
17360 N%=1
17370 IF GWABC%(N%)>GWNO% THEN 17390 'j if entry passed
17380 N%=N%+1:GOTO 17370
17390 N%=N%-1               'get command start letter as offset
17400 ON N% GOSUB 760,770,780,790,800,810,820,830,840,850,860,870,880,890,900,910,920,930,940,950,960,970,980,990,1000,1010
17410 X%=GWABC%(N%)         'get 1st command no.in string
17420 GWCOM$=MID$(Y$,(GWNO%-X%)*7+1,7) 'get command
17430 X$=GWCOM$:GOSUB 17640:GWCOM$=X$
17440 OBUFF$=OBUFF$+GWCOM$
17450 OCP%=OCP%+LEN(GWCOM$) 'step output pointer
17460 IF GWNO%=69 OR GWNO%=70 THEN RETURN
17470 IF GWNO%=84 OR GWNO%=122 THEN RETURN
17480 IF ICP%>LL% THEN RETURN
17490 IF FNKMID$<>SP1$ THEN ICP%=ICP%-1:MID$(CURRLINE$,ICP%,1)=SP1$
17500 RETURN
17510 '
17520 '    COPY TO OUTPUT BUFFER
17530 '    ---------------------
17540 IF ICP%>LL% THEN RETURN 'j if at end
17550 Z$=MID$(CURRLINE$,ICP%,LL%+1-ICP%)
17560 GOSUB 17590:RETURN
17570 OBUFF$=OBUFF$+FNCSTR$:RETURN
17580 Z$=CHR$(40)
17590 OBUFF$=OBUFF$+Z$:Z$=SP0$:RETURN
17600 OBUFF$=OBUFF$+COLON$:RETURN
17610 OBUFF$=OBUFF$+LPRIN$+PRNT$:RETURN
17620 OBUFF$=OBUFF$+BREX$:RETURN
17630 X$=FNCSTR$
17640 WHILE RIGHT$(X$,1)=SP1$:X$=LEFT$(X$,LEN(X$)-1):WEND
17650 RETURN
17660 WHILE LEFT$(X$,1)=SP1$:X$=RIGHT$(X$,LEN(X$)-1):WEND
17670 RETURN
17680 IF K%=41 THEN ICP%=ICP%+1 'step over )
17690 RETURN
17700 '
17710 '    ANALYSE * COMMANDS
17720 '    ------------------
17730 STYPE%=2:GOSUB 17030 'look for alpha
17740 IF OK%=1 THEN RETURN
17750 STAR$=MID$(CURRLINE$,ICP%,2) 'get command letters
17760 IF STAR$="FX" THEN 17820
17770 IF STAR$="TV" THEN 17860
17780 GOTO 8150            'ignore the rest
17790 '
17800 '   *FX
17810 '   ---
17820 WAR%=7:GOTO 8140
17830 '
17840 '   *TV
17850 '   ---
17860 WAR%=8:GOTO 8140

17790 '
1780