SCREEN	SEGMENT	AT 0F000H
  ;
SCREEN	ENDS
  ;
  ; Stack segment follows...
  ;
STACK	SEGMENT	STACK
  ;
  ; Allocate 200 words for stack space
  ;
	DW	200 DUP (?)
STACK_TOP	LABEL	WORD
  ;
STACK	ENDS
  ;
  ; Code segment follows...
  ;
CODE	SEGMENT	PUBLIC
  ;
	EXTRN	TEXT:NEAR
	PUBLIC	BPOLE
	ASSUME	CS:CODE,SS:STACK,ES:SCREEN
  ;
  ; BPOLE tests the memory of the test segment
  ; using the 'Barber Pole' algorithm.The values
  ; from the table BPTAB are written and read
  ; from each pair of bytes and checked for any change.
  ;
BPOLE	PROC
  ; Push registers onto stack
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
  ; Begin main code for this procedure
	LEA	SI,CS:BPTAB	; Point SI to top of table
	MOV	AX,CS:[SI]	; Set AX to first value
	MOV	CX,7FFFH
	MOV	DI,0
BPLE01:	MOV	DS:[DI],AX	; Write first value to all bytes
	ADD	DI,2
	LOOP	BPLE01		; Repeat until CX = 0 ( whole segment )
	ADD	SI,2
BPLE02:	MOV	AX,CS:[SI]
	MOV	CX,7FFFH
	MOV	DI,0
BPLE03:	MOV	BX,DS:[DI]	; Read current value
	CMP	BX,CS:[SI-2]	; Check for addressing error
	JE	BPLE04
	MOV	DX,CS:[SI-2]	; Last test value used
	MOV	DS:[DI],DX	; Write to current address
	MOV	DX,DS:[DI]	; Read from current address
	CMP	DX,CS:[SI-2]	; Check error not caused by incorrect data
	JNE	BPLE04
	MOV	AX,26		; Length of following text
	PUSH	AX
	CALL	TEXT		; Display message
	DB	'Addressing error occurred '
	CALL	DISCD
BPLE04:	MOV	DS:[DI],AX	; Write new value to current byte
	MOV	BX,DS:[DI]	; Read back from current byte
	CMP	AX,BX		; Check for data error
	JE	BPLE05
	MOV	AX,20		; Length of following text
	PUSH	AX
	CALL	TEXT		; Display message
	DB	'Data error occurred '
	CALL	DISCD
BPLE05:	ADD	DI,2		; Increment for next byte
	LOOP	BPLE03		; Repeat for whole segment 
	ADD	SI,2
	CMP	WORD PTR CS:[SI],0FFFFH
	JNE	BPLE02		; Repeat until table value is FFFF
  ; Restore registers from stack and return
	POP	SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	RET
  ;
BPOLE	ENDP
BPTAB	DW	00001H
	DW	00002H
	DW	00004H
	DW	00008H
	DW	00010H
	DW	00020H
	DW	00040H
	DW	00080H
	DW	00100H
	DW	00200H
	DW	00400H
	DW	00800H
	DW	01000H
	DW	02000H
	DW	04000H
	DW	08000H
	DW	0FFFEH
	DW	0FFFDH
	DW	0FFFBH
	DW	0FFF7H
	DW	0FFEFH
	DW	0FFDFH
	DW	0FFBFH
	DW	0FF7FH
	DW	0FEFFH
	DW	0FDFFH
	DW	0FBFFH
	DW	0F7FFH
	DW	0EFFFH
	DW	0DFFFH
	DW	0BFFFH
	DW	07FFFH
	DW	0FFFFH
  ;
  ; DISCD indicates which of the two DRAM cards 
  ; has failed the test in BPOLE.
  ;
DISCD	PROC
  ;
  ; Begin main code for this procedure
	MOV	AX,DS
	CMP	AX,8000H	; Check which card is being tested
	JAE	DSCD01
	MOV	AX,16		; Length of text to display
	PUSH	AX
	CALL	TEXT		; Display message
	DB	'in lower 256K.',0AH,0DH
	MOV	AH,4CH
	INT	21H		; Terminate program
DSCD01:	MOV	AX,16		; Length of text to display
	PUSH	AX
	CALL	TEXT		; Display message
	DB	'in upper 256K.',0AH,0DH
	MOV	AH,4CH
	INT	21H		; Terminate program
  ; No need to restore registers and return as program terminates here
  ;
DISCD	ENDP
  ;
CODE	ENDS
	END
