10	' ==============================


	MBASIC LIBRARIAN UTILITY


	AUTHOR	D.COOPER


20	' =============================


	VERSION	1

	EDIT	7

	DATE	30-NOV-1981


40	DEFINT A-Z


50	' =============================


	LIBRARY FORMAT ASSUMED


	===============================


60	' 	a LIBRARY consists of a sequence of MODULES each of which

	occupies a statement range of 1000, the first MODULE starts at 20000

	the last one starts at 31000.


70	'	a MODULE starts with a JUMP TABLE and is followed by a series

	of subroutines. Each subroutine must start with a

	comment statement :	'ENTRY		& must end with a

	comment statement :	'END


80	'	a JUMP TABLE must also end with		'END

	The subroutines in the library modules may call one another

	in any manner. There may be multiple entrypoints to a routine

	each with a	'ENTRY		and an equal no. of	'END

	at the end.


100	' ============================


	DATA STRUCTURES


190	MAXROUTINES=200

	' NUMBER OF ROUTINES ALLOWED IN LIBRARY


200	DIM RNUM(200)

	' TABLE OF LIBRARY ROUTINE NOS REFERENCED IN THE PROGRAM


220	DIM RLS(200),RFS(200)

	' ROUTINE LAST STMT, ROUTINE FIRST STMT


230	DIM EXTERNAL(200)

	' ENTRY POINT IN JUMP TABLE TO LIBRARY ROUTINE


240	DIM REF(200,30),REFMAX(200)

	' TABLE OF X-REFS BETWEEN LIBRARY ROUTINES (BY ROUTINE NUMBER).

	REFMAX(I) IS NO OF NON ZERO ENTRIES IN REF(I,-).


260	DIM JTS(13),JTE(13)

	' TABLES OF STMT NOS OF START & END RESP OF JUMP TABLES


280	DIM RUSED(200)

	' TABLE OF ROUTINE NOS WHICH MUST BE INCLUDED INTO OUTPUT LIBRARY.


800	DEF FNLINEN(L$)=VAL(LEFT$(L$,5))

	' LINE NO OF A STMT


810	DEF FNENDM(L$)=(INSTR(L$,"'END")<>0)

	' TRUE IF STMT CONTAINS		'END


820	DEF FNENTRYM(L$)=(INSTR(L$,"'ENTRY")<>0)

	' TRUE IF STMT CONTAINS		'ENTRY


895	' ===========================


	LIBRARY FUNCTIONS


950	DEF FNMAX%(X%,Y%)=(X% AND X%>Y%) OR (Y% AND X%<=Y%)

	' RETURNS LARGEST OF X% AND Y%


960	DEF FNMIN%(X%,Y%)=(X% AND X%<Y%) OR (Y% AND X%>=Y%)

	' RETURNS SMALLEST OF X% & Y%


970	DEF FNLN%(X%,Y%)=X% OR ((X%=0) AND Y%)

	' RESULT IS Y% IF X%=0 OTHERWISE IS X%


990	' ===========================


	END OF LIBRARY FUNCTIONS


1000	COM$=CHR$(9)+CHR$(39)+CHR$(32)

	' TAB,APOSTROPHE,SPACE


1010	COM1$=CHR$(9)+CHR$(39)+"E"

	' TAB, APOSTROPHE, E


1020	COM2$=":REM "

	:COM3$="REM "


1190	' ============================


	CONTROLING PARAMETERS


1200	STARTLIB=20000

	' START OF LIBRARY


1390	' =============================


	EXECUTIVE ROUTINE


1400	PRINT "ACT(UK) Ltd Technical Support"

	:PRINT "Microsoft Basic Librarian Utility    Version 1.07"

	:PRINT


1405	P$="Program file"

	:MODE$="1I1\BAS"

	:GOSUB 28070

	:PROG$=F$

	:IF E% THEN 1480

	' INPUT PROGRAM FILE TITLE


1410	P$="Library Input file"

	:MODE$="1I2\BAS"

	:GOSUB 28070

	:LIBRARY$=F$

	:IF E% THEN 1480

	' INPUT LIBRARY FILE TITLE


1420	P$="Library Output file"

	:MODE$="3O3\LIB"

	:GOSUB 28070

	:OUTLIB$=F$

	:IF E% THEN 1480

	' OUTPUT LIBRARY FILE TITLE


1422	P$="Include Functions & Arrays (Y/N)"

	:GOSUB 27020

	:IF F$="Y" OR F$="y" THEN ARRAYS=1 ELSE

	IF F$="N" OR F$="n" THEN ARRAYS=0 ELSE

	E$="must be Y or N"

	:GOSUB 27080

	:GOTO 1422


1425	GOSUB 3000

	:IF E%=0 THEN 1450

	' READ LIBRARY ANALYSIS FILE


1430	PRINT

	:PRINT "Library Pass 1"

	:GOSUB 1700

	:CLOSE #2


1440	PRINT "Library Pass 2"

	:OPEN "I",#2,LIBRARY$

	:GOSUB 1800

	:CLOSE #2

	:OPEN "I",#2,LIBRARY$

	:PRINT "Cross referencing"

	:GOSUB 2000

	' PASS2 THEN X-REF


1445	PRINT "Writing Library analysis"

	:GOSUB 3100

	' WRITE LIBRARY ANALYSIS FILE


1450	PRINT "Scanning Program"

	:GOSUB 1500

	:CLOSE #1


1460	PRINT

	:PRINT "Creating Output Library : ";OUTLIB$

	:GOSUB 2200

	:CLOSE


1470	PRINT "Librarian finished"


1480	END


1490	' ==============================


	READ THRO PROGRAM PICKING OUT CALLS

	TO LIBRARY FUNCTIONS.STORE IN ENTRY()


1500	LASTRNUM=0


1530	LINE INPUT #1,L$

	:P=1

	' GET PROGRAM STMT


1535	IF FNLINEN(L$)>20000 THEN RETURN

	' Start of library


1540	GOSUB 10000

	:IF REF<STARTLIB THEN 1610

	' GET STMT REF, JUMP UNLESS LIBRARY ENTRY


1550	GOSUB 8000

	:FOR I=1 TO LASTRNUM

	:IF REFN>=RNUM(I) THEN 1570

	' LOOK FOR REFERENCE


1560	NEXT


1570	IF REFN=RNUM(I) THEN 1600

	' JUMP IF FOUND


1580	LASTRNUM=LASTRNUM+1

	:FOR J=LASTRNUM TO I+1 STEP -1

	:RNUM(J)=RNUM(J-1)

	:NEXT

	:RNUM(I)=REFN

	' ADD REF TO TABLE


1600	IF REFN=0 THEN

	PRINT "Library Entry Point : ";REF;" in statement : ";FNLINEN(L$);

	" not found"


1610	IF REF<>0 THEN 1540

	' EXTRACT NEXT STMT REF


1620	IF EOF(1)=0 THEN 1530 ELSE RETURN


1690	' ==============================


	FIRST PASS THRO LIBRARY PICKING OUT

	'END  STMTS


1700	NEXTLIB=0

	:LASTRFS=0

	:LASTRLS=0

	:WHILE NOT EOF(2)

	:LINE INPUT #2,L$

	:P=1

	:L=FNLINEN(L$)

	' GET LIBRARY STMT


1710	IF L<NEXTLIB THEN 1740

	' NOT NEW LIBRARY SECTION


1715	IF L<STARTLIB THEN 1760

	' IGNORE BEFORE LIBRARY START


1720	WHILE NOT FNENDM(L$)

	:LINE INPUT #2,L$

	:WEND

	:L1=FNLINEN(L$)

	' END OF JUMP TABLE


1730	K=(L+1000-STARTLIB)\1000

	:JTS(K)=L

	:JTE(K)=L1

	:NEXTLIB=STARTLIB+K*1000

	:GOTO 1760

	' SET UP START & END OF JUMP TABLE


1740	IF FNENDM(L$) THEN LASTRLS=LASTRLS+1

		:RLS(LASTRLS)=L

	' END OF LIBRARY ROUTINE


1745	IF LASTRFS>=MAXROUTINES THEN

	PRINT "Too many routines in Library"

	:END


1750	IF FNENTRYM(L$) THEN LASTRFS=LASTRFS+1

		:RFS(LASTRFS)=L

	' START OF LIBRARY ROUTINE


1760	WEND


1770	IF LASTRFS<>LASTRLS THEN

	PRINT "Error in ";LIBRARY$;" there are";LASTRFS;" 'ENTRY  markers";

		" but";LASTRLS;" 'END  markers"

	:END


1775	RETURN


1790	' ===========================


	PASS 2 THRO LIBRARY PICKING OUT

	X-REFS


1800	NEXTLIB=0

	:RFP=0

	:RLP=0


1810	LINE INPUT #2,L$

	:P=1

	:L=FNLINEN(L$)

	' READ LIBRARY STMT


1820	IF L>=NEXTLIB THEN 1870

	' JUMP IF NEW LIBRARY SECTION


1830	IF L>=RLS(RLP) THEN RLP=RLP+1

	' SMALLEST CURRENT ROUTINE NO. IN RLP


1835	IF L>=RFS(RFP+1) THEN RFP=FNMIN(RFP+1,LASTRLS)

	' BIGGEST CURRENT ROUTINE NO IN RFP

 
1840	GOSUB 10000

	:IF REF=0 THEN 1890

	' EXTRACT X-REF


1843	FOR RP=RLP TO RFP

	:J=REFMAX(RP)

	:FOR K=1 TO J

	:IF REF(RP,K)=REF THEN 1860

	' LOOK FOR REF IN TABLE


1850	NEXT

	:J=J+1

	:REF(RP,J)=REF

	:REFMAX(RP)=J

	:NEXT

	' ADD X-REF TO TABLE IF NOT THERE


1860	GOTO 1840


1870	IF FNENDM(L$) THEN NEXTLIB=(1+L\1000)*1000

		:GOTO 1890

	' END OF JUMP TABLE


1880	GOSUB 10000

	:IF REF=0 THEN 1890

	' EXTRACT STMT NO FROM ENTRY IN JUMP TABLE, SKIP IF ISNT ONE


1885	GOSUB 9000

	' EXTERNAL ENTRY POINT


1887	IF EXTERNAL(REFN)<>0 THEN REFN=REFN-1:GOTO 1887

	' MULTI ENTRYS TO SAME STMT


1888	IF RLS(REFN)<L THEN

	:PRINT "Error in ";LIBRARY$;" There are more Jump table entries to statement";L;" than 'ENTRY and 'END markers"

	ELSE EXTERNAL(REFN)=L


1890	IF NOT EOF(2) THEN 1810

	ELSE RETURN


1990	' ============================


	GO THRO X-REF TABLE LOOKING FOR 

	ROUTINES A,B,C WITH :

	A CALLS B  &  B CALLS C

	PUT A REF TO C IN TABLE FOR A.


2000	FOR I=1 TO LASTRLS

	:J=REFMAX(I)

	:FOR K=1 TO J

	:REF=REF(I,K)

	:GOSUB 9000

	:REF(I,K)=REFN

	' CONVERT STMT NO REFS TO ROUTINE NO. REFS


2003	NEXT K

	:NEXT I


2005	REFFLAG=1

	:WHILE REFFLAG

	:REFFLAG=0

	:FOR A=1 TO LASTRLS

	:FOR H=1 TO REFMAX(A)


2010	B=REF(A,H)


2020	FOR I=1 TO REFMAX(B)

	:C=REF(B,I)


2030	FOR J=1 TO REFMAX(A)

	:IF REF(A,J)=C THEN 2050

	' LOOK TO SEE IF A REFERENCES C


2040	NEXT J

	:K=REFMAX(A)+1

	:REF(A,K)=C

	:REFMAX(A)=K

	:REFFLAG=1

	' ADD A REF TO C INTO TABLE FOR A


2050	NEXT I

	:NEXT H

	:NEXT A

	:WEND

	:RETURN


2190	' ===========================


	COMPILE A LIST OF ROUTINE NOS.

	REQUIRED BY PROGRAM IN RUSED()


2200	LASTRUSED=0


2210	FOR I=1 TO LASTRNUM

	:R=RNUM(I)

	:GOSUB 4000

	' ADD ROUTINE TO RUSED()


2220	R1=R

	:K=REFMAX(R)

	:FOR J=1 TO K

	:R=REF(R1,J)

	:GOSUB 4000

	:NEXT J

	' ADD ROUTINES CALLED BY ROUTINE R


2230	NEXT I


2290	' ===========================


	PRODUCE OUTPUT LIBRARY


2300	LASTSTMT=0

	:NEXTLIB=0

	:RUSEDP=0


2310	LINE INPUT #2,L$

	:L=FNLINEN(L$)

	:IF L>=NEXTLIB THEN 2323

	' JUMP IF STMT NO ABOVE CURRENT LIBRARY MODULE


2322	IF L<LASTSTMT THEN 2335 ELSE 2330

	' CURRENT LIBRARY ROUINE ?


2323	IF L<STARTLIB THEN IF ARRAYS THEN 2340 ELSE 2350

	' prior to start of Library, output if option on else ignore


2324	K=(L-STARTLIB)\1000 + 1

	:IF L>JTE(K) THEN NEXTLIB=STARTLIB+K*1000

		:GOTO 2330

	' SKIP IF FINISHED JUMP TABLE


2326	FOR J=1 TO LASTRUSED

	:IF L=EXTERNAL(RUSED(J)) THEN 2340

	' OUTPUT JUMP TABLE ENTRY IF NEEDED


2328	NEXT J

	:GOTO 2350

	' JUMP TABLE ENTRY NOT NEEDED


2330	IF RUSEDP>LASTRUSED THEN 2360 ELSE

	IF L>=LASTSTMT THEN	

	RUSEDP=RUSEDP+1

	:FIRSTSTMT=RFS(RUSED(RUSEDP))

	:LASTSTMT=RLS(RUSED(RUSEDP))

	:GOTO 2330

	' JUMP IF NO MORE WANTED ELSE START & END OF NEXT WANTED ROUTINE


2335	IF L=<FIRSTSTMT THEN 2350

	' SKIP IF STMT OCCURS BEFORE NEXT ROUTINE WANTED


2340	GOSUB 5000

	:IF LEN(STREXP$) THEN PRINT #3,STREXP$

	' STRIP COMMENT & OUTPUT


2350	IF NOT EOF(2) THEN 2310


2360	RETURN


2990	' ==========================


	READ FILE CONTAINING ANALYSIS

	OF LIBRARY


	RETURN	E%=0	IF OK


3000	ANALYSIS$=LEFT$(LIBRARY$,INSTR(LIBRARY$,"."))+"ANL"

	:ON ERROR GOTO 3040   

	:OPEN "I",#4,ANALYSIS$


3010	INPUT #4,LASTRFS

	:PRINT "Reading Library analysis"

	:FOR I=1 TO 13

	:INPUT #4,JTS(I),JTE(I)

	:NEXT


3015	LASTRLS=LASTRFS


3020	FOR I=1 TO MAXROUTINES

	:INPUT #4,RLS(I),RFS(I),REFMAX(I),EXTERNAL(I)

	:FOR J=1 TO REFMAX(I)

	:INPUT #4,REF(I,J)

	:NEXT J

	:NEXT I


3030	E%=0

	:GOTO 3050


3040	E%=1

	:RESUME 3050


3050	ON ERROR GOTO 0

	:CLOSE #4

	:RETURN


3090	' =====================


	WRITE LIBRARY ANALYSIS

	FILE


3100	OPEN "O",#4,ANALYSIS$


3110	WRITE #4,LASTRFS

	:FOR I=1 TO 13

	:WRITE #4,JTS(I),JTE(I)

	:NEXT


3120	FOR I=1 TO MAXROUTINES

	:WRITE #4,RLS(I),RFS(I),REFMAX(I),EXTERNAL(I)

	:FOR J=1 TO REFMAX(I)

	:WRITE #4,REF(I,J)

	:NEXT J

	:NEXT I


3130	CLOSE #4

	:RETURN


3990	' ==========================


	ADD THE ROUTINE NUMBER R TO THE

	TABLE RUSED() UNLESS ALREADY THERE


4000	F=RFS(R)

	:FOR J1=1 TO LASTRUSED

	:IF F<=RFS(RUSED(J1)) THEN 4020

	' GO THRO LIB ROUTINES CALLED DIRECTLY


4010	NEXT


4020	IF F=RFS(RUSED(J1)) THEN 4040

	' ROUTINE PREVIOUSLY REFERENCED


4030	LASTRUSED=LASTRUSED+1

	:FOR K1=LASTRUSED TO J1+1 STEP -1

	:RUSED(K1)=RUSED(K1-1)

	:NEXT K1

	:RUSED(J1)=R

	' SLOT R INTO TABLE


4040	RETURN


4980	' ===============================


	ROUTINE TO REMOVE THE COMMENTS FROM 

	A STATEMENT


4990	' =========================


	RETURNS		L$	INPUT STMT

			STREXP$	OUTPUT STMT


5000	STREXP$=""


5010	P1%=1

	:A%=INSTR(L$,COM$)

	:IF A%=0 THEN A%=INSTR(L$,COM1$)

	:IF A%=0 THEN A%=INSTR(L$,COM2$)

	:IF A%=0 THEN A%=INSTR(L$,COM3$)

	   :IF A%=0 THEN A%=300

	' 4 CHARACTER GROUPS GIVING COMENTS


5020	IF VAL(LEFT$(L$,1))=0 THEN

	   PRINT "LINE TOO LONG :- "

	  :PRINT L1$

	  :PRINT L$

	  :STREXPS$=L$

		:RETURN


5030	STRTSTMT=1

	' FIRST LINE OF MULTI-STMT


5040	L1$=L$


5050	P2%=INSTR(P1%,L$,CHR$(13))

	:IF P2%=0 THEN 5100

	:REM END OF LINE


5060	IF A%>P2% THEN GOSUB 5120

	:STRTSTMT=0

	:GOTO 5050

	:REM NO REMARK IN THIS STATEMENT


5070	IF A%<8 THEN RETURN

	:REM ENTIRE MULTISTATEMENT IS REMARK


5080	P2%=A%-1

	:IF P1%<P2% THEN GOSUB 5120

		:STRTSTMT=0  ELSE F%=0

	:REM OUTPUT LINE UP TO COMMENT


5090	IF F% THEN STREXP$=STREXP$+CHR$(10)+CHR$(13)

	:REM INSERT 1 LINE GAP WHEN COMMENT NOT ON OWN LINE


5100	RETURN

	:REM END OF STATEMENT


5110	REM  ==================


	PROCESS STATEMENT


	=======================


5120	FOR I%=P1% TO P2%

	:T%=ASC(MID$(L$,I%,1))

	:IF T%<>32 AND T%<>9 THEN 5140

	:REM SKIP TABS & SPACES


5130	NEXT

	:I%=P2%


5140	P1%=I%


5150	F%=1

	:IF P1%>=P2% THEN F%=0:RETURN

	:REM NOTHING ON LINE


5160	IF STRTSTMT=0 THEN STREXP$=STREXP$+CHR$(9)

	' ADD TAB EXCEPT ON FIRST LINE


5170	STREXP$=STREXP$+MID$(L$,P1%,P2%-P1%+1)

	:P1%=P2%+1

	:RETURN


7990	' ===========================


	CONVERT STMT REF OF ENTRY IN

	JUMP TABLE TO ROUTINE NO. REFN


8000	FOR I2=1 TO LASTRLS

	:IF REF=EXTERNAL(I2) THEN REFN=I2

		:RETURN


8010	NEXT

	:REFN=0

	:RETURN


8990	' =============================


	CONVERT STMT NO REF TO ROUTINE NO

	REFN


9000	GOSUB 8000

	:IF REFN THEN RETURN

	' CONVERT IF REF VIA JUMP TABLE


9010	FOR I2=1 TO LASTRLS

	:IF REF>=RFS(I2) THEN REFN=I2 ELSE RETURN

	' CONVERTS IF REF DIRECT TO ROUTINE


9020	NEXT

	:REFN=LASTRLS

	:RETURN


9990	' ============================


	EXTRACT NEXT STMT REFERENCE AFTER

	CHARACTER P FROM LINE L$ RETURN ANS

	IN REF


10000	IF P=1 THEN P1=0

	' P1 IS SET DURING ON...GOSUB (or GOTO)


10010	IF P1<>0 THEN 10100

	' JUMP IF ON...GOSUB (or GOTO)


10050	I3=FNLN(INSTR(P,L$,"GOSUB"),256)

	:I4=FNLN(INSTR(P,L$,"GOTO"),256)

	:I5=FNLN(INSTR(P,L$,"THEN"),256)


10060	I6=FNMIN(I3,I4)

	:I6=FNMIN(I6,I5)

	:IF I6=256 THEN REF=0:RETURN


10070	P=I6+5

	:REF=VAL(MID$(L$,P))

	:IF REF=0 THEN 10050

	' CATCH  IF ... THEN A=7


10080	IF FNLN(INSTR(P,L$,","),256)<FNLN(INSTR(P,L$,":"),256) THEN P1=1

		ELSE P1=0

	' LOOK FOR  ","   BEFORE   ":"   IE   ON ... GOSUB (or GOTO)


10090	RETURN


10100	I3=FNLN(INSTR(P,L$,","),256)

	:IF I3>=FNLN(INSTR(P,L$,":"),256) THEN P1=0:GOTO 10050

	' NO MORE CHOICES IN ON ... GOSUB (or  GOTO)


10110	P=I3+1

	:REF=VAL(MID$(L$,P))

	:RETURN


27020	PRINT P$;" : ";

	:LINE INPUT F$

	:RETURN


27080	PRINT CHR$(7);"ERROR - ";E$

	:RETURN


28070	GOTO 28600	' FILE REQUEST & OPEN


28595	' =========================================


	ROUTINE TO INPUT A FILE NAME AND OPEN IT

	HAVING CHECKED THAT IT DOES OR DOES NOT

	EXIST.  IF OPENED IN R MODE GETS 1ST RECORD.



					
28597	'	ENTRY	X%,Y%,P$

			MODE$ ="CMSR\E"


			C is CHECK	0 = DON'T CHECK

					1 = CHECK EXISTS

					2 = CHECK DOESN'T EXIST

					3 = IF EXISTS KILL THEN OPEN


       			M is MODE	I,O,R


			S is STREAM NO 1-9

 

			R is RECORD SIZE

	
28598	'		\E (Optional) EXTENSION


28599	'	RETURNS	F$ - FILE NAME

			E% SET IF ERROR


28600	L.T% = INSTR(MODE$,"\")+1

	:IF L.T% = 1 THEN L.T% = 100

	' L.T% IS START OF EXTENSION


28605	L.C% = VAL(LEFT$(MODE$,1))	

	:L.M$ = MID$(MODE$,2,1)

	:L.ST% = VAL(MID$(MODE$,3,1))

	:L.RS% = VAL(MID$(MODE$,4))

	:L.E$ = MID$(MODE$,L.T%)

	' SPLIT MODE$ INTO L.C% - TYPE OF CHECK, L.M$ - MODE

	L.ST% - STREAM, L.RS% - RECORD SIZE, L.E$ - EXTENSION


28607	E% = 0

	:IF L.E$ = "" THEN W% = 14 ELSE W% = 10

	' WIDTH OF FILE NAME DEPENDS ON EXTENSION


28608	GOSUB 27020

	:IF F$ = "" THEN E%=1

	:GOTO 28680

	' INPUT FILE NAME


28609	IF L.E$ <> "" AND INSTR(F$,".")=0  THEN F$ = F$+"."+L.E$

	' ADD EXTENSION TO FILE NAME


28610	IF L.C% <> 3 THEN GOTO 28620

	   ELSE ON ERROR GOTO 28615

	   :KILL F$

	   :GOTO 28620

	' CHECK 3 IF FILE EXISTS KILL


28615	RESUME 28620


28620	IF L.RS% = 0  AND L.M$ = "R" THEN E% = 2

	:GOTO 28680

	' CHECK RECORD SIZE


28625	IF L.C% <> 3 AND L.C% <> 0 THEN GOTO 28635 ELSE

	   IF L.M$ = "R" THEN OPEN "R",L.ST%,F$,L.RS%

			ELSE OPEN L.M$,L.ST%,F$

	' FOR CHECKS 0 & 3 OPEN FILE


28630	GOTO 28680


28635	IF L.M$ <> "R" THEN GOTO 28650 ELSE

	OPEN "R",L.ST%,F$,L.RS%

	:GET L.ST%

	:IF L.C% = 2 AND NOT EOF(L.ST%) THEN 28660

	' CHECK AND OPEN FILE IN R MODE AND GET 1ST REC


28645	IF L.C% = 1 AND EOF(L.ST%) THEN E$ = "FILE NOT FOUND"

	   :GOSUB 27080

	   :CLOSE L.ST%

	   :KILL F$

	   :GOTO 28600

	ELSE RETURN


28650	IF L.M$ <> "I" THEN GOTO 28665

	   ELSE ON ERROR GOTO 28655

	      :OPEN "I",L.ST%,F$

	      :GOTO 28680


28655	RESUME 28660


28660	E$ = "FILE NOT FOUND"

	:GOSUB 27080

	:CLOSE L.ST%

	:GOTO 28600

	'  CHECK AND OPEN FILE IN I MODE


28665	ON ERROR GOTO 28670

	:OPEN "I",L.ST%,F$

	:E$ = "FILE ALREADY EXISTS"

	:GOSUB 27080

	:CLOSE L.ST%

	:GOTO 28600


28670	RESUME 28675


28675	CLOSE L.ST%

	:OPEN "O",L.ST%,F$

	' CHECK AND OPEN FILE IN O MODE


28680	ON ERROR GOTO 0

	:RETURN


RESUME 28675


28675	CLOSE L.ST%

	:OPEN "O",L.ST%,F$

	' CHECK AND OPEN FILE IN O MODE
