PAGE	,132
COMMENT /
********************************************************************************
*									       *
*		   132C.ASM -- 132 COLUMN BY 38 LINE EMULATOR                  *
*									       *
*	     AUTHOR : NICK J. WILSON - ACT (ADVANCED TECHNOLOGY) LTD.          *
*									       *
*                              DATE : 6-10-1983                                *
*									       *
*               COPYRIGHT (C) 1983 ACT (ADVANCED TECHNOLOGY) LTD.              *
*                                                                              *
*                 NO USE OR DISCLOSURE WITHOUT WRITTEN CONSENT.                *
*                                                                              *
********************************************************************************/


CODE	SEGMENT		'CODE'

	ASSUME	DS:CODE,CS:CODE

	ORG	100H

	MOV	AX,CS
	MOV	DS,AX

	JMP	INSTALL


TAB_STOP	EQU	8			; MODULO FOR TABS
SCOLS		EQU	50			; 50 COLUMNS IN HIRES MODE
SROWS		EQU	25			; 25 CHAR LINES
DWORDS		EQU	SCOLS*SROWS*16		; 20000 WORDS ON SCREEN
DBYTES		EQU	2*DWORDS		; 40000 BYTES ON SCREEN
MAX_XDOTS	EQU	16*SCOLS		; 800 DOTS WIDE
MAX_YDOTS	EQU	16*SROWS		; BY 400 HIGH
COL_BYTE	EQU	2*MAX_YDOTS		; # BYTE PER COLUMN
REV_ATTR	EQU	8000H			; REVERSE VIDEO ATTRIBUTE
LOW_ATTR	EQU	4000H			; LOW INTENSITY ATTRIBUTE
UND_ATTR	EQU	2000H			; UNDERLINE ATTRIBUTE
NON_ATTR	EQU	1000H			; NON-DISPLAY ATTRIBUTE
RES_ATTR	EQU	0800H			; RESERVED ATTRIBUTE
DOT_OFF		EQU	0
SCN_SEG		EQU	0F000H			; SCREEN SEGMENT
XPOS		DW	0			; X OF TOP LEFT OF CHAR CELL
YPOS		DW	0			; Y OF TOP LEFT OF CHAR CELL
SAVE_XPOS	DW	0			; SAVE CURSOR COLUMN
SAVE_YPOS	DW	0			; SAVE CURSOR LINE
CELL_WIDTH	DW	0			; WIDTH OF CHAR CELL IN DOTS
CELL_HEIGHT	DW	0			; HEIGHT OF CHAR CELL IN RASTER LINES
CELL_MASK	DW	0			; MASK FOR CHAR CELL
COLM_MAX	DW	0			; MAX # OF CHAR COLUMNS
LINE_MAX	DW	0			; MAX # OF CHAR LINES
TOP_LINE	DW	0			; TOP LINE OF THE SCREEN
BOT_LINE	DW	0			; BOTTOM LINE OF THE SCREEN
PUT_VEC		DW	0			; DISPATCH FOR PUT_CON
INSERT_FLAG	DB	0			; IF INSERT MODE ON THEN FLAG = 1
DISCARD_FLAG	DB	0			; IF DISCARD THEN FLAG=1
ATTRIBUTE_FLAG	DB	40H			; ALL FIVE ATTRIBUTES, DEFAULT LOW INT.
CURSOR_FLAG	DB	0			; IF OFF THEN FLAG=FLAG OR 1
CRLF_FLAG	DB	0			; IF AUTO LF ON CR THEN FLAG=FLAG OR 1
LITERAL_FLAG	DB	0			; IF LITERAL THEN FLAG = 1
GRAPHIC_FLAG	DB	0			; IF GRAPHIC THEN FLAG = 1
BOT_FLAG	DB	0			; IF BOT ENABLED THEN FLAG = 1
BUF_COUNT	DB	0			; COUNT OF CBUFF CHARS SENT TO VT52
CBUFF		DB	8   DUP (?)		; 8 CHAR BUFFER FOR ESC SEQUENCES
CELL_BUFF	DW	16  DUP (?)		; SCREEN CELL BUFFER
MSCREEN		DB	0			; MICROSCREEN ECHO FLAG
ACTIVE		DB	0			; DRIVER ACTIVE FLAG
EN132		DB	0			; ALREADY IN 132 MODE FLAG


;** STORE FOR THE OLD_STUB_CO

OLD_STUB_CO 	LABEL 	DWORD
OLD_O		DW	?
OLD_S		DW	?



;**************************************************
;	TABLE FOR THE AMMOUNT OF CHARACTERS THAT 
;	THE ESCAPE SEQUENCE HANDLER MUST WAIT 
;	FOR BEFORE IT ACTUALLY HANDLES THEM
;*************************************************

ESC_SIZE	DB	0		; 20H ' '
		DB	0		; 21H '!'
		DB	0		; 22H '"'
		DB	2		; 23H '#'  TRANSMIT PAGE
		DB	2		; 24H '$'  TRANSMIT CURSOR CHAR
		DB	0		; 25H '%'
		DB	0		; 26H '&'
		DB	0		; 27H '''
		DB	2		; 28H '('  HIGH INTENSITY ON
		DB	2		; 29H ')'  HIGH INTENSITY OFF
		DB	0		; 2AH '*'
		DB	0		; 2BH '+'
		DB	0		; 2CH ','
		DB	0		; 2DH '-'
		DB	0		; 2EH '.'
		DB	0		; 2FH '/'
		DB	2		; 30H '0'  ENTER UNDERLINE MODE
		DB	2		; 31H '1'  EXIT  UNDERLINE MODE
		DB	0		; 32H '2'
		DB	0		; 33H '3'
		DB	4		; 34H '4'
		DB	0		; 35H '5'
		DB	0		; 36H '6'
		DB	0		; 37H '7'
		DB	2		; 38H '8'  LITERAL CHARACTER
		DB	0		; 39H '9'
		DB	0		; 3AH ':'
		DB	0		; 3BH ';'
		DB	0		; 3CH '<'
		DB	0		; 3DH '='
		DB	0		; 3EH '>'
		DB	0		; 3FH '?'
		DB	2		; 40H '@'  ENTER INSERT CHAR MODE
		DB	2		; 41H 'A'  CURSOR UP
		DB	2		; 42H 'B'  CURSOR DOWN
		DB	2		; 43H 'C'  CURSOR FORWARD
		DB	2		; 44H 'D'  CURSOR BACKWARD
		DB	2		; 45H 'E'  CLEAR DISPLAY
		DB	2		; 46H 'F'  ENTER GRAPHICS MODE
		DB	2		; 47H 'G'  EXIT GRAPHICS MODE
		DB	2		; 48H 'H'  CURSOR HOME
		DB	2		; 49H 'I'  REVERSE INDEX
		DB	2		; 4AH 'J'  ERASE TO END OF PAGE
		DB	2		; 4BH 'K'  ERASE TO END OF LINE
		DB	2		; 4CH 'L'  INSERT LINE
		DB	2		; 4DH 'M'  DELETE LINE
		DB	2		; 4EH 'N'  DELETE CHARACTER
		DB	2		; 4FH 'O'  EXIT INSERT CHAR MODE
		DB	0		; 50H 'P'
		DB	0		; 51H 'Q'
		DB	0		; 52H 'R'
		DB	0		; 53H 'S'
		DB	0		; 54H 'T'
		DB	2		; 55H 'U'  MICROSCREEN ON
		DB	0		; 56H 'V'
		DB	2		; 57H 'W'  MICROSCREEN OFF
		DB	2		; 58H 'X'  EXCHANGE FRGND/BKGND (?)
		DB	4		; 59H 'Y'  DIRECT CURSOR ADDRESSING
		DB	2		; 5AH 'Z'  IDENTIFY AS VT52 (ESC/K)
		DB	0		; 5BH '['
		DB	0		; 5CH '\'
		DB	2		; 5DH ']'  TRANSMIT BOTTOM LINE
		DB	2		; 5EH '^'
		DB	0		; 5FH '_'
		DB	0		; 60H '`'
		DB	0		; 61H 'a'
		DB	2		; 62H 'b'  ERASE TO BEGINNING OF PAGE
		DB	0		; 63H 'c'
		DB	0		; 64H 'd'
		DB	0		; 65H 'e'
		DB	0		; 66H 'f'
		DB	0		; 67H 'g'
		DB	2		; 68H 'h'  REVERSE TAB
		DB	0		; 69H 'i'
		DB	2		; 6AH 'j'  SAVE CURSOR POSITION
		DB	2		; 6BH 'k'  SET CURSOR TO SAVED POS
		DB	2		; 6CH 'l'  ERASE ENTIRE LINE
		DB	5		; 6DH 'm'  SET SIZE
		DB	2		; 6EH 'n'  CURSOR POSITION REPORT
		DB	2		; 6FH 'o'  ERASE BEGINNING OF LINE
		DB	2		; 70H 'p'  ENTER REVERSE VIDEO MODE
		DB	2		; 71H 'q'  EXIT REVERSE VIDEO MODE
		DB	0		; 72H 'r'
		DB	0		; 73H 's'
		DB	0		; 74H 't'
		DB	0		; 75H 'u'
		DB	2		; 76H 'v'  WRAP AROUND AT END OF LINE
		DB	2		; 77H 'w'  DISCARD AT END OF LINE
		DB	3		; 78H 'x'  SET MODE(S)
		DB	3		; 79H 'y'  RESET MODE(S)
		DB	2		; 7AH 'z'  RESET TO 80 COLUMN MODE
		DB	2		; 7BH '{'  KEYBOARD ENABLED
		DB	2		; 7CH '|'  ENABLE 132 COLUMN MODE
		DB	2		; 7DH '}'  KEYBOARD DISABLE
		DB	0		; 7EH '~'
		DB	0		; 7FH DEL


;*************************************
;	CONTROL CODE (<20H) JUMP
;	TABLE FOR DISPATCHES
;*************************************


CTRL_TAB	DW	PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1
		DW	CTBS,CTHT,CTLF,PASS_1,PASS_1,CTCR,CTSO,CTSI
		DW	PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1,PASS_1
		DW	PASS_1,PASS_1,PASS_1,CTESC,PASS_1,PASS_1,PASS_1,PASS_1


;**********************************
;	BINARY CHARACTER SET
;**********************************


	INCLUDE CSET.ASM



;(PHEW!)

;***************************************************
;	THE NEW CONSOLE OUTPUT SUBROUTINE, CALLED
;	AS AN INTERRUPT 29 HEX BY MS-DOS (OR
;	ANYTHING ELSE). REMEMBER THAT OLD_STUB_CO
;	CONTAINS THE ADDRESS OF THE OLD APRICOT
;	SCREEN HANDLER (USED FOR BELLS & SOME
;	ESCAPE SEQUENCES).
;	ASCII OF CHARACTER IS IN AL, NOTHING ELSE
;	MATTERS, BUT MUST BE SAVED.
;	WE HAVE MUCH TO DO, AND VERY LITTLE TIME TO
;	DO IT IN.
;***************************************************

STUBCO:

	CMP	CS:ACTIVE,1	;ARE WE RE-ENTERING?
	JE	OUTKWIK		;YES, GET OUT QUICK

	MOV	CS:ACTIVE,1	;SET THE ACTIVE FLAG

	PUSH	BP		;SAVE THE WORLD
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	ES
	PUSH	AX
	PUSH	DS


;** ENSURE THE INTEGRITY OF THE DS

	PUSH	CS
	POP	DS

;** AS PER NORMAL:
;** MASK THE TOP BIT SO AS NOT TO
;** MESS UP THE CHARACTERS

	AND	AL,7FH

;** WRITE THE CHARACTER ....

	CALL	PUT_VEC


;** GET BACK


	XOR	AL,AL				;SENDS A NUL
	PUSHF					;TO OLD DRIVER
	CALL	CS:DWORD PTR OLD_STUB_CO 	;SO >STOP< WORKS

	POP	DS
	POP	AX
	POP	ES
	POP	SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	BP

	MOV	CS:ACTIVE,0	;NOT ACTIVE ANY MORE

;** HOME TO ORIGINAL CALLER:

	IRET

OUTKWIK:
	MOV	CS:WORD PTR PUT_VEC,OFFSET STUBCO
	IRET

	

;**********************************
;	DUMMY ROUTINE TO PLEASE
;	THE BIOS
;**********************************

PASS_BUFFER:	RET



;**********************************
;	ROUTINE TO SEND CBUFF
;	TO THE OLD SCREEN DRIVER
;**********************************
SEND_BUFFER:
	XOR	BX,BX
S100:
	MOV	AL,CBUFF[BX]

	PUSHF
	CALL	CS:DWORD PTR OLD_STUB_CO

	INC	BL
	CMP	BL,BUF_COUNT
	JB	S100
	RET


;********************************************
;	HERE IS THE ROUTINE TO PUT THE
;	CHARACTER IN AL ON THE SCREEN.
;	WE USE CL FROM NOW ON AS AL IS
;	TOO IMPORTANT:
;********************************************
PUT_ACTIVE:

	XOR	AH,AH		; CLEAR
	XOR	CH,CH		; CRAP

	MOV	CL,AL		; SWAP THEM AROUND
	JMP	MECHO		; MIGHT ECHO TO MSCREEN
NO_ECHO:
	TEST	LITERAL_FLAG,1	; PRINT LITERALLY ?
	JNE	PUTC170		; YES
	XOR	CH,CH		; CH=0
	CMP	CL,20H		; YES - A CTRL CHAR ?
	JB	CTRL99		; YES
	CMP	CL,7FH		; NO - A DEL ?
	JE	PUTC350		; YES - NO DISPLAY
PUTC170:
	CALL	TOGGLE_CURSOR	; TURN CURSOR OFF
	TEST	INSERT_FLAG,1	; IN INSERT MODE ?
	JE	PUTC200		; NO
	CALL	INSERT_CHAR	; MOVE ALL CHARS RIGHT FROM CURSOR
PUTC200:
	TEST	GRAPHIC_FLAG,1	; IN GRAPHIC MODE ?
	JE	PUTC207		; NO
	CMP	CL,"^"		; IN GRAPHIC CHARS ?
	JB	PUTC207		; NO
	CMP	CL,"~"		; CHECK HIGHEST GRAPHIC
	JNE	PUTC205		; IF GRAPHIC THEN ADJUST
	INC	CL		; ELSE PARA. THEN DISPLAY 7FH
	JMP 	PUTC207
PUTC205:
	SUB	CL,"^"
PUTC207:
	CALL	CLEAR_CELL
	CALL	CHAR_OR_CELL	; COPY CHAR IN CL TO CELL_BUFF
	TEST	CS:ATTRIBUTE_FLAG,LOW_ATTR/256	; HIGH INTENSITY
	JNE	PUTC210		; NO
	CALL	LSHIFT_CELL	; SHIFT CELL LEFT
	CALL	CHAR_OR_CELL	; SHADOW PRINT CHAR
PUTC210:
	CALL	ADD_UNDERLINE	; ADD UNDERLINE IF ON
	CALL	ADD_REVERSE	; ADD REVERSE IF ON
	CALL	PUT_CELL	; PUT THE CELL ON THE SCREEN
	MOV	LITERAL_FLAG,0	; DID A LITERAL CLEAR FLAG
	INC	CS:XPOS		; MOVE FORWARD ONE CHAR COLUMN
	MOV	AX,CS:XPOS
	CMP	AX,CS:COLM_MAX	; AT RIGHT SIDE OF SCREEN ?
	JL	PUTC300		; NO
	MOV	AL,CS:DISCARD_FLAG
	OR	AL,AL		; YES - IS DISCARD MODE ON ?
	JE	PUTC240		; NO
	MOV	AX,CS:COLM_MAX	; YES - STAY AT RIGHT COLUMN
	DEC	AX
	MOV	CS:XPOS,AX
	JMP    	PUTC300
CTRL99:	
	JMP	CTRL100
NO_ECHO99:
	JMP	NO_ECHO
PUTC240:
	MOV	CS:XPOS,0		; WRAP TO LEFT COLUMN
	CALL	CTLF		; THEN DO LINE FEED
PUTC300:
	CALL	TOGGLE_CURSOR	; TURN CURSOR BACK ON
PUTC350:
	XOR	AL,AL		; NO SEQ PENDING
	RET



;**************************************************
;	MICROSCREEN LOGIC - SEND CHAR IN CL
;	TO THE BIOS MSCREEN HANDLER
;**************************************************
MSCR_OUT:
	PUSH	BX
	PUSH	CX
	PUSH	DX
	MOV	BX,33H
	MOV	DX,CX
	MOV	CX,1
	INT	0FCH
	POP	DX
	POP	CX
	POP	BX
	RET

;**************************************************
;	THIS TIME, CHECK IF WE ARE ECHOING,
;	IF SO, THEN CALL THE ABOVE ROUTINE
;**************************************************
MECHO:
	CMP	CS:BYTE PTR MSCREEN,1	; ECHOING TO MSCREEN ?
	JNE	NO_ECHO99		; NO
	CALL	MSCR_OUT		; YES
	JMP	NO_ECHO			; BACK


;**************************************************
;	CONTROL CODES
;**************************************************
CTRL100:
	CMP	CL,1BH		; SPECIAL TEST FOR ESC
	JE	CTESC		; YES - RETURN DIFFERENT
	MOV	BX,CX
	SHL	BX,1
	CALL	TOGGLE_CURSOR	; CURSOR OFF
	CALL	CS:CTRL_TAB[BX]
	CALL	TOGGLE_CURSOR	; CURSOR ON
	RET
;**************************************************
PASS_1:
	MOV	BUF_COUNT,1
	MOV	CBUFF,CL
	CALL	SEND_BUFFER
	RET

;**************************************************
CTESC:
	MOV	CBUFF,CL			; ESC FIRST CHAR IN BUFFER
	MOV	BUF_COUNT,1			; ONE CHAR IN BUFFER
	MOV	PUT_VEC,OFFSET BUFFER_ESC
	RET

;**************************************************
CTBS:
	MOV	AX,XPOS		; BACKSPACE
	DEC	AX		; BACKWARD ONE CHAR COLUMN
	JNS	BS500		; IF NOT AT LEFT SIDE OF SCREEN
	TEST	CS:DISCARD_FLAG,1	; IN DISCARD MODE ?
	JNE	BS600		; YES - NO WRAP
	MOV	AX,CS:COLM_MAX	; ELSE WRAP AROUND
	DEC	AX
	MOV	BX,CS:YPOS
	CMP	BX,CS:TOP_LINE	; AT TOP LINE ?
	JE	BS500		; YES - STAY THERE
	DEC	BX		; SIMULATE BOT+1
	CMP	BX,CS:BOT_LINE	; AT BOT+1 ?
	JE	BS500		; YES - STAY THERE
	MOV	CS:YPOS,BX		; ELSE - WRAP UP
BS500:
	MOV	CS:XPOS,AX
BS600:
	RET

;**************************************************
CTHT:
	MOV	AX,CS:XPOS		; HORIZONTAL TAB
	ADD	AX,TAB_STOP
	AND	AX,0FFF8H
	CMP	AX,CS:COLM_MAX	; OFF END ?
	JL	HT550		; NO
	MOV	AX,CS:COLM_MAX	; ELSE - STICK AT LAST COLUMN
	DEC	AX
HT550:
	MOV	CS:XPOS,AX
	RET

;**************************************************
CTLF:
	CALL	LINE_FD		; LINE FEED
	TEST	CS:CRLF_FLAG,2	; AN AUTO CR ON LF ?
	JE	LF100		; NO
	MOV	CS:XPOS,0		; YES - DO A RETURN
LF100:
	RET

LINE_FD:
	MOV	AX,CS:YPOS
	MOV	BX,CS:BOT_LINE
	CMP	AX,BX
	JE	LF300
	INC	BX		; CHECK BOTTOM +1
	CMP	AX,BX
	JE	LF200		; IF BOT+1 DO NOTHING
	INC	AX
	MOV	CS:YPOS,AX
LF200:
	RET			; IF BOT+1 DO NOTHING
LF300:
	MOV	SI,CS:TOP_LINE	; SCROLL FROM TOP TO BOTTOM LINE
	MOV	DI,CS:BOT_LINE	; PRINT ON BOTTOM LINE
	MOV	CS:YPOS,DI		; STAY ON BOTTOM LINE - 1
	CALL	SCROLL_UP
	RET

;**************************************************
CTCR:	
	MOV	CS:XPOS,0		; RETURN, MOVE TO LEFT COLUMN
	TEST	CS:CRLF_FLAG,1	; AN AUTO LF ON CR ?
	JE	CR100		; NO
	CALL	LINE_FD		; YES
CR100:
	RET

;**************************************************
CTSO:
	RET

;**************************************************
CTSI:
	RET

;**************************************************
;	BUFFER CHARS FOR ESCAPE SEQUENCE
;**************************************************
BUFFER_ESC:
	PUSH	CS
	POP	DS
	XOR	CH,CH
	XOR	AH,AH
	MOV	CL,AL

	CMP	CL,27			; IS CHAR ANOTHER ESCAPE?
	JE	IGNORE_CHAR		; WE DON'T WANT IT THEN

	MOV	BL,BUF_COUNT
	XOR	BH,BH
	MOV	CBUFF[BX],CL		; PUT CHAR INTO ESC SEQUENCE BUFFER
	INC	BL			; BUMP COUNT
	MOV	BUF_COUNT,BL
	MOV	DL,CBUFF+1
BUFT200:
	XCHG	DL,BL			; DL=LENGTH, BL=ESC SEQ CHAR
	SUB	BL,20H			; ASCII PRINT CHARS ONLY
	JB	ABORT_ESC		; ELSE ABORT
	CMP	DL,ESC_SIZE[BX]		; GOT ALL OF CHARS IN SEQUENCE ?
	JB	CONT_SEQ		; NO - GET MORE
	SHL	BX,1			; WORD POINTER
	CALL	TOGGLE_CURSOR		; CURSOR OFF
	PUSH	CS
	POP	DS
	CALL	CS:ESC_DISPATCH[BX]	; ESC DISPATCH --->
	CALL	TOGGLE_CURSOR		; CURSOR ON
	MOV	PUT_VEC,OFFSET PUT_ACTIVE
	RET

ABORT_ESC:
	RET

CONT_SEQ:
	MOV	PUT_VEC,OFFSET BUFFER_ESC

IGNORE_CHAR:
	RET



;**************************************************
;
;	ESCAPE SEQUENCE HANDLERS
;
;**************************************************


;**************************************************
;	TRANSMIT PAGE 
;	ESC #  (1BH,23H)
;**************************************************
TRANSMIT_PAGE:
	RET


;**************************************************
;	TRANSMIT CHARACTER AT CURSOR
;	ESC $  (1BH,24H)
;**************************************************
TRANSMIT_CHAR:
	RET


;**************************************************
;	SET HIGH INTENSITY MODE
;	ESC (  (1BH,28H)
;**************************************************
LOW_INT_OFF:
	AND	ATTRIBUTE_FLAG,NOT (LOW_ATTR/256)	; LOW INTENSITY OFF
	RET


;**************************************************
;	RESET HIGH INTENSITY MODE
;	ESC )  (1BH,29H)
;**************************************************
LOW_INT_ON:
	OR	ATTRIBUTE_FLAG,LOW_ATTR/256		; LOW INTENSITY ON
	RET


;**************************************************
;	ENTER UNDERLINE CHARACTER MODE
;	ESC 0  (1BH,30H)
;**************************************************
UNDERLINE_ON:
	OR	ATTRIBUTE_FLAG,UND_ATTR/256	; TURN UNDERLINE ON
	RET


;**************************************************
;	EXIT UNDERLINE CHARACTER MODE
;	ESC 1  (1BH,31H)
;**************************************************
UNDERLINE_OFF:
	AND	ATTRIBUTE_FLAG,NOT (UND_ATTR/256)	; TURN UNDERLINE OFF
	RET


;**************************************************
;	LITERAL CHARACTER
;	ESC 8  (1BH,38H)
;**************************************************
LITERAL:
	MOV	LITERAL_FLAG,1		; NEXT CHAR IS A LITERAL
	RET


;**************************************************
;	ENTER INSERT CHARACTER MODE
;	ESC @  (1BH,40H)
;**************************************************
INSERT_CHAR_ON:
	MOV	INSERT_FLAG,1			; ENABLE INSERT CHAR
	RET


;**************************************************
;	CURSOR UP
;	ESC A  (1BH,41H)
;**************************************************
CURSOR_UP:
	MOV	AX,YPOS
	CMP	AX,TOP_LINE		; AT TOP OF SCREEN ?
	JE	CUP100			; YES - STAY THERE
	DEC	AX			; SIMULATE BOT+1
	CMP	AX,BOT_LINE		; ON BOTTOM LINE ?
	JE	CUP100			; YES - STAY THERE
	MOV	YPOS,AX
CUP100:
	RET


;**************************************************
;	CURSOR DOWN
;	ESC B  (1BH,42H)
;**************************************************
CURSOR_DOWN:
	MOV	AX,YPOS
	MOV	BX,BOT_LINE
	CMP	AX,BX			; ON BOTTOM LINE ?
	JE	CDN100			; YES - STAY THERE
	INC	BX			; ON BOT+1 ?
	CMP	AX,BX
	JE	CDN100			; YES - STAY THERE
	INC	AX			; ELSE - MOVE DOWN ONE LINE
	MOV	YPOS,AX
CDN100:
	RET

 
;**************************************************
;	CURSOR FORWARD
;	ESC C  (1BH,43H)
;**************************************************
CURSOR_FORWARD:
	MOV	AX,XPOS
	INC	AX			; MOVE FORWARD ONE CHAR COLUMN
	CMP	AX,COLM_MAX		; AT RIGHT SIDE OF SCREEN ?
	JL	CRT100			; NO
	MOV	AX,COLM_MAX		; YES - STAY THERE
	DEC	AX
CRT100:
	MOV	XPOS,AX
	RET


;**************************************************
;	CURSOR BACKWARD
;	ESC D  (1BH,44H)
;**************************************************
CURSOR_BACKWARD:
	MOV	AX,XPOS
	DEC	AX			; BACKWARD ONE CHAR COLUMN
	JNS	CLF100			; IF NOT AT LEFT SIDE OF SCREEN
	SUB	AX,AX			; ELSE STAY THERE
CLF100:
	MOV	XPOS,AX
	RET


;**************************************************
;	CLEAR DISPLAY
;	ESC E  (1BH,45H)
;**************************************************
CLEAR:
	MOV	SI,TOP_LINE
	MOV	DI,BOT_LINE
	MOV	AX,YPOS
	CMP	AX,DI			; BEYOND BOTTOM LINE
	JLE	CLEAR100		; NO
	INC	DI			; DI = BOT+1
	MOV	SI,DI			; CLEAR FROM BOT+1 TO BOT+1
	CALL	ERASE_LINES		; ERASE BOT LINE +1
	MOV	XPOS,0			; MOVE TO BEGINNING OF BOT LINE +1
	RET
CLEAR100:
	CALL	ERASE_LINES		; ERASE LINE RANGE
	CALL	HOME			; HOME CURSOR
	RET


;**************************************************
;	ENTER GRAPHICS MODE
;	ESC F  (1BH,46H)
;**************************************************
GRAPHIC_ON:
	MOV	GRAPHIC_FLAG,1		; ENABLE GRAPHICS
	RET


;**************************************************
;	EXIT GRAPHICS MODE
;	ESC G  (1BH,47H)
;**************************************************
GRAPHIC_OFF:
	MOV	GRAPHIC_FLAG,0		; DISABLE GRAPHICS
	RET


;**************************************************
;	HOME CURSOR
;	ESC H  (1BH,48H)
;**************************************************
HOME:
	XOR	AX,AX
	MOV	XPOS,AX		; LEFT COLUMN
	MOV	AX,TOP_LINE
	MOV	YPOS,AX		; TOP LINE
	RET


;**************************************************
;	REVERSE LINE FEED
;	ESC I  (1BH,49H)
;**************************************************
REV_LINE_FEED:
	MOV	SI,TOP_LINE
	MOV	DI,BOT_LINE
	MOV	AX,YPOS
	CMP	AX,SI			; AT TOP OF SCREEN
	JE	RVLF100			; YES - SCROLL
	DEC	AX			;SIMULATE BOT+1
	CMP	AX,DI
	JE	RVLF200			; DONT SCROLL IF ON BOT+1
	DEC	YPOS			; ELSE MOVE UP ONE LINE
	JMP SHORT	RVLF200
RVLF100:
	CALL	SCROLL_DOWN		;  SCROLL THE SCREEN DOWN
RVLF200:
	RET


;**************************************************
;	ERASE TO END OF PAGE
;	ESC J  (1BH,4AH)
;**************************************************
ERASE_EOP:
	CALL	ERASE_EOL	; FIRST ERASE TO END OF LINE
	MOV	AX,YPOS
	MOV	SI,AX
	INC	SI
	MOV	DI,BOT_LINE
	CMP	AX,DI		; IF AT BOTTOM THEN DONE
	JE	EEOP200
	DEC	AX		; SIMULATE BOT+1
	CMP	AX,DI		; AT BOT+1 ?
	JE	EEOP200		; YES - DONE
	CALL	ERASE_LINES
EEOP200:
	RET


;**************************************************
;	ERASE TO END OF LINE
;	ESC K  (1BH,4BH)
;**************************************************
ERASE_EOL:
	MOV	AX,XPOS			; SAVE CURSOR COLUMN POSITION
	PUSH	AX
	CALL	CLEAR_CELL		; BLANK FOR ERASE
EOL100:
	CALL	PUT_CELL		; CLEAR A CHAR CELL
	INC	XPOS
	MOV	AX,XPOS
	CMP	AX,COLM_MAX		; ERASED THE END OF LINE ?
	JL	EOL100			; NO
	POP	AX			; RESTORE CURSOR POSITION
	MOV	XPOS,AX
	RET


;**************************************************
;	INSERT LINE
;	ESC L  (1BH,4CH)
;**************************************************
INSERT_LINE:
	MOV	SI,YPOS		; SCROLL FROM THIS LINE ...
	MOV	DI,BOT_LINE	;  TO BOTTOM LINE ...
	MOV	AX,SI
	DEC	AX		; SIMULATE BOT+1
	CMP	AX,DI		; DONT INSERT AT BOT+1
	JE	INST100
	CALL	SCROLL_DOWN	;  DOWN ONE LINE
	MOV	XPOS,0		; POSITION TO BEGINNING OF LINE
INST100:
	RET


;**************************************************
;	DELETE LINE
;	ESC M  (1BH,4DH)
;**************************************************
DELETE_LINE:
	MOV	SI,YPOS		; SCROLL FROM THIS LINE ...
	MOV	DI,BOT_LINE	;  TO BOTTOM LINE ...
	MOV	AX,SI
	DEC	AX		; SIMULATE BOT+1
	CMP	AX,DI		; DONT DELETE IF AT BOT+1
	JE	DELE100
	CALL	SCROLL_UP	;  UP ONE LINE
	MOV	XPOS,0		; POSITION TO BEGINNING OF LINE
DELE100:
	RET


;**************************************************
;	DELETE CHARACTER
;	ESC N  (1BH,4EH)
;**************************************************
DELETE_CHAR:
	MOV	AX,XPOS		; SAVE CHAR COLUMN POS
	PUSH	AX
DLC100:
	INC	XPOS
	MOV	AX,XPOS
	CMP	AX,COLM_MAX	; MOVED ALL CHARS RIGHT ?
	JGE	DLC200		; YES
	CALL	GET_CELL	; GET CELL TO RIGHT
	DEC	XPOS
	CALL	PUT_CELL	; PUT ON TOP OF HERE
	INC	XPOS
	JMP SHORT	DLC100
DLC200:
	DEC	XPOS
	CALL	CLEAR_CELL	; WIPE CELL BUFFER
	CALL	PUT_CELL	; ERASE RIGHT MOST CELL
	POP	AX		; MOVE CURSOR BACK TO ORIGINAL POS
	MOV	XPOS,AX
	RET


;**************************************************
;	EXIT INSERT CHARACTER MODE
;	ESC O  (1BH,4FH)
;**************************************************
INSERT_CHAR_OFF:
	MOV	INSERT_FLAG,0	; INSERT CHARACTER MODE OFF
	RET


;**************************************************
;	SWITCH MICROSCREEN ECHO
;	MODE ON AND INIT MSCREEN
;	ESC U
;**************************************************
MSCREEN_ON:
	MOV	CS:BYTE PTR MSCREEN,1
	MOV	BX,33H
	MOV	CX,1
	MOV	DX,27
	INT	0FCH
	MOV	DX,"U"		;THIS CODE SWITCHES THE MSCREEN
	INT	0FCH		;ON, CLEARS IT AND PUTS THE
	MOV	DX,27		;CURSOR IN THE TOP-LEFT
	INT	0FCH
	MOV	DX,"r"
	INT	0FCH
	RET


;**************************************************
;	SWITCH MSCREEN ECHO MODE
;	OFF AND RESET MSCREEN
;	ESC V
;**************************************************
MSCREEN_OFF:
	MOV	CS:BYTE PTR MSCREEN,0
	MOV	BX,33H
	MOV	CX,1
	MOV	DX,27
	INT	0FCH
	MOV	DX,"s"
	INT	0FCH
	RET


;**************************************************
;	EXCHANGE LINE
;	ESC X  (1BH,58H)
;**************************************************
EXCHANGE_LINE:
	RET


;**************************************************
;	DIRECT CURSOR ADDRESSING
;	ESC Y[1][C]  (1BH,59H,XXH,XXH)
;**************************************************
DIRECT_CURSOR:
	MOV	AL,CBUFF+2	; HEX LINE #
	XOR	AH,AH		; AH=0
	SUB	AL,20H
	JB	DCR800		; NOT ASCII
	MOV	BL,CBUFF+3	; HEX COLUMN #
	XOR	BH,BH		; AH=0
	SUB	BL,20H
	JB	DCR800		; NOT ASCII
DCR150:
	CMP	AX,TOP_LINE	; ABOVE TOP LINE ?
	JGE	DCR200		; NO
	MOV	AX,TOP_LINE	; CLIP TO TOP
	JMP SHORT	DCR300
DCR200:
	MOV	CX,BOT_LINE
	CMP	AX,CX		; BELOW OR EQUAL BOTTOM LINE ?
	JLE	DCR300		; YES - OK THEN
	INC	CX		; NO - ON BOT+1 LINE ?
	CMP	AX,CX
	JNE	DCR350		; NO - DONT DO ANYTHING
	TEST	BOT_FLAG,1	; YES - BOT+1 LINE ENABLED ?
	JE	DCR350		; NO - DO COLUMN ONLY
DCR300:
	MOV	YPOS,AX		; CHANGE LINE POSITION
DCR350:
	CMP	BX,COLM_MAX	; BEYOND MAX COLUMNS ?
	JL	DCR400		; NO - LEAVE OK
	MOV	BX,COLM_MAX	; YES - CLIP TO COLM_MAX-1
	DEC	BX
DCR400:
	MOV	XPOS,BX
DCR800:
	RET


;**************************************************
;	IDENTIFY AS VT52 (ESC/K)
;	ESC Z  (1BH,5AH)
;**************************************************
IDENT_VT52:
	RET


;**************************************************
;	TRANSMIT BOTTOM LINE
;	ESC ]  (1BH,5DH)
;**************************************************
TRANSMIT_BOT:
	RET


;**************************************************
;	ERASE BEGINNING OF DISPLAY
;	ESC b  (1BH,62H)
;**************************************************
ERASE_BOP:
	CALL	ERASE_BOL	; ERASE TO BEGINNING OF LINE
	MOV	SI,TOP_LINE
	MOV	DI,BOT_LINE
	MOV	AX,YPOS
	CMP	AX,SI		; AT TOP LINE ?
	JE	EBOP100		; YES - DONE
	DEC	AX		; SIMULATE BOT+1
	CMP	AX,DI		; AT LINE BOT+1
	JE	EBOP100		; YES - DONE
	MOV	DI,AX		; ERASE FROM TOP TO CURSOR-1 LINE
	CALL	ERASE_LINES
EBOP100:
	RET


;**************************************************
;	REVERSE TAB
;	ESC h  (1BH,68H)
;**************************************************
REVERSE_TAB:
	MOV	AX,XPOS
	SUB	AX,TAB_STOP
	AND	AX,0FFF8H	; OFF LEFT SIDE OF SCREEN
	JNS	REVT100		; NO
	SUB	AX,AX		; STOP ON LEFT SIDE
REVT100:
	MOV	XPOS,AX
	RET


;**************************************************
;	SAVE CURSOR POSITION
;	ESC j  (1BH,6AH)
;**************************************************
SAVE_POS:
	MOV	AX,XPOS		; SAVE CURSOR COLUMN
	MOV	SAVE_XPOS,AX
	MOV	AX,YPOS		; SAVE CURSOR LINE
	MOV	SAVE_YPOS,AX
	RET


;**************************************************
;	SET CURSOR TO SAVED POSITION
;	ESC k  (1BH,6BH)
;**************************************************
RESTORE_POS:
	MOV	AX,SAVE_YPOS	; GET CURSOR LINE
	MOV	BX,SAVE_XPOS	; GET CURSOR COLUMN
	JMP	DCR150		; DO A CURSOR POSITION


;**************************************************
;	ERASE ENTIRE LINE
;	ESC l  (1BH,6CH)
;**************************************************
ERASE_LINE:
	MOV	SI,YPOS		; ERASE THIS LINE
	CALL	ERASE_ONE
	RET


;**************************************************
;	SET SIZE
;	ESC m[C1][C2][C3] (1BH,6DH,XXH,XXH,XXH)
;**************************************************
SET_SIZE:
	MOV	BL,CBUFF+2	; DISPATCH #
	CMP	BL,'1'		; SET CELL SIZE ?
	JE	SET_CELL	; YES
	CMP	BL,'2'		; SET SCREEN SIZE ?
	JE	SET_SCREEN
	RET

SET_CELL:
	XOR	BH,BH		; BH=0
	MOV	BL,CBUFF+3	; CELL WIDTH
	SUB	BL,1FH
	CMP	BL,1		; TOO SMALL WIDTH
	JL	SCEL500		; YES
	CMP	BL,10H		; TOO BIG ?
	JG	SCEL500		; YES - DON'T CHANGE
	SUB	CH,CH		; CH=0
	MOV	CL,CBUFF+4	; CELL HEIGHT
	SUB	CL,1FH
	CMP	CL,1		; TOO SMALL HEIGHT
	JL	SCEL500		; YES - DON'T CHANGE
	CMP	CL,10H		; TOO BIG
	JG	SCEL500		; YES
	CALL	SET_CELL_SIZE
SCEL500:
	RET

SET_SCREEN:
	MOV	AX,LINE_MAX	; GET MAX LINE #
	DEC	AX
	XOR	BH,BH		; BH=0
	MOV	BL,CBUFF+3	; TOP LINE #
	SUB	BL,20H		; TOO SMALL TOP LINE #
	JS	SSCN500		; YES
	CMP	BX,AX		; TOO BIG ?
	JG	SSCN500		; YES - DON'T CHANGE
	SUB	CH,CH		; CH=0
	MOV	CL,CBUFF+4	; BOT_LINE
	SUB	CL,20H
	CMP	BX,CX		; BOT MUST BE GREATER THAN OR EQUAL TOP
	JG	SSCN500		; ELSE - DON'T CHANGE
	CMP	CX,AX		; TOO BIG
	JG	SSCN500		; YES
	CALL	SET_SCRN_SIZE
SSCN500:
	RET


;**************************************************
;	CURSOR POSITION REPORT
;	ESC n  (1BH,6EH)
;**************************************************
REPORT_CURSOR:
	RET


;**************************************************
;	ERASE BEGINNING OF LINE
;	ESC o  (1BH,6FH)
;**************************************************
ERASE_BOL:
	MOV	AX,XPOS		; SAVE CURSOR COLUMN POSITION
	PUSH	AX
	CALL	CLEAR_CELL	; TO ERASE
EBOL100:
	CALL	PUT_CELL	; ERASE
	DEC	XPOS
	JGE	EBOL100		; TO BEGINNING OF LINE
	POP	AX		; RESTORE CURSOR COLUMN POSITION
	MOV	XPOS,AX
	RET


;**************************************************
;	ENTER REVERSE VIDEO MODE
;	ESC p  (1BH,70H)
;**************************************************
REVERSE_ON:
	OR	ATTRIBUTE_FLAG,REV_ATTR/256		; TURN REVERSE ON
	RET


;**************************************************
;	EXIT REVERSE VIDEO MODE
;	ESC q  (1BH,71H)
;**************************************************
REVERSE_OFF:
	AND	ATTRIBUTE_FLAG,NOT (REV_ATTR/256)	; TURN REVERSE OFF
	RET


;**************************************************
;	WRAP AROUND AT END OF LINE
;	ESC v  (1BH,76H)
;**************************************************
WRAP_MODE:
	MOV	DISCARD_FLAG,0		; ENABLE WRAP MODE
	RET


;**************************************************
;	DISCARD AT END OF LINE
;	ESC w  (1BH,77H)
;**************************************************
DISCARD_MODE:
	MOV	DISCARD_FLAG,1		; ENABLE DISCARD MODE
	RET


;**************************************************
;	SET MODE(S)
;	ESC x [PS] (1BH,78H)
;**************************************************
SET_MODES:
	XOR	BH,BH			; BH = 0
	MOV	BL,CBUFF+2		; FIND WHAT TO SET
	SUB	BL,'1'			; BELOW ASCII "0" ?
	JS	SET_DONE		; YES - EXIT
	CMP	BL,9			; FROM 0 - 9 ?
	JL	SETM500			; YES
	SUB	BL,7
	CMP	BL,7			; BELOW ASCII "A" ?
	JL	SET_DONE		; YES - EXIT
	CMP	BL,12			; A - C ?
	JGE	SET_DONE		; NO - EXIT
SETM500:
	SHL	BX,1
	JMP	CS:SET_TAB[BX]


SET_TAB		DW	ENABLE_BOT,SET_DONE,SET_DONE,BLK_CUR
		DW	CUR_OFF,SET_DONE,SET_DONE,SET_LF
		DW	SET_CR,SEND_BUFFER,SEND_BUFFER,SEND_BUFFER

ENABLE_BOT:
	OR	BOT_FLAG,1		; ENABLE BOT LINE

SET_DONE:
	RET

BLK_CUR:
	AND	CURSOR_FLAG,NOT 2	; ENABLE BLOCK CURSOR
	RET

CUR_OFF:
	OR	CURSOR_FLAG,1		; CURSOR OFF
	RET

SET_LF:
	OR	CRLF_FLAG,1		; ENABLE AUTO LINE FEED ON CR
	RET

SET_CR:
	OR	CRLF_FLAG,2		; ENABLE AUTO CR ON LINE FEED
	RET

;**************************************************
;	RESET MODE(S)
;	ESC y [PS] (1BH,79H)
;**************************************************
RESET_MODES:
	XOR	BH,BH			; BH = 0
	MOV	BL,CBUFF+2		; FIND WHAT TO SET
	SUB	BL,'1'			; BELOW ASCII "1" ?
	JS	REST_DONE		; YES - EXIT
	CMP	BL,9			; FROM 0 - 9 ?
	JL	REST500			; YES
	SUB	BL,7
	CMP	BL,7			; BELOW ASCII "A" ?
	JL	REST_DONE		; YES - EXIT
	CMP	BL,12			; A - C ?
	JGE	REST_DONE		; NO - EXIT
REST500:
	SHL	BX,1
	JMP	CS:RESET_TAB[BX]

RESET_TAB	DW	DISABLE_BOT,REST_DONE,REST_DONE,UND_CUR
		DW	CUR_ON,REST_DONE,REST_DONE,REST_LF
		DW	REST_CR,SEND_BUFFER,SEND_BUFFER,SEND_BUFFER

DISABLE_BOT:
	AND	BOT_FLAG,NOT 1		; DISABLE BOT LINE

REST_DONE:
	RET

UND_CUR:
	OR	CURSOR_FLAG,2		; ENABLE UNDERSCORE CURSOR
	RET

CUR_ON:
	AND	CURSOR_FLAG,NOT 1	; CURSOR ON
	RET

REST_LF:
	AND	CRLF_FLAG,NOT 1		; NO AUTO LINE
	RET

REST_CR:
	AND	CRLF_FLAG,NOT 2		; NO AUTO CR
	RET

;**************************************************
;	RESET TO 80 COLUMN TEXT MODE
;	ESC z  (1BH,7AH)
;**************************************************

LAST_ONE	DB	0

T132:	CMP	AL,"|"
	JE	COULD_BE
	MOV	CS:LAST_ONE,AL

ITS_NOT:
	PUSHF
	CALL	CS:DWORD PTR OLD_STUB_CO
	IRET

COULD_BE:
	CMP	CS:LAST_ONE,27
	JE	MUST_BE
	JMP	ITS_NOT	

MUST_BE:
	CALL	ENABLE_132
	IRET

RESET:
	MOV	CS:BYTE PTR EN132,0

;** SWITCH TO TEXT MODE

	MOV	BX,31H
	MOV	CX,1
	MOV	DX,0
	INT	0FCH


	PUSH	CS
	POP	DS
	MOV	DX,OFFSET T132
	MOV	AH,25H
	MOV	AL,29H
	INT	21H

	RET

;**************************************************
;	KEYBOARD ENABLE
;	ESC {  (1BH,7BH)
;**************************************************
KEYBOARD_ON:
	CALL	SEND_BUFFER		; VT52 DOES THIS
	RET

;**************************************************
;	ENABLE 132 COLUMN DISPLAY
;	ESC |  (1BH,7CH)
;**************************************************
ENABLE_132:
	CMP	CS:BYTE PTR EN132,1
	JE	NOTDO
	MOV	CS:BYTE PTR EN132,1
    	PUSH	AX
	PUSH	DS
	PUSH	CX

	PUSH	CS
	POP	DS

	MOV	CX,2

AGAIN:
	PUSH	CX

	CALL	SETHIRES

	POP	CX
	LOOP	AGAIN

	CALL	DO_NEW

	PUSH	CS
	POP	DS
	MOV	DX,OFFSET STUBCO
	MOV	AH,25H
	MOV	AL,29H
	INT	21H


	POP	CX
	POP	DS
	POP	AX

	RET

NOTDO:
	JMP	CLEAR


;**************************************************
;	KEYBOARD DISABLE
;	ESC }  (1BH,7DH)
;**************************************************
KEYBOARD_OFF:
	CALL	SEND_BUFFER		; VT52 DOES THIS
	RET




;**************************************************
;	SCROLL UP
;	ENTER	SI = TOP    LINE # INCLUSIVE
;		DI = BOTTOM LINE # INCLUSIVE
;**************************************************
SCROLL_UP:


;** SWITCH OFF THE KEYCLICK, AS THE PIT
;** DOES NOT GET A LOOK-IN FOR AT LEAST
;** 50MS:

	PUSH	AX
	MOV	AL,0FFH
	OUT	50H,AL
	POP	AX


;** DO THE SCROLL

	PUSH	DI			; SAVE BOTTOM LINE # TO ERASE IT
	SUB	DI,SI			; # LINES -1 TO MOVE
	MOV	AX,CS:CELL_HEIGHT		; CALC # WORDS TO MOVE
	MUL	DI
	MOV	BX,AX
	MOV	AX,CS:CELL_HEIGHT		; CALC TO ADDR
	SHL	AX,1			; TIMES TWO FOR WORDS
	MUL	SI
	MOV	BP,AX			; SCROLL UP TO THIS LINE

;	BP = WHERE TO MOVE WORDS TO
;	BX = # WORDS TO MOVE

	MOV	DL,SCOLS		; # OF COLUMNS TO SCROLL UP
SCU100:
	MOV	DI,BP			; TO
	MOV	SI,BP			; CALC FROM ADDR
	MOV	AX,CS:CELL_HEIGHT
	SHL	AX,1			; TIMES TWO FOR WORDS
	ADD	SI,AX
	MOV	CX,BX			; COUNT

	PUSH	AX
	MOV	AX,280H
	MOV	ES,AX
	POP	AX

	PUSH	DS
	PUSH	ES
	POP	DS

	CLD
	REP	MOVSW

	POP	DS
	ADD	BP,320H			; NEXT COLUMN LEFT
	DEC	DL
	JG	SCU100
	POP	SI			; LINE TO ERASE
	CALL	ERASE_ONE
	RET

;**************************************************
;	SCROLL DOWN
;	ENTER	SI = TOP    LINE # INCLUSIVE
;		DI = BOTTOM LINE # INCLUSIVE
;**************************************************
SCROLL_DOWN:

;** SWITCH OFF THE KEYCLICK, AS THE PIT
;** DOES NOT GET A LOOK-IN FOR AT LEAST
;** 50MS:

	PUSH	AX
	MOV	AL,0FFH
	OUT	50H,AL
	POP	AX


	PUSH	CS
	POP	DS
	PUSH	SI			; SAVE TOP LINE # TO ERASE IT
	SUB	SI,DI			; # LINES -1 TO MOVE
	NEG	SI			; BECAUSE IT WAS MINUS
	MOV	AX,CELL_HEIGHT		; CALC # WORDS TO MOVE
	MUL	SI
	MOV	BX,AX
	MOV	AX,CELL_HEIGHT		; CALC TO ADDR
	SHL	AX,1			; TIMES TWO FOR WORDS
	INC	DI			; BOTTOM LINE +1
	MUL	DI
	MOV	BP,AX			; SCROLL DOWN TO THIS LINE
	DEC	BP			; BACKUP ONE WORD
	DEC	BP

	STD				; MOVE FOR HI TO LOW MEMORY
	MOV	DL,SCOLS		; # OF COLUMNS TO SCROLL DOWN
SCD100:
	MOV	DI,BP			; TO
	MOV	SI,BP			; CALC FROM ADDR
	MOV	AX,CELL_HEIGHT
	SHL	AX,1			; TIMES TWO FOR WORDS
	SUB	SI,AX
	MOV	CX,BX			; COUNT
	PUSH	AX
	MOV	AX,280H
	MOV	ES,AX
	POP	AX
	PUSH	DS
	PUSH	ES
	POP	DS
	REP	MOVSW	
	POP	DS
	ADD	BP,COL_BYTE			; NEXT COLUMN LEFT
	DEC	DL
	JG	SCD100
	POP	SI			; LINE TO ERASE
	CALL	ERASE_ONE
	RET

;**************************************************
;	ERASE LINES
;	ENTER:	SI = TOP LINE NUMBER 
;		DI = BOTTOM LINE NUMBER
;	ES EQUAL DS
;	DESTROYS DL,CX,DI,AX
;**************************************************
ERASE_ONE:
	MOV	DI,SI

ERASE_LINES:


;** SWITCH OFF THE KEYCLICK, AS THE PIT
;** DOES NOT GET A LOOK-IN FOR AT LEAST
;** 50MS:


	PUSH	AX
	MOV	AL,0FFH
	OUT	50H,AL
	POP	AX

	PUSH	CS
	POP	DS
	SUB	DI,SI			; CALC # LINES TO ERASE
	INC	DI
	MOV	AX,CELL_HEIGHT		; NOW CALC # RASTER LINES
	MUL	DI
	MOV	BX,AX
	MOV	AX,CELL_HEIGHT
	SHL	AX,1			; FOR WORDS
	MUL	SI			; CALC ADDR OF FIRST LINE
	MOV	SI,AX
	SUB	AX,AX			; FILL WITH ZERO
	MOV	DL,SCOLS		; NUMBER 16 BIT COLUMNS
ERL100:
	MOV	DI,SI
	MOV	CX,BX			; # WORD IN COLUMN TO ERASE
	CLD
	PUSH	AX
	MOV	AX,280H
	MOV	ES,AX
	POP	AX
	REP	STOSW	
	ADD	SI,COL_BYTE		; NEXT COLM LEFT
	DEC	DL			; DONE ALL COLMS ?
	JG	ERL100			; NO
	RET

;**************************************************
;	INSERT A CHARACTER SPACE
;	ENTER:	XPOS AND YPOS
;	SCROLLS ALL CHARS FROM XPOS,YPOS
;	TO END OF LINE RIGHT ONE CHAR COLUMN
;	AND ERASES XPOS,YPOS CHAR
;**************************************************
INSERT_CHAR:

;** SWITCH OFF THE KEYCLICK, AS THE PIT
;** DOES NOT GET A LOOK-IN FOR AT LEAST
;** 50MS:

	PUSH	AX
	MOV	AL,0FFH
	OUT	50H,AL
	POP	AX


	PUSH	CS
	POP	DS
	PUSH	CX
	MOV	AX,XPOS		; SAVE CURSOR POSITION
	PUSH	AX
	MOV	AX,COLM_MAX	; START RIGHT COLUMN
	DEC	AX
	MOV	XPOS,AX
IRC100:
	POP	AX		; START POSITION
	CMP	AX,XPOS		; DONE ?
	JE	IRC200		; YES
	PUSH	AX
	DEC	XPOS
	CALL	GET_CELL	; GET SCREEN CELL TO LEFT
	INC	XPOS
	CALL	PUT_CELL	; PUT IT HERE
	DEC	XPOS
	JMP SHORT	IRC100
IRC200:
	CALL	CLEAR_CELL	; ERASE ORIGINAL POS
	CALL	PUT_CELL
	POP	CX
	RET

;**************************************************
;	CALCULATE ADDR FOR POSITION ON SCREEN
;	ENTER	POSITION = XPOS,YPOS
;	EXIT	BP = ADDR OF TOP WORD IN CELL
;		CL = SHIFT COUNT
;		BX = MASK FOR WIDTH OF CHAR CELL
;**************************************************
CALC_ADDR:
	PUSH	CS
	POP	DS
	MOV	AX,XPOS			; ABS X POSITION
	MOV	BX,CELL_WIDTH		; CALC ABS POSITION OF ARRAY
	MUL	BX
	MOV	CX,AX			; SAVE IN CX
	AND	CL,0FH			; 16 BIT SHIFT COUNT
	AND	AX,03F0H		; 16*COL#  (COLUMN NUMBER)
	MOV	BX,COL_BYTE/16		; FOR MULT BY 800/16=50
	MUL	BX			; (16*COL#)*(800/16)=WORD/COLUMN
	MOV	BP,AX
	MOV	AX,YPOS			; CALC ABS LINE FOR CELL
	MOV	BX,CELL_HEIGHT
	SHL	BX,1			; TIMES 2 FOR WORDS
	MUL	BX
	ADD	BP,AX			; GEN ADDR TO FIRST FONT CELL WORD
	MOV	BX,CELL_MASK		; MASK FOR CELL_WIDTH WIDE CHARS
	RET

;**************************************************
;	TOGGLE CURSOR
;	ENTER	POSITION = XPOS,YPOS
;**************************************************
TOGGLE_CURSOR:
	PUSH	CS
	POP	DS
	PUSH	BX
	PUSH	CX
	TEST	CURSOR_FLAG,1	; CURSOR ON ?
	JNE	NO_CURSOR	; NO - SKIP ALL THIS
	CALL	GET_CELL	; GET THE CELL FROM SCREEN INTO CELL_BUFF
	TEST	CURSOR_FLAG,2	; A BLOCK CURSOR ?
	JE	CXOR100		; YES - GO DO A BLOCK CURSOR
	MOV	CX,CELL_HEIGHT
	MOV	BX,CELL_MASK
	PUSH	ES
	MOV	SI,CS
	MOV	ES,SI
	MOV	SI,OFFSET CHRSET
	MOV	AX,8000H		; MSB FLAGS UNDERLINE
	XOR	DI,DI
CUND100:
	TEST	ES:[SI],AX		; UNDERLINE HERE
	JE	CUND200			; NO
	XOR	CS:CELL_BUFF[DI],BX
CUND200:
	INC	DI
	INC	DI
	INC	SI
	INC	SI
	LOOP	CUND100
	POP	ES
	JMP SHORT	CXOR200
CXOR100:
	CALL	XOR_CELL	; XOR FOR A BLOCK CURSOR
CXOR200:
	CALL	PUT_CELL	; PUT BACK ON SCREEN
NO_CURSOR:
	POP	CX
	POP	BX
	RET

;**************************************************
;	OR CHAR FROM TABLE TO CELL_BUFF
;	ENTER:	CL = CHARACTER
;		CHAR_SEG=SEGMENT FOR TABLE
;		CHAR_OFF=OFFSET FOR TABLE
;**************************************************
CHAR_OR_CELL:
	PUSH	CS
	POP	DS
	PUSH	CX
	MOV	SI,OFFSET CHRSET
	MOV	AX,32
	MUL	CX
	ADD	SI,AX
	MOV	DI,OFFSET CELL_BUFF
	MOV	CX,CELL_HEIGHT
	MOV	AX,CS
	MOV	DS,AX
	MOV	ES,AX
	CLD
CTC200:
	PUSH	CS
	POP	DS
	LODSW			; GET CHAR WORD
	OR	AX,CS:[DI]	; OR TO CELL
	PUSH	CS
	POP	ES
	STOSW	
	LOOP	CTC200
	POP	CX
	RET

;**************************************************
;	ADD UNDERLINE TO CELL_BUFF IF ON
;**************************************************
ADD_UNDERLINE:
	PUSH	CS
	POP	DS
	TEST	ATTRIBUTE_FLAG,UND_ATTR/256
	JE	ADDU400				; NO UNDERLINE
ADDU050:
	MOV	CX,CELL_HEIGHT
	MOV	BX,CELL_MASK
	MOV	AX,8000H			; MSB FLAGS UNDERLINE
	XOR	DI,DI
ADDU100:
	TEST	CS:CELL_BUFF[DI],AX		; UNDERLINE HERE
	JE	ADDU200				; NO
	MOV	CS:CELL_BUFF[DI],BX
ADDU200:
	INC	DI
	INC	DI
	LOOP	ADDU100
ADDU400:
	RET

;**************************************************
;	ADD REVERSE TO CELL_BUFF IF ON
;**************************************************
ADD_REVERSE:
	PUSH	CS
	POP	DS
	TEST	ATTRIBUTE_FLAG,REV_ATTR/256
	JE	ADDR100			; NO REVERSE
	CALL	XOR_CELL
ADDR100:
	RET

;**************************************************
;	SHIFT CELL LEFT ONE DOT
;**************************************************
LSHIFT_CELL:
	PUSH	CS
	POP	DS
	PUSH	CX
	MOV	CX,CELL_HEIGHT
	XOR	DI,DI
LSCL100:
	SHL	CS:CELL_BUFF[DI],1		; SHIFT ONE WORD
	INC	DI
	INC	DI
	LOOP	LSCL100
	POP	CX
	RET

;**************************************************
;	GET CHARACTER CELL
;	READ SCREEN CELL INTO CELL_BUFF
;	NORMALIZED TO THE LSB SIDE OF THE BUFFER
;	ENTER	POSITION = XPOS,YPOS
;**************************************************
GET_CELL:
	PUSH	CS
	POP	DS	
	CALL	CALC_ADDR		; SET BP TO ADDR OF SCREEN CELL
	MOV	SI,BP			; GET FROM HERE POINTER
	MOV	DI,OFFSET CELL_BUFF	; ADDRESS TO PUT NORMALIZED CELL
	MOV	CH,BYTE PTR CELL_HEIGHT		; NUMBER WORDS IN A CELL
	CLD
	PUSH	AX
	MOV	AX,280H
	PUSH	AX
	POP	ES
	POP	AX
GCL100:
	PUSH	DS
	PUSH	ES
	POP	DS
	LODSW				; GET LEFT WORD
	POP	DS
	SHR	AX,CL			; ADJUST FOR SHIFT
	AND	AX,BX			; MASK OFF BAD STUFF
	PUSH	ES
	PUSH	CS
	POP	ES
	STOSW				; PUT IN BUFFER
	POP	ES
	DEC	CH
	JG	GCL100
	XOR	CL,0FH			; NEGATE CL
	INC	CL
	CMP	CL,CS:BYTE PTR CELL_WIDTH	; DO A RIGHT SIDE ?
	JGE	GCL300			; NO
	MOV	SI,BP			; MOVE TO NEXT COLUMN RIGHT
	ADD	SI,COL_BYTE
	MOV	DI,OFFSET CELL_BUFF	; ADDRESS TO PUT NORMALIZED CELL
	MOV	CH,CS:BYTE PTR CELL_HEIGHT ; NUMBER WORDS IN A CELL
GCL200:
	PUSH	DS
	PUSH	ES
	POP	DS
	LODSW				; GET LEFT WORD
	POP	DS
	SHL	AX,CL			; ADJUST FOR SHIFT
	AND	AX,BX			; MASK OFF BAD STUFF
	OR	AX,CS:[DI]		; OR INTO BUFFER
	PUSH	ES
	PUSH	CS
	POP	ES
	STOSW	
	POP	ES
	DEC	CH
	JG	GCL200
GCL300:
	RET

;**************************************************
;	PUT CHARACTER CELL
;	PUT CELL_BUFF CHAR ON THE SCREEN
;	ENTER	POSITION = XPOS,YPOS
;**************************************************
PUT_CELL:
	PUSH	CS
	POP	DS
	CALL	CALC_ADDR		; BP = ADDR OF SCREEN CELL
	MOV	DI,BP			; ADDR TO PUT CHAR
	MOV	SI,OFFSET CELL_BUFF	; ADDRESS OF CELL
	MOV	CH,CS:BYTE PTR CELL_HEIGHT		; LOOP CTR
	SHL	BX,CL			; ADJUST MASK
	PUSH	AX
	MOV	AX,280H
	MOV	ES,AX
	POP	AX
	CLD
PCL100:
	PUSH	CS
	POP	DS
	LODSW				; WORD FROM CELL
	SHL	AX,CL
	MOV	DX,ES:[DI]		; ADD IN WORD FROM SCREEN
	XOR	AX,DX
	AND	AX,BX			; MASK UNWANTED STUFF
	XOR	AX,DX			; REMOVE AND ADD NEW 
	STOSW				; BACK TO SCREEN
	DEC	CH			; DONE ALL OF LEFT SIDE OF CELL ?
	JG	PCL100			; NO
	XOR	CL,0FH			; NEGATE CL
	INC	CL
	CMP	CL,CS:BYTE PTR CELL_WIDTH	; ANY DOTS SHIFT INTO NEXT
	JGE	PCL300			; NO - ALL DONE THEN
	MOV	DI,BP
	ADD	DI,COL_BYTE		; NEXT COLUMN RIGHT
	MOV	SI,OFFSET CELL_BUFF	; ADDRESS OF CELL
	MOV	CH,CS:BYTE PTR CELL_HEIGHT		; LOOP CTR
	MOV	BX,CS:CELL_MASK		; MASK FOR OTHER SIDE
	SHR	BX,CL			; ADJUST MASK 
PCL200:
	PUSH	CS
	POP	DS
	LODSW				; WORD FROM CELL
	SHR	AX,CL
	MOV	DX,ES:[DI]		; ADD IN WORD FROM SCREEN
	XOR	AX,DX
	AND	AX,BX			; MASK UNWANTED STUFF
	XOR	AX,DX			; REMOVE AND ADD NEW 
	STOSW				; BACK TO SCREEN
	DEC	CH			; DONE ALL OF LEFT SIDE OF CELL ?
	JG	PCL200
PCL300:
	RET

;**************************************************
;	CLEAR CHARACTER CELL_BUFF
;**************************************************
CLEAR_CELL:
	PUSH	CS
	POP	ES
	PUSH	CX
	MOV	CX,CS:CELL_HEIGHT		; # WORDS TO CLEAR
	MOV	DI,OFFSET CELL_BUFF
	XOR	AX,AX
	CLD
	REP	STOSW	
	POP	CX
	RET

;**************************************************
;	XOR CHARACTER CELL_BUFF
;**************************************************
XOR_CELL:
	PUSH	CS
	POP	DS
	MOV	DI,CS:CELL_HEIGHT		; # WORDS TO XOR
	SHL	DI,1	
	MOV	AX,CS:CELL_MASK
XCEL100:
	XOR	CELL_BUFF-2[DI],AX
	DEC	DI
	DEC	DI
	JG	XCEL100
	RET

;**************************************************
;	SET CELL SIZE
;	ENTER:	BX = CELL WIDTH
;		CX = CELL HEIGHT
;**************************************************
SET_CELL_SIZE:
	PUSH	CS
	POP	DS
	MOV	CS:CELL_WIDTH,BX	; SAVE WIDTH
	MOV	CS:CELL_HEIGHT,CX	;  AND HEIGHT
	SUB	AX,AX		; AX = 0
SETC100:
	STC			; GEN CELL MASK
	RCL	AX,1
	DEC	BX
	JG	SETC100
	MOV	CS:CELL_MASK,AX	; SAVE MASK
	XOR	DX,DX		; DX = 0
	MOV	AX,MAX_XDOTS	; 800 DOTS HORZ
	MOV	CX,CS:CELL_WIDTH	; DIVIDE BY CELL WIDTH
	DIV	CX
	MOV	CS:COLM_MAX,AX	; EQUAL MAX COLUMNS
	XOR	DX,DX		; DX = 0
	MOV	AX,MAX_YDOTS	; 400 LINES VERT
	MOV	CX,CS:CELL_HEIGHT	; DIVIDE BY CELL HEIGHT
	DIV	CX
	MOV	CS:LINE_MAX,AX	; EQUAL MAX LINES
	XOR	BX,BX		; TOP LINE = 0
	MOV	CX,CS:LINE_MAX
	DEC	CX
	DEC	CX		; BOTTOM LINE = 38
				; FALL THROUGH TO SET SCREEN SIZE

;**************************************************
;	SET SCREEN SIZE
;	ENTER:	BX = TOP LINE #
;		CX = BOTTOM LINE #
;**************************************************
SET_SCRN_SIZE:
	PUSH	CS
	POP	DS
	MOV	CS:TOP_LINE,BX	; SAVE TOP AND BOTTOM LINE
	MOV	CS:BOT_LINE,CX
	CALL	HOME		; HOME THE CURSOR
	RET



;*****************************
;	ESCAPE SEQUENCE
;	DISPATCH TABLE
;*****************************
ESC_DISPATCH	DW	PASS_BUFFER	; 20H ' '
		DW	PASS_BUFFER	; 21H '!'
		DW	PASS_BUFFER	; 22H '"'
		DW	TRANSMIT_PAGE	; 23H '#'  TRANSMIT PAGE
		DW	TRANSMIT_CHAR	; 24H '$'  TRANSMIT CURSOR CHAR
		DW	PASS_BUFFER	; 25H '%'
		DW	PASS_BUFFER	; 26H '&'
		DW	PASS_BUFFER	; 27H '''
		DW	LOW_INT_OFF	; 28H '('  HIGH INTENSITY ON
		DW	LOW_INT_ON	; 29H ')'  HIGH INTENSITY OFF
		DW	PASS_BUFFER	; 2AH '*'
		DW	PASS_BUFFER	; 2BH '+'
		DW	PASS_BUFFER	; 2CH ','
		DW	PASS_BUFFER	; 2DH '-'
		DW	PASS_BUFFER	; 2EH '.'
		DW	PASS_BUFFER	; 2FH '/'
		DW	UNDERLINE_ON	; 30H '0'  ENTER UNDERLINE MODE
		DW	UNDERLINE_OFF	; 31H '1'  EXIT  UNDERLINE MODE
		DW	SET_DONE	; 32H '2'
		DW	SET_DONE	; 33H '3'
		DW	PASS_BUFFER	; 34H '4'
		DW	PASS_BUFFER	; 35H '5'
		DW	PASS_BUFFER	; 36H '6'
		DW	PASS_BUFFER	; 37H '7'
		DW	LITERAL		; 38H '8'  LITERAL CHARACTER
		DW	PASS_BUFFER	; 39H '9'
		DW	PASS_BUFFER	; 3AH ':'
		DW	PASS_BUFFER	; 3BH ';'
		DW	PASS_BUFFER	; 3CH '<'
		DW	PASS_BUFFER	; 3DH '='
		DW	PASS_BUFFER	; 3EH '>'
		DW	PASS_BUFFER	; 3FH '?'
		DW	INSERT_CHAR_ON	; 40H '@'  ENTER INSERT CHAR MODE
		DW	CURSOR_UP	; 41H 'A'  CURSOR UP
		DW	CURSOR_DOWN	; 42H 'B'  CURSOR DOWN
		DW	CURSOR_FORWARD	; 43H 'C'  CURSOR FORWARD
		DW	CURSOR_BACKWARD	; 44H 'D'  CURSOR BACKWARD
		DW	CLEAR		; 45H 'E'  CLEAR DISPLAY
		DW	GRAPHIC_ON	; 46H 'F'  ENTER GRAPHICS MODE
		DW	GRAPHIC_OFF	; 47H 'G'  EXIT GRAPHICS MODE
		DW	HOME		; 48H 'H'  CURSOR HOME
		DW	REV_LINE_FEED	; 49H 'I'  REVERSE INDEX
		DW	ERASE_EOP	; 4AH 'J'  ERASE TO END OF PAGE
		DW	ERASE_EOL	; 4BH 'K'  ERASE TO END OF LINE
		DW	INSERT_LINE	; 4CH 'L'  INSERT LINE
		DW	DELETE_LINE	; 4DH 'M'  DELETE LINE
		DW	DELETE_CHAR	; 4EH 'N'  DELETE CHARACTER
		DW	INSERT_CHAR_OFF	; 4FH 'O'  EXIT INSERT CHAR MODE
		DW	PASS_BUFFER	; 50H 'P'
		DW	PASS_BUFFER	; 51H 'Q'
		DW	PASS_BUFFER	; 52H 'R'
		DW	PASS_BUFFER	; 53H 'S'
		DW	PASS_BUFFER	; 54H 'T'
		DW	MSCREEN_ON	; 55H 'U'  SWITH ECHO ON
		DW	MSCREEN_OFF     ; 56H 'V'  SWITCH ECHO OFF
		DW	PASS_BUFFER	; 57H 'W'
		DW	EXCHANGE_LINE	; 58H 'X'  EXCHANGE FRGND/BKGND (?)
		DW	DIRECT_CURSOR	; 59H 'Y'  DIRECT CURSOR ADDRESSING
		DW	IDENT_VT52	; 5AH 'Z'  IDENTIFY AS VT52 (ESC/K)
		DW	SET_DONE	; 5BH '['
		DW	SET_DONE	; 5CH '\'
		DW	TRANSMIT_BOT	; 5DH ']'  TRANSMIT BOTTOM LINE
		DW	SET_DONE	; 5EH '^'
		DW	PASS_BUFFER	; 5FH '_'
		DW	PASS_BUFFER	; 60H '`'
		DW	PASS_BUFFER	; 61H 'a'
		DW	ERASE_BOP	; 62H 'b'  ERASE TO BEGINNING OF PAGE
		DW	PASS_BUFFER	; 63H 'c'
		DW	PASS_BUFFER	; 64H 'd'
		DW	PASS_BUFFER	; 65H 'e'
		DW	PASS_BUFFER	; 66H 'f'
		DW	PASS_BUFFER	; 67H 'g'
		DW	REVERSE_TAB	; 68H 'h'  REVERSE TAB
		DW	PASS_BUFFER	; 69H 'i'
		DW	SAVE_POS	; 6AH 'j'  SAVE CURSOR POSITION
		DW	RESTORE_POS	; 6BH 'k'  SET CURSOR TO SAVED POS
		DW	ERASE_LINE	; 6CH 'l'  ERASE ENTIRE LINE
		DW	SET_SIZE	; 6DH 'm'  SET SIZE
		DW	REPORT_CURSOR	; 6EH 'n'  CURSOR POSITION REPORT
		DW	ERASE_BOL	; 6FH 'o'  ERASE BEGINNING OF LINE
		DW	REVERSE_ON	; 70H 'p'  ENTER REVERSE VIDEO MODE
		DW	REVERSE_OFF	; 71H 'q'  EXIT REVERSE VIDEO MODE
		DW	PASS_BUFFER	; 72H 'r'
		DW	PASS_BUFFER	; 73H 's'
		DW	PASS_BUFFER	; 74H 't'
		DW	PASS_BUFFER	; 75H 'u'
		DW	WRAP_MODE	; 76H 'v'  WRAP AROUND AT END OF LINE
		DW	DISCARD_MODE	; 77H 'w'  DISCARD AT END OF LINE
		DW	SET_MODES	; 78H 'x'  SET MODE(S)
		DW	RESET_MODES	; 79H 'y'  RESET MODE(S)
		DW	RESET		; 7AH 'z'  RESET TO 80 COLUMN MODE
		DW	KEYBOARD_ON	; 7BH '{'  KEYBOARD ENABLED
		DW	ENABLE_132	; 7CH '|'  ENABLE 132 COLUMN MODE
		DW	KEYBOARD_OFF	; 7DH '}'  KEYBOARD DISABLE
		DW	PASS_BUFFER	; 7EH '~'
		DW	PASS_BUFFER	; 7FH DEL



;***************************************
;	SET CRTC TO TEXT MODE
;***************************************
SETTEXT:
	MOV	BX,31H
	MOV	CX,1
	MOV	DX,0
	INT	0FCH
	RET


;**************************************
;	INSTALL THE MODULE
;**************************************
INSTALL:	MOV	DX,OFFSET MESSAGE
		MOV	AH,9	
		INT	21H
		CALL	INIT_SCR
		JMP	STAY_RES


;**************************************
;	INITIALIZE THE SCREEN FOR
;	       132 COLUMNS
;**************************************
INIT_SCR:	CALL	SET_INT29
		CALL	SETHIRES
		RET


;**************************************
;	SET UP THE INTERRUPT 29H
;	TO POINT TO THE 132C
;	CONSOLE OUTPUT STUB
;	AND SET UP THE OLD_STUB_CO
;
;**************************************
SET_INT29:	MOV	AX,0
		MOV	ES,AX
		MOV	DI,0A4H
		PUSH	ES:[DI]
		PUSH	ES:[DI+2]
		POP	OLD_S
		POP	OLD_O

		PUSH	CS
		POP	DS
		MOV	DX,OFFSET STUBCO
		MOV	AH,25H
		MOV	AL,29H
		INT	21H


		RET


CRTC_GRAF	DB	59,50,51,7,25,10,25,25,3,14,0,15,0,0,0,0



;**********************************
;	SET SCREEN BUFFER,
;	PAR PORT ADDRESS,
;	AND CRTC FOR HIRES
;**********************************
SETHIRES:
	PUSH	ES
	PUSH	AX
	PUSH	DX
	PUSH	BX
	PUSH	DI	
	PUSH	SI
	PUSH	DS

;** CLEAR SCREEN BUFFER + RESET CRTC TO TEXT MODE

	MOV	AL,27
	PUSHF
	CALL	CS:DWORD PTR OLD_STUB_CO
	MOV	AL,"z"
	PUSHF
	CALL	CS:DWORD PTR OLD_STUB_CO

	CALL	DO_NEW

;** SET UP THE SCREEN BUFFER LONGDITUDALLY

	MOV	AX,SCN_SEG
	MOV	ES,AX
	MOV	BX,0
	MOV	CH,50
	MOV	AX,0140H	;DOTRAM SHR (1)

SH200:
	PUSH	BX
	MOV	CL,25
SH300:
	MOV	ES:[BX],AX
	INC	AX
	ADD	BX,50*2
	DEC	CL
	JG	SH300
	POP	BX
	ADD	BX,2
	DEC	CH
	JG	SH200

;** CLEAR THE DOT RAM

	MOV	AX,280H
	MOV	ES,AX
	MOV	CX,20000
	XOR	AX,AX
	MOV	DI,AX
	CLD
	REP	STOSW

	MOV	BX,31H
	MOV	CX,01H
	MOV	DX,01H
	INT	0FCH

	PUSHF
	CLI

CRTC10:
	MOV	SI,OFFSET CRTC_GRAF
	MOV	DX,68H
	MOV	BL,0
	MOV	CX,16

CRTC20:
	MOV	AL,BL
	OUT	DX,AL
	INC	BX
	INC	DX
	INC	DX
	LODSB
	OUT	DX,AL
	DEC	DX
	DEC	DX
	LOOP	CRTC20	

	POPF


	POP	DS
	POP	SI
	POP	DI
	POP	BX
	POP	DX
	POP	AX
	POP	ES

	RET


;** INIT MESSAGE

MESSAGE		DB	27,'V',27,'E',27,'/',0,27,'z$'


;*********************************
;	SET UP THE DEFAULT SIZES
;	FOR THE CHARACTER CELL
;	AND SCREEN.
;*********************************
DO_NEW:

	MOV	BX,6
	MOV	CX,10
	CALL	SET_CELL_SIZE
	PUSH	AX
	MOV	AX,OFFSET PUT_ACTIVE
	MOV	PUT_VEC,AX
	POP	AX
	CALL	TOGGLE_CURSOR
	RET


;*********************************
;	KEEP US RESIDENT &
;	SIGN - ON
;*********************************
STAY_RES:
	
	MOV	DX,OFFSET SIGNON
	MOV	AH,9
	INT	21H

	MOV	DX,OFFSET ENDRES
	INT	27H

SIGNON	DB	27,'p     ',27,'q'
	DB	'  Apricot ',27,'0',27,'('
	DB	' 132 Column ',27,')',27,'1 Interface  -  Vr1.4  '
	DB	27,'p     ',27,'q',13,10,13,10,'$'


ENDRES:		 ;LABEL FOR END OF CODE

CODE		ENDS

		END

;END OF 132C.ASM

                                                                    