                                                                                                                         
$ TYPE diskiop.asm

; [bios.apricot.rom]diskiop.asm
	TITLE	'[bios.apricot.rom]diskiop.asm'
;
        Include 'legal.asi'
;**************************************************************************
;
;       FILENAME:       diskiop.asm
;       PROGRAMMER:     G. Kurth
;       IMPLEMENTED:    23-jan-84
;       MODIFIED:	10-aug-84	GK
;			IOP routines for all FLOPPY & WINCHESTER I/O
;			Dual winchester board support 14/3/85 IGC
;
;**************************************************************************
;

        name DiskIOP
        nolist sym
        

        Include 'macro89.asi'
        Include 'iop.asi'
        Include 'ioregs.asi'
        
        Global CodeBaseQQ,DataBaseQQ   ;   set during link
        
        Include 'align.asi'
        
;*************************************************************************
;
;	NOTE!!	These Routines are placed in the CONSTANTS area of the
;		BIOS as they cannot run in ROM.
;
;*************************************************************************

        Section DiskIOP.instr,align(1),class=constQQ
        
        Assume ds:DataBaseQQ, cs:CodeBaseQQ
;
; 1)	FLOPPY DISK READ/WRITE
;
        Global  rw_PB           ;read/write globals
        Global  rw_TB
        Global  rw_offset
        Global  rw_segment
        Global  rw_sec_count
        Global  rw_cur_sec
        Global  rw_8089_cc
        Global  rw_FDC_com
;
; 2)	FLOPPY DISK VERIFY
;        
        Global  vfy_PB          ;verify globals
        Global  vfy_TB
        Global  vfy_offset
        Global  vfy_segment
        Global  vfy_byte_count
        Global  vfy_fin_mc
        Global  vfy_FDC_com
;
; 3)	FLOPPY DISK FORMAT
;
	Global	format_PB	;floppy format globals
	Global	format_TB
	Global	FMT_offset
	Global	FMT_dataseg
	Global	FMT_FDC_com
;
; 4)	WINCHESTER READ/WRITE
;
WIP_ram	equ	01F0h		;port address of winchester buffer RAM
;
        Global  WI_rw_PB                ;read/write globals
        Global  WI_rd_TB
        Global  WI_wrt_TB
        Global  WI_rw_offset
        Global  WI_rw_segment
        Global  WI_rw_byte_count
	Global	WI_rw_port		;*
;
; 5)	FLOPPY TRACK READ
;
	Global	FTR_PB		;floppy TRACK READ globals
	Global	FTR_TB
	Global	FTR_offset
	Global	FTR_dataseg
	Global	FTR_FDC_com
;
; 6)	SECTOR READ/WRITE FOR PROTECTION
;
	GLOBAL	SRW_PB
	GLOBAL	SRW_offset
	GLOBAL	SRW_segment
	GLOBAL	SRW_8089_cc
	GLOBAL	SRW_FDC_com

	page
       
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 1) IOP program to read/write a Floppy sector ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

           align_data

rw_PB           address rw_TB
rw_offset       block 2
rw_segment      block 2
rw_sec_count    block 2
rw_cur_sec      block 2
rw_8089_cc      block 2
rw_FDC_com      BLOCK 1
           
rw_TB      movbi9  ga,FDC_DAT			; FDC data reg - data source/dest.
           lpd9    gb,{pp}.rw_offset-rw_PB	; data destination/source.
           mov9    mc,{pp}.rw_cur_sec-rw_PB
           mov9    ix,{pp}.rw_sec_count-rw_PB
           mov9    cc,{pp}.rw_8089_cc-rw_PB
           movbi9  gc,FDC_COM			; FDC command reg.
           wid9    8,8				; 8-8 transfer since read/write.
rw_loop    movi9   bc,512
           mov9    {gc}.4,mc                    ;FDC sector register
           xfer9
           movb9   {gc},{pp}.rw_FDC_com-rw_PB   ; FDC_reg0:=command
;
; tBC0
           ljmp9   rw_next_sec
; tX4
           
           ljmp9   rw_next_sec
           
rw_next_sec 
           inc9    mc                  ;set up next sector
           dec9    ix                  ;sector count
           jnz9    ix,rw_more_secs
rw_error_ret
           hlt9

rw_more_secs
            jbt9  {gc},00h,rw_more_secs         ;wait for not busy
            jbt9  {gc},02h,rw_error_ret         ;only loop if no error
            jbt9  {gc},03h,rw_error_ret
            jbt9  {gc},04h,rw_error_ret
            jbt9  {gc},07h,rw_error_ret
            jmp9 rw_loop
            
	page

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 2) IOP program to verify a floppy sector ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

           align_data
vfy_PB         address vfy_TB           ; 8089 code
vfy_offset     block 2                  ; 8089 data areas
vfy_segment    block 2
vfy_byte_count block 2
vfy_fin_mc     block 2
vfy_FDC_com    block 1

vfy_TB     movbi9  ga,FDC_DAT		; FDC data reg - data source.
           mov9    mc,{pp}.(vfy_fin_mc-vfy_PB)
           mov9    bc,{pp}.(vfy_byte_count-vfy_PB)
           movbi9  gc,FDC_COM		; FDC command reg.
           movi9   cc,(CC_p2p!CC_srcsync!CC_tBC0!CC_tX4!CC_srcGA)
           wid9    8,8			; 8089-3 hardware bug.
           movbi9  gb,78h		; Data sink address for Apricot.
           xfer9
           movb9   {gc},{pp}.(vfy_FDC_com-vfy_PB) ; FDC_reg0:= command
; tBC0
           ljmp9   v_stop_fdc
; tX4
           hlt9

v_stop_fdc jmcne9  {gc}.4,v_stop_fdc   ; Wait until sector read complete.
           movbi9  {gc},0D0h           ; FDC_reg0:=[ force interrupt ]
           hlt9
  
	page

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 3) IOP program to format floppy track ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	align_data

format_PB	address	format_TB
FMT_offset	BLOCK	2
FMT_dataseg	BLOCK	2
FMT_FDC_com	BLOCK	1

format_TB	movbi9	gb,FDC_DAT			;FDC data register
		lpd9	ga,{pp}.(FMT_offset-format_PB)	;compute 20 bit address
		movbi9	gc,FDC_COM			;fdc command register
		movi9	cc,(CC_m2p!CC_dstsync!CC_tbc0!CC_tx0!CC_srcGA)
		movbi9	mc,0
		movi9	bc,7000
		wid9	8,8
		xfer9
		movb9	{gc},{pp}.(FMT_FDC_com-format_PB)	;start write
; tbc0
; tx0
		hlt9

	page

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; IOP program to read/write Winchester data ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

           align_data
WI_rw_PB                word (WI_rd_TB-DatabaseQQ)
                        word bits(DatabaseQQ,4,16)
WI_rw_offset            block 2
WI_rw_segment           block 2
WI_rw_byte_count        block 2
WI_rw_port		block 2		;*
        

WI_rd_TB
;**	movi9	ga,WIP_ram			; WINI ram port - data source.
	mov9	ga,{pp}.WI_rw_port-WI_rw_PB	;*
        lpd9    gb,{pp}.WI_rw_offset-WI_rw_PB	; data destination.
        mov9    bc,{pp}.WI_rw_byte_count-WI_rw_PB
        movi9   cc,(CC_p2m!CC_nosync!CC_srcGA!CC_tBC0)
        xfer9
        wid9    8,16				; 8-16 transfer since p to mem.
        hlt9

WI_wrt_TB
;**	movi9	ga,WIP_ram			; WINI ram port - data dest.
	mov9	ga,{pp}.WI_rw_port-WI_rw_PB
        lpd9    gb,{pp}.WI_rw_offset-WI_rw_PB	; data source.
        mov9    bc,{pp}.WI_rw_byte_count-WI_rw_PB
        movi9   cc,(CC_m2p!CC_nosync!CC_srcGB!CC_tBC0)
        xfer9
        wid9    16,8				; 16-8 transfer since mem to p.
        hlt9

	page

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; 5) IOP program to read floppy track ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	align_data

FTR_PB		address	FTR_TB
FTR_offset	BLOCK	2
FTR_dataseg	BLOCK	2
FTR_FDC_com	BLOCK	1

FTR_TB		movbi9	gb,FDC_DAT			;FDC data register
		lpd9	ga,{pp}.(FTR_offset-FTR_PB)	;compute 20 bit address
		movbi9	gc,FDC_COM			;fdc command register
		movi9	cc,(CC_p2m!CC_srcsync!CC_tbc0!CC_tx0!CC_srcGB)
		movbi9	mc,0
		movi9	bc,7000
		wid9	8,8
		xfer9
		movb9	{gc},{pp}.(FTR_FDC_com-FTR_PB)	;start write
; tbc0
; tx0
		hlt9

;***********************************************
; Sector read/write code for protection calls
;***********************************************
	align_data

SRW_PB		address	SRW_TB
SRW_offset	block	2
SRW_segment	block	2
SRW_8089_cc	block	2
SRW_FDC_com	block	1

SRW_TB	movbi9	ga,FDC_DAT			;port source/sink
	lpd9	gb,{pp}.SRW_offset-SRW_PB	;memory source/sink
	mov9	cc,{pp}.SRW_8089_cc-SRW_PB	;8089 transfer command
	movbi9	gc,FDC_COM			;FDC command register
	movbi9	mc,0
	movi9	bc,1024				;maximum byte count
	wid9	8,8
	xfer9					;do the transfer
	movb9	{gc},{pp}.SRW_FDC_com-SRW_PB	;command for fdc
;tbc0
;tx0
	hlt9

        
            End

$ 