VAXBIOS              :g)      FONT    SYS&            (  KEYTAB  SYS&              IO      SYS'      [?3h
$ TYPE diskreg.asm

; [bios.apricot]diskreg.asm
	title	'[bios.apricot]diskreg.asm'



        include 'legal.asi'




;************************************************************************
;*                                                                      *
;*                         D I S K R E G                                *
;*                                                                      *
;*      FS_INIT      - Initialisation of status array (FS_stat).        *
;*      FR_q_swapped - Tests if disk has been swapped.                  *
;*      FR_time_out  - Unloads head for scheduler.                      *
;*	int_229	     - disk protection interface			*
;*                                                                      *
;*                     --------------------                             *
;*                                                                      *
;*      PROGRAMMER:     Nick Wilson, G. Kurth, and Ray Woolcock.        *
;*      FILE NAME :     [bios.apricot.rom]diskreg.asm                   *
;*      MODIFICATIONS:  apricot version 15/8/84 GK                      *
;*			Deamon disable flag 5/2/85 GK			*
;*                      Disk protection interface GK 18/3/85		*
;*                                                                      *
;************************************************************************
  page


        nolist
        include 'ioregs.asi'
        include 'mserror.asi'
	include	'genequ.asi'
	include 'iop.asi'
        list


        Global  CodeBaseQQ, DataBaseQQ, STKbaseQQ


        Assume  CS:CodeBaseQQ, DS:DataBaseQQ




;************************************************************************
;****************************  DATA SECTION  ****************************
;************************************************************************


        Section diskreg.data, Align (2), Class=DataQQ

	GLOBAL	CNF_f_deamon	;deamon disable flag
	GLOBAL	B_FLP_NUM	;number of floppy drives
        Global  B_FLP_TYP

	GLOBAL	FTR_PB		;TRACK READ 8089 BLOCK
	GLOBAL	FTR_offset
	GLOBAL	FTR_dataseg
	GLOBAL	FTR_fdc_com

	GLOBAL	FORMAT_PB	;TRACK WRITE 8089 BLOCK
	GLOBAL	FMT_offset
	GLOBAL	FMT_dataseg
	GLOBAL	FMT_fdc_com

	GLOBAL	SRW_PB		;SECTOR READ/WRITE 8089 BLOCK
	GLOBAL	SRW_offset
	GLOBAL	SRW_segment
	GLOBAL	SRW_8089_cc
	GLOBAL	SRW_FDC_com


        INCLUDE 'FSstat.asi'
;
DOP_DRV		BLOCK	1	;DRIVE NUMBER
DOP_COM		BLOCK	1	;COMMAND
DOP_TRK		BLOCK	1	;TRACK
DOP_HEAD	BLOCK	1	;HEAD
DOP_SEC		BLOCK	1	;SECTOR
DOP_SECL	BLOCK	1	;SECTOR LENGTH FLAG
DOP_BUFO	BLOCK	2	;BUFFER OFFSET
DOP_BUFS	BLOCK	2	;BUFFER SEGMENT

;
FS_LOGAD	BLOCK	2		;OFFSET FOR CURRENT LOGGING TABLE
					;SET UP BY DO_SELECT
; DISK LOGGING TABLE
FS_logtab				;label for start of table
FS_log0		BLOCK	4		;table for drive 0
FS_log1		BLOCK	4		;table for drive 1


FS_active       BLOCK   1               ;floppy driver active flag
FS_sel          BLOCK   1               ;floppy selected drive flag
FZ_drive	BLOCK	2		;temp drive save
FZ_stat		BLOCK	1		;temp status save

;       FS_stat - disk status array:-
;
FS_stat 
FS_stat0
d0_on_line      BLOCK   1       ;on_line        )
d0_swapped      BLOCK   1       ;swapped        )       Drive 0
d0_track        BLOCK   1       ;track          )
d0_head		BLOCK	1	;head loaded	)

FS_stat1
d1_on_line      BLOCK   1       ;on_line        )
d1_swapped      BLOCK   1       ;swapped        )       Drive 1
d1_track        BLOCK   1       ;track          )
d1_head		BLOCK	1	;head		)

d2_on_line      BLOCK   1       ;on_line        )
d2_swapped      BLOCK   1       ;swapped        )       Drive 2 (dummy)
d2_track        BLOCK   1       ;track          )
d2_head		BLOCK	1	;head		)




;************************************************************************
;**************************  CODE SECTION  *****************************
;************************************************************************


        Section Diskreg.code, Align (2), Class=InstrQQ


; Internal Globals

        Global  INT_229
        Global  FR_q_swapped
	Global	FS_INIT
	Global	FR_time_out

; External Globals

	Global	SH_wake_me_up
	Global	DO_select_drive
	Global	DO_hd_load
	Global	DO_seek
	Global	DRW_wait_89
	Global	DO_wait_FDC
        Global  DO_HD_unload

  page
;************************************************************************
;************************  SUBROUTINE FR_TIME_OUT  **********************
;************************************************************************
;
; FR_time_out    - called by sheduler after 1 second non-disk use
;                 unloads head on drive.
;		Drive number in AX


FR_time_out
;IF DEAMON CURRENTLY DISABLED DO NOT UNLOAD
	cmpb	CNF_f_deamon,#1		;deamon disabled
	je	FR_time_0
	
;IF DISK SYSTEM IS ACTIVE: DO NOT UNLOAD HEAD
        cmpb    FS_active,#0            ;is file system active?
        je      FR_Time_3		;no - proceed

;FILE SYSTEM CURRENTLY ACTIVE - DO NOT CHECK
FR_time_0
	mov	bx,#FR0_sleeper		;load ID for drive 0
	cmp	al,#1			;was it drive 1?
	jne	FR_Time_1		;no - leave as 0
	mov	bx,#FR1_sleeper		;set up Drive 2 ID
FR_Time_1
	push	bx			;send ID
	mov	bx,#50			;1 second timeout
	cmpb	FS_sel,al		;current drive?
	je	FR_Time_2		;yes - restart timer - 1 second
	mov	bx,#5			;100ms count
FR_Time_2
	push	bx
	call	SH_wake_me_up		;call scheduler
	ret				;done
;
;UNLOAD THE HEAD ON REQUESTED DRIVE
FR_Time_3
	lea	bx,FS_stat		;point at status array
	cmp	al,#1			;drive 1?
	jne	FR_Time_4		;no - must be zero
	add	bx,#D_length		;adjust for drive 2
FR_Time_4
	mov	FZ_drive,ax		;save drive for later
	
; SET HEAD UNLOADED IN STATUS ARRAY
	xor	ax,ax
	xchg	D_head[bx],al		;set head load to zero & get old one
	push	bx			;save index
	push	ax			;and old head load
	push	FZ_drive		;send drive
	call	DO_select_drive		;and select it

; GET DRIVE STATUS AND CHECK FOR CHANGE
	in	al,#FDC_STAT		;get status
	movb	FZ_stat,al		;save for later
	pop	ax
	pop	bx			;get back old load & array
	cmp	Al,Ah			;was head loaded?
	jne	FR_Time_nul		;no - no UNLOAD
	
;UNLOAD THE HEAD ON SELECTED DRIVE
	pushf
	cli
	in	al,#PIO_PORB		;get current head load status
	and	al,#0FBh		;clear head load
	out	#PIO_PORB,al		;eh voila!
	popf
	cmpb	B_FLP_TYP,#0		;70 track drive?
	jne	FR_Time_nul		;no - skip delay
	movb	cl,#200			;200uS delay
	shl	cx,cl

;HAVE WE JUST GONE OR COME (ON LINE THAT IS)
FR_Time_nul
	testb	FZ_stat,#080h		;check ready bit in status
	jz	FR_Time_col		;yes - ready - on line
	movb	D_swapped[bx],#1	;swapped
	jmp	FR_Time_ex		;done - restart timer

;COME ON LINE  - LEAVE STATUS
FR_Time_col
	
; SET OFF TIMER TO RE-CALL IN 1 SECOND
FR_Time_ex
	mov	bx,#FR0_sleeper		;load ID for drive 0
	cmpb	FZ_drive,#1		;was it drive 1?
	jne	FR_Time_ex1		;no - leave as 0
	mov	bx,#FR1_sleeper		;set up Drive 2 ID
FR_Time_ex1
	push	bx			;send ID
	mov	ax,#50			;1s count
	push	ax
	call	SH_wake_me_up		;call scheduler
	ret				;done
;
;
  page
;************************************************************************
;************************  SUBROUTINE  FR_q_swapped  ********************
;************************************************************************
;
; FIND OUT WHETHER THE DISK HAS BEEN SWAPPED OR NOT.
; This routine is called by diskcon in order to do a media check
;
; On Entry:
;       al = drive number to check
;
; On Exit:
;       al = 0 if disk has not been changed
;          = 1 if disk has been changed
;          = 2 if drive could not be selected (drive not ready)
;



FR_q_swapped


;FLAG DRIVE AS ACTIVE
        movb    FS_active,#1            ;we're active now


;SELECT THE REQUESTED DRIVE
        xor     ah,ah                   ;save drive number
        push    ax                      ;


        push    ax                      ;send drive number to routine
        call    DO_select_drive         ;call select procedure
        call    DO_wait_FDC             ;wait around


        pop     ax                      ;restore drive number


;POINT TO STATUS ARRAY FOR REQUESTED DRIVE (drive number in ax)
        mov     bx,#FS_stat-DatabaseQQ  ;point at status array
        cmp     al,#1                   ;drive 1 requested ?
        jb      drive_0                 ;no, jump

        ja      not_on_line             ;BAD DRIVE NUMBER - say not on line

        add     bx,#D_length            ;adjust for drive 1
drive_0


;IF DRIVE NOT ON-LINE: SAY DISK SWAPPED
        in      al,#FDC_STAT            ;drive ready ?
        test    al,#80H                 ;
        jz      on_line                 ;yes, jump


        movb    D_swapped[bx],#1        ;drive off-line: say swapped
        jmpsh   not_on_line             ;
on_line


;DISK ON-LINE: TEST IF THE MEDIA HAS BEEN CHANGED, AND RESET SWAPPED STATUS
        xor     ax,ax                   ;FIRST TEST SOFTWARE SWAP
        xchg    al,D_swapped[bx]        ;reset swapped status & get previous
        cmp     al,ah                   ;was disk swapped?
        je	disk_not_swapped	;no, jump

;DISK HAS BEEN CHANGED:
disk_swapped

;RETURN STATUS: MEDIA CHANGED
        mov     al,#1                   ;return DISK CHANGED code


;RETURN TO CALLING PROGRAM
dquit   movb    FS_active,#0            ;flag: no longer active


        ret                             ;RETURN


;DISK NOT ON-LINE (OR INVALID DISK NUMBER): RETURN ERROR
not_on_line
        mov     al,#2                   ;return DRIVE NOT READY code
        jmpsh   dquit                   ;


;MEDIA NOT SWAPPED: RETURN 'NOT SWAPPED CODE'
disk_not_swapped
        mov     al,#0                   ;return DISK NOT CHANGED code
        jmpsh   dquit                   ;
  page
;***************************************************************************
;****************************** FS_INIT ************************************
;***************************************************************************
;  Initialise the disk status array (FS_stat) for both drives to say:
;               Track 0,
;               Disk Swapped,
;               Disk not on-line.
;		Head unloaded
;


FS_init
        movb    FS_active,#0            ;we are not active
        movb    FS_sel,#2               ;say dummy currently selected

	mov	BX,#(FS_LOGTAB-DatabaseQQ)
	MOV	FS_LOGAD,BX
	XOR	AX,AX
	MOV	[BX],AX			;CLEAR OUT LOGGING TABLES
	MOV	2[BX],AX
	MOV	4[BX],AX
	MOV	6[BX],AX

;INITIALISE DRIVE 0 STATUS ARRAY
        mov     bx,#FS_stat-databaseqq  ;set up offset
        call    put_in_bits


;INITIALISE DRIVE 1 STATUS ARRAY
        add     bx,#D_length            ;next one
        call    put_in_bits
        add     bx,#D_length            ;and again


;DROP THROUGH TO SUBROUTINE TO INITIALISE ARRAY AND EXIT



;SUBROUTINE TO INITIALISE ARRAY POINTED TO BY BX
put_in_bits
        movb    D_on_line[bx],#0        ;NOT on line
        movb    D_track[bx],#0          ;track zero
        movb    D_swapped[bx],#1        ;we are swapped
	movb	D_head[bx],#0		;head unloaded
        ret 



	page
;************************************************************************
;*                                                                      *
;*                         D I S K P R O T                              *
;*                                                                      *
;*	INT E5H HANDLER FOR DISK PROTECTION CALLS			*
;*                                                                      *
;*                                                                      *
;************************************************************************


;************************************************************************
;**************************  CODE SECTION  *****************************
;************************************************************************

;************************************************************************
;************************  INT_229 - INT E5 HANDLER  ********************
;************************************************************************
;
;	INT_229	- Int E5h entry point for protection calls
;		On entry:
;		AL	= Drive 0 or 1
;		AH	= Command -	1 = read track
;					2 = write track
;					3 = read sector
;					4 = write sector
;		BL	= Track number
;		BH	= Head number
;		CL	= Sector number
;	(******	CH	= Sector size flag *****)
;		DS:SI	= Data buffer
;
;		On exit AX = status
;
INT_229
	PUSH	BP
	PUSH	DS
	PUSH	ES
	MOV	DX,#BITS(DATABASEQQ,4,16)
	MOV	ES,DX
	MOV	DI,SS
	CMP	DI,DX
	JE	INT_229_S
	MOV	BP,SP
	MOV	SS,DX
	MOV	SP,#(STKBASEQQ-DATABASEQQ)
	PUSH	DI			;- OLD SS
	PUSH	BP			;- OLD SP
	CALL	DO_PROTECT
	POP	BP
	POP	SS
	MOV	SP,BP
INT_229_X
	POP	ES
	POP	DS
	POP	BP
	IRET
INT_229_S
	CALL	DO_PROTECT
	JMPSH	INT_229_X

;***********************************************************************
;*****************  DO_PROTECT - PROTECTION CALL HANDLER  **************
;***********************************************************************
;
;	Entry - Same as INT 229 but with segments set up
;		bios data segment value in DX, buffer segment still
;		in DS.
;	Exit - Same as INT 229
;
DO_protect

	MOV	DI,DS			;SAVE BUFFER SEG
	MOV	DS,DX			;set up DS
	MOV	DOP_BUFS,DI		;SET UP BUFFER SEG
	STI				;INTs OK now

	MOV	DOP_DRV,AX		;set up drive/comm
	MOV	DOP_TRK,BX		;set up track/head
	MOV	DOP_SEC,CX		;set up sector/size
	MOV	DOP_BUFO,SI		;set up buffer offset	

	CMP	AL,B_FLP_NUM		;valid drive?
	JAE	DO_protect_f		;no - abort

	CMP	AH,#0			;COMM 0?
	JE	DO_protect_f		;sorry
	CMP	AH,#4			;valid 1-4?
	JBE	DO_prot			;valid - go do it

DO_protect_f				;bad command or other nasty
	MOV	AX,#0FFFFH

DO_protect_x
	CLI				;done - disable ints
	RET				;return status in AX

DO_prot_fail				;failed op
	IN	AL,#FDC_STAT		;get FDC status
	MOV	AH,#80H			;indicate fault
DO_protect_done				;Ok op
; PERFORM LOGGING OPERATION - ASSUME FS_LOGAD CORRECTLY SET
	MOV	BX,FS_LOGAD		;get log table for current drive
	MOV	DL_STAT[BX],AL		;put FDC status in table
	PUSH	AX			;save Status
	IN	AL,#FDC_SEC		;get sector register
	MOV	DL_SECTOR[BX],AL	;set up in logging table
	MOV	AL,DOP_HEAD		;get head
	MOV	DL_HEAD[BX],AL		;set up in logging table
	IN	AL,#FDC_TRK		;get track register
	MOV	DL_TRACK[BX],AL		;set up track in logging table

;RESTART SLEEPER FOR DRIVE
	MOV	AX,#FR0_sleeper		;load up sleeper ID for 0
	CMPB	DOP_DRV,#0		;drive 0?
	JE	DO_prot_dn1		;yes
	MOV	AX,#FR1_sleeper		;load up sleeper ID for 1
DO_prot_dn1
	PUSH	AX			;send ID
	MOV	AX,#50			;1 second timeout
	PUSH	AX
	CALL	SH_wake_me_up		;kick off sheduler
	MOVB	FS_active,#0		;not active

; RETURN FDC AND OPERATION STATUS
	POP	AX			;get back status
	JMPSH	DO_protect_x		;done

DO_prot
; STEP 1 - SELECT DRIVE
	MOVB	FS_active,#1		;say active
	MOV	AL,DOP_DRV		;get drive
	CBW
	PUSH	AX			;send drive
	CALL	DO_select_drive		;select it
	CMP	AX,#MSE_OK		;all well?
	JNE	DO_prot_fail		;sorry - abort

; STEP 2 - LOAD HEAD
	MOV	AX,#1			;pretend we are writing
	PUSH	AX
	MOV	AX,#255			;pretend going a long way
	PUSH	AX
	CALL	DO_hd_load		;load the head	
        
; STEP 3 - SEEK DESIRED TRACK - ASLO CHECKS IF ON LINE
	MOV	AL,DOP_TRK		;get track
	MOV	AH,#1			;say we are writing
	PUSH	AX			;send it
	CALL	DO_seek			;seek it
	CMP	AX,#MSE_OK		;all well?
	JNE	DO_prot_fail		;no - sorry

; STEP 4 - DETERMINE OPERATION & PERFORM
	call	DRW_wait_89		;wait for 8089 not busy
	call	DO_wait_FDC		;wait for FDC not busy
	MOV	AL,DOP_COM		;get command
	CMP	AL,#1			;Read Track?
	JNE	DO_prot_1		;no
;
;	*** READ TRACK ***
;
	mov	ax,DOP_BUFO		;set up address for 8089 code
	mov	FTR_offset,ax
	mov	ax,DOP_BUFS
	mov	FTR_dataseg,ax
	mov	al,DOP_HEAD		;set up head in command
	and	al,#1
	shl	al,#1
	or	al,#11100100b		;read track command + 15ms delay
	mov	FTR_fdc_com,al		;pass to 8089 array
	mov	dx,ds			;save ds
	mov	ax,#50h			;point at ccb
	mov	ds,ax
	mov	4,dx			;store BIOS ds
	movw	2,#(FTR_PB-DatabaseQQ)	;8089 parameter block
	movw	6,#0EE03h		;set busy
	mov	ds,dx			;restore ds
	out	#IOP_CH1,al		;kick 8089
	call	DRW_wait_89		;wait for 8089
	call	DO_wait_FDC		;wait for FDC
;
	JMP	DO_prot_ex		;done - clean up & return
;
DO_prot_1
	CMP	AL,#2			;Write track?
	JNE	DO_prot_2		;no
;
;	*** WRITE TRACK ***
;
	mov	ax,DOP_BUFO		;set up address for 8089 code
	mov	FMT_offset,ax
	mov	ax,DOP_BUFS
	mov	FMT_dataseg,ax
	mov	al,DOP_HEAD		;set up head in command
	and	al,#1
	shl	al,#1
	or	al,#11110100b		;write track command + 15ms delay
	mov	FMT_fdc_com,al		;pass to 8089 array
	mov	dx,ds			;save ds
	mov	ax,#50h			;point at ccb
	mov	ds,ax
	mov	4,dx			;store BIOS ds
	movw	2,#(FORMAT_PB-DatabaseQQ)	;8089 parameter block
	movw	6,#0EE03h		;set busy
	mov	ds,dx			;restore ds
	out	#IOP_CH1,al		;kick 8089
	call	DRW_wait_89		;wait for 8089
	call	DO_wait_FDC		;wait for FDC
;	
	JMP	DO_prot_ex
;
DO_prot_2
	CMP	AL,#3			;Read Sector?
	JNE	DO_prot_3		;no
;
;	*** READ SECTOR ***
;
	mov	ax,DOP_BUFO		;set up address for 8089 code
	mov	SRW_offset,ax
	mov	ax,DOP_BUFS
	mov	SRW_segment,ax
	mov	ax,#(CC_p2m!CC_srcsync!CC_tbc0!CC_tx0!CC_srcGA)
	mov	SRW_8089_cc,ax		;set up CC for 8089
	mov	al,DOP_HEAD		;set up head in command
	and	al,#1
	shl	al,#1
	or	al,#10001000b		;read sector command, no delay
	mov	SRW_FDC_com,al		;pass to 8089 array
	mov	dx,ds			;save ds
	mov	ax,#50h			;point at ccb
	mov	ds,ax
	mov	4,dx			;store BIOS ds
	movw	2,#(SRW_PB-DatabaseQQ)	;8089 parameter block
	movw	6,#0EE03h		;set busy
	mov	ds,dx			;restore ds
	MOV	AL,DOP_SEC		;GIVE SECTOR NUMBER TO FDC
	OUT	#FDC_SEC,AL
	out	#IOP_CH1,al		;kick 8089
	call	DRW_wait_89		;wait for 8089
	call	DO_wait_FDC		;wait for FDC
;
	JMP	DO_prot_ex
;
DO_prot_3
	CMP	AL,#4			;Write Sector?
	JNE	DO_prot_ex		;invalid command?!?
;
;	*** WRITE SECTOR ***
;
	mov	ax,DOP_BUFO		;set up address for 8089 code
	mov	SRW_offset,ax
	mov	ax,DOP_BUFS
	mov	SRW_segment,ax
	mov	ax,#(CC_m2p!CC_dstsync!CC_tbc0!CC_tx0!CC_srcGB)
	mov	SRW_8089_cc,ax		;set up CC for 8089
	mov	al,DOP_HEAD		;set up head in command
	and	al,#1
	shl	al,#1
	or	al,#10101000b		;write sector command, no delay
	mov	SRW_FDC_com,al		;pass to 8089 array
	mov	dx,ds			;save ds
	mov	ax,#50h			;point at ccb
	mov	ds,ax
	mov	4,dx			;store BIOS ds
	movw	2,#(SRW_PB-DatabaseQQ)	;8089 parameter block
	movw	6,#0EE03h		;set busy
	mov	ds,dx			;restore ds
	MOV	AL,DOP_SEC		;GIVE SECTOR NUMBER TO FDC
	OUT	#FDC_SEC,AL
	out	#IOP_CH1,al		;kick 8089
	call	DRW_wait_89		;wait for 8089
	call	DO_wait_FDC		;wait for FDC
;
DO_prot_ex
	IN	AL,#FDC_STAT		;get FDC status
	MOV	AH,#0			;say operation performed
	JMP	DO_protect_done		;clean up & return

	page
;**************************************************************************
;	ROM ENTRY POINT FOR ROM BIOS'S ONLY
;
;;	SECTION disprot.abs, Absolute
;;	ORG	0FFFD0H
;
;;	Assume 		;NOTHING
;
; entrypoint
;;	PUSHF				;SIMULATE INTERRUPT
;;	CALLS	INT_229,CODEBASEQQ	;CALL INTERRUPT HANDLER
;;	RETS				;AND RETURN TO CALLER
;
	End



$ 