/*
======================== Supplier Module C Function ===========================
FILENAME = dos_call.c
AUTHOR   = dave barton
VERSION  = 1.1.0.0
LAST MOD = 230491
===============================================================================
*/

#include <dos.h>
#include <errno.h>
#include <io.h>

struct	find_t in_info;

/***
	search directory for file,
	return first in list the directory list produced.
	:	CALL GET_FIRST( search, len) RETURNING filename
***/
get_first( nargs)
int nargs;
{
int 	in_len;
char	in_file[ 63];

	in_info.name[ 0] =( (char) 0);

	if( nargs == 2) {
		popint( &in_len);			/* get filespec length */
		in_len++;				/* null terminated */
		popquote( in_file, in_len);		/* get filespec */

		if( _dos_findfirst( in_file, _A_NORMAL, &in_info) !=0) {
			in_info.name[ 0] =( (char) 0);
		} /* if */
	} /* if */	

	retquote( in_info.name);
	return( 1);
}

/***
	return the next file in the directory list created
	by get_first()
	:	CALL GET_NEXT() RETURNING filename
***/
get_next( nargs)
int nargs;
{
	in_info.name[ 0] =( (char) 0);

	if( nargs == 0) {
		if( _dos_findnext( &in_info) !=0) {
			in_info.name[ 0] =( (char) 0);
		} /* if */
	} /* if */	

	retquote( in_info.name);
	return( 1);
}
/***
	rename a dos file.
	:	CALL RENAME_FILE( from, len, to, len)
***/
rename_file( nargs)
int nargs;
{
int	to_len;
int	from_len;
char	to_file[ 63];
char	from_file[ 63];

	if( nargs ==4) {
		popint( &to_len);
		to_len++;
		popquote( to_file, to_len);
		popint( &from_len);
		from_len++;
		popquote( from_file, from_len);
		rename( from_file, to_file);
	}
return( 0);
}
