/*
======================== Customer Module C Function ===========================
FILENAME = getline.c
AUTHOR   = peter
VERSION  = 1.6.0.0
LAST MOD = 91/03/14
===============================================================================
FUNCTION getline()
DESCRIPTION :
  getline.c                                                        
                                                                   
  This function returns a line of standard input to informix 4gl   
                                                                   
  It should be called like:-                                       
                                                                   
         CALL getline() RETURNING  line1 ,retcode
                                                                   
                                                                   
   Where line1 being the returned line 

   line1 should be of size 512
                                                                   
return status  can be

	0 = line read ok
	1 = end of line not reached reread
	100 = notfound eof


===============================================================================
*/


#include <stdio.h>

extern int status;        /* global value used for return status */

getline(argc)
int argc;
{
static FILE *streamin;
static char oldpath[257];			/* System V PATHMAX */
int slen;
char fullpath[257];			/* System V PATHMAX */
extern FILE *fopen();
extern char *fgets();      /* system call to read for file descriptor*/


	if (argc == 2 )
	{
		char buffer[513];

		popint(&slen);
		slen++;
	    popquote(fullpath, slen);

		if(strcmp(fullpath,oldpath) != 0){

		    if(streamin != (FILE *)0)
			    fclose(streamin);

	    	if((streamin = fopen(fullpath, "r")) == NULL){
		    	status = -4501; 
		    	retquote("");
		    	retint(status);
				return(2);
	
			}

	  		strcpy(oldpath, fullpath);
		}

		if (fgets(buffer, 512, streamin) == NULL)  /*read line check for err/EOF */
		{
			status = 100;                   /* set status = NOTFOUND */
			retquote("");                 /* return NULL, error on read */
			retint(status);                 /* return status value  */
		}
		else
		{
		
			if ( buffer[strlen(buffer)-1] == '\n' ||
				buffer[strlen(buffer)-1] == '\r')   /* remove newline */
			{
				buffer[strlen(buffer) -1]  = '\000';
				status = 0;
			}
			else
				status = 1;                              /* set status = ok */

			retquote(buffer);
			retint(status);                 /* return status value  */
		
		}
	}
	else
	{
		register int loop;
		char rubbish[2];

		for (loop = argc -1; loop; loop--)     /* remove rubbish from stack */
			popquote(rubbish,1);

		status = -4501;                  /* set status = parameter mismatch */
		retquote("");
		retint(status);                 /* return status value  */
	
	}
	return(2);

}


