/*
======================== Customer Module C Function ===========================
FILENAME = s_getenv.c
AUTHOR   = peter
VERSION  = 1.1.0.0
LAST MOD = 91/01/29
===============================================================================
FUNCTION s_getenv()
DESCRIPTION :

	function to return an environment variable to 4GL

	called using

	CALL s_getenv(env_var, length(env_var)) RETURNING p_env retcode

	env_var = environment variable required eg. "PATH"
	lenght(env_var) = length of the environment variable
	p_env = result "failed" if not found
	retcode = TRUE or FALSE depending on result

===============================================================================
*/

#include <stdio.h>
#include <stdlib.h>
#define PASS 1
#define FAIL 0
#define MAXENVNAM	32 /** maximum length of an environment variable name **/

s_getenv(nargs)    /* nargs is the number of arguments 4GL passes  */
int nargs;
{
long len;
char envname[32];
char *envp;
extern char *getenv();

	if ( nargs != 2 )   /* there should be 2 arguments   */
	{
		fprintf (stderr,
				" wrong number of arguments");
		exit(1);
	};

	poplong(&len);             /* get the length of the environment variable */
	len++;                     /* has to be 1 longer cos of null terminator  */

	if ( len > 32 )
	{
		fprintf (stderr,
				"environment variable name too long");
		exit(1);
	};

	popquote(envname,(int)len);   /* get the env variable */

/*  get the environment variable into p NULL if fail */

    envp = getenv(envname);

	if( envp != NULL)
	{
		retint(PASS);       /*push PASS for getting  p */
		retquote(envp);             /*push the actual value of env var */

	} else
	{
		retint(FAIL);               /* push FAIL to indicate failure */
		retquote("failed");      /* cannot pass NULL back so anything ok */
	}

return(2);    /* put 2 variables on stack */
}
