

; [bios.apricot.rom]contab.asm
	Title	'[bios.apricot.rom]contab.asm'
	INCLUDE	'legal.asi'
;****************************************************************************
;*                                                                          *
;*                                                                          *
;*  File name:                      [bios.apricot.rom]contab.asm             *
;*  File status:                                                            *
;*  Host program:                   interim BIOS                            *
;*  Programmer:                     G.Kurth                                 *
;*  Original implementation date:   12-jul-83                               *
;*  Language:                       Tektronix 8086/88 assembler.            *
;*  Project name:                   Cactus BIOS                             *
;*  Other modules referenced:                                               *
;*  Include files referenced:                                               *
;*  Revision history:               Wini/double sided  16-jan-84 GK         *
;*                                  VAX version 2/5/84 GK                   *
;*                                                                          *
;****************************************************************************
;
        PAGE
;
;***************************************************************************
;
;       BIOS configuration table format - loaded from disk in boot process
;       from Track 0, Sector 0, into memory at address given in low RAM
;       address 040AH (double-word pointer).
;       Designed for use by configurator utility for permanent on-disk
;       patches.
;       Table length is 80H bytes and occupies the second 80H bytes of the sector
;       on disk. Therefore any disk modifications MUST preserve the rest of
;       the sector.
;
;	FOR the moment this is kept in the constants area for default
;
;***************************************************************************
;
        name    CONFIGTABLE
;
        global  CodebaseQQ, DatabaseQQ
;
        assume  CS:CodebaseQQ, DS:DatabaseQQ
;
        section CONFIGTABLE.DATA, align(16), class=ConstQQ
;
        PAGE
;
;       Declarations of internal constants:
;
        GLOBAL  CNFtab_base                     ;base address of table
;
;               VARIABLE NAME           OFFSET  ACTION
;
;*****************************************************************************
;       Section 1 - Systems unit        (offset 0)
;
        GLOBAL  CNF_ver_lo              ;00H	version
	GLOBAL  CNF_ver_hi              ;01H    version
        GLOBAL  CNF_diagflag            ;02H    Global diagnostics (0=off, 1=on)
        GLOBAL  CNF_lst_dev             ;03H    List device (0=parallel, 1=serial)
        GLOBAL  CNF_Bell_vol            ;04H    Bell volume (0=max, 15=min)
        GLOBAL  CNF_cache_on            ;05H    Disk Cache on/off
        GLOBAL  CNF_graphics_on         ;06H    Graphics on/off
        GLOBAL  CNF_DOS_sec             ;0AH    DOS start sector
        GLOBAL  CNF_FONT_sec            ;0CH    FONT start sector
        GLOBAL  CNF_KEYS_sec            ;0EH    KEYTAB start sector


;******************************************************************************
;       Section 2 -Keyboard             (offset 10H)
;
        GLOBAL  CNF_Click_vol           ;10H    Key click volume (0=max, 15=min)
        GLOBAL  CNF_rept_en             ;11H    Auto-repeat master enable (0=off, 1=on )
        GLOBAL  CNF_rept_dly            ;12H    lead-in delay COUNT*20ms (1-255)
        GLOBAL  CNF_rept_int            ;13H    repeat interval of COUNT*20ms (1-255)
        GLOBAL  CNF_Mscrn_mode          ;14H    Microscreen mode (0=time, 1=screen echo)
;
;******************************************************************************
;       Section 3 - Screen              (offset 20H)
;
	GLOBAL	CNF_line_mode		;20H	0=256 line 1=200 line
	GLOBAL	CNF_line_width		;21H	0=80 column 1=40 column
	GLOBAL	CNF_image_off		;22H	0=image used, 1=no image
;
;******************************************************************************
;       Section 4 - Serial Comms        (offset 30H)
;
        GLOBAL  CNF_Tx_brate            ;30H    Tx baud rate
                                                ;1=50, 2=75, 3=110, 4=134.5, 5=150, 6=300
                                                ;7=600, 8=1200, 9=1800, 10=2400, 11=3600
                                                ;12=4800, 13=7200, 13=7200, 14=9600, 15=19200
        GLOBAL  CNF_Rx_brate            ;31H    Rx baud rate (as above)
        GLOBAL  CNF_Tx_bits             ;32H    Transmit bits per char (5 - 8)
        GLOBAL  CNF_Rx_bits             ;33H    Receive bits per char (5 - 8)
        GLOBAL  CNF_stop_bits           ;34H    stop bits (1=1, 2=1.5, 3=2)
        GLOBAL  CNF_parity_chk          ;35H    Receive parity check (0=off, 1=on)
        GLOBAL  CNF_parity_typ          ;36H    parity type
                                                ;(0=none, 1=odd, 2=even, 3=mark, 4=space)
        GLOBAL  CNF_Tx_xonxoff          ;37H    Transmit xon/xoff protocol (0=off, 1=on)
        GLOBAL  CNF_Rx_xonxoff          ;38H    Receive xon/xoff protocol (0=off, 1=on)
        GLOBAL  CNF_xon_char            ;39H    XON character code
        GLOBAL  CNF_xoff_char           ;3AH    XOFF character code
        GLOBAL  CNF_Rx_X_limit          ;3BH    XON/XOFF receive buffer limit
        GLOBAL  CNF_dtr_dsr             ;3DH    DTR/DSR protocol (0=off, 1=on)
        GLOBAL  CNF_cts_rts             ;3EH    CTS/RTS protocol (0=off, 1=on)
        GLOBAL  CNF_CR_null             ;3FH    number of nulls to send after CR (0-255)
        GLOBAL  CNF_FF_null             ;40H    nulls * 10 to send after FF (0-255)
        GLOBAL  CNF_s_cr_lf             ;41H    insert LF after CR
        GLOBAL  CNF_S_BIOSERR           ;42H    bios error reporting
        
;******************************************************************************
;       Section 5 - Parallel Comms      (offset 50H)
;
        GLOBAL  CNF_p_cr_lf             ;50H    auto LF after CR (0=off, 1=0n)
        GLOBAL  CNF_select              ;51H    select line support (0=off, 1=on)
        GLOBAL  CNF_pe                  ;52H    paper empty support (0=off, 1=on)
        GLOBAL  CNF_fault               ;53H    fault line support (0=off, 1=0on)
        GLOBAL  CNF_P_BIOSERR           ;54H    printer bios error reporting
        
;*****************************************************************************
;       Section 6 - Winchester Disk     (offset 60H)
;
	GLOBAL	CNF_wini_wpre		;60H	write precomp cylinder+1
	GLOBAL	CNF_wini_park		;6EH	parking disable (0=park, FF=no)
	GLOBAL	CNF_wini_form		;6FH	format protect (=normal, FF=prot)
;
;*****************************************************************************
;       Section 7 - RAM Disk            (offset 70H)
;
	Global	CNF_dummy_sec		;70H	dummy sector size for loadable
					;	drivers
;
;*****************************************************************************
;
;
        PAGE
;
;       Configuration constants definition area
;
CNFtab_base                             ;base address of config table
;
;       Section 1 - Systems unit        (offset 0)
;
CNF_ver_lo      BYTE    1               ;low version number
CNF_ver_hi      BYTE    1               ;high version number
CNF_diagflag    BYTE    0               ;diagnostics off
CNF_lst_dev     BYTE    0               ;parallel list device
CNF_Bell_vol    BYTE    4               ;bell volume 8 dB down
CNF_cache_on    BYTE    1               ;cache on/off
CNF_graphics_on BYTE    0               ;Graphics on/off
                BYTE    0,0,0
CNF_DOS_sec     WORD    125             ;DOS start sector
CNF_FONT_sec    WORD    13              ;FONT start sector
CNF_KEYS_sec    WORD    33              ;KEYTAB start sector
;
;       Section 2 - Keyboard            (offset 10H)
;
CNF_Click_vol   BYTE    8               ;Key click volume 16 dB down
CNF_rept_en     BYTE    1               ;Auto-repeat master enable
CNF_rept_dly    BYTE    25              ;lead-in delay of 25*20ms = 500ms
CNF_rept_int    BYTE    5               ;repeat interval of 5*20ms = 100ms
CNF_Mscrn_mode  BYTE    0               ;Microscreen in Time&Date mode
;
                BYTE    0,0,0
                BYTE    0,0,0,0,0,0,0,0
;
;       Section 3 - Screen              (offset 20H)
;
CNF_line_mode	BYTE	0		;256 line mode
CNF_line_width	BYTE	0		;80 column mode
CNF_image_off	BYTE	0		;image used
                BYTE    0,0,0,0,0
                BYTE    0,0,0,0,0,0,0,0
;
;       Section 4 - Serial comms        (offset 30H)
;
CNF_Tx_brate    BYTE    14              ;Tx = 9600 baud
CNF_Rx_brate    BYTE    14              ;Rx = 9600 baud
CNF_Tx_bits     BYTE    8               ;8 bits per char
CNF_Rx_bits     BYTE    8               ;8 bits per char
CNF_stop_bits   BYTE    2               ;1 1/2 stop bits
CNF_parity_chk  BYTE    0               ;parity check off
CNF_parity_typ  BYTE    0               ;no parity
CNF_Tx_xonxoff  BYTE    0               ;no transmit xon/xoff
CNF_Rx_xonxoff  BYTE    0               ;no receive xon/xoff
CNF_xon_char    BYTE    11H             ;XON character code
CNF_xoff_char   BYTE    13H             ;XOFF character code
CNF_Rx_X_limit  WORD    30              ;XON/XOFF receive buffer limit
CNF_dtr_dsr     BYTE    0               ;no DTR/DSR protocol
CNF_cts_rts     BYTE    0               ;no CTS/RTS protocol
CNF_CR_null     BYTE    0               ;number of nulls to send after CR
CNF_FF_null     BYTE    0               ;nulls * 10 to send after FF
CNF_s_cr_lf     BYTE    0               ;auto lf after cr
CNF_S_BIOSERR   BYTE    0               ;error reporting

;
                BYTE    0,0,0,0,0
                BYTE    0,0,0,0,0,0,0,0
;
;
;       Section 5 - Parallel comms      (offset 50H)
;
CNF_p_cr_lf     BYTE    0               ;no auto LF after CR
CNF_select      BYTE    0               ;select line not supported
CNF_pe          BYTE    0               ;paper empty not supported
CNF_fault       BYTE    0               ;fault line not supported
CNF_P_BIOSERR   BYTE    0               ;error reporting

                BYTE    0,0,0
                BYTE    0,0,0,0,0,0,0,0
;
;       Section 6 - Winchester          (offset 60H)
;
CNF_wini_wpre	BYTE	0		;write precomp cylinder + 1
                BYTE    0,0,0,0,0,0,0
                BYTE    0,0,0,0,0,0
CNF_wini_park	BYTE	0		;allow parking of winchester
CNF_wini_form	BYTE	0		;allow formatting of wini
;
;       Section 7 - RAM disk            (offset 70H)
;
CNF_dummy_sec	WORD	0		;no dummy size
                BYTE    0,0,0,0,0,0
                BYTE    0,0,0,0,0,0,0,0
;
;
        END


$ 