      

; [bios.apricot]diskfrm.asm
;
        INCLUDE 'legal.asi'
;************************************************************************
;*                                                                      *
;*       MODULE:        [bios.apricot]diskfrm.asm                       *
;*       PROGRAMMER:    G. Kurth                                        *
;*       STATUS:        Test Version                                    *
;*       IMPLEMENTED:   3-Feb-84                                        *
;*       MODIFICATIONS: apricot version 16-mar-84 R.J.W.                *
;*			VAX version 2/5/84 GK				*
;*                      DMA version 3/5/84 rjw                          *
;*			Apricot version created from activm 15/8/84 GK  *
;*									*
;************************************************************************
;
;       DISKFRM -      FORMATS ENTIRE DISK FOR apricot WITH DMA CONTROLLER
;		            70 or 80 track; single or double sided.
;
;------------------------------------------------------------------------

        INCLUDE 'mserror.asi'
	INCLUDE 'genequ.asi'
        INCLUDE 'ioregs.asi'
        
        Global  CodebaseQQ, DatabaseQQ
        
        Assume  CS:CodebaseQQ, DS:DatabaseQQ, SS:DatabaseQQ
        
        Section Diskfrm.data, Align(2), Class=DataQQ
        
        INCLUDE 'FSstat.asi'

	Global	FORMAT_PB, FMT_offset, FMT_dataseg, FMT_FDC_com
	Global	FMT_drive
	Global	CNF_diagflag        
        Global  B_FLP_TYP
;
FMT_error       BLOCK   2       ;error status
FMT_stat        BLOCK   2       ;save of status array offset for FMT_drive
FMT_drive	BLOCK	2	;drive to format
FMT_trk         BLOCK   1       ;current track save
FMT_hd          BLOCK   1       ;current head save
FMT_sides       BLOCK   1       ;number of sides flag
FMT_tracks      BLOCK   1       ;number of tracks flag
head_mask	BLOCK	1	;temporary head mask for format command
;
;----------------------------------------------------------------------
;
        Section Diskfrm.code, Align(1), Class=InstrQQ
;
;----------------------------------------------------------------------
; TRKINIT(type:word):word - format selected format disk of type passed
;                               and return error status
;
; On Entry:
;	B_FLP_TYP set up from restart
;
;	FMT_drive   = drive number to format
;	FMT_offset  = offset  of 7000 byte buffer
;	FMT_dataseg = segment of 7000 byte buffer
;	   [sp+2]   = disk type
;

        Global  TRKINIT, SH_wake_me_up
        Global  DO_select_drive, DO_on_line, DO_restore
        Global  DO_seek, DIO_wait15
        Global  DO_wait_FDC, DO_hd_load, DRW_wait_89
;
TRKINIT


;IF DISK TYPE IS INCOMPATIBLE WITH DRIVE TYPE: EXIT WITH ERROR CODE
        mov     bp,sp
        mov     ax,2[bp]                ;get disk type
        cmpb    FMT_drive,#1            ;check if valid drive
        ja      TRKINIT_0               ;no - exit
        cmpb    al,B_FLP_TYP            ;valid type for drives?
        jbe     TRKINIT_1               ;yes - skip
TRKINIT_0
        movw    FMT_error,#MSE_failure  ;say failed
TRKINIT_X
        movw    ax,FMT_error            ;get error status
        ret     #2                      ;return error status in ax

TRKINIT_1                               ;OK - we have a valid type


;SET UP INTERNAL REGISTERS FOR SIDE AND TRACK COUNT
        movb    FMT_sides,#1            ;set up default sides info
        movb    FMT_tracks,#70          ;and default tracks
        cmp     al,#1                   ;is it an 80 track SS?
        je      TRKINIT_2               ;yes - set up 80 track
        cmpb    al,#2                   ;is it an 80 track DS?
        jne     TRKINIT_3               ;no - leave default 70 track SS
        movb    FMT_sides,#2            ;two sides
TRKINIT_2
        movb    FMT_tracks,#80          ;80 tracks


;WAIT UNTIL FILE SYSTEM IS NOT ACTIVE
TRKINIT_3
        pushf
        cli                             ;make sure we are alone
        cmpb    FS_active,#0            ;is file system active?
        jz      TRKINIT_4               ;no - we can have it
        popf
        nop                             ;let whoever was playing in
        jmpsh   TRKINIT_3               ;and try again
TRKINIT_4
        movb    FS_active,#1            ;set file system active
        popf                            ;and restore interrupts




;POINT TO FS_STAT (DISK STATUS ARRAY) FOR DRIVE TO BE FORMATTED
        movw    bx,#FS_stat-DatabaseQQ  ;set up array for disk 0
        cmpw	FMT_drive,#1            ;drive 1
        jne     TRKINIT_5               ;no - must be zero - skip
        add     bx,#D_length            ;adjust offset
TRKINIT_5
        movw    FMT_stat,bx             ;save address for later

;SELECT THE REQUESTED DRIVE
        push    FMT_drive               ;send drive number
        call    DO_select_drive         ;try to select the drive


;IF NOT SELECTED OK: EXIT WITH ERROR CODE
        cmp     ax,#MSE_OK              ;all well?
        je      TRKINIT_6               ;yes, jump


;EXIT (ax = disk error code)
TRKINIT_EX
	movw    FMT_error,ax            ;set up error
        movw    bx,FMT_stat             ;get status array for drive
        movb    D_swapped[bx],#1        ;set swapped status
	movw	ax,#FR0_sleeper		;set up for drive 0
	cmpw	FMT_drive,#1		;drive 1?
	jne	TRKINIT_NW		;no - must be 0
	movw	ax,#FR1_sleeper		;drive 2 ID
TRKINIT_NW
	push	ax			;send id
	mov	ax,#50
	push	ax			;send 1 sec timeout
	call	SH_wake_me_up		;set off head load timeout
	movb    FS_active,#0            ;say done with file system
        jmp     TRKINIT_X               ;exit


;IF DRIVE IS NOT READY: EXIT WITH ERROR CODE
TRKINIT_6                               ;we have selected the drive
        call    DO_on_line              ;on line?
        cmp     ax,#MSE_OK
        jne     TRKINIT_EX              ;no - give - up


;IF CANNOT RESTORE DISK: EXIT WITH ERROR CODE
        call    DO_restore              ;restore the diskipoos
        cmp     ax,#MSE_OK              ;all well?
        jne     TRKINIT_EX              ;no - give up


;LOAD THE HEAD
        xorw    ax,ax
        movb    al,#1                   ;set ax = 1 - 'write operation'
        push    ax
        dec     ax                      ;ax = 0 we want track 00
        push    ax
        call    DO_hd_load              ;load the head
;
; Now for the main inner loop!!!
;
        xorw    cx,cx
        mov     cl,FMT_tracks           ;get track count
        movb    FMT_trk,#0              ;zero current track


;ENTER TRACK LOOP
TRKINIT_TL                              ;track loop
        push    cx                      ;save loop count
        xorw    cx,cx
        mov     cl,FMT_sides            ;get sides count
        movb    FMT_hd,#0               ;set head up


;ENTER HEAD LOOP (ie, repeat each track for each head: 1 or 2)
TRKINIT_HL
        push    cx                      ;save sides
        call    DO_wait_FDC             ;wait for FDC ready
        movb    al,FMT_trk              ;get track
        out     #FDC_TRK,al             ;set track register in FDC
        movb    ah,FMT_hd               ;head in ch ( track still in al )
        call    SETUPDATA               ;set-up the image
        movw    cx,#10                  ;up to 10 re-trys
	cmpb	CNF_diagflag,#1		;retries disabled?
	jne	TRKINIT_RL		;no - skip
	movw	cx,#1			;set up no retry

;ENTER RETRY LOOP (each track write can be tried up to 10 times)
TRKINIT_RL

;write track image

        push    cx                      ;save retry count
        call    WRTTRK                  ;write track out
        call    DO_wait_FDC             ;wait for FDC not busy
        in      al,#FDC_STAT            ;get FDC status
        testb   al,#11000000b           ;write protect or drive not ready ?
        pop     cx                      ;(get retry count)
        jz      TRKINIT_7               ;no, jump

;ABORT ENTIRE OPERATION...
;error: write protect, drive not ready, or all retries exhausted)
TRKINIT_8                               
        pop     cx                      ;clear head count
        pop     cx                      ;clear track count
        movw    ax,#MSE_drv_not_rdy     ;set up not ready
        jmp     TRKINIT_EX              ;and exit

;if lost data error: retry (up to 10 times)
TRKINIT_7
        testb   al,#00000100b           ;lost data?
        loopnz  TRKINIT_RL              ;yes - try again
        jnz     TRKINIT_8               ;jump if all retries exhausted

;END OF RETRY LOOP

        incb    FMT_hd                  ;adjust head
        pop     cx                      ;get head count
        loop    TRKINIT_HL              ;and do the other side

;END OF HEAD LOOP

;step on to next track
        incb    FMT_trk                 ;adjust track
        movb    al,#01011011b           ;step command, head loaded, 15ms
        out     #FDC_COM,al             ;send to FDC
	call	DO_wait_FDC		;wait for FDC
	call	DIO_wait15		;wait 15ms for a good settle
        cmpb    B_FLP_TYP,#0            ;check drive type
        jz      TRKINIT_9               ;0 = 70 track - skip
        call    DIO_wait15              ;additional delay for 80 track drives
TRKINIT_9
        pop     cx                      ;get track count
        loop    TRKINIT_TL              ;and do the rest

;END OF TRACK LOOP


;FORMAT COMPLETE: RESTORE HEAD
        call    DO_restore              ;restore the drive
        jmp     TRKINIT_EX              ;return error in ax
;
;
;
;-------------------------------------------------------------------
; SETUPDATA - sets up format buffer for each track
;	Head (0 or 1) passed in ah, Track in al

SETUPDATA
	mov	bl,ah		;work out head mask
	shl	bl,#1
	and	bl,#2
	mov	head_mask,bl	;and save away
	push	es
	mov	es,FMT_dataseg	;get address of track image
	mov	di,FMT_offset
	add	di,#162		;point to first head/track entry
	mov	cx,#09		;nine to do
tloop	mov	es:[di],ax	;track = al, head = ah
	add	di,#656		;next entry
	loop	tloop
	pop	es
	ret
;
;-------------------------------------------------------------------------
; WRTTRK - Writes single track image using the 8089
;
WRTTRK
	call	DRW_wait_89	;wait for the 8089 not busy
	mov	al,head_mask
	or	al,#0f4h	;or write track command into head mask
	mov	FMT_FDC_com,al	;and put in 8089 array
	mov	dx,ds		;save ds
	mov	ax,#50h		;point at ccb at 500h
	mov	ds,ax
	xor	bx,bx
	movw	4[bx],dx	;old DS as segment
	movw	2[bx],#(format_PB-DatabaseQQ)
	movw	[bx],#0EE03h	;set up busy
	mov	ds,dx		;restore ds
	out	#IOP_CH1,al	;kick the 8089
	call	DRW_wait_89	;and await completion
	ret
;
;
	end
	

$ 