   bits(CodebaseQQ,4,16)   ; segment
        word    253*4                   ;int 253 address
 

; [bios.apricot.ram]diskio.asm
	title   '[bios.apricot.ram]diskio.asm'


        INCLUDE 'legal.asi'




;************************************************************************
;*                                                                      *
;*                          D I S K I O                                 *
;*                                                                      *
;*      ROM resident disk input/output routine called by                *
;*      diskcon to perform read/write/verify operations.                *
;*                                                                      *
;*                                                                      *
;*      FILENAME:       [bios.apricot.ram]diskio.asm                    *
;*      AUTHOR:         G. Kurth, N. Wilson, Ray Woolcock  	        *
;*      WRITTEN:        25-MAY-84 RJW                                   *
;*	MODIFICATIONS:	Apricot version from activm 15/8/84 GK		*
;*                      Apricot RAM BIOS version 5/9/84 GK              *
;*			FLPY_INIT_DRVR to return proper error status,	*
;*						 3/12/84 RJW.		*
;*			FLPY_INIT_DRVR to support all zero BPB's	*
;*                                                                      *
;************************************************************************
  page
        nolist
        INCLUDE 'ioregs.asi'
        INCLUDE 'GENEQU.asi'
	list
        list dbg

        include 'mserror.asi'		;definitions of returned error codes
	include	'fsstat.asi'

        Global  CodebaseQQ, DatabaseQQ

        Assume CS:CodebaseQQ, DS:DatabaseQQ, SS:DatabaseQQ, ES:DatabaseQQ


;CALLS TO EXTERNAL MODULE DISKOPS:
        Global  Do_select_drive
        Global  FS_init
        Global  Do_on_line, DO_hd_load, Do_restore, Do_seek
        Global  SH_wake_me_up


;CALLS TO LOW LEVEL DISK DRIVER DISKRWV
        Global  DRWV_sctr
    page
;***********************************************************************
;**********************  CONSTANTS SECTION *****************************
;***********************************************************************


        Section diskio.const, Align(1), CLASS=ConstQQ


        Global  MSD_BPB0, MSD_BPB1
        Global  finit_table
        Global  FLPY_bpb
        Global  DSK_type0, DSK_type1, DSK_secs0, DSK_secs1 

;The pointer to this table will be stored in DWORD location 418h at boot time.
finit_table          Word    MSD_BPB0-DataBaseQQ
                     Word    MSD_BPB1-DataBaseQQ   ; 2 disks


;DEFAULT BPB COPIED TO BPB'S BELOW
Flpy_BPB             Word       512             ;sector size
                     Byte       1               ;cluster size
                     Word       1               ;reserved sectors
                     Byte       2               ;number of Fats
                     Word       128             ;number of directory entries
                     Word       630             ;number of sectors
                     Byte       0FCH            ;media ID
                     Word       2               ;number of sectors per FAT
                     Byte       0               ;disk type
                     Word       0               ;logical offset


;BPB FOR DISK DRIVE 0
MSD_BPB0             Word       512             ;sector size
DSK_CLUS0            Byte       1               ;cluster size
                     Word       1               ;reserved sectors
                     Byte       2               ;number of Fats
                     Word       128             ;number of directory entries
DSK_secs0            Word       630             ;number of sectors
                     Byte       0FCH            ;media ID
                     Word       2               ;number of sectors per FAT
DSK_type0            Byte       0               ;disk type
                     Word       0               ;logical offset


;BPB FOR DISK DRIVE 1
MSD_BPB1             Word       512             ;sector size
DSK_CLUS1            Byte       1               ;cluster size
                     Word       1               ;reserved sectors
                     Byte       2               ;number of Fats
                     Word       128             ;number of directory entries
DSK_secs1            Word       630             ;number of sectors
                     Byte       0FCH            ;media ID
                     Word       2               ;number of sectors per FAT
DSK_type1            Byte       0               ;disk type
                     Word       0               ;logical offset
  page
;***********************************************************************
;*************************  DATA SECTION *******************************
;***********************************************************************



        Section diskio.data, Align (2), Class=DataQQ

;EXTERNAL DATA
		global  B_FLP_TYP ;drive type, determined at boot time
		global	CNF_diagflag

;SAVE AREA FOR DATA PASSED BY romdisk:-
mem_adr_off     BLOCK   2       ;memory pointer offset
mem_adr_seg     BLOCK   2       ;memory pointer segment
first_sctr      BLOCK   2       ;1st logical sector in current track
st_trk          BLOCK   2       ;first track to access
n_sctr          BLOCK   2       ;number of sector to access
drive           BLOCK   2       ;drive number
command         BLOCK   2       ;command (0=rd; 1=wrt; 2=ver; 3=wrt & ver)


;SCRATCH PAD AREA
en_sctr         BLOCK   2       ;physical sector num. of last sector to access
n               BLOCK   2       ;number of sectors to do in current track
trk             BLOCK   2       ;current track number
st_sctr         BLOCK   2       ;starting physical sector number
en_trk          BLOCK   2       ;last track to access
error           BLOCK   2       ;save area for error code
retry           BLOCK   1       ;retry downcounter for disk retries
head_tran       BLOCK   1       ;head translate flag, set if double sided disk
head            BLOCK   1       ;head number (0, 1)
   page





;***********************************************************************
;***********************  PROGRAM  SECTION  ****************************
;***********************************************************************



        Section diskio.code, Align(1), CLASS=InstrQQ



;OTHER ROUTINES CONTAINED IN THIS MODULE
        Global  BPB_default
        Global  FLPY_init_drvr
        Global  DO_wait_fdc
        Global  DO_fdc_clr
        Global  DIO_wait15
        Global  diskio
  page
	stitle	'SUBOUTINE:  Flpy_init_drvr'
;***********************************************************************
;********************  SUBROUTINE Flpy_init_drvr  **********************
;***********************************************************************
;
; Tests if the disk type, as read from the disk's BPB, is valid. If
; it is invalid the BPB is overwitten with the default BPB, and an
; error status returned.
;
; On Entry:
;       word on stack is drive unit number
;
; On Exit:
;       al = disk status (as defined by disk_status.asmi)
;


Flpy_init_drvr                  ;Word on the stack is unit code


;GET DRIVE NUMBER FROM STACK INTO AX
        mov     bp,sp
        mov     ax,2[bp]


;DETERMINE WHETHER DRIVE 0 OR DRIVE 1
        cmp     al,#1           ;unit 1 ?
        je      FLPY_init_1


;SET UP REGISTERS FOR DRIVE 0
FLPY_init_0                     ;init driver for 0
	lea	bx,FS_stat0
        mov     dl,DSK_type0    ;get disk type in dl
	MOV	CX,DSK_SECS0	;SECTOR COUNT IN BX
	MOV	DH,DSK_CLUS0	;CLUSTERS IN DH
        jmpsh   FLPY_init_x
        

;SET UP REGISTERS FOR DRIVE 1
FLPY_init_1
	lea	bx,FS_stat1
        mov     dl,DSK_type1    ;get disk type in dl
	mov	cx,dsk_secs1	;sector count in bx
	mov	dh,dsk_clus1	;clusters in dh
FLPY_init_x
        

;CHECK IF THE DISK TYPE IS COMPATIBLE WITH THE DRIVE TYPE
        cmp     dl,B_FLP_TYP    ;compare disk type with max drive type
        ja	bad_media	;illegal disk, so set up default

;CHECK IF THE DISK TYPE IS ZERO - IF SO LOAD UP 70T SS TYPE & SAY OK

	CMP	DL,#0		;ZERO TYPE?
	JE	SAY_70T		;YES - GO FOR IT

;IF ZERO SECTORS OR CLUSTERS: SAY BAD MEDIA (STOP MSDOS FALLING OVER)
        cmp	cx,#0		;zero sectors
	je	bad_media	;
	cmp	dh,#0		;zero clusters
	jne	media_ok	;


;MEDIA ERROR: SET SWAPPED STATUS
bad_media
	movb	D_swapped[bx],#1	;set swapped status on naughty disk


;MEDIA ERROR: SET UP DEFAULT BPB
        push    ax              ;ax = drive number
        call    BPB_default     ;set up default BPB


;MEDIA ERROR: RETURN ERROR STATUS IN AX
	mov	ax,#MSE_bad_media	
	ret	#2

;TYPE FIELD SAID 0 - SUPPORT OLD DISKS BY LOADING DEFAULT BPB

SAY_70T
        push    ax              ;ax = drive number
        call    BPB_default     ;set up default BPB

;MEDIA OK: RETURN OK STATUS IN AX
media_ok
	xor	ax,ax		;always say ok	
        ret     #2              ;
  page
	stitle	'SUBROUTINE:   BPB_default'
;***********************************************************************
;********************  SUBROUTINE  BPB_default  ************************
;***********************************************************************
;
; OVERWRITE BPB FOR SPECIFIED DRIVE UNIT WITH DEFAULT VALUES
;
; On Entry:
;       word on stack is drive unit number (0 or 1).


BPB_default                     ;word on stack is unit code

        mov     bp,sp
        mov     ax,2[bp]        ;unit in al
        
        cmp     al,#1
        je      FLPY_un1

FLPY_un0                        ;init floppy 0

        mov     di,#MSD_bpb0-DatabaseQQ
        jmpsh   movem           ;do transfer

FLPY_un1                        ;init floppy 1

        mov     di,#MSD_bpb1-DatabaseQQ
        
movem
        mov     si,#FLPY_bpb-DatabaseQQ
                                ;do transfer
        mov     bx,es           ;save es for Pascal
        mov     ax,ds
        mov     es,ax
        mov     cx,#8           ;move 8 words
        cld                     ;make sure
        rep     movw
        mov     es,bx           ;restore ES
        ret     #2
  page
	stitle	'SUBROUTINE:  diskio'
;**************************************************************************
;**************************  SUBROUTINE  diskio  **************************
;**************************************************************************
;
;  Main routine for reading, writing and verifying areas of disk.
;
;
;  On Entry:
;               di =  mem-addr_off      memory pointer offset
;               dx =  mem_addr_seg      memory pointer segment
;               si =  st_sctr           starting physical sector number.
;		cx =  n_sctr            number of sectors to access.
;               al =  drive             drive number
;               ah =  command           (0=read;1=wrt;2=ver;3=wrt&ver)
;
;
;  (uses B_FLP_TYP, set up with disk hardware type on restart)
;
;
;  On Exit:
;               ax = disk status (as defined by mserror.asi)
;

diskio


;FLAG THAT THE DISK IS NOW ACTIVE
        movb    FS_active,#1


;SAVE THE INPUT VARIABLES
        mov     mem_adr_off,di          ;memory address offset
        mov     mem_adr_seg,dx          ;memory address segment
	mov	st_sctr,si		;starting physical sector
        mov     n_sctr,cx               ;store number of sectors

	mov	command,ah		;store command
	xor	ah,ah			;
	movb	command+1,ah		;

	mov	drive,ax		;store drive (ah now zero)


;IF ERROR IN DATA: RETURN ERROR STATUS
	cmp	command,#3		;valid command ?
	jbe	valid_cmd		;yes, jump

	movw	error,#MSE_bad_cmd	;return bad command error

	jmp	abort_call		;exit
valid_cmd



;IF THE DISK TYPE IS NOT COMPATIBLE WITH THE DRIVE: EXIT WITH ERROR CODE
;       (drive type codes are in order of upward compatibility)
        movb    al,B_FLP_TYP            ;get system drives type
        cmpb    drive,#0                ;drive 0 ?
        jne     valid1                  ;no, jump 
        cmp     DSK_type0,al            ;drive type compatible ?
        jmpsh   valid2                  ;
valid1  cmpb    DSK_type1,al            ;
valid2  jbe     disk_compatible         ;yes, jump


        movw    error,#MSE_bad_media    ;no, bad media
        jmp     abort_call              ;abort the call
disk_compatible


;SELECT THE REQUESTED DRIVE
        push    drive                   ;set up stack
        call    DO_select_drive         ;attempt a select
        mov     error,ax                ;save error status for later


;IF NOT SELECTED OK: ABORT CALL
        cmpw    error,#MSE_ok           ;was it OK?
        jne     long_abort_call         ;no, jump


;TEST IF SWITCHED ON-LINE
        call    DO_on_line              ;test if on line
        mov     error,ax                ;save error status for later use


;IF NOT ON-LINE: ABORT THE CALL
        cmp     ax,#MSE_ok              ;was this drive ok ?
        jne     long_abort_call         ;no, jump


;TEST IF STARTING SECTOR EXISTS (and get max no. sectors in bx)
        mov     bx,DSK_secs0            ;set max sectors for drive 0 in bx
        cmpb    drive,#0                ;is it drive 0
        je      valid3                  ;yes -skip
        movw    bx,DSK_secs1            ;set up for drive 1
valid3  cmp     st_sctr,bx              ;over the top?
        jae     sector_not_found        ;yes, jump


;TEST IF NUMBER OF SECTORS GREATER THAN 0       (save bx)
        cmpw    n_sctr,#0               ;read zero sectors ?
        je      sector_not_found        ;yes, jump


;TEST IF THE LAST SECTOR TO BE READ EXISTS (bx=max no. sectors on disk)
        mov     ax,st_sctr              ;calculate last sector number
        add     ax,n_sctr               ;
        cmp     ax,bx                   ;last sector exists ?
        jbe     sector_exists           ;yes, jump


;NON-EXISTENT SECTOR ERROR: EXIT
sector_not_found
        mov     error,#MSE_no_sctr      ;'No Sector Error'

long_abort_call
        jmp     abort_call              ;abort the call


sector_exists


;IF DOUBLE SIDED DISK: SET HEAD TRANSLATE FLAG
        xorw    ax,ax
        cmpb    drive,al                ;drive 0?
        jne     setup1                  ;no, jump
        cmpb    DSK_type0,#2            ;double sided disk?
        jne     setup                   ;no - no translate
        incw    ax                      ;head_tran=1
        jmpsh   setup
setup1  cmpb    DSK_type1,#2            ;double sided?
        jne     setup
        incw    ax                      ;head tran=1
setup   mov     head_tran,al            ;set up translate flag


;CALCULATE THE ENDING PHYSICAL SECTOR NUMBER
;-- en_sctr:=st_sctr+n_sctr-1
        mov     bx,st_sctr              ;get start sector
        add     bx,n_sctr               ;add on number of sectors
        dec     bx                      ;minus one
        mov     en_sctr,bx              ;put away


;CALCULATE FIRST TRACK NUMBER
;-- st_trk:=(st_sctr div 9)
        mov     ax,st_sctr              ;* get start sector
        mov     cx,#9                   ;* for modulo of nine
        cwd                             ;* clear dx
        div     cx                      ;* divide down (yawn!)
        mov     st_trk,ax               ;* put away in the start track


;CALCULATE THE LAST TRACK NUMBER
;-- en_trk:=(en_sctr div 9)
        mov     ax,en_sctr              ;get end sector
        mov     cx,#9                   ;for modulo of nine
        cwd                             ;clear dx
        div     cx                      ;divide down
        mov     en_trk,ax               ;remainder stuck in en_trk


;LOAD THE HEAD
        mov     ax,command              ;form read=0 write=1  flag
        and     ax,#1                   ;throw away verify (b2)
        push    ax                      ;send direction
	mov	ax,st_trk		;get destination
	cmpb	head_tran,#0		;double sided?
	je	load_single		;no - skip
	shr	ax,#1			;divide by 2
load_single
        push    ax			;send track required
        call    DO_hd_load              ;load the head 


;INITIALISE LOOP FOR ACCESSING ONE TRACK AT A TIME
        mov     cx,st_trk               ;start at the first
        mov     trk,cx                  ;put in variable


;ENTER LOOP TO ACCESS ONE TRACK AT A TIME
TP_loop


;IF NOT FIRST TIME THROUGH: ADJUST MEMORY SEGMENT ADDRESS 
;-- mem_addr.segment:=mem_addr.segment+(10-first_sctr)*32
        mov     cx,trk                  ;get current track number
        cmp     cx,st_trk               ;on the starting track ?
        jbe     no_adjust               ;no, jump

        push    cx                      ;save CX
        mov     ax,mem_adr_seg          ;save segment
        mov     bx,#10                  ;one extra
        sub     bx,first_sctr           ;subtract first one
        mov     cl,#5
        shl     bx,cl                   ;multiply by 32
        add     ax,bx                   ;add on first
        mov     mem_adr_seg,ax          ;restore
        movw    first_sctr,#1           ;set to sector 1
        pop     cx                      ;restore CX
	jmp	t_bypass
no_adjust


;FIRST TIME THROUGH FOR THIS TRACK: CALCULATE FIRST SECTOR IN TRACK
;-- first_sctr:=(st_sctr mod 9)+1
        mov     ax,st_sctr              ;* get first sector
        mov     bx,#9                   ;* modulo nine
        cwd                             ;* clear dx
        div     bx                      ;* divide down
        inc     dx                      ;* add on difference
        mov     first_sctr,dx           ;* put away
        
t_bypass


;IF NOT ON LAST TRACK: CALCULATE NUMBER OF SECTOR TO END OF TRACK
;-- n:=10-first_sctr
        cmp     cx,en_trk               ;at end track?
        jae     on_last_track           ;yes, jump


        mov     ax,#10                  ;calc number of sector left in track
        sub     ax,first_sctr           ;
        mov     n,ax                    ;
        jmp     not_last_track          ;


;ON LAST TRACK: CALCULATE NUMBER OF SECTORS TO LEFT TO DO
;-- n:=(en_sctr mod 9)+2-first_sctr

on_last_track

        mov     ax,en_sctr              ;get end sector
        mov     bx,#9                   ;nine sectors
        cwd                             ;clear dx
        div     bx                      ;divide down
        add     dx,#2                   ;add on zeroes
        sub     dx,first_sctr           ;subtract first sector
        mov     n,dx                    ;shove in n
not_last_track


;SET UP LOOP FOR RETRYING A NUMBER OF SINGLE TRACK OPERATIONS
        movb    retry,#9		;retry 10 times
	cmpb	CNF_diagflag,#1		;retries disabled?
	jne	trwloop			;no - skip
	movb	retry,#0		;no retrys

;ENTER LOOP FOR RETRYING A SINGLE TRACK OPERATION
trwloop


;IF RETRY NUMBER IS 3 OR 7: DO A RESTORE (SEEK TRACK 0)
        cmpb    retry,#3                ;3rd retry ?
        je      rest                    ;yes, jump
        cmpb    retry,#7                ;7th retry ?
        jne     NO_restore              ;no, jump
rest
        call    DO_restore              ;restore head, ignore any error here
NO_restore


;IF DOUBLE SIDED DISK AND ODD TRACK NUMBER: SELECT SECOND HEAD
        xorw    bx,bx                   ;default to first head
        movw    ax,trk                  ;get track number
        cmpb    head_tran,bl            ;double sided disk ?
        jz      DIO_seek                ;no, jump

        shr     ax,#1                   ;odd track number ?
        jnc     DIO_seek                ;no, jump
        incw    bx                      ;select head 1
DIO_seek
        movb    head,bl                 ;set head up


;SEEK THE DESIRED TRACK (TRACK NUMBER IN AX)
	movb	ah,command		;direction in ah
        and	ah,#1			;form 0=read, 1=write
	push    ax                      ;push track & direction
        call    DO_seek                 ;seek track
        mov     error,ax                ;put error status in flag


;IF SEEK ERROR: RETRY SEEK
        cmp     ax,#MSE_ok              ;error ?
        je      can_do_op               ;no, jump
        jmp     op_exit                 ;nasty, so do the retry business
can_do_op


;ATTEMPT DISK OPERATION (READ OR WRITE)
        push    first_sctr              ;set up stack
        push    n                       ;number of sectors
        push    mem_adr_seg             ;memory address
        push    mem_adr_off             ;
        movb    ah,command              ;(0=read,1=wrt,2=ver,3=wrt + ver)

	cmp	ah,#3			;write and verify ?
	jne	not_wv			;no, jump
	mov	ah,#1			;yes, just do write command now
not_wv

        mov     al,head                 ;ah = code, al = head
        push    ax
        call    DRWV_sctr               ;call low-level disk handler
        call    complete                ;call fixup routine


;IF NO ERROR, AND WRITE+VERIFY OPERATION: DO VERIFY OPERATION
        cmp     error,#MSE_ok           ;error occurred ?
        jne     op_exit                 ;yes, jump


        cmp     command,#3h             ;post-operation verify required
        jne     op_exit                 ;no, jump


        push    first_sctr              ;set up the stack
        push    n                       ;
        push    mem_adr_seg             ;
        push    mem_adr_off             ;
        mov     ah,#2                   ;(code for verify)
        mov     al,head                 ;
        push    ax                      ;
        call    DRWV_sctr               ;do the verify
        call    complete                ;update error register

op_exit

;CLEAR DOWN FDC (FORCE INTERRUPT)
        call    DO_fdc_clr              ;clear down FDC to type 1 status


;IF NO ERROR HAS OCCURRED AT ANY POINT: EXIT THE RETRY LOOP
        cmp     error,#MSE_ok           ;error occurred ?
        je      getout                  ;no, jump


;ERROR OCCURRED: IF ALL RETRIES DONE ABORT THE CALL
        cmpb    retry,#0                ;all retries done ?
        je      abort_call              ;yes, jump


;LOOP BACK TO RETRY OPERATION
        decb    retry                   ;just lost a life
        jmp     trwloop                 ;loop again
getout


;IF MORE TRACKS TO BE DONE: LOOP BACK TO DO NEXT TRACK OPERATION
        mov     cx,trk                  ;get current track number
        cmp     cx,en_trk               ;finished all tracks?
        je      abort_call              ;yes, jump


        incw    trk                     ;get next track number
        jmp     TP_loop                 ;loop back to do next track


;ALL TRACKS DONE
abort_call


;INITIATE HEAD UNLOAD INTERRUPT TIMER
	mov	ax,#FR0_sleeper		;set up fro drive 0 timeout
	cmpw	drive,#1		;was it drive 1
	jne	abort_drv_0		;no - do 0
	mov	ax,#FR1_sleeper		;sleeper id for drive 1
abort_drv_0
        push    ax
        mov     ax,#50			;1 second timeout
        push    ax
        call    SH_wake_me_up           ;set off head load timeout


;FLAG: NO LONGER ACTIVE
        movb    FS_active,#0            ;not active any more


;RETURN ERROR IN AX
        mov     ax,error                ;put error code in AX
        ret                             ;return - ax = disk status
   page
	stitle	'SUBROUTINE:  complete'
;**************************************************************************
;**************************  SUBROUTINE  COMPLETE  ************************
;**************************************************************************
;
; Internal subroutine called after DRWV_sctr is called.
; Gets status from FDC and converts it to the disk status code returned
; by the ROM bios.
;
; On Entry:
;       FDC status port contains the status to be converted to error code. 
;
;
; On Exit:
;       error = disk status as defined by module mserror.asi
;

COMPLETE

;ENSURE THAT FDC HAS FINISHED
        call    DO_wait_FDC             ;wait for FDC to stop


;DECODE FDC STATUS AND CONVERT TO MSDOS ERROR CODE
        in      al,#FDC_STAT            ;get status in al
        test    al,#128
        jnz     ME1                     ;'Drive Not Ready Error'

        test    al,#16
        jnz     ME2                     ;'Sector Not Found Error'

        test    al,#8
        jnz     ME3                     ;'CRC Error'

        test    al,#4
        jnz     ME4                     ;'Lost Data Error'

        test    al,#64
        jnz     ME5                     ;'Write Protect Error'

no_wrt_prot
        mov     error,#MSE_ok
        ret

ME1
        mov     error,#MSE_drv_not_rdy  ;drive not ready
        ret
ME2
        mov     error,#MSE_no_sctr
        ret
ME3
        mov     error,#MSE_crc_err
        ret
ME4
        mov     error,#MSE_failure      ;lost data
        ret
ME5
        testb   command,#1              ;write or write-&-verify ?
        jz      no_wrt_prot             ;no, jump
        mov     error,#MSE_wrt_prot 	;yes, return write protect error
        ret
   page
	stitle	'SUBROUTINE:	DIO_wait15'








;**************************************************************************
;************************  SUBROUTINE  DIO_wait15  ************************
;**************************************************************************
;
; DIO_wait15    - 15mS wait loop for head settling delays
;                 NOTE: this will not work on an 80188/80186
;
;
DIO_wait15
        movw    bx,#90
DIO_wait_l
        movb    cl,#200
        shl     cx,cl
        decw    bx
        jnz     DIO_wait_l
        ret
   page
	stitle	'SUBROUTINE:	DIO_wait_FDC'






;**************************************************************************
;************************  SUBROUTINE  DO_wait_FDC  ***********************
;**************************************************************************
;
; DO_wait_FDC - waits 16microseconds then tests busy bit in fdc
;
;
DO_wait_FDC
        movb    cl,#20          ;approx 16usec period
        shl     cx,cl           ;wait
DO_wait_lFDC
        in      al,#FDC_STAT    ;get FDC status
        test    al,#1           ;test busy bit
        jnz     DO_wait_lFDC
        ret
    page 
	stitle	'SUBROUTINE:	DIO_fdc_clr'






;**************************************************************************
;************************  SUBROUTINE  DO_fdc_clr  ************************
;**************************************************************************
;
; DO_fdc_clr    - sends Force Interrupt to FDC and wait on busy
;
DO_fdc_clr
        mov     al,#0D0H                ;send force interrupt to FDC
        out     #FDC_COM,al             ;send D0
        call    DO_wait_FDC             ;wait
        ret
        



        End



$ 