                                                            

; [BIOS.APRICOT.RAM]diskops.asm
	TITLE	'[BIOS.APRICOT.RAM]diskops.asm'
;
        INCLUDE 'legal.asi'
;
;***********************************************************************
;        
; MODULE:       diskops.asm
; PROGRAMMER:   G.Kurth
; IMPLEMENTED:  31-jan-84
; STATUS:       UNFINISHED
; MODIFICATIONS: vax rom bios version 15/8/84 GK
;			RAM BIOS version 5/9/84 GK
;			Possible timing problems corrected 24/10/84 GK
;
;***********************************************************************
;
;----------------------------------------------------------------------
; DISKOPS.ASM - this module replaces the pascal module which handles
; floppy disk select, seek, and head load handling
;----------------------------------------------------------------------
;
        INCLUDE 'ioregs.asi'
        INCLUDE 'mserror.asi'
	INCLUDE	'genequ.asi'
        
        GLOBAL  CodebaseQQ, DatabaseQQ
        Global  DO_restore, DO_wait_FDC, DO_FDC_clr
        Global  DO_select_drive
        Global  DO_seek, DIO_wait15

	Global	B_FLP_NUM, B_FLP_TYP

        ASSUME CS:codebaseQQ, DS:DatabaseQQ, SS:DatabaseQQ
        
	INCLUDE	'FSstat.asi'
        
        Section Diskops.data, Align(1), Class=DataQQ
;
Delay_flag      BLOCK 1         ;head load delay flag
;

        Section Diskops.code, Align(2), Class=InstrQQ
;
;------------------------------------------------------------------
; DIO_INIT - initialises disk drivers
;	On Exit:
;		B_FLP_NUM	= number of drives (1 or 2)
;		B_FLP_TYP	= Floppy type (0 or 2)
;
        Global DIO_INIT, FS_INIT
;
DIO_INIT
        call    FS_INIT                 ;initialise floppy status routines

;SET DUMMY AS CURRENT DRIVE
	movb	FS_SEL,#2		;Dummy Drive (2)

        ret
;
;------------------------------------------------------------------------
; DO_end_hd_delay - called by head load timeout
;
        Global  DO_end_hd_delay
;
DO_end_hd_delay
        movb    delay_flag,#1           ;set delay flag true
        ret
;
;
;-----------------------------------------------------------------------
; DO_hd_load(writing:boolean;destination:byte) - loads head of disk drive
;
        Global  DO_hd_load, SH_wake_me_up
;
DO_hd_load
        pushf
        cli                             ;alone again
        in      al,#PIO_PORB            ;get current bits
        or      al,#04h                 ;set head load
        out     #PIO_PORB,al
        popf
        mov     bp,sp
        movb    cl,2[bp]                ;get destination track
        movb    al,4[bp]                ;get writing flag
        movw    bx,#FS_stat-DatabaseQQ  ;point at status array
        cmpb    FS_sel,#1               ;current disk = 1?
        ja      DO_hd_load_x            ;above - exit
        jne     DO_hd_load_1            ;not 1 - skip
        addw    bx,#D_length            ;adjust for drive 1 index
DO_hd_load_1
        cmpb    al,#1                   ;writing?
        jne     DO_hd_load_8            ;no - skip
        in      al,#FDC_TRK             ;get FDC track register
        cmp     al,cl
        ja      DO_hd_load_2            ;check if distance <= 4
        xchg    al,cl
DO_hd_load_2
        sub     al,cl
        cmpb    al,#4
        ja      DO_hd_load_8            ;no - skip
        cmpb    D_head[bx],#0           ;head loaded?
        jnz     DO_hd_load_8            ;yes - skip
        movb    delay_flag,#0           ;set delay flag=false
        movw    ax,#HD_sleeper          ;head sleeper
        push    bx                      ;save index
        push    ax
	mov	ax,#4			;4 * 20ms
        push    ax                      ;wait 4*20ms
        call    SH_wake_me_up           ;call sheduler
        pop     bx                      ;restore index
DO_hd_load_3
        cmpb    delay_flag,#1           ;flag set?
        jne     DO_hd_load_3            ;nope - wait
        
DO_hd_load_8
        movb    D_head[bx],#1           ;say head loaded
DO_hd_load_X
        ret     #4                      ;done - return
        
;
;-------------------------------------------------------------------------
; DO_restore  - restores head of drive
;
        ;
DO_restore
        call    DO_wait_FDC             ;wait for FDC not busy
        call    DO_FDC_clr              ;clear FDC down
        movb    al,#03H                 ;FDC RESTORE 15ms step
        out     #FDC_COM,al             ;send command
        call    DO_wait_FDC             ;wait for FDC not busy
        xorw    ax,ax
        out     #FDC_TRK,al             ;set track register = 0
        in      al,#FDC_STAT            ;get status
        andb    al,#10011101b           ;and check
        cmpb    al,#00000100b           ;for OK track 00
        movw    ax,#MSE_OK              ;set up OK status
        je      DO_restore_1            ;quit if ok
        movw    ax,#MSE_seek_err        ;say seek error
DO_restore_1
        ret                             ;return status in ax
        
;
;------------------------------------------------------------------------
; DO_on_line;error - procedure to check if disk on line
;
        Global  DO_on_line
;
DO_on_line
        in      al,#FDC_STAT            ;get FDC status
        test    al,#01h                 ;check busy bit
        jnz     DO_on_line              ;busy - wait
        movw    bx,#FS_stat-DatabaseQQ  ;set up array base
        cmpb    FS_sel,#1               ;drive 1?
        ja      DO_on_line_4            ;say drive not ready
        jne     DO_on_line_1            ;not drive 1 - skip adjust
        addw    bx,#D_length            ;adjust base
DO_on_line_1
        test    al,#80h                 ;check drive not ready bit
        jnz     DO_on_line_3            ;not -ready
        movw    ax,#MSE_OK              ;say OK
        ret                             ;and return

DO_on_line_3
        xorw    ax,ax                   ;zap ax
        incw    ax
        movb    D_swapped[bx],al        ;swapped = true
DO_on_line_4
        movw    ax,#MSE_drv_not_rdy     ;say drive not ready
        ret
        
;
;-------------------------------------------------------------------------------
; DO_select_drive(drive:word):MSE_error - selects drive
;
        ;
DO_select_drive
        mov     bp,sp
        mov     dx,2[bp]                ;get drive
        cmpb    dl,#2                   ;drive codes 0-2?
        ja      DO_select_bad           ;say bad unit
        movw    bx,#FS_stat-DatabaseQQ  ;get base of FS_stat array
        cmpb    FS_sel,#1               ;current drive = 1?
        ja      DO_select_2             ;above - skip
        jne     DO_select_1             ;not 1 - no adjust
        add     bx,#D_length            ;adjust for drive 1
DO_select_1
        in      al,#FDC_TRK             ;get current track
        movb    D_track[bx],al          ;and put in current drives table
DO_select_2
        cmpb    dl,#1                   ;drive #1
        jna     DO_select_3             ;drives 0 or 1 - handle them
        pushf
        cli
        in      al,#PIO_PORB            ;get port b
        orb     al,#020h                ;deselect drives
        out     #PIO_PORB,al
        movb    cl,#40                  ;give the old drive some time
        shl     cx,cl
        andb    al,#0FBh                ;set head unload
        out     #PIO_PORB,al            ;an tell the PIO
        movb    cl,#20                  ;give the old drive some time
        shl     cx,cl
        popf
        movb    FS_sel,dl               ;say dummy drive selected
DO_select_bad
        movw    ax,#MSE_bad_unit        ;say bad unit
        ret     #2                      ;and return

DO_select_3
        cmpb    dl,FS_sel               ;same drive as currently selected?
        je      DO_select_ok            ;yes - all done ok
        movw    bx,#FS_stat-DatabaseQQ
        andb    dl,dl                   ;drive 0?
        jz      DO_select_4             ;yes - skip adjust
        add     bx,#D_length            ;adjust for drive 1
DO_select_4
        pushf
        cli
        in      al,#PIO_PORB            ;get current
        orb     al,#020h                ;deselect current drive (leave head as is)
        out     #PIO_PORB,al
        movb    cl,#40                  ;give the old drive some time
        shl     cx,cl
	andb    al,#09Bh                ;select new drive
        cmpb    dl,#0                   ;drive 0?
        jz      DO_select_5             ;yes -skip
        orb     al,#040h                ;set drive 1 bit
DO_select_5
        cmpb    D_head[bx],#1           ;head loaded ?
        jne     DO_select_6             ;nope
        orb     al,#04h                 ;set head load
DO_select_6
        out     #PIO_PORB,al            ;select drive
	movb    cl,#20                  ;give the old drive some time
        shl     cx,cl
	popf
        movb    al,D_track[bx]          ;get track entry for drive
        out     #FDC_TRK,al             ;and update FDC
        movb    FS_sel,dl               ;set up select disk
DO_select_ok
        movw    ax,#MSE_OK              ;say all well
        ret     #2
        
;
;-----------------------------------------------------------------------
; DO_seek - seek to track - word parameter on stack
;  LOW byte = Track number;  HIGH byte = 0 for read, 1 for write
;  Returns error status in AX.
DO_seek
        call    DO_on_line              ;on line?
        cmpw    ax,#MSE_OK
        jne     DO_seek_x               ;no - quit - error in ax
        mov     bp,sp                   ;get track and direction
        movw    dx,2[bp]                ;in dx
        in      al,#FDC_TRK             ;get track
        cmp     al,dl                   ;the same?
        je      DO_seek_ok              ;OK - exit
        mov     al,dl                   ;track in al
        out     #FDC_DAT,al             ;send to FDC data register
        movb    al,#13h                 ;FDC SEEK command 15ms step
        out     #FDC_COM,al             ;send command
        call    DO_wait_FDC             ;wait for it! (does not destroy DX)
	cmpb	dh,#0			;reading?
	je	DO_seek_1		;yes - do not delay (retry will cope)
	call	DIO_wait15		;wait 15ms
        cmpb    B_FLP_TYP,#0            ;check drive type
        je      DO_seek_1               ;if zero - skip
        call    DIO_wait15              ;further 15ms delay for 80 track drives
DO_seek_1
        in      al,#FDC_STAT            ;get FDC status
        test    al,#18h                 ;check seek & crc error bits
        jz      DO_seek_ok              ;both zero - all OK
        push    ax                      ;save status
        call    DO_FDC_clr              ;clear down FDC
        pop     ax
        test    al,#10h                 ;seek error?
        jz      DO_seek_2               ;no - other one
        movw    ax,#MSE_seek_err        ;say seek error
        jmpsh   DO_seek_x
DO_seek_2
        movw    ax,#MSE_CRC_err         ;say CRC error
        jmpsh   DO_seek_x
DO_seek_ok
        xor	ax,ax			;say OK
DO_seek_x
        ret     #2                      ;and return
        
        end

$ 