                                           

; [bios.apricot]diskreg.asm
	title	'[bios.apricot]diskreg.asm'



        include 'legal.asi'




;************************************************************************
;*                                                                      *
;*                         D I S K R E G                                *
;*                                                                      *
;*      FS_INIT      - Initialisation of status array (FS_stat).        *
;*      FR_q_swapped - Tests if disk has been swapped.                  *
;*      FR_time_out  - Unloads head for scheduler.                      *
;*                                                                      *
;*                     --------------------                             *
;*                                                                      *
;*      PROGRAMMER:     Nick Wilson, G. Kurth, and Ray Woolcock.        *
;*      FILE NAME :     [bios.apricot.rom]diskreg.asm                   *
;*      MODIFICATIONS:  apricot version 15/8/84 GK                      *
;*                                                                      *
;*                                                                      *
;************************************************************************
  page



        nolist
        include 'ioregs.asi'
        include 'mserror.asi'
	include	'genequ.asi'
        list


        Global  CodeBaseQQ, DataBaseQQ


        Assume  CS:CodeBaseQQ, DS:DataBaseQQ




;************************************************************************
;****************************  DATA SECTION  ****************************
;************************************************************************


        Section diskreg.data, Align (2), Class=DataQQ


        INCLUDE 'FSstat.asi'


FS_active       BLOCK   1               ;floppy driver active flag
FS_sel          BLOCK   1               ;floppy selected drive flag
FZ_drive	BLOCK	2		;temp drive save
FZ_stat		BLOCK	1		;temp status save

;       FS_stat - disk status array:-
;
FS_stat 
FS_stat0
d0_on_line      BLOCK   1       ;on_line        )
d0_swapped      BLOCK   1       ;swapped        )       Drive 0
d0_track        BLOCK   1       ;track          )
d0_head		BLOCK	1	;head loaded	)

FS_stat1
d1_on_line      BLOCK   1       ;on_line        )
d1_swapped      BLOCK   1       ;swapped        )       Drive 1
d1_track        BLOCK   1       ;track          )
d1_head		BLOCK	1	;head		)

d2_on_line      BLOCK   1       ;on_line        )
d2_swapped      BLOCK   1       ;swapped        )       Drive 2 (dummy)
d2_track        BLOCK   1       ;track          )
d2_head		BLOCK	1	;head		)




;************************************************************************
;**************************  CODE SECTION  *****************************
;************************************************************************


        Section Diskreg.code, Align (2), Class=InstrQQ


        Global  FR_q_swapped,FS_INIT
        Global  SH_wake_me_up, B_FLP_TYP
        Global  DO_wait_FDC,DO_select_drive
        Global  DO_HD_unload, FR_time_out
  page
;************************************************************************
;************************  SUBROUTINE FR_TIME_OUT  **********************
;************************************************************************
;
; FR_time_out    - called by sheduler after 1 second non-disk use
;                 unloads head on drive.
;		Drive number in AX


FR_time_out
	
;IF DISK SYSTEM IS ACTIVE: DO NOT UNLOAD HEAD
        cmpb    FS_active,#0            ;is file system active?
        je      FR_Time_3		;no - proceed

;FILE SYSTEM CURRENTLY ACTIVE - DO NOT CHECK
	mov	bx,#FR0_sleeper		;load ID for drive 0
	cmp	al,#1			;was it drive 1?
	jne	FR_Time_1		;no - leave as 0
	mov	bx,#FR1_sleeper		;set up Drive 2 ID
FR_Time_1
	push	bx			;send ID
	mov	bx,#50			;1 second timeout
	cmpb	FS_sel,al		;current drive?
	je	FR_Time_2		;yes - restart timer - 1 second
	mov	bx,#5			;100ms count
FR_Time_2
	push	bx
	call	SH_wake_me_up		;call scheduler
	ret				;done
;
;UNLOAD THE HEAD ON REQUESTED DRIVE
FR_Time_3
	lea	bx,FS_stat		;point at status array
	cmp	al,#1			;drive 1?
	jne	FR_Time_4		;no - must be zero
	add	bx,#D_length		;adjust for drive 2
FR_Time_4
	mov	FZ_drive,ax		;save drive for later
	
; SET HEAD UNLOADED IN STATUS ARRAY
	xor	ax,ax
	xchg	D_head[bx],al		;set head load to zero & get old one
	push	bx			;save index
	push	ax			;and old head load
	push	FZ_drive		;send drive
	call	DO_select_drive		;and select it

; GET DRIVE STATUS AND CHECK FOR CHANGE
	in	al,#FDC_STAT		;get status
	movb	FZ_stat,al		;save for later
	pop	ax
	pop	bx			;get back old load & array
	cmp	Al,Ah			;was head loaded?
	jne	FR_Time_nul		;no - no UNLOAD
	
;UNLOAD THE HEAD ON SELECTED DRIVE
	pushf
	cli
	in	al,#PIO_PORB		;get current head load status
	and	al,#0FBh		;clear head load
	out	#PIO_PORB,al		;eh voila!
	popf
	cmpb	B_FLP_TYP,#0		;70 track drive?
	jne	FR_Time_nul		;no - skip delay
	movb	cl,#200			;200uS delay
	shl	cx,cl

;HAVE WE JUST GONE OR COME (ON LINE THAT IS)
FR_Time_nul
	testb	FZ_stat,#080h		;check ready bit in status
	jz	FR_Time_col		;yes - ready - on line
	movb	D_swapped[bx],#1	;swapped
	jmp	FR_Time_ex		;done - restart timer

;COME ON LINE  - LEAVE STATUS
FR_Time_col
	
; SET OFF TIMER TO RE-CALL IN 1 SECOND
FR_Time_ex
	mov	bx,#FR0_sleeper		;load ID for drive 0
	cmpb	FZ_drive,#1		;was it drive 1?
	jne	FR_Time_ex1		;no - leave as 0
	mov	bx,#FR1_sleeper		;set up Drive 2 ID
FR_Time_ex1
	push	bx			;send ID
	mov	ax,#50			;1s count
	push	ax
	call	SH_wake_me_up		;call scheduler
	ret				;done
;
;
  page
;************************************************************************
;************************  SUBROUTINE  FR_q_swapped  ********************
;************************************************************************
;
; FIND OUT WHETHER THE DISK HAS BEEN SWAPPED OR NOT.
; This routine is called by diskcon in order to do a media check
;
; On Entry:
;       al = drive number to check
;
; On Exit:
;       al = 0 if disk has not been changed
;          = 1 if disk has been changed
;          = 2 if drive could not be selected (drive not ready)
;



FR_q_swapped


;FLAG DRIVE AS ACTIVE
        movb    FS_active,#1            ;we're active now


;SELECT THE REQUESTED DRIVE
        xor     ah,ah                   ;save drive number
        push    ax                      ;


        push    ax                      ;send drive number to routine
        call    DO_select_drive         ;call select procedure
        call    DO_wait_FDC             ;wait around


        pop     ax                      ;restore drive number


;POINT TO STATUS ARRAY FOR REQUESTED DRIVE (drive number in ax)
        mov     bx,#FS_stat-DatabaseQQ  ;point at status array
        cmp     al,#1                   ;drive 1 requested ?
        jb      drive_0                 ;no, jump

        ja      not_on_line             ;BAD DRIVE NUMBER - say not on line

        add     bx,#D_length            ;adjust for drive 1
drive_0


;IF DRIVE NOT ON-LINE: SAY DISK SWAPPED
        in      al,#FDC_STAT            ;drive ready ?
        test    al,#80H                 ;
        jz      on_line                 ;yes, jump


        movb    D_swapped[bx],#1        ;drive off-line: say swapped
        jmpsh   not_on_line             ;
on_line


;DISK ON-LINE: TEST IF THE MEDIA HAS BEEN CHANGED, AND RESET SWAPPED STATUS
        xor     ax,ax                   ;FIRST TEST SOFTWARE SWAP
        xchg    al,D_swapped[bx]        ;reset swapped status & get previous
        cmp     al,ah                   ;was disk swapped?
        je	disk_not_swapped	;no, jump

;DISK HAS BEEN CHANGED:
disk_swapped

;RETURN STATUS: MEDIA CHANGED
        mov     al,#1                   ;return DISK CHANGED code


;RETURN TO CALLING PROGRAM
dquit   movb    FS_active,#0            ;flag: no longer active


        ret                             ;RETURN


;DISK NOT ON-LINE (OR INVALID DISK NUMBER): RETURN ERROR
not_on_line
        mov     al,#2                   ;return DRIVE NOT READY code
        jmpsh   dquit                   ;


;MEDIA NOT SWAPPED: RETURN 'NOT SWAPPED CODE'
disk_not_swapped
        mov     al,#0                   ;return DISK NOT CHANGED code
        jmpsh   dquit                   ;
  page
;***************************************************************************
;****************************** FS_INIT ************************************
;***************************************************************************
;  Initialise the disk status array (FS_stat) for both drives to say:
;               Track 0,
;               Disk Swapped,
;               Disk not on-line.
;		Head unloaded
;


FS_init
        movb    FS_active,#0            ;we are not active
        movb    FS_sel,#2               ;say dummy currently selected


;INITIALISE DRIVE 0 STATUS ARRAY
        mov     bx,#FS_stat-databaseqq  ;set up offset
        call    put_in_bits


;INITIALISE DRIVE 1 STATUS ARRAY
        add     bx,#D_length            ;next one
        call    put_in_bits
        add     bx,#D_length            ;and again


;DROP THROUGH TO SUBROUTINE TO INITIALISE ARRAY AND EXIT



;SUBROUTINE TO INITIALISE ARRAY POINTED TO BY BX
put_in_bits
        movb    D_on_line[bx],#0        ;NOT on line
        movb    D_track[bx],#0          ;track zero
        movb    D_swapped[bx],#1        ;we are swapped
	movb	D_head[bx],#0		;head unloaded
        ret 


        End


$ 