MOUSE   COM           00  CONFIG  UK    

; [bios.apricot.rom]diskrwv.asm
	TITLE	'[bios.apricot.rom]diskrwv.asm'
;
        Include 'legal.asi'
;*************************************************************************
;
;       FILENAME:       [bios.apricot.rom]diskrwv.asm
;       PROGRAMMER:     G. Kurth
;       IMPLEMENTED:    20-jan-84
;       MODIFIED:
;                       23-jan-84 - non 8089 apricot support
;			ROM BIOS version 15/8/84
;
;************************************************************************

        name DiskRWV
                        
        Include 'iop.asi'
        Include 'ioregs.asi'
        
        Global CodeBaseQQ,DataBaseQQ   ;   set during link
        
        
        Section DiskRWV.instr,align(1),class=instrQQ
        
        Assume ds:DataBaseQQ, cs:CodeBaseQQ
;

        Global  rw_PB           ;read/write globals
        Global  rw_TB
        Global  rw_offset
        Global  rw_segment
        Global  rw_sec_count
        Global  rw_cur_sec
        Global  rw_8089_cc
        Global  rw_FDC_com
        
        Global  vfy_PB          ;verify globals
        Global  vfy_TB
        Global  vfy_offset
        Global  vfy_segment
        Global  vfy_byte_count
        Global  vfy_fin_mc
        Global  vfy_FDC_com

        
        Global	DRWV_sctr, DRW_wait_89
        
; FDC command bytes
FDC_Read        equ     088h    ;single sector read, head 0, no delay
FDC_Write       equ     0A8h    ;single sector write, head 0, no delay
FDC_vfy         equ     098H    ;multi-sector read, head 0, no delay
;
; IOP channel commands
;
Read_cc         equ     (CC_p2m!CC_srcsync!CC_tBC0!CC_tx4!CC_srcGA)
Write_cc        equ     (CC_m2p!CC_dstsync!CC_tBC0!CC_tx4!CC_srcGB)
;  
	page
        
;---------------------------------------------------------------------------;
;   DRW_wait_89 - Wait for 8089 channel one not busy
;
;
;---------------------------------------------------------------------------;

DRW_wait_89
        push    es
        xorw    ax,ax
        movw    es,ax
DRW_wait_1
        cmpb    es:501h,al              ;busy flag clear in iop channel 1?
        jnz     DRW_wait_1
        pop     es
        ret

	page        
;---------------------------------------------------------------------------;
;   DRWV_sctr - Read/Write/Verify sector(s) within one track
;
;	On entry:	[sp+10]	First sector number
;			[sp+8]	Number of sectors (max=9)
;			[sp+6]	Memory address segment
;			[sp+4]	Memory address offset
;			[sp+2]	Operation Type + Head (0 or 1)
;
;       Where 'type' =  0000h + head bit - READ
;                       0100h + head bit - WRITE
;                       0200h + head bit - VERIFY
;

DRWV_sctr
        call    DRW_wait_89             ;ensure 8089 is not busy
        movw    bp,sp
        
        cmpb    3[bp],#2                ;verify?
        jb      DRW_sctr                ;no - read or write
        jmp     DV_sctr                 ;do verify if not 0 or 1
DRW_sctr
        movw    ax,4[bp]                ;rw_offset:=mem_addr.offset
        movw    rw_offset,ax
        
        movw    ax,6[bp]                ;rw_segment:=mem_addr.segment
        movw    rw_segment,ax
        
        mov     ax,10[bp]               ;FDC_sctr:=first_sctr
        mov     rw_cur_sec,ax
        
        mov     ax,8[bp]                     ;n_sectors
        mov     rw_sec_count,ax
        
        mov     ax,2[bp]                ;get operation type
                                        ; al = head (0 or 1)
                                        ; ah = read (0) or write (1)
        shl     al,#1                   ;move head bit to bit 1
        and     al,#2                   ;mask to only head bit
        cmp     ah,#1                   ;write?
        jne     DRW_read                ;no - do read
        movw    rw_8089_cc,#Write_cc	;set write channel control
        orb     al,#FDC_write           ;or write command into head bit
        jmpsh   DRW_go                  ;and go
DRW_read
        movw    rw_8089_cc,#Read_cc	;set read channel control
        orb     al,#FDC_read            ;or read command into head bit
DRW_go
        movb    rw_FDC_com,al		;set up FDC command
        
   
        movw    dx,ds
        xorw    ax,ax
        movw    ds,ax
        movw    bx,#500h                ;DS:BX --> IOP_CCB
        
        movw    4[bx],dx
        movw    2[bx],#(rw_PB-DataBaseQQ)
DRWV_exit
        movw    [bx],#0EE03H            ;pre-set busy byte, start prog. cmd.
        
        movw    ds,dx                   ;restore DS
        
        out     #IOP_CH1,al

	call	DRW_wait_89		;wait for 8089 to complete

        ret     #10                     ;clear 5 words off stack


;****************************************************************************
;                                                                           ;
; Disk Verify Procedure.                                                    ;
; =====================                                                     ;
;                                                                           ;
;   This is rather a fudge version. Since this bloody stupid 8089 type      ;
; thing does not have a verify mode, I'm just going to read back the data,  ;
; throw it away and hope that any errors are detected by the FDC's CRC      ;
; checking.  This saves having a 9-sector buffer and doing a subsequent     ;
; memory-memory verification or doing the verification using 'single trans- ;
; fer mode' on the 8089 and then checking each byte individually. I've a    ;
; feeling that this won't work as the loop (a) has to take less than 16us   ;
; and (b) shouldn't lock out the 8086 for the 8ms it takes to read a whole  ;
; sector.                                                                   ;
;                                                                           ;
;   So note that although mem_addr is passed across as a parameter to the   ;
; 8089 routine, it's ignored.                                               ;
;                                                                           ;
;    So there ya go Bruce, if ya don't like it, you fix it.                 ;
;                                                                           ;
;---------------------------------------------------------------------------;
;
;
DV_sctr
        ;movw   ax,4[bp]                ;vfy_offset:=mem_addr.offset
        ;movw   vfy_offset,ax
        
        ;movw   ax,6[bp]                ;vfy_segment:=mem_addr.segment
        ;movw   vfy_segment,ax
        
        movb    al,10[bp]                ;FDC_sctr:=first_sctr
        out     #FDC_SEC,al		; FDC sector register
        
        addb    al,8[bp]                ; vfy_fin_mc:=(0FF00h and (first_sctr-n_sctrs))
        movb    ah,#0FFh
        movw    vfy_fin_mc,ax
        
        movb    ah,8[bp]                ;vfy_byte_count:=512*n_sctrs
        shl     ah,#1
        xorb    al,al
        movw    vfy_byte_count,ax
        
        movw    ax,2[bp]                ;type
                                        ;al = head (0 or 1)
        shl     al,#1
        andb    al,#2                   ;get head bit down to bit 1
        orb     al,#FDC_vfy             ;or in command
        movb    vfy_FDC_com,al
        
        movw    dx,ds
        xorw    ax,ax
        movw    ds,ax
        movw    bx,#500h                ;DS:BX --> IOP_CCB
        
        movw    4[bx],dx
        movw    2[bx],#(vfy_PB-DataBaseQQ)
        jmp     DRWV_exit               ;set off 8089 and exit

       
            End

$ 