f





























           

; [bios.apricot.ram]keyboard.asm
	title	'[bios.apricot.ram]keyboard.asm'
        INCLUDE 'legal.asi'
;****************************************************************************
;*                                                                          *
;*  Old file name:                  /usr/geoff/keybd/KBhandler.asm          *
;*  New file name:                  [bios.apricot.ram]keyboard.asm          *
;*  Programmer:                     G. Kurth                                *
;*  Original implementation date:   30th march 1983                         *
;*  Language:                       Tektronix 8086/88 assembler.            *
;*  Revision history:               Re-created 11-may-1983                  *
;*                                                                          *
;*  Adapted for ACTIVM:             26th March 1984                         *
;*  Programmer:                     Vince CORBIN                            *
;*				VAX version 2/5/84 GK			    *
;*				Real version 9/5/84 GK			    *
;*				ROM BIOS version 21-may-84		    *
;*				Ten function key layout 30/7/84 GK	    *
;*				APRICOT PC version 2/aug/84		    *
;*				Apricot RAM bios version 5/9/84 GK	    *
;*                                                                          *
;****************************************************************************
        page
;
;       Module Declarations
;
        name    KBD_handler                 ;key handler
;
;
        ;
        INCLUDE 'Genequ.asi'               ;include constant equates
	INCLUDE	'Copyregs.asi'
	INCLUDE	'ioregs.asi'
        ;
;
        GLOBAL  codebaseqq,databaseqq
;
        ASSUME  DS:databaseqq, SS:databaseqq, CS:codebaseqq

;** Internal Routines **
	GLOBAL	KBD_handler
	GLOBAL	KBD_init
	GLOBAL	KBD_config
	GLOBAL	KC_error
	GLOBAL	KC_led_set
	GLOBAL	KC_repeat

;** External Routines **
        GLOBAL  KBD_q_out
	GLOBAL	KBD_q_get
	Global	KBD_qinit
	GLOBAL	KC_click
	GLOBAL	KC_bell
	Global	Calc_input
	Global	CLK_key_in
	Global	KC_kbdq_out
	Global	KC_transmit
	Global	LCD_echo_en
	Global	LCD_echo_dis
	Global	LCD_calc_on
	Global	LCD_init
	Global	KLCD_restore

;** External Data **
	Global	screen_active
	Global	KBD_queue
	Global	KBD_q_opt
	Global	KBD_in_count
	Global	KBD_q_count
	Global	CNF_rept_en
	Global	CNF_rept_dly
	Global	CNF_rept_int
	Global	LCD_echo_on

;** Internal Data **
	Global	KD_status
	Global	KD_shift_cnt
	Global	KD_trans_off
	Global	KD_missing
	Global	KD_led_status

        page
;
	stitle	'keyboard handler equates'
;
;	Keyboard Lookup Bit definitions
;
str_bit		equ	80h	;string indicator bit
spc_bit		equ	40h	;special key bit
rep_bit		equ	20h	;repeat allowed bit
shl_bit		equ	10h	;affected by shift lock bit
cpl_bit		equ	08h	;affected by caps lock bit
lcl_bit		equ	04h	;local key bit
prf_bts		equ	03h	;prefix type bits
;
spmax		equ	8	;maximum number of special keys
;
;	KD_status bit definitions
;
ihelp_on	equ	01h	;ignore help in fallthrough
stop_on		equ	02h	;stop key on
calc_on		equ	04h	;calc mode on
shftl_on	equ	08h	;shift lock on
fall_on		equ	10h	;fallthrough mode on
voice_on	equ	20h	;voice led on
klock_on	equ	40h	;keyboard lock on
capsl_on	equ	80h	;caps lock on
;
locks_on	equ	(shftl_on ! capsl_on)	;caps & shift lock bits
;
dcmin		equ	1	;lowest valid downcode
dcmax		equ	104	;highest valid downcode
dbmax		equ	16	;maximum entries in downcode buffer
;
;	Data bytes to the keyboard unit
;
kbd_query	equ	0E0h	;keyboard query
tad_req		equ	0E1h	;time and date request
tad_set		equ	0E4h	;time and date set
led_pref	equ	0E3h	;set led prefix code
kbd_rest	equ	0E8h	;keyboard reset
;
;	Data bytes from the keyboard
;
kbd_xon		equ	0EAh	;XON code
kbd_xoff	equ	0EBh	;XOFF code
res_req		equ	0ECh	;reset request
kbd_ack		equ	0FBh	;keyboard acknowledge
;
;	Special Key Numbers
;
nul_key		equ	0	;null key
cpl_key		equ	1	;caps lock key
rhs_key		equ	2	;right hand shift
lhs_key		equ	3	;left hand shift key
ctl_key		equ	4	;control key
stp_key		equ	5	;stop key
clc_key		equ	6	;calculator key
ech_key		equ	7	;LCD echo key
vce_key		equ	8	;voice key


	page
;
        SECTION KBDhandler.code, ALIGN(1), CLASS = INSTRQQ
                                                ;Part of keyboard handler
                                                ;code area
;
	stitle	'keyboard handler initialisation'
;
;	KBD_init	- ROM keyboard initialisation - checks for
;			keyboard present and inits it,
;			and enables SIO interrupts.
;			Assumes INTERRUPTS DISABLED
;
KBD_init
		call	KC_init		;init variables
		call	KBD_reset	;reset the keyboard
		mov	al,#1		;select write register 1
		out	#SIO_B_COM,al	;- keyboard
		mov	al,COPY_SIO_W1B	;get current SIO write reg 1 B
		orb	al,#1Ah		;set TX & RX interrupts
		out	#SIO_B_COM,al
		mov	COPY_SIO_W1B,al	;update copy
		mov	al,#28h		;reset TX int pending
		out	#SIO_B_COM,al
		pushf
		cli
		in	al,#PIC_IMR	;enable SIO ints
		and	al,#0DFh
		out	#PIC_IMR,al
		popf
		call	LCD_init	;initialise the LCD driver
		mov	al,#0E1h	;ask for time & date (for clock)
		call	KC_kbdq_out	;send to keyboard
		ret
;
;-----------------------------------------------------------------------
;	KC_reinit	- Re-initialise keyboard after power loss
;
KC_reinit
		pushf
		cli		
		call	KC_error	;clear out buffers
		call	KBD_reset	;reset the keyboard hardware
		andb	KD_status,#\calc_on	;no calc
		movb	LCD_calc_on,#0		;for sure
		popf
		call	KLCD_restore	;restore the LCD
		mov	al,#0E1h	;ask for time & date
		call	KC_kbdq_out
		ret			;done
;
;-----------------------------------------------------------------------
;	KBD_reset	- sends Reset to keyboard and waits for response
;
KBD_reset
		call	KBD_reset1	;try once
		cmp	al,#0		;ok
		jz	KBD_resetx	;yes - done
KBD_reset1	
		in	al,#SIO_B_STAT	;get tx status
		test	al,#04h		;ready?
		jz	KBD_reset1	;nope
		mov	al,#0E8h	;reset command
		out	#SIO_B_DAT,al	;to keyboard
		mov	bx,#200		;wait about 40ms
KBD_reset2
		mov	cx,#200		;
		shl	cx,cl		;delay
		decw	bx
		jnz	KBD_reset2	;loop
		in	al,#SIO_B_STAT	;is there anything there?
		test	al,#1
		jz	KBD_reset3	;nope - shame
		in	al,#SIO_B_DAT	;get char
		cmp	al,#0FBh	;is it the acknowlege?
		jb	KBD_reset3	;no
		cmp	al,#0FEh
		ja	KBD_reset3	;shame that
		xor	ax,ax
		mov	KD_missing,al	;keyboard not missing
		ret
;
KBD_reset3
		mov	al,#1
		mov	KD_missing,al	;keyboard gone
KBD_resetx	ret
;
;---------------------------------------------------------------------
;	KC_init	- Initialises keyboard driver software
;
KC_init		pushf
		cli
		cld
		xor	ax,ax		;set accumulator to zero
		lea	di,KD_database
		mov	cx,#(KD_datatop-KD_database)
		rep	stob		;fill data areas with zero's
		lea	di,KD_downbuff	;clear downcode buffer
		mov	cx,#dbmax
		not	ax		;ax=0FFFFh
		rep	stob		;fill buffer with FF's
		call	KBD_qinit	;initialise keyboard queue
		popf
		ret
;
;--------------------------------------------------------------------------
;	KC_error	- Resets keyboard downcode buffer
;			and clears out control & shift counts
;			For use when nasty character received.
;
KC_error
		pushf
		cli
		xor	ax,ax		;
		movb	KD_downcount,al
		movb	KD_shift_cnt,al
		movb	KD_control_cnt,al
		cld
		lea	di,KD_downbuff	;clear downcode buffer
		mov	cx,#dbmax
		not	ax		;
		rep	stob		;fill buffer with FF's
		popf
		ret
;

	page
	stitle	'Auto-Repeat handler'
;-----------------------------------------------------------------------------
;
;	KC_repeat	- Auto-repeat handler, called every 20ms by the
;			system clock.
;
KC_repeat
		cmpb	KD_downcount,#1		;only one key down?
		jne	KC_rep_end		;no - abort
		xor	ax,ax
		cmp	CNF_rept_en,al		;auto-repeat allowed?
		jz	KC_rep_end		;no - abort
		testb	KD_status,#stop_on	;is stop mode on?
		jnz	KC_rep_end		;yes - abort
		cmp	KD_rep_dly,al		;lead-in delay done
		jz	KC_rep_0		;yes - go repeat
		decb	KD_rep_dly		;count down lead-in
		jmpsh	KC_rep_end		;done
;
KC_rep_0	incb	KD_rep_div		;bump rate divisor
		mov	al,CNF_rept_int		;get interval
		cmp	KD_rep_div,al		;there?
		jb	KC_rep_end		;no - abort
		mov	KD_rep_div,ah		;reset rate divisor
;
;	1)	Search through downcode buffer for repeat key
;
KC_rep_1	xor	bx,bx			;clear buffer pointer
KC_rep_2	cmp	bl,#dbmax		;at end of buffer?
		jae	KC_rep_end		;yes - no key found - abort
		cmpb	KD_downbuff[bx],#0FFH	;anything there?
		jne	KC_rep_3		;yes - go have a look
		inc	bx			;bump pointer
		jmpsh	KC_rep_2		;loop through buffer
;
KC_rep_3	mov	al,KD_downbuff[bx]	;get scan code
		testb	KD_status,#calc_on	;is the calculator on?
		jz	KC_rep_4		;no - skip
		xor	ah,ah			;clear top
		mov	dx,ax			;save code in dx
		mov	cl,#3			;divide key number by 8
		shrb	al,cl
		lea	bx,KD_calc_map		;point at calc key map
		xlat				;get byte from map in al
		mov	cl,dl			;put key number in cl
		and	cl,#07h			;strip to 3 bits
		inc	cl			;adjust for 1-8
		shrb	al,cl			;shift entry into carry
		mov	ax,dx			;restore scan code
		jb	KC_rep_end		;abort on carry
KC_rep_4	call	KBD_conv		;convert key
		test	ah,#str_bit		;string key?
		jz	KC_rep_6		;yes - check for repeat allowed
		test	ah,#spc_bit		;special key?
		jnz	KC_rep_end		;yes - abort
		test	ah,#rep_bit		;is repeat allowed in any case?
		jz	KC_rep_end		;no!
;
KC_rep_5	call	KBD_rept_out		;send key to queue
KC_rep_end	ret				;done
;
KC_rep_6	push	es			;save es
		mov	bx,ax			;string pointer in bx
		xor	di,di
		mov	es,di			;point at page 0
		les	di,es:712h		;set es:di -> keyboard table
		mov	bx,es:[bx][di]		;get type & count in bx
		pop	es			;restore es
		test	bh,#rep_bit		;is it allowed to repeat?
		jnz	KC_rep_5		;yes - go for it
		ret				;no - done
		
;
	page

        stitle  'main module - code despatcher'
;--------------------------------------------------------------------------
;
;       KBD_handler     - Module entry point and main handler
;			Key scan code passed in AL.
;                       If keyboard is in pass-through mode then
;                       raw codes are passed straight through to
;                       the MS-dos input queue.
;                       Despatches Key codes to code handler, and
;                       other data to non-key data handler.
;
;       INPUTS:         Single byte in AL
;       OUTPUTS:        none
;       USAGE:          AX, CX, BP + called routines
;       CALLS:          KBD_code
;                       KBD_q_out
;
KBD_handler
		xor	ah,ah			;clear out ah
		cmp	al,#dcmin		;less than valid downcode?
		jb	KBD_nonkeys		;yes - go to non-key handler
		cmp	al,#dcmax		;is it a valid downcode?
		jbe	KBD_downcode		;yes - go to downcode handler
		cmp	al,#dcmin+80h		;less than valid upcode?
		jb	KBD_nonkeys		;send to non key handler
		cmp	al,#dcmax+80h		;valid upcode?
		jbe	KBD_upcode		;yes - go to upcode handler
;
KBD_nonkeys	call	KC_nonkeys		;call non key handler
		ret				;and exit
;
KBD_downcode	testb	KD_status,#fall_on	;in pipeline mode?
                jnz     KBD_noninterp		;send data straight to MS-Dos
                call    KBD_dcode		;call code handler
                ret
;
KBD_upcode	testb	KD_status,#fall_on	;in pipeline mode?
                jnz     KBD_noninterp		;send data straight to MS-Dos
                call    KBD_ucode		;call code handler
                ret
;
KBD_noninterp 
                testb	KD_status,#ihelp_on	;ignoring help?
                jnz     KBD_non1		;yes - skip test
                cmpb    al,#01			;HELP key (zero - F1)?
                jz      KBD_nonhlp		;yeigh or neigh
;
KBD_non1
                movb	ah,#1			;say one key coming
		push    ax			;put code on stack
                call    KBD_q_out		;and into queue
                ret
;
KBD_nonhlp
                andb	KD_status,#\fall_on	;reset funny mode
;
KBD_h_end       ret				;return
;
	page
;-------------------------------------------------------------------------
;	KC_nonkeys	- Non-key code handling
;		Handles:
;			Keyboard Reset Request
;			XON XOFF queue control
;			MOUSE data
;			TIME & DATE codes
;	INPUT:	Code in AL
;	OUTPUT:	NONE
;	USES:	AX + BX + called routines
;	CALLS:	KC_reinit
;		KC_transmit
;		CLK_key_in
;
KC_nonkeys
		cmp	al,#res_req	;reset request?
		je	KC_non_k2	;yes - handle it
		cmp	al,#kbd_xoff	;XOFF code?
		je	KC_non_k3	;yes - disable transmit
		cmp	al,#kbd_xon	;XON code?
		je	KC_non_k4	;yes - enable transmit
		cmp	al,#0F0h	;Time & Date data?
		jb	KC_non_1	;no - skip
		cmp	al,#0FAh	;Time & date data?
		jbe	KC_non_k5	;yes - handle time input
KC_non_1	cmp	al,#0EFh	;MOUSE lead-in code?
		je	KC_non_k6	;yes - go start up
		cmp	al,#070h		;MOUSE data?
		jb	KC_non_2	;nope - skip
		cmp	al,#080h	;MOUSE data?
		jb	KC_non_k7	;yes - go for it
KC_non_2
		; Handle any other bits here

KC_non_x		ret
;
;	1)	Reset request - re-initialise the keyboard
;
KC_non_k2	call	KC_reinit	;do the reinit
		ret
;
;	2)	XOFF code - set transmit disable flag
;
KC_non_k3	movb	KD_trans_off,#01h
		ret
;
;	3)	XON code - clear transmit disable flag
;
KC_non_k4	movb	KD_trans_off,#00h
		call	KC_transmit	;try to transmit
		ret
;
;	4)	Time & Date code - send to clock
;
KC_non_k5	call	CLK_key_in	;send al to clock
		ret
;
;	5)	Mouse lead-in detect - sets up mouse buffer & disables transmit
;
KC_non_k6	movb	KD_mouse_ipt,#00
		jmpsh	KC_non_k3	;disable transmit
;
;	6)	Mouse data collection
;
KC_non_k7	xor	bx,bx
		mov	bl,KD_mouse_ipt		;get mouse packet input pointer
		mov	KD_mouse_q[bx],al	;put data in queue
		cmp	bl,#4			;done 5 bytes?
		jae	KC_non_k8		;yes - transmit mouse packet
		incb	KD_mouse_ipt		;bump pointer
		ret
;
;	7)	Mouse data transmit
;		called by reception routine when whole packet here
;
KC_non_k8	lea	bx,KD_mouse_q		;point at queue
		mov	al,[bx]			;get first = button
		shl	al,#1			;shift to middle bits
		and	al,#06h			;strip to button bits
		or	al,#09h			;set Y packet & mouse bits
		mov	ch,al			;save in ch
		mov	cl,#4			;count for 4 shifts
		mov	ax,1[bx]		;get Y bytes
		and	ax,#0F0Fh		;knock down to nibbles
		shl	al,cl			;zap up high nibble
		or	al,ah			;and add in low nibble
		mov	ah,ch			;get buttons
		int	#0F5h			;send the Y packet
		mov	ax,3[bx]		;get X data
		and	ax,#0F0Fh		;knock down to nibbles
		shl	al,cl			;zap up high nibble
		or	al,ah			;and add in low nibble
		mov	ah,ch			;get buttons
		and	ah,#0Eh			;clear X bit
		int	#0F5h			;send X-packet
		jmpsh	KC_non_k4		;re-enable transmit
;
	page
;------------------------------------------------------------------------
;		
;	KBD_ucode	- Upcode handler
;			Key data enters in AL, is converted to 0-103 range
;			and converted to check for special key.
;			Normal keys simply have their entries in the
;			downcode buffer removed.
;			The CONTROL & SHIFT specials are acted upon.
;
;	INPUT:	AL = raw scan code
;	OUTPUT:	None
;	CALLS:	KC_convert
;	USES:	AX,BX,DX + called routine
;
KBD_ucode
		and	ax,#007Fh		;strip down to 1-104
		dec	al			;adjust to 0-103
		push	ax			;save for later
		call	KBD_conv		;convert character
		pop	dx			;restore original code to DX
		test	ah,#str_bit		;is it a string?
		jz	KBD_uc_n0		;yes - skip special test
		test	ah,#spc_bit		;is it a special key?
		jnz	KBD_uc_s1		;yes - go handle
;
;	1) Normal or String key upcode - remove entry from downcode buffer,
;	   update the down count, enable/disable auto-repeat
;
KBD_uc_n0	mov	al,dl			;get scan code in al
		xor	bx,bx			;zero out buffer index
KBD_uc_n1	cmp	bl,#dbmax		;at end of buffer?
		jae	KBD_uc_n3		;yes - do not remove
		cmp	KD_downbuff[bx],al	;code matches buffer?
		je	KBD_uc_n2		;yes - extract
		inc	bx			;bump pointer
		jmpsh	KBD_uc_n1		;loop through buffer
;
KBD_uc_n2	movb	KD_downbuff[bx],#0FFh	;clear buffer entry
KBD_uc_n3	mov	al,KD_downcount		;get downcode count
		and	al,al
		jz	KBD_uc_n4		;zero - don't decrement
		dec	al			;count down
		cmp	al,#1			;only one down?
		jne	KBD_uc_n4		;no - skip
		mov	ah,CNF_rept_dly		;get lead-in delay
		mov	KD_rep_dly,ah		;and set up lead-in
KBD_uc_n4	mov	KD_downcount,al		;set up new downcount
		ret				;done
;
;	2)	Special key upcodes - act on CONTROL & SHIFT keys
;
KBD_uc_s1	cmp	al,#ctl_key		;is it the CONTROL key?
		jne	KBD_uc_s2		;nope - skip
		cmpb	KD_control_cnt,#0	;is down count 0?
		jz	KBD_uc_sx		;yes - don'decrement
		decb	KD_control_cnt		;count down control keys
KBD_uc_sx	ret				;done
;
KBD_uc_s2	cmp	al,#rhs_key		;is it the RIGHT SHIFT?
		je	KBD_uc_s3		;yes - do it
		cmp	al,#lhs_key		;is it LEFT SHIFT?
		jne	KBD_uc_sx		;no - done
KBD_uc_s3	cmpb	KD_shift_cnt,#0		;shift count zero?
		jz	KBD_uc_sx		;yes - abort
		decb	KD_shift_cnt		;count down shifts
		ret				;done
;
	page
;-----------------------------------------------------------------------------
;
;       KBD_dcode     -  Valid keyboard down-code handler
;			Enter with data in al,in Apricot form.
;                       The down code is then converted via the look-up
;                       tables, into a Type byte and an ASCII data byte,
;                       or a 15 bit string pointer.
;                       The special keys (CAPS LOCK, STOP, and CALC),
;			are then filtered off to a subsection of code
;			KBD_code_spec - see later.
;                       The current mode is checked to see if we are
;                       in a STOP condition, if so, the stop is cleared
;                       and the STOP key LED extinguished.
;                       The current mode is then checked to see if we are in
;                       'calc' mode, if so, the key is checked via the
;                       calculator specific bit map to see if it should be
;                       sent to the calculator, if this is true, the down
;                       code is sent to the calculator input buffer, and the
;                       routine returns.
;                       If the key is a LOCAL mode key, then the 'destination'
;                       flag is set to indicate that output should be sent to
;                       the screen.
;                       The prefix flags are then checked to see if an escape
;                       sequence should be sent with the key, if so these are
;                       passed to the output routine.
;                       The ASCII key data is then sent to the output routine,
;                       and the procedure then returns.
;
;       INPUTS: Single byte in AL - valid down code
;       OUTPUTS:None - directly - subroutines called to output data
;       USES:   AX, BX, CX, DX + called routines
;       CALLS:  none
;
;
;
KBD_dcode
;
;       1)      Convert key number to key type & data
;
		and	ax,#007Fh		;strip to 1-104
		dec	al			;adjust 0-103
                push    ax                      ;save key number
                call    KBD_conv                ;convert via lookup tables
                                                ;into Type & data in ax
		pop     dx                      ;restore key number into dx
                testb   ah,#str_bit             ;is it a string key?
                jz      KBD_dcode_3             ;yes - do not test for special
                testb   ah,#spc_bit             ;is it a special key?
                jz      KBD_dcode_3             ;no - continue
                jmp     KBD_code_spec           ;yes - branch to special handler
;
;       3)      Check for STOP mode, clear mode and switch off the stop led.
;
KBD_dcode_3     testb	KD_status,#stop_on	;are we in stop mode?
                jz      KBD_dcode_31            ;no - skip to next operation
		andb	KD_status,#\stop_on	;clear stop mode
		push	ax
		push	dx
		call	KBD_set_leds		;and do the leds
		pop	dx
		pop	ax						
;
;	4)	Add normal/string code to downcode buffer
;		increment count of keys down,
;		and set/reset repeat flag.
;
KBD_dcode_31	xor	bx,bx			;use bx as buffer pointer
KBD_dcode_32	cmp	bl,#dbmax		;at end of buffer?
		jae	KBD_dcode_34		;yes - don't add downcode
		cmpb	KD_downbuff[bx],#0FFh	;free slot?
		je	KBD_dcode_33		;yes - go fill it
		inc	bx			;bump pointer
		jmpsh	KBD_dcode_32		;loop through
;
KBD_dcode_33	mov	KD_downbuff[bx],dl	;put code in buffer
KBD_dcode_34	cmpb	KD_downcount,#0		;will there be one key?
		jnz	KBD_dcode_35		;no - skip
		mov	bl,CNF_rept_dly		;set up lead-in delay
		mov	KD_rep_dly,bl
KBD_dcode_35	incb	KD_downcount		;bump downcount
;
;       5)      Check for calculator mode, check if key calculator
;               specific, & send to calculator input buffer.
;
KBD_dcode_4     push	ax			;save key type & data
		testb	KD_status,#calc_on	;in calculator mode?
                jz      KBD_dcode_6		;no - skip
                mov     ax,dx                   ;put key status & scan
		movb    ah,al                   ;copy key number into ah
                movb    cl,#3                   ;divide key number by 8
                shrb    al,cl                   ;to give bit map byte
                lea	bx,KD_calc_map		;point to bit map
                xlat                            ;get byte from bit map in al
                movb    cl,ah                   ;put key number in cl
                andb    cl,#07H                 ;get 0-7 value (bit select)
                incb    cl                      ;adjust to 1-8
                shrb    al,cl                   ;shift bit into carry
                jae     KBD_dcode_6              ;carry not set - not calc
		pop	ax			;clear type & data from stack
		incb	dl			;adjust range for calculator
                push    dx                      ;key scan
                call    CALC_INPUT              ;send to calculator
KBD_dcode_5	jmp     KBD_dcode_end            ;clean-up & return
;
;	KBD_rept_out	- entry point for Auto_repeat
;			key code in AX.
;
KBD_rept_out
		push	ax			;put key code on stack
;
KBD_dcode_6	call    KC_click                ;sound feedback click
		pop	cx			;put key type & data in cx
                testb   ch,#str_bit             ;string bit set?
                jnz     KBD_dcode_7             ;yes - not a string, skip
		push	es
		xor	di,di
		mov	es,di
		les	di,es:712h		;set es:di -> keyboard table
		movw    bx,cx                   ;type & data is string pointer - in bx
                movw    cx,es:[bx][di]          ;get string type & count in cx
                andb    ch,#\str_bit            ;ensure string bit not set
                pop	es
;
;       2)      Check for local key
;
KBD_dcode_7     testb   ch,#lcl_bit             ;local bit set?
                jz      KBD_dcode_8             ;no - skip
                cmpb    screen_active,#0        ;is screen driver active?
                jnz     KBD_dcode_end           ;yes - ignore local
                movb    KD_destination,#1       ;set destination to screen
;
;       3)      Check for prefix bits & send appropriate codes
;
KBD_dcode_8     testb   ch,#prf_bts             ;test prefix bits
                jz      KBD_dcode_12            ;no - prefix, output char
                movb    ah,#3                   ;say string length of three
                testb   ch,#str_bit             ;is it a string key as well?
                jnz     KBD_dcode_9             ;no - skip
                addb    ah,cl                   ;yes - add string length
KBD_dcode_9     movb    al,#1BH                 ;send an 'ESC' code
                call    KBD_code_out            ;to queue
                andb    al,al                   ;error?
                jnz     KBD_dcode_end           ;yes - skip rest of string
                testb   ch,#02H                 ;ESC only?
                jz      KBD_dcode_12            ;yes - send character now
                testb   ch,#01H                 ;ESC, [ prefix?
                jz      KBD_dcode_10            ;yes - send '['
                movb    al,#'O'                 ;send 'O' for 'ESC O' prefix
                jmp     KBD_dcode_11             ;
KBD_dcode_10    movb    al,#'['                 ;set up '['
KBD_dcode_11    movb    ah,#1                   ;set count to 1 character
                call    KBD_code_out            ;and send
;
KBD_dcode_12    testb   ch,#str_bit             ;string key?
                jz      KBD_dcode_13            ;yes - output string
                movb    ah,#1                   ;otherwise single character
                movb    al,cl                   ;from cl
                call    KBD_code_out            ;send it
                jmp     KBD_dcode_end           ;done
;
KBD_dcode_13    orb     cl,cl                   ;zero length string?
                jz      KBD_dcode_end           ;yes - done
                incw    bx                      ;adjust string pointer
                incw    bx                      ;to point at start of string
                xorb    ch,ch                   ;strip cx to character count

KBD_dcode_14    push    es                      ;setup ES:DI for start of table
		xor	di,di
		mov	es,di
                les	di,es:712h
 
KBD_dcode_ns    movb    al,ES:[bx][di]          ;get string character
                movb    ah,cl                   ;string count in ah
                push    es
                push    di
                call    KBD_code_out		;output character
                pop     di
                pop     es
                andb    al,al                   ;was there room?
                jnz     KBD_dcode_15            ;no - abort
                incw    bx                      ;bump pointer
                loop    KBD_dcode_ns            ;loop till done

KBD_dcode_15	pop	es                      ;restore registers
;
KBD_dcode_end   movb    KD_destination,#0       ;reset destination to MS-DOS
                ret				;exit downcode handler

	page
;--------------------------------------------------------------------------
; KBD_code_out	- sends character in al to appropriate queue.
;
;
KBD_code_out    push    cx                      ;save character & type
                push    bx
		cmpb    KD_destination,#0       ;to MS-dos?
                jnz     KBD_code_o1             ;no - send to local
                push    ax                      ;send character & count
                call    KBD_q_out		;send to MS-dos queue
                jmpsh   KBD_code_o3             ;done
KBD_code_o1     int     #0F1h                   ;send al to screen
KBD_code_o2     xorw    ax,ax                   ;say ok transfer
KBD_code_o3     pop     bx                      ;restore string pointer
                pop     cx                      ;and character type/data
		ret
        ;
        page
        stitle  'Special key downcodes handler'
;
;       KBD_code_spec    -       Handles setting of statuses on receipt
;                       of special key down codes for null, control, right
;                       and left hand shift, caps lock, stop, and calc keys,
;                       sends requests for led state changes to led routines.
;       INPUT:  Key special type number in AL, key status & pos in dx
;       OUTPUT: none (direct)
;       USES:   AX, BX & called routines.
;       CALLS:  KC_click
;
;       1)      ignore invalid special key numbers, convert number to
;               word index into jump table, and go to handler.
;
KBD_code_spec   cmpb    al,#spmax               ;legal special key number?
                ja      KBD_dcode_end		;no - ignore key
                movb    bl,al                   ;use number as index
                xorb    bh,bh                   ;zero out top of bx
                shlw    bx,#1                   ;multiply by 2 for word index
                jmp     [CS:KD_stab][bx]        ;jump via special key table
                                                ;to handlers
;
;       2)      special keys jump table to handlers
;
KD_stab         WORD    KBD_dcode_end-codebaseqq	;0 - null key, no action
                WORD    KBD_s_cpl-codebaseqq	;1 - caps lock key
                WORD    KBD_s_shf-codebaseqq	;2 - right-hand shift
                WORD    KBD_s_shf-codebaseqq	;3 - left-hand shift
                WORD    KBD_s_ctl-codebaseqq	;4 - control key
                WORD    KBD_s_stp-codebaseqq	;5 - stop key
                WORD    KBD_s_clc-codebaseqq	;6 - calculator key
                WORD    KBD_s_echo-codebaseqq	;7 - lcd echo key
		WORD	KBD_s_voice-codebaseqq	;8 - voice key
;
;       1)      caps lock key handling
;               sound the keyboard feedback click,
;               if in caps lock then clear lock & led
;               if in shift lock then clear lock & led
;               if in control mode set shift lock & led
;               if in normal mode set caps lock & led
;
KBD_s_cpl       call    KC_click                ;sound click
		testb   KD_status,#locks_on     ;caps lock or shift lock on?
		jz	KBD_s_cpl1		;no - set shift or caps lock
		andb	KD_status,#(\locks_on)	;clear shift and caps lock
		jmpsh	KBD_s_led		;and set up leds
;
KBD_s_cpl1	cmpb	KD_control_cnt,#0	;in control mode?
                jz      KBD_s_cpl2              ;no - set caps lock
                orb     KD_status,#shftl_on     ;set shift lock on
		jmpsh	KBD_s_led		;and send to port
;
KBD_s_cpl2      orb     KD_status,#capsl_on     ;set caps lock
;
KBD_s_led	call	KBD_set_leds		;setup leds
KBD_s_led1	jmp     KBD_dcode_end           ;done - quit downcode handler
;
;	2 & 3)	RIGHT & LEFT SHIFT key handlers
;
KBD_s_shf	incb	KD_shift_cnt		;bump down count
		jmp	KBD_dcode_end
;
;	4)	CONTROL key handler
;
KBD_s_ctl	incb	KD_control_cnt		;bump down count
		jmp	KBD_dcode_end
;
;       5)      stop key handler - sets/resets status & lights/extinguishes led
;               sound the keyboard feedback click,
;		clears the downcode buffer.
;               
KBD_s_stp	call	KC_error		;clear downcode buffer
		call    KC_click                ;sound click
		testb	KD_status,#stop_on	;in stop mode?
		jnz     KBD_s_stp1              ;yes - switch it off
		orb	KD_status,#stop_on	;switch on mode
		jmpsh	KBD_s_led		;and send to port
;
KBD_s_stp1      andb	KD_status,#\stop_on	;clear stop status
		jmpsh	KBD_s_led
;
KBD_s_stp2	testb	KD_status,#stop_on	;stop mode on?
		jnz	KBD_s_stp1		;yes - switch off
		jmp	KBD_dcode_end		;or done
;
;
;       6)      calc key handler, sets calculator mode,
;               and sends start sequences to calculator.
;               
KBD_s_clc	mov	al,#04
		push    ax                      ;send command
                call    CALC_INPUT              ;send it to calculator
		orb	KD_status,#calc_on	;switch on
		jmpsh   KBD_s_stp2		;done - check stop.          
;
;	7)	LCD echo key
;
KBD_s_echo	call	KC_click		;
		cmpb	LCD_echo_on,#0		;echo on?
		jnz	KBD_s_echo1		;yes - switch off
		call	LCD_echo_en		;enable LCD echo
		jmpsh   KBD_s_stp2		;done - check stop.          
KBD_s_echo1	call	LCD_echo_dis		;disable LCD echo
		jmpsh   KBD_s_stp2		;done - check stop.          

;	8)	Voice key handler - does the interrupt
;
KBD_s_voice	int	#0f7h			;do a voice key interrupt
		jmp	KBD_dcode_end		;done

;
        page
;----------------------------------------------------------------------------
;
;       Keyboard downcode conversion routine
;
;       Operation:      Single word entry in ax contains the Apricot code and
;			status of the key.
;                       This key number is converted via the keyboard tables
;                       into the ASCII key byte + Key type byte, or a 15-bit
;                       string pointer - returned in AX.
;                       Area of lookup is controlled by the shift, control,
;                       caps lock, and shift lock status bits.
;
;       INPUT:  AX = ah = status, al = Apricot lookup byte.
;
;       OUTPUT: AX - two bytes - AH = key type
;                                AL = ASCII key data
;                       or:-     AX = 15 bit string pointer
;
;       USAGE:  AX, BX, CX, DX, DI, SI
;
KBD_conv	push    es
						;
                xor	bx,bx                   ; bottom memory segment
                movw    es,bx
		les	di,es:712h		; set es:di -> keyboard table

                mov	bl,al                   ; get offset into bx
                shlw	bx,#1			; convert to word index
		cmpb	KD_control_cnt,#0	; in control mode ?
                
                jnz     KBD_conv_ctrl           ; yes - do control convertion
		cmpb	KD_shift_cnt,#0		; in shift mode ?
                
                jnz     KBD_conv_shift          ; yes - do shift area convertion
		movw    ax,ES:[bx][di]		; get normal key
		movb	cl,KD_status		; get caps & shift lock status                
		testb   cl,#locks_on    	; check if caps or shift lock on
                jz      KBD_conv_end
                
                movb    dh,ah			; save keytab status in dh
                testb   ah,#str_bit		; is this a string key?
                jnz     KBD_conv_n1		; no - skip
                movw    si,ax
                push    bx
                movw    bx,si
                movw    dx,es:[bx][di]		; get first two bytes of string
                pop     bx
                
KBD_conv_n1     testb   dh,#shl_bit		; affected by shift lock?
                jz      KBD_conv_n2		; no - skip
                testb   cl,#shftl_on    	; is shift lock on
                jnz     KBD_conv_shift		; yes - do shift area convert
                
KBD_conv_n2     testb   dh,#cpl_bit		; affected by caps lock?
                jz      KBD_conv_end		; no -skip
                testb   cl,#capsl_on		; is it on?
                jz      KBD_conv_end		; no - skip
                
KBD_conv_shift  movw    ax,es:208[bx][di]
                jmpsh	KBD_conv_end
                
KBD_conv_ctrl	movw    ax,es:416[bx][di]

KBD_conv_end	pop     es
                ret
;
	page
	stitle	'Keyboard configuration'
;---------------------------------------------------------------------------
;	KBD_config	- handles configurator calls for keyboard
;			Enter with data in registers:
;			AX = fail status 0FFFFh
;			CX = command
;			DX = data
;			or DX:SI = pointer
;			Exit with data in AX
;
KBD_config
		mov	bx,cx			;command in BX
		cmp	bx,#000Fh		;valid command?
		ja	KBD_con_x		;no - abort
		shl	bx,#1			;word pointer
		jmp	[cs:KBD_CTAB][bx]	;go to handler
;
KBD_con_ok
		xor	ax,ax			;return ok status
KBD_con_x
		ret				;return status in ax
;
KBD_CTAB	WORD	KBD_con_init-CodebaseQQ	;0 - return status
		WORD	KBD_con_rep-CodebaseQQ	;1 - enable/disable Auto-repeat
		WORD	KBD_con_repi-CodebaseQQ	;2 - set repeat lead-in
		WORD	KBD_con_repr-CodebaseQQ	;3 - set repeat rate
		WORD	KBD_con_mod-CodebaseQQ	;4 - set keyboard fallthrough
		WORD	KBD_con_fls-CodebaseQQ	;5 - flush keyboard
		WORD	KBD_con_ok-CodebaseQQ	;6 - clear downcodes
		WORD	KBD_con_ign-CodebaseQQ	;7 - ignore help toggle
		WORD	KBD_con_out-CodebaseQQ	;8 - send char to ms-dos
		WORD	KBD_con_bel-CodebaseQQ	;9 - sound bell
		WORD	KBD_con_cnt-CodebaseQQ	;A - return buffer count
		WORD	KBD_con_get-CodebaseQQ	;B - Get character from keyboard
		WORD	KBD_con_chk-CodebaseQQ	;C - Queue look-ahead
		WORD	KBD_con_str-CodebaseQQ	;D - Send string to Keyboard queue
		WORD	KBD_con_gst-CodebaseQQ	;E - Get string from Keyboard queue
		WORD	KBD_con_stat-CodebaseQQ	;F - Get/set keyboard status
;
KBD_con_tgl	;subroutine to toggle flag [bx] 0 or 1
		xor	ax,ax			;zap top
		mov	al,[bx]			;get current
		cmp	dx,#1			;valid
		ja	KBD_con_x		;no - return current
		xchg	ax,dx
		mov	[bx],al			;update
		jmpsh	KBD_con_x		;done
;
KBD_con_srf	;subroutine to set/reset flag bit (al) in KD_status
		cmp	dx,#1			;valid?
		ja	KBD_con_srf2		;no - return current
		je	KBD_con_srf1		;set flag
		not	al
		andb	KD_status,al		;clear flag
		not	al
		jmpsh	KBD_con_srf2
KBD_con_srf1	orb	KD_status,al		;set flag
KBD_con_srf2	testb	KD_status,al		;flag set?
		jz	KBD_con_ok		;no - return zero
		mov	ax,#1			;set - return 1
		jmpsh	KBD_con_x
;
KBD_con_init	;initialise keyboard
		call	KC_init			;init software
		call	KBD_set_ledI		;and do the leds
		mov	al,KD_missing
		cbw
		jmpsh	KBD_con_x		;return missing status
;
KBD_con_rep	;enable/disable auto-repeat
		lea	bx,CNF_rept_en
		jmpsh	KBD_con_tgl
;
KBD_con_repi	;get/set repeat lead-in delay
		lea	bx,CNF_rept_dly		;point at repeat lead-in
		jmp	KBD_con_srp		;go do it
;
KBD_con_repr	;get/set repeat rate
		lea	bx,CNF_rept_int		;point at repeat interval
		jmp	KBD_con_srp		;go do it
;
KBD_con_mod	;set/reset fallthrough mode
		movb	al,#fall_on		;fallthrough flag bit
		jmpsh	KBD_con_srf
;
KBD_con_fls	;flush keyboard buffer
		call	KBD_qinit
		jmpsh	KBD_con_ok		;exit with ok status
;
KBD_con_ign	;set/reset help key recognition
		movb	al,#ihelp_on		;ignore help bit
		jmpsh	KBD_con_srf
;
KBD_con_out	;send data to MS-DOS buffer
		mov	dh,#1			;say one char
		push	dx			;send
		call	KBD_q_out		;to Keyboard queue
		jmp	KBD_con_x		;return ax status
;
KBD_con_bel	;sound bell
		call	KC_bell
		jmp	KBD_con_ok
;
KBD_con_cnt	;return queue count
		mov	ax,KBD_q_count
		jmp	KBD_con_x
;
KBD_con_get	;get next key from keyboard
		call	KBD_q_get
		jmp	KBD_con_x
;
KBD_con_chk	;Queue look-ahead
		cmpw	KBD_q_count,#0	;keys in buffer
		jz	KBD_con_chk1	;no - return ax=0FFFFh
		xor	ax,ax
		movw	bx,KBD_q_opt	;point at queue output
		mov	al,KBD_queue[bx]
KBD_con_chk1
		jmp	KBD_con_x	;and return char with ah=00
;
KBD_con_str	;send string to Keyboard queue
		pushf
		cli
		mov	bx,ds		;save ds
		mov	ds,dx		;get pointer
		lodw			;get byte count
		mov	cx,ax		;count in cx
		cld
		lds	si,[si]		;get pointer to string
KBD_con_st1	lodb			;get character
		mov	ah,cl		;count
		push	ds
		mov	ds,bx		;restore ds for call
		push	bx
		push	si
		push	cx
		push	ax		;send char & count
		call	KBD_q_out	;to queue
		pop	cx
		pop	si
		pop	bx
		pop	ds
		cmp	al,#0		;room?
		loopz	KBD_con_st1
		cbw			;convert status
		mov	ds,bx
		popf
		jmp	KBD_con_x	;done
;
KBD_con_gst	;get string from Keyboard queue
		mov	bx,es		;save es
		mov	es,dx		;get pointer
		mov	cx,es:[si]	;get count
		cld
		les	di,es:2[si]	;get pointer to string
KBD_con_gs1	push	es
		mov	es,bx
		push	bx
		push	di
		push	cx
		call	KBD_q_get	;get key from queue
		pop	cx
		pop	di
		pop	bx
		pop	es
		stob	es:		;put data at es:di
		loop	KBD_con_gs1
		mov	es,bx
		jmp	KBD_con_ok	;done
;
KBD_con_stat	;get/set keyboard status
		mov	al,KD_status	;get current status
		mov	ah,al		;save in ah
		and	al,dh		;do the and masking
		or	al,dl		;and the or masking
		xor	ah,al		;any changes?
		jz	KBD_con_stat1	;no -skip
		mov	KD_status,al	;set up status
		PUSH	AX
		call	KBD_set_leds	;and do the LED's
		POP	AX
		test	ah,#calc_on	;calc flag changed?
		jz	KBD_con_stat1	;no - skip
		test	al,#calc_on	;calc flag gone on?
		mov	ax,#4		;start calc
		jnz	KBD_con_stat0	;yes - skip
		mov	ax,#9		;stop calc
KBD_con_stat0	push	ax
		call	Calc_Input	;with 4 on stack
KBD_con_stat1	xor	ax,ax
		mov	al,KD_status	;return status
		jmp	KBD_con_x	;in ax
;
;
KBD_con_srp	;set repeat lead-in & rate subroutine
		xor	ax,ax
		xchg	dx,ax			;requested in ax
		cmp	dh,ah			;above 255?
		jnz	KBD_con_srp1		;yes - return current		
		cmp	dl,al			;below 1?
		jz	KBD_con_srp1		;yes - kill
		mov	[bx],al			;fill in
		jmp	KBD_con_x		;and return
KBD_con_srp1	mov	ah,dh
		mov	al,[bx]			;return current
		jmp	KBD_con_x
;
	page
;
;*************************************************************************** 
;	KBD_set_leds	- subroutine to set up keyboard related LED's
;			from the status byte in KD_status.
;			registers affected: AX,FLAGS. + called routines
;
KBD_set_leds
		pushf
		cli
		mov	ah,KD_status		;get keyboard status
		mov	al,KD_led_status	;get led status
		and	al,#0FCh		;clear out keyboard handler bits
		testb	ah,#stop_on		;stop mode on?
		jz	KBD_set_l1		;no - skip
		or	al,#2			;or in stop bit
KBD_set_l1	testb	ah,#locks_on		;caps or shift lock?
		jz	KBD_set_l2		;no - skip
		or	al,#1			;set caps lock bit
KBD_set_l2	mov	ah,al			;copy into ah
		xor	ah,KD_led_status	;has anything changed?
		jz	KBD_set_l4		;no - skip update
		mov	KD_led_status,al	;update copy
KBD_set_l3	push	ax			;save byte
		mov	al,#led_pref		;send LED prefix
		call	KC_kbdq_out		;to keyboard
		pop	ax
		call	KC_kbdq_out		;and then data
KBD_set_l4	popf
		ret
;
KBD_set_ledI	pushf
		cli
		mov	al,KD_led_status	;get led bits
		jmpsh	KBD_set_l3		;and go
;
;--------------------------------------------------------------------------
;	KC_led_set	- used by LCD driver to set membrane key LED's
;		on input AL bits 0-5 represent leds for MB1-MB8.
;
KC_led_set	pushf
		cli
		shl	al,#1
		shl	al,#1			;get bits in correct place
		mov	ah,KD_led_status	;get current status
		and	ah,#03			;strip to stop & caps led's
		or	al,ah			;add in membrane leds
		jmpsh	KBD_set_l2		;finish it off
;
;
;
;***************************************************************************
	page
;----------------------------------------------------------------------------
; Keyboard constants area
;
	Section KBDhandler.const, Align(2), class=ConstQQ
;
;
; KD_calc_map	- bit map of calculator specific keys
;		Apricot style format (key 1 = HELP etc)
KD_calc_map
	BYTE	00000000b	;1-8
	BYTE	00111111b	;9-16
	BYTE	00000000b	;17-24
	BYTE	11110000b	;25-32
	BYTE	00000001b	;33-40
	BYTE	10000000b	;41-48
	BYTE	00000111b	;49-56
	BYTE	00000000b	;57-64
	BYTE	00011100b	;65-72
	BYTE	00000000b	;73-80
	BYTE	00111000b	;81-88
	BYTE	11100000b	;89-96
	BYTE	00000000b	;97-104
;
;
	page
;--------------------------------------------------------------------------
; Keyboard handler data areas.
;
	Section KBDhandler.data, Align(2), class=DataQQ
;
;
KD_database			;dummy label at base of variables
;
;
KD_status	BLOCK	1	;Keyboard status byte
				;bit 0 = help key ignored in fallthrough mode
				;bit 1 = stop mode active
				;bit 2 = calculator mode active
				;bit 3 = shift lock on
				;bit 4 = fallthrough mode active
				;bit 5 = voice LED on
				;bit 6 = keyboard lock active
				;bit 7 = caps lock on
;
;
KD_destination	BLOCK	1	;Keyboard output destination
				;0 = MS-DOS buffer
				;1 = screen (local)
;
KD_led_status	BLOCK	1	;Keyboard LED status byte
;
KD_missing	BLOCK	1	;keyboard missing flag
;
KD_trans_off	BLOCK	1	;keyboard transmit disable
;
KD_downcount	BLOCK	1	;keyboard downcode buffer count
;
KD_shift_cnt	BLOCK	1	;Shift key count
;
KD_control_cnt	BLOCK	1	;Control key count
;
KD_rep_dly	BLOCK	1	;Auto repeat lead-in delay
;
KD_rep_div	BLOCK	1	;Auto repeat rate
;
KD_mouse_ipt	BLOCK	1	;mouse queue input count
;
screen_active	BLOCK	1	;temporary
;
KD_datatop			;dummy label at top of data area
;
KD_downbuff	BLOCK	16	;Downcode buffer
;
KD_mouse_q	BLOCK	5	;mouse code queue
;
;
        end


$ 