                                                                                                                         

; [bios.apricot.rom]print.asm
	title	'bios.apricot.rom]print.asm'
	INCLUDE	'legal.asi'
;****************************************************************************
;*                                                                          *
;*                                                                          *
;*  Old file name:                  /usr/dave/ibios/prn/msprn.ps            *
;*  New file name:                  [bios.apricot.rom]print.asm             *
;*  Programmer:                     G. Kurth                                *
;*  Original implementation date:   15-Apr-83.                              *
;*  Revision history:               27-may-83 - implemented                 *
;*                                                                          *
;*  Rewritten in Assembler for the apricot                                  *
;*  Amended on:                     30th March 1984                         *
;*  Amended by:                     Vince CORBIN                            *
;*				VAX version 2/5/84 GK                       *
;*				ROM BIOS version 23-may-84 GK		    *
;*				Serial Printer support 13/6/84 RJW	    *
;*				Apricot ROM BIOS version 9-aug-84 GK	    *
;*				Abort on first char only 2-nov-84 GK	    *
;*                                                                          *
;****************************************************************************
        
        name    PRINTER
        
        global  CODEBASEQQ, DATABASEQQ
        
        assume  cs:CODEBASEQQ, ds:DATABASEQQ
        
        ;* Equates:
        
        INCLUDE 'Genequ.asi'
        INCLUDE 'mserror.asi'
        INCLUDE 'ioregs.asi'
	INCLUDE	'copyregs.asi'
        
        ;* General equates
        
prnqmax         equ     2048            ;default length of printer queue
        
        ;* Externals
        
        Global  CNF_lst_dev
        Global  CNF_p_cr_lf
        Global  CNF_fault
        Global  CNF_select
        Global  CNF_pe
        Global  PRN_queue
        Global  SH_wake_me_up
	Global	AUX_config
	Global	AUX_txq_ipt
	Global	AUX_txq_opt
        Global  AUX_txq_count
        Global  AUX_txq_max
        Global  AUX_txq_put
        Global  Wake_on

        ;* Internals
        
        Global  PRN_init
        Global  PRN_config
        Global  PRN_Tout
        Global  PRN_transmit
;
        SECTION PRINTER.data,     ALIGN(2),       CLASS = DataQQ
;
PRN_toff	BLOCK	2		;temporary offset & segment store
PRN_tseg	BLOCK	2		;used as dword pointer
;
;       printer queue
PRN_count       BLOCK   2               ;Queue count
PRN_ipt         BLOCK   2               ;Input pointer
PRN_opt         BLOCK   2               ;Output pointer
;
;       printer work area
PRN_error	BLOCK   1               ;0 = Do not know if we have one
					;1 = we have printed
					;FF = we have an error
PRN_CR_detect   BLOCK   1               ;CR detected flag
;
        SECTION PRINTER.code,     ALIGN(1),       CLASS = InstrQQ
;
;---------------------------------------------------------------------------
	page
;--------------------------------------------------------------------------
; PRN_transmit - called by both an interrupt and PRN_write.
; Transmits character to printer if ready.
;--------------------------------------------------------------------------

PRN_transmit

        pushf                           ;save flags
        cli                             ;dont interrupt us were busy
        mov	ah,#TRUE		;set up true status for tests
	cmpb    PRN_CR_detect,ah	;test if last char was an LF
        je      PRN_transmit_1          ;jump if it was
        cmpw    PRN_count,#0            ;test if queue is empty
	jne	PRN_transmit_0		;no
	jmp	PRN_transmit_exit	;yes it is - skip
PRN_transmit_0
	cmpb	PRN_error,#0		;have we done a check?
	jne	PRN_transmit_1		;yes - skip
	movb	PRN_error,#0FFh		;we are trying to print-first time
PRN_transmit_1
	mov	al,#10h			;reset ext/status command
	out	#SIO_B_COM,al
	in	al,#PIO_PORC		;get PIO centronics status
	mov	bl,al			;in bl
	in	al,#SIO_B_STAT		;and SIO cantronics status

        testb   al,#8                   ;test if printer busy
        jz      PRN_transmit_exit       ;jump if busy

        cmpb    CNF_fault,ah            ;test if fault line selection is being
        jne     PRN_transmit_2          ;supported-jump if not
        testb   al,#10h                 ;test the fault line
        jnz     PRN_transmit_error      ;jump if fault on printer
PRN_transmit_2

        cmpb    CNF_select,ah           ;test if select line selection is being
        jne     PRN_transmit_3          ;supported-jump if not
        testb   bl,#2                   ;test the select line
        jz      PRN_transmit_error      ;jump if printer not selected
PRN_transmit_3

        cmpb    CNF_pe,ah               ;test if paper empty line is being supported
        jne     PRN_transmit_4          ;jump if not
        testb   bl,#1                   ;test the paper empty line
        jnz     PRN_transmit_error      ;jump if paper is out
PRN_transmit_4
        
                ; Printer selection is successful
PRN_transmit_data

        cmpb    PRN_CR_detect,ah	;should a LF be output
        jne     PRN_transmit_5          ;jump if not

        mov     al,#0Ah                 ;load LF character
        movb    PRN_CR_detect,#FALSE    ;reset LF flag
        jmpsh   PRN_transmit_out        ;output the character
PRN_transmit_5

        mov     bx,PRN_opt              ;get queue output pointer
        mov     al,PRN_queue[bx]        ;get character from queue
        cmpb    al,#0Dh                 ;is char a CR
        jne     PRN_transmit_6          ;jump if not
        cmpb    CNF_p_cr_lf,ah          ;test if auto LF is selected
        jne     PRN_transmit_6          ;jump if not

        movb    PRN_CR_detect,ah        ;set CR detect flag
PRN_transmit_6
	movb	PRN_error,#1		;we printed!        
        decw    PRN_count               ;decrement the buffer count
        incw    bx	                ;bump the output pointer
        cmpw    bx,#prnqmax	        ;loop round required ?
        jb      PRN_transmit_out        ;jump if not required - output the char
        xor     bx,bx                   ;set BX to zero
PRN_transmit_out
        movw    PRN_opt,bx              ;reset pointer
        out     #PIO_PORA,al            ;output 
        in	al,#PIO_PORC		;get strobe port
	or	al,#10h			;set strobe high
        out     #PIO_PORC,al            ;strobe printer high
        and     al,#0EFh                ;set to low
        out     #PIO_PORC,al            ;strobe printer low
	nop
	nop
	nop				;longer strobe
        or	al,#10h                 ;set to high
        out     #PIO_PORC,al            ;strobe printer high
        jmpsh   PRN_transmit_exit
PRN_transmit_error

        movb    PRN_error,#0FFh		;set error flag
PRN_transmit_exit

        popf
        ret

	page
;--------------------------------------------------------------------------
; PRINTER driver initialisation.
;--------------------------------------------------------------------------

PRN_init

        pushf                           ;save flags
        cli                             ;stop the interrupts
        xor     ax,ax                   ;set AX to zero
        movw    PRN_ipt,ax              ;init. buffer input pointer
        movw    PRN_opt,ax              ;init. buffer output pointer
        movw    PRN_count,ax            ;init. buffer counter
        movb    PRN_CR_detect,al	;init. CR detect flag
        movb    PRN_error,al		;init. error flag
        in	al,#PIO_PORC		;get strobe port
	or	al,#10h			;set strobe high
        out     #PIO_PORC,al            ;strobe printer high
	mov	al,#1			;select write register 1
	out	#SIO_B_COM,al
	mov	al,COPY_SIO_W1B		;get copy
	or	al,#1			;enable ext/status int
	mov	COPY_SIO_W1B,al		;update copy
	out	#SIO_B_COM,al		;and tell SIO
        popf
        ret

	page
;----------------------------------------------------------------------------
;       PRN_char_out
;
;       This routine will put a character in the buffer, unless
;       the buffer is full then the PRN_timer_count will equal
;       0FFh.
;----------------------------------------------------------------------------

PRN_char_out

        cmpw    PRN_count,#prnqmax      ;test if print buffer full
        jb      PRN_char_1              ;jump if not full
        call    PRN_transmit            ;try to transmit a character
        cmpb    PRN_error,#0FFh		;test if error occurred
        je      PRN_char_exit           ;abort if it has. Lose the char
	jmpsh	PRN_char_out		;loop if still full

PRN_char_1

        mov     bp,sp                   ;point into stack
        mov     ax,2[bp]                ;get data
        pushf                           ;save interrupt status
        cli
        mov     bx,PRN_ipt              ;get queue input pointer
        mov     PRN_queue[bx],al        ;put char in the queue
        inc     bx                      ;bump pointer
        cmp     bx,#prnqmax             ;do we need to loop round
        jb      PRN_char_2              ;jump if not
        xor     bx,bx                   ;reset the input pointer
PRN_char_2

        mov     PRN_ipt,bx              ;update the pointer
        incw    PRN_count               ;bump count
        call    PRN_transmit            ;transmit a character
        popf                            ;restore interrupt status
PRN_char_exit

        ret     #2

	page
;--------------------------------------------------------------------------
; PRN_write - called by print string routines
;	enters with DX:SI = DWORD pointer to:
;			     WORD byte count
;		             DWORD string address
;	Error status returned in AX
;
PRN_write
	push	es			;save current es
	mov	PRN_toff,si		;set up temp offset
	mov	PRN_tseg,dx		;and segment
	sti                             ;ensure that interrupts are enabled
	les	di,PRN_toff		;load up seg & offset of table	
	mov     cx,es:[di]		;get no.bytes for printing
        les     di,es:2[di]		;get source address
	cld
PRN_write_loop

        mov     al,es:[di]              ;get char to be printed
	push	es
	push	di
        push	cx
	push    ax                      ;save it for the char output routine
        call    PRN_char_out            ;attempt to output the char
        pop	cx
	pop	di
	pop	es
	cmpb    PRN_error,#0FFh		;test for printer error
        je      PRN_loop_error          ;jump if printer in error
        inc     di                      ;move to next char
        loop    PRN_write_loop          ;do some more if required

                ;all chars put into the printer buffer

        xor	ax,ax			;all well
	jmpsh	PRN_wrt_x		;exit with ok status

PRN_loop_error
	les	di,PRN_toff		;get pointer to table again
        subw    es:[di],cx		;tell DOS how many chars sent
        jmpsh	PRN_error1
PRN_error0
        movw    es:[di],#0		;tell DOS no chars sent
PRN_error1
	movw    ax,#MSE_no_paper	;put no paper in status
PRN_wrt_x
        pop	es			;original es
	jmp	PRN_con_x		;return status
;
	page
;--------------------------------------------------------------------------
; PRN_status	- Returns printer status in AX for config call
;
PRN_status		;return status
	xor	bx,bx			;set up ok status
        cmpw    PRN_count,#prnqmax      ;test if print buffer full - Busy
        jb      PRN_status0             ;jump if not full
        orw     bx,#0200H		;set busy flag
PRN_status0
	cmpb	PRN_error,#0FFh		;timeout error?
	je	PRN_status4

	mov	ah,#TRUE
	in	al,#PIO_PORC		;get PIO centronics status
	mov	cl,al			;into cl
	in	al,#SIO_B_STAT		;and SIO centronics status
        cmpb    CNF_fault,ah            ;test if select line is being supported
        jne     PRN_status2             ;jump if not
        testb   al,#10h                 ;test the fault line status
        jnz     PRN_status4             ;jump if fault has occurred
PRN_status2

        cmpb    CNF_pe,ah               ;test if paper empty line is being supported
        jne     PRN_status3             ;jump if not
        testb   cl,#1                   ;test the paper empty line status
        jnz     PRN_status4             ;jump if paper out
PRN_status3

        cmpb    CNF_select,ah           ;test if select line is being supported
        jne     PRN_status5             ;jump if not
        testb   cl,#2                   ;test the select line status
        jnz     PRN_status5             ;jump if printer selected
PRN_status4

        or      bx,#MSE_no_paper	;set paper out status
PRN_status5
	mov	ax,bx
	jmp	PRN_con_x		;return status
        
	page
;----------------------------------------------------------------------------
; PRN_config - handle all printer IO facilities
;	Called with data in registers:
;	AX = fail status = 0FFFFh
;	CX = Command
;	DX = data
;	or DX:SI = pointer
;	Returns AX = status
;
;----------------------------------------------------------------------------
PRN_config

        mov     bx,cx			;get command in bx
        cmp     bx,#000Ah		;test if command valid
        ja	PRN_con_x	        ;jump if invalid
        shl     bx,#1                   ;convert command to a word pointer
        jmp     [cs:PRN_TABLE][bx]      ;call appropriate command
;
PRN_con_ok
	xor	ax,ax			;set ok status
;
PRN_con_x
	ret				;return status in ax
;
PRN_TABLE
        word    PRN_config0 - CodebaseQQ	;0 - init driver
        word    PRN_config1 - CodebaseQQ	;1 - return space in buffer
        word    PRN_config2 - CodebaseQQ	;2 - get/set fault line detect
        word    PRN_config3 - CodebaseQQ	;3 - get/set sel line detect
        word    PRN_config4 - CodebaseQQ	;4 - get/set PE line detect
        word    PRN_config5 - CodebaseQQ	;5 - get/set auto lf after cr
        word    PRN_config6 - CodebaseQQ	;6 - get/set serial/parallel
        word    PRN_config7 - CodebaseQQ	;7 - print character
        word    PRN_config8 - CodebaseQQ	;8 - flush buffer
	word	PRN_config9 - CodebaseQQ	;9 - transmit string
	word	PRN_configA - CodebaseQQ	;A - return status
;
;----------------------------------------------------------------------------
;
PRN_config0		;initialise driver

	call	PRN_init		;initialise driver
	jmpsh	PRN_con_ok		;and return ok
;
;----------------------------------------------------------------------------
;        
PRN_config1		;return bytes free in buffer

        cmpb    CNF_lst_dev,#0          ;test if parallel or serial printer
        jne     PRN_config1_ser         ;jump if serial
        mov     ax,#prnqmax             ;calculate remaining space in queue
        sub     ax,PRN_count
        jmpsh	PRN_con_x		;return count

PRN_config1_ser
        mov     ax,AUX_txq_max          ;calculate the remaining space
        sub     ax,AUX_txq_count
        jmpsh	PRN_con_x		;return count
;
;----------------------------------------------------------------------------
;
; PRN_con_tgl - subroutine to get/set 0 1 toggle flags
;	Enter with flag address in BX, data in dx
;
PRN_con_tgl
	xor	ax,ax			;zap top
	mov	al,[bx]			;get current
	cmp	dx,#1			;valid?
	ja	PRN_con_x		;no - return present
	xchg	ax,dx			;swap old for new
	mov	[bx],al
	jmpsh	PRN_con_x		;return new setting
;
;----------------------------------------------------------------------------
;
PRN_config2		;get/set FAULT line detection

        lea	bx,CNF_fault
	jmpsh	PRN_con_tgl
;
;----------------------------------------------------------------------------
;
PRN_config3		;get/set SELECT line detection

	lea	bx,CNF_select
	jmpsh	PRN_con_tgl
;
;----------------------------------------------------------------------------
;
PRN_config4		;get/set PE line detect

	lea	bx,CNF_pe
	jmpsh	PRN_con_tgl
;
;----------------------------------------------------------------------------
;
PRN_config5		;get/set auto lf after cr

	lea	bx,CNF_p_cr_lf
	jmpsh	PRN_con_tgl
;
;----------------------------------------------------------------------------
;
PRN_config6		;get/set serial/parallel device


;STOP INTERRUPTS
	pushf
	cli


;IF DATA IS >2: ABORT THE UPDATE
        cmp     dx,#1                   ;test if data is valid
        ja      skip_sp_update          ;jump if invalid


;IF DATA = 1 (SWITCH TO SERIAL PRINTER): SET UP AUX QUEUE
	jne	select_parallel		;data not 1: jump

	xor	ax,ax			;flush the aux queue
	mov	AUX_txq_ipt,ax		;
	mov	AUX_txq_opt,ax		;
	mov	AUX_txq_count,ax	;

	movw	AUX_txq_max,#(2048+512)	;queue size = printer + AUX tx

	jmp	done_aux_init
select_parallel


;DATA = 0 (SELECT PARALLEL); IF ALREADY NOT ALREADY SELECTED: INITIALISE AUX
	cmpb	CNF_lst_dev,#0		;already zero ?
	je	already_parallel	;yes, jump

	xor	ax,ax			;flush the aux queue
	mov	AUX_txq_ipt,ax		;
	mov	AUX_txq_opt,ax		;
	mov	AUX_txq_count,ax	;

	movw	AUX_txq_max,#(512)	;queue size = normal
already_parallel

done_aux_init


;STORE NEW VALUE OF SERIAL/PARALLEL FLAG AND INITIALISE PRINTER (dl = flag)
        movb    CNF_lst_dev,dl          ;store new value of flag

        call    PRN_init                ;init the parallel printer driver


;RETURN CURRENT VALUE OF FLAG
skip_sp_update
	xor	ah,ah	
        mov     al,CNF_lst_dev


;RESTORE INTERRUPT AND RETURN
	popf

       
        ret
;
;----------------------------------------------------------------------------
;
PRN_config7			;print single character

        cmpb    CNF_lst_dev,#0          ;test for serial or parallel printer
        jne     PRN_config7_ser         ;jump if serial
        push    dx                      ;save data on stack
        call    PRN_char_out            ;put char in buffer
	cmpb	PRN_error,#0FFh		;timeout?
        jne	long_PRN_con_ok		;set result OK
	mov	ax,#MSE_no_paper	;return no paper
	jmp	PRN_con_x

PRN_config7_ser
	movw	cx,#0001H		;serial transmit char command
	jmp	AUX_config		;and do the AUX equivalent
;
;----------------------------------------------------------------------------
;
PRN_config8		;flush output buffer

        cmpb    CNF_lst_dev,#0          ;test for serial or parallel printer
        jne     PRN_config8_ser         ;jump if serial
        pushf                           ;save flags
        cli                             ;stop the interrupts
        xor     ax,ax                   ;set AX to zero
        mov     PRN_ipt,ax              ;init. buffer input pointer
        mov     PRN_opt,ax              ;init. buffer output pointer
        mov     PRN_count,ax            ;init. buffer counter
        movb	PRN_error,al		;reset timeout
        mov     PRN_CR_detect,#FALSE    ;init. CR detect flag
	popf
long_PRN_con_ok
	jmp	PRN_con_ok
;
PRN_config8_ser
	mov	cx,#001Ch		;serial device flush buffer command
	jmp	AUX_config		;and do the AUX equivalent
;
;----------------------------------------------------------------------------
;
PRN_config9		;print string

        cmpb    CNF_lst_dev,#0          ;test for serial or parallel printer
        jne     PRN_config9_ser         ;jump if serial
	jmp	PRN_write		;do parallel write
;
PRN_config9_ser
	mov	cx,#001Fh		;serial device transmit string command
	jmp	AUX_config		;and do the AUX equivalent
;
;----------------------------------------------------------------------------
;
PRN_configA		;return status

	cmpb    CNF_lst_dev,#0          ;test for serial or parallel printer
        jne     PRN_configA_ser         ;jump if serial
	jmp	PRN_status		;do parallel check
;	
PRN_configA_ser
	xor	ax,ax
	cmpw	AUX_txq_count,#(2048+512)
	jb	PRN_configA_s1		;not full
	mov	ax,#0200H		;set busy
PRN_configA_s1
	jmp	PRN_con_x		;return status
;
	page
;-----------------------------------------------------------------------
;       PRN_Tout        character transmit timeout routine
;                       called by the sleeper scheduler in MSCLOCK
;	THIS IS NOW A DUMMY ROUTINE
;-----------------------------------------------------------------------
PRN_Tout

        ret

        end


$ 