Apricot              @      FONT    SYS&            (  KEYTAB  SYS&              IO      SYS&          cu	  p 

; [bios.apricot.ram]]readtrk.asm
       


	include 'legal.asi'



;************************************************************************
;*        								*
;*        	           R E A D T R K 				*
;*									*
;*									*
;*	READTRK    -    read a track image 				*
;*        								*
;*              	------------------------			*
;*        								*
;* 	PROGRAM:        [bios.apricot.ram]readtrk.asm			*
;*     	PROGRAMMER:     R. J. Woolcock.					*
;*    	IMPLEMENTED:    19/11/84					*
;*     	MODIFICATIONS:  						*
;*									*
;*									*
;************************************************************************
  page 

        name READTRK
        
        Include 'align.asi'
        Include 'ioregs.asi'
	include	'mserror.asi'
	Include 'genequ.asi'
        
        Global  CodeBaseQQ,DataBaseQQ


;************************************************************************
;*************************  DATA  SECTION  ******************************
;************************************************************************


        Assume ds:DatabaseQQ, cs:CodeBaseQQ
        
        Section dsktrk.data ,align(2),class=DataQQ

        Global  FMT_DATASEG, FMT_OFFSET
	Global  FMT_DRIVE, RD_TRACK, RD_HEAD
	Global	FS_ACTIVE, SH_wake_me_up
	Global	FTR_offset			;variables in DISKIOP
	Global	FTR_dataseg			;
	Global	FTR_PB				;
	Global	FTR_FDC_com			;


;************************************************************************
;*************************  CODE  SECTION  ******************************
;************************************************************************


        Section readtrk.instr,align(1),class=instrQQ


;ENTRY POINTS TO ROUTINE
        Global	READTRK


;EXTERNAL ROUTINES
	global 	DRW_wait_89		;wait for 8089 to complete
	global	DO_select_drive
	global	DO_hd_load
	global	DO_hd_unload
	global	DO_on_line
	global	DO_seek
   page     								
;************************************************************************
;*************************   SUBROUTINE  READTRK  ***********************
;************************************************************************
;
; Read a track image.
; 
; NOTE: The DMA controller uses the high order data lines, therefore
;	access to the DMA registers must be via ah. The ls byte is
;	written first.
;
; No retries are done because the lost data bit in the FDC status 
; tends to be set anyway.
; 
; This routine expects a physical track number, ie, the track number
; must already be translated for double sided drives.
;
; On Entry:
;	RD_HEAD	    = head number (0,1)
;	RD_TRACK    = PHYSICAL track to be read
;	FMT_DRIVE   = valid floppy drive number
;	FMT_OFFSET  = offset  of 7000 byte destination buffer
;	FMT_DATASEG = segment of buffer
;	(buffer will not be on a 64K boundary)
;
; On Exit:
;	ax = error status
;


READTRK


;SAY FILE SYSTEM IS ACTIVE
	movb	FS_ACTIVE,#1


;SELECT THE REQUESTED DRIVE: EXIT IF ERROR
	push	FMT_DRIVE		;pass validated drive number
	call	DO_select_drive		;
	
	cmp	ax,#MSE_ok		;error occurred ?
	je	select_ok		;no, jump
	jmp	abort_call		;yes, exit
select_ok


;IF DRIVE IS NOT READY: EXIT WITH AN ERROR CODE
	call	DO_on_line		;check if drive ready
	
	cmp	ax,#MSE_ok		;error/not-ready ?
	je	ready_ok		;no, jump
	jmp	abort_call		;yes, exit
ready_ok


;LOAD THE HEAD
;---say that it is a write operation so that the full head settling
;---time will be given since we have no retry mechanism.	
	mov	ax,#1			;pass write operation flag
	push	ax			;
	push	RD_TRACK		;pass physical track number	
	call	DO_HD_LOAD		;load the head


;SEEK THE REQUESTED TRACK
;---again, say write operation to get full delay.
	mov	ax,RD_TRACK		;get physical track number in al
	mov	ah,#1			;say write operation
	push	ax			;pass data to subroutine
	call	DO_SEEK			;

	cmp	ax,#MSE_ok		;error occurred ?
	je	seek_ok			;no, jump
	jmp	ret_status		;yes, exit
seek_ok


;WAIT FOR THE 8089 IOP TO BE NOT BUSY
	call	DRW_wait_89		;wait for 8089 not busy


;SET UP PARAMETER BLOCK FOR READ TRACK OPERATION
	mov	ax,FMT_offset		;store offset of destination buffer
	mov	FTR_offset,ax		;

	mov	ax,FMT_dataseg		;store segment of destination buffer
	mov	FTR_dataseg,ax		;


;SET UP READ TRACK COMMAND FOR FDC & STORE IN 8089 ARRAY
	mov	al,RD_HEAD		;form head bit
	and	al,#1			;
	shl	al,#1			;
	or	al,#0E4h		;command: read track + 15ms delay
	mov	FTR_fdc_com,al		;pass to 8089 array


;SET UP CCB AT 500h
	mov	dx,ds			;point to ccb
	mov	ax,#50h			;
	mov	ds,ax			;

	mov	4,dx			;store BIOS ds
	mov	2,#(FTR_PB-databaseqq)	;store offset of 8089 Parameter Block
	mov	0,#0EE03h		;set up busy

	mov	ds,dx			;restore BIOS's ds


;KICK 8089
	out	#IOP_CH1,al		;kick 8089


;WAIT FOR 8089 TO COMPLETE
	call	DRW_wait_89		;wait for 8089 to finish


;RETURN OK CODE (FDC STATUS UNRELIABLE ON THIS OPERATION)
	mov	ax,#MSE_ok		;return ok code


;HERE TO UNLOAD THE HEAD AND RETURN STATUS IN AX
ret_status


;INITIATE HEAD UNLOAD TIMER AND EXIT    (ax = return status)
	push	ax			;save status

        movw    ax,#FR0_sleeper         ;head load timeout sleeper ID
	cmpb	FMT_DRIVE,#0		;drive 0?
	je	sleeper0		;yes -skip
	movw	ax,#FR1_sleeper		;drive 1 sleeper
sleeper0
        push    ax
        mov     ax,#50                  ;1 second timeout
        push    ax
        call    SH_wake_me_up           ;set off head load timeout

	pop	ax			;restore status	


;HERE TO RETURN STATUS IN AX
abort_call
	movb	FS_ACTIVE,#0		;say finished with file system


	ret				;RETURN --- status in ax




$ 