
CNF_wini_form	BYTE	0		;allow formatting of wini
;
;       Section 7 - RAM disk            (of

; [bios.apricot.rom]sioint.asm
	title   '[bios.apricot.rom]SIOINT.ASM'

	INCLUDE	'legal.asi'


;****************************************************************************
;*                                                                          *
;*			       S I O I N T				    *
;*									    *
;*      Interrupt request service routine for the SIO which handles	    *
;*      the keyboard, the AUX device, and the printer interrupt.	    *
;*									    *
;*                                                                          *
;*  New file name:                  [bios.apricot.rom]SIOINT.ASM             *
;*  Original Programmer:            P.Horne + G. Kurth (Pascal for Apricot) *
;*  Original implementation date:   13/4/1983                               *
;*  Revision history:               19/4/1983                               *
;*                                  Re-created 11-may-1983                  *
;*                                                                          *
;*  MODIFICATIONS:							    *
;*                                                                          *
;*     -  Rewritten from Pascal to Assembler for the apricot testbios,      *
;*  	        8th March 1984 by Vince CORBIN     	                    *
;*     -  VAX version 2/5/84 GK						    *
;*     -  Hamming table/keyboard input GK 8/5/84	 		    *
;*     -  AUX device error handler and handshake protocols added. ROM	    *
;*	         resident version. Serial mouse support. RJW 22/6/84	    *
;*     -  APRICOT version created from ACTIVM 1-aug-84 GK                   *
;*     -  RX mask implemented 10/10/84 GK				    *
;*                                                                          *
;****************************************************************************
  page
        NAME    SIOINT

        Global  CODEBASEQQ,     DATABASEQQ
        Assume  CS:CODEBASEQQ,  DS:DATABASEQQ

        INCLUDE 'ioregs.asi'
	INCLUDE	'copyregs.asi'
        INCLUDE 'Genequ.asi'


;************************************************************************
;**************************  DATA SECTION  ******************************
;************************************************************************

	Section sioint.data, align(1), class=DataQQ


;IMPORTED GLOBALS FROM CONFIGURATION TABLE 
; word variables:
		global	CNF_RX_X_limit	;num chars before end when XOFF needed


; byte variables:
    		global	CNF_CR_null	;number of nulls after C/R
		global  CNF_FF_null	;number of nulls/10 after formfeed
		
; byte flags:
		global  CNF_s_cr_lf	;auto linefeed after C/R enable
		global  CNF_cts_rts	;cts/rts protocol enable
		global	CNF_xon_char	;character used for xon
		global	CNF_xoff_char	;character used for xoff
		global	CNF_rx_xonxoff	;receiver XON/XOFF protocol enable
		global	CNF_tx_xonxoff	;transmitter XON/XOFF protocol enable


;IMPORTED GLOBALS FROM IOQUEUES ETC
    	        global  AUX_txqueue		;transmitter queue
    	        global  AUX_txq_opt		;tx o/p pointer
    	        global  AUX_txq_count		;number of chars in tx queue
    	        global  AUX_txq_max		;size of tx queue

    	        global  AUX_rxq_opt		;receiver queue
    	        global  AUX_rxq_count		;number of chars in rx queue
    	        global  AUX_rxq_max		;size of rx queue
	
		global	serial_mouse		;byte flag for mouse serial enable

		global	KBD_oq_count		;keyboard output queue count
		global	KD_trans_off		;keyboard transmit disable flag

;EXPORTED GLOBALS: VARIABLES TO BE CLEARED ON RESTART
		global	AUX_fill_cnt		;word
		global	AUX_CR_detect		;byte
		global	TX_xon_xoff_flag	
		global	RX_xon_xoff_flag 	;accesed by IOQUEUES
		global  xon_xoff_request	; ''     ''     ''

		global	RX_mask			;mask for receive characters



;AUXILIARY DEVICE SCRATCH REGISTERS
AUX_fill_cnt	 BLOCK	2	;down counter for nulls
AUX_CR_detect	 BLOCK	1	;internal flag set when C/R found
TX_xon_xoff_flag BLOCK  1	;xoff character received flag
RX_xon_xoff_flag BLOCK  1	;xoff character transmitted flag
xon_xoff_request BLOCK  2	;1=tx XOFF request, 2=tx XON request
RX_mask          BLOCK	1	;receive character mask


  page
;************************************************************************
;**************************  CODE SECTION  ******************************
;************************************************************************


	Section sioint.code, align(1), class=InstrQQ


;EXTERNAL VARIABLES AND ROUTINES
       	Global  AUX_rxq_put
        Global  AUX_transmit
	Global	KBD_q_out
        Global  KC_click
        Global  KC_bell
	Global	KBD_handler
	Global	AUX_ext_on
	Global  aux_errors
	Global  AUX_tx_interrupt
	Global	KC_error
	Global	KC_transmit
	Global	PRN_transmit

;EXPORTED GLOBAL SYMBOLS
        Global  SIO_int

   page
;***********************************************************************;
;*******************   SIO INTERRUPT ENTRY POINT  **********************;
;***********************************************************************;
;									;
;    Decodes the SIO interrupt type and jumps to appropriate routine	;
;    via a jump table.							;
;									;
;    1. Channel A of SIO   - Auxiliary Device				;
;    2. Channel B of SIO   - Serial Keyboard				;
;									;
;------------------------------------------------------------------------


SIO_int					;SIO interrupt vector


;GET THE INTERRUPT VECTOR INTO AX

	lock in	al,#SIO_B_STAT		;get vector

        and	ax,#000Eh		;zap down



;IF EXTERNAL HANDLING OF CHANNEL A: ENTER HANDLER VIA INT 0F0h
	test	al,#8h			;is it a channel A interrupt ?
	jz	not_external		;no, jump

	cmpb	AUX_ext_on,#0		;channel-A handled externally ?
	je	not_external		;no, jump

	
	int	#0F0h			;enter external handler

        mov     al,#038h      		;clear interrupt under service
        out     #SIO_A_COM,al		;

        ret	                        ;RETURN
not_external


;CLEAR INTERRUPT UNDER SERVICE AND ENTER INTERNAL HANDLER
        mov	bx,ax			;vector in bx
	mov     al,#038h      		;clear interrupt under service
        out     #SIO_A_COM,al		;

        jmp     [cs:SIO_TAB][bx]	;call routine & RETURN
  page
;************************************************************************
;									;
; 	     LOOK UP TABLE OF SIO INTERRUPT HANDLER ROUTINES		;
;									;
;***********************************************************************;
        
SIO_TAB

        WORD    KBD_Tx_int      -codebaseqq     ;0, ch B tx buffer empty 
        WORD    KBD_ext_int     -codebaseqq     ;2, ch B ext/status int. 
        WORD    KBD_Rx_int      -codebaseqq     ;4, ch B rx ready 
        WORD    KBD_spec_int    -codebaseqq     ;6, ch B special rx/status 

        WORD    AUX_Tx_interrupt-codebaseqq     ;8, ch A tx buffer empty 
        WORD    AUX_ext_int     -codebaseqq     ;A, ch A ext/status int. 
        WORD    AUX_Rx_int      -codebaseqq     ;C, ch A rx ready 
        WORD    AUX_spec_int    -codebaseqq     ;E, ch A special rx/status 

   page
;***********************************************************************;
;*******************  AUX DEVICE TRANSMITTER INTERRUPT  ****************;
;***********************************************************************;
;									;
;  Transmitter interrupt routine to get the next character from		;
;  the transmitter queue and output it to the SIO.			;
;									;
;  This routine is entered under four different conditions:		;
;       A)  when the SIO interrupts because the transmitter register	;
;	    empty.							;
;	B)  when the receiver interrupts and it is necessary to		;
;	    transmit an XOFF character, or to restart the 		;
;           transmitter when an XON is received.			;
;	C)  when characters have been taken from the receive queue	;
;	    and an XON can be transmitted.				;
;	D)  when a character is put in the transmit queue.		;
;  									;
;  The following options are also supported by this routine:		;
;									;
;	1)  XON/XOFF protocol.						;
;	2)  CTS/RTS  protocol.						;
;	3)  Padding of nulls after carriage return and form feeds.	;
;	4)  Auto linefeed after carriage return.			;
;									;
;									;
;------------------------------------------------------------------------



AUX_Tx_interrupt

;DISABLE INTERRUPTS (THIS ROUTINE IS ALSO CALLED FROM NON-INTERRUPT PROGRAMS)
	pushf				;save interrupt flag
	cli				;disable interrupts


;IF THE TX BUFFER IS NOT EMPTY: EXIT THE ROUTINE (see A and B above)
	in	al,#SIO_A_STAT		;read status register
	test	al,#4h			;transmitter buffer empty ?
	jnz	tx_empty		;yes, jump


	jmp	aux_tx_exit		;EXIT  --- error tx buffer not empty
tx_empty



;IF NO MORE CHARACTERS TO TRANSMIT: RESET TRANSMITTER AND EXIT
	mov	ax,AUX_fill_cnt		;any nulls to send ?
	or	ax,AUX_txq_count	;any ordinary chars to send ?
	or	al,AUX_CR_detect	;auto linefeed to send ?
	or	al,xon_xoff_request	;xon or xoff to be sent ?
	or	al,ah			;
	jne	more_aux_chars		;yes, jump


        mov     al,#28h                 ;give 'reset tx interrupt pending'...
        out     #SIO_A_COM,al		;...to the SIO and exit
        jmp     aux_tx_exit		;
more_aux_chars


;IF CTS/RTS PROTOCOL: HANG UNTIL CTS RECEIVED
	cmpb	CNF_cts_rts,#1		;CTS/RTS protocol disabled ?
	jne	CTS_RTS_disabled	;yes, jump

	sti				;enable interrupts during hang
wait_for_cts
	mov	al,#10h			;reset external interrupts
	out	#SIO_A_COM,al		;

	in	al,#SIO_A_STAT		;read CTS
	test	al,#20h			;CTS set ?
	jz	wait_for_cts		;no, jump
	cli				;interrupts off again
CTS_RTS_disabled


;IF REQUEST TO SEND XON OR XOFF CHARACTER: SEND IT AND EXIT
	mov	al,CNF_xoff_char	;preset al with xoff character
	cmpb	xon_xoff_request,#1	;xon or xoff requested?
	jb	not_xon_xoff		;no, jump

	je	tx_x_char		;yes, jump if xoff requested
	mov	al,CNF_xon_char		;must be xon character request
tx_x_char
	out	#SIO_A_DAT,al		;transmit xon or xoff
	movb	xon_xoff_request,#0	;cancel the request

	jmp	aux_tx_exit		;EXIT
not_xon_xoff	


;IF TRANSMITTER SWITCHED OFF BY XON/XOFF PROTOCOL: RESET TX & EXIT
	cmpb	TX_xon_xoff_flag,#0	;transmitter switched off ?
	jz	tx_on			;no, jump 

        mov     al,#28h                 ;give 'reset tx interrupt pending'...
        out     #SIO_A_COM,al		;...to the SIO and exit

	jmp	aux_tx_exit		;EXIT
tx_on


;IF CURRENTLY OUTPUTTING NULLS: OUTPUT NEXT NULL AND EXIT
	cmpw	AUX_fill_cnt,#0		;null to output  ?
	je	not_doing_nulls		;no, jump

	xor	al,al			;output another null
	out	#SIO_A_DAT,al		;

	decw	AUX_fill_cnt		;update null count

	jmp	aux_tx_exit		;EXIT
not_doing_nulls


;IF REQUEST FOR LINEFEED: TRANSMIT LINE FEED AND EXIT
	cmpb	AUX_CR_detect,#0	;linefeed requested ?
	je	no_linefeed		;no, jump

	mov	al,#0Ah			;transmit a linefeed
	out	#SIO_A_DAT,al		;

	movb	AUX_CR_detect,#0	;cancel request


	jmp	aux_tx_exit		;EXIT
no_linefeed


;TRANSMIT THE NEXT CHARACTER   (we know there is one)
        call    AUX_transmit		;get character and output 


;IF JUST OUTPUT FORMFEED: SET UP NULL FILL COUNT (al=last char O/P)
	cmp	al,#0Ch			;was character a formfeed
	jne	not_ff			;no, jump

	mov	bl,CNF_FF_null		;get FF null count x 10
	xor	bh,bh			;
	shl	bx,#1			;(x2)
	mov	cx,bx			;save
	shl	bx,#1			;(x4)
	shl	bx,#1			;(x8)
	add	bx,cx			;(x10)

	mov	AUX_fill_cnt,bx		;store in internal null counter
	
	jmp	not_cr			;cannot be a carriage return
not_ff


;IF JUST OUTPUT C/R: SET UP NULL FILL COUNT (al = last char output)
	cmp	al,#0Dh			;was character carriage return ?
	jne	not_cr			;no, jump

	mov	cl,CNF_CR_null		;get number of nulls after a C/R
	xor	ch,ch			;
	mov	AUX_fill_cnt,cx		;store in internal counter


;IF AUTO L/F SELECTED: REQUEST A LINEFEED         (save al)
	cmpb	CNF_s_cr_lf,#0		;auto linefeed selected ?
	je	not_auto_lf		;no, jump

	movb	AUX_CR_detect,#1	;request linefeed
not_auto_lf
not_cr

;RESTORE THE INTERRUPT CONDITION (CAN BE CALLED FROM NON-INTERRUPT ROUTINES)
aux_tx_exit
	popf				;restore interrupt flag


        ret				;RETURN

   page
;***********************************************************************;
;*******************  AUX DEVICE RECEIVER INTERRUPT  *******************;
;***********************************************************************;
;									;
; This routine is entered when the SIO interrupts on receipt of a	;
; character.								;			
;									;
; The following options are supported:					;
;	1)    Switching on and off the transmitter in response		;
;	      to receiving XON and XOFF characters.			;
;									;
;	2)    Transmitting an XOFF character if receive buffer	 	;
;	      becomes nearly full.					;
;									;
;	3)    Serial mouse support.					;
;									;
;									;
;------------------------------------------------------------------------



AUX_Rx_int


;READ THE CHARACTER INTO al
        in      al,#SIO_A_DAT   	;read data from SIO

;MASK DOWN RECEIVED DATA TO CORRECT NUMBER OF BITS
	and	al,RX_mask		;use RX_mask

;IF SERIAL MOUSE ENABLED: ENTER EXTERNAL MOUSE HANDLER AND EXIT
	cmpb	serial_mouse,#0		;serial mouse enabled ?
	je	no_mouse_handler	;no, jump

	int	#0FAh			;enter external mouse handler
	ret				;RETURN
no_mouse_handler

;IF XON/XOFF PROTOCOL (CONTROLLING TX) SWITCHED OFF: SKIP XON/XOFF CHECK
	cmpb	CNF_tx_xonxoff,#0	;xon/xoff disabled ?
	je	skip_tx_xonxoff		;yes, jump


;IF XON RECEIVED: SWITCH ON TRANSMITTER AND RESTART IT (IF NECESSARY)
	cmp	al,CNF_xon_char		;xon character ?
	jne	not_tx_xon		;no, jump

	movb	TX_xon_xoff_flag,#0	;switch transmitter on again
	call	AUX_tx_interrupt	;restart the transmitter
	jmp	rx_char_done		;finished with receive character
not_tx_xon


;IF XOFF RECEIVED: SWITCH THE TRANSMITTER OFF
	cmp	al,CNF_xoff_char	;xoff character ?
	jne	not_tx_xoff		;no, jump

	movb	TX_xon_xoff_flag,#1	;switch transmitter off
	jmp	rx_char_done		;finished with receive character
not_tx_xoff

skip_tx_xonxoff


;ORDINARY CHARACTER: ENTER THE CHARACTER IN THE RECEIVE QUEUE (char in al)
        push    ax			;pass data to routine
        call    AUX_rxq_put     	;put 1 char in input queue
rx_char_done


;IF XON/XOFF PROTOCOL (CONTROLLING RX) SWITCHED OFF: SKIP BUFFER CHECK
	cmpb	CNF_rx_xonxoff,#0	;receiver xon/xoff disabled ?
	je	skip_rx_xonxoff		;yes, jump

	
;IF AN XOFF CHARACTER HAS ALREADY BEEN TRANSMITTED: SKIP BUFFER CHECK
	cmpb	RX_xon_xoff_flag,#0	;xoff already transmitted ?
	jne	skip_rx_xonxoff		;yes, jump


;IF XON/XOFF REQUEST BUFFER IS BUSY: EXIT THIS TIME
	cmpb	xon_xoff_request,#0	;waiting to send an xon/xoff char ?
	jne	skip_rx_xonxoff		;yes, jump

	
;IF BUFFER NEARLY FULL: REQUEST TRANSMISSION OF XOFF
	mov	ax,AUX_rxq_max		;calculate number of characters...
	sub	ax,CNF_Rx_X_limit	;...received before xoff necessary
	
	cmp	ax,#1			;is limit valid (>0) ?
	jge	rx_limit_ok		;yes, jump
	mov	ax,#1			;would be -ve :set limit to minimum
rx_limit_ok

	cmp	AUX_rxq_count,ax	;getting near end of buffer ?
	jb	skip_rx_xonxoff		;no, jump

	mov	xon_xoff_request,#1	;request xoff


;TRANSMIT THE XOFF CHARACTER NOW IF TX BUFFER IS EMPTY
	call	AUX_tx_interrupt	;transmit the XOFF if buffer empty	


;FLAG THAT XOFF HAS BEEN TRANSMITTED
	movb	RX_xon_xoff_flag,#1	;flag that xoff transmitted
skip_rx_xonxoff


        ret				;RETURN
   page
;***********************************************************************;
;********************  KEYBOARD RECEIVER INTERRUPT  ********************;
;***********************************************************************;
;									;
;   Routine to input data from the keyboard receiver channel,		;
;   and send it to the keyboard handler.				;
;									;
;									;
;------------------------------------------------------------------------



KBD_Rx_int
	in	al,#SIO_B_STAT			;get status
	test	al,#01h				;character available?
KBD_Rx_int1
	jz	KBD_Rx_exit			;no - skip
	in      al,#SIO_B_DAT                   ;read data from SIO

        call    KBD_handler                     ;CHARACTER in al

	in	al,#SIO_B_STAT			;check status again
	test	al,#01h				;another character?
	jnz	KBD_Rx_int1			;yes - get it

KBD_Rx_exit

        ret

   page
;***********************************************************************;
;******************  KEYBOARD TRANSMITTER INTERRUPT  *******************;
;***********************************************************************;
;									;
;	Respond to transmitter ready interrupt.				;
;									;
;------------------------------------------------------------------------

KBD_Tx_int
	xor	ax,ax
	cmp	KBD_oq_count,ax	;anything in the queue?
	jz	KBD_Tx_intr	;no - reset TX int pending
	cmp	KD_trans_off,al	;allowed to transmit?
	jnz	KBD_Tx_intr	;no - reset TX int pending
	pushf
	cli
	call	KC_transmit	;go do the transmission
	popf
	ret
;
KBD_Tx_intr
        mov     al,#28h         ;
        out     #SIO_B_COM,al   ;reset TxInt pending
        ret



;***********************************************************************;
;*******************  CHANNEL B EXTERNAL INTERRUPT  ********************;
;***********************************************************************;
;									;
;  Channel B ext/status interrupts are used for printer status line	;
;  responses.								;
;									;
;									;
;------------------------------------------------------------------------


KBD_ext_int

        mov     al,#010h        ;
        out     #SIO_B_COM,al   ;reset ext/status flags
        call	PRN_transmit	;print character (if there is one)
	ret



;***********************************************************************;
;*******************  CHANNEL A EXTERNAL INTERRUPT  ********************;
;***********************************************************************;
;									;
;   Dummy routine.							;
;									;
;   The external interrupts for side A are not enabled by the BIOS.	;
;									;
;------------------------------------------------------------------------

AUX_ext_int

        mov     al,#010h        ;reset ext/status flags
        out     #SIO_A_COM,al   ;
        ret
   page
;***********************************************************************;
;***************  KEYBOARD SPECIAL RECEIVE INTERRUPT  ******************;
;***********************************************************************;
;									;
;  If and error condition occurs on the keyboard receive channel	;
;  the downcode buffer is cleared out.					;
;									;
;									;
;------------------------------------------------------------------------


KBD_spec_int
	in	al,#SIO_B_DAT	;read in error data
        mov     al,#030h        ;reset error condition
        out     #SIO_B_COM,al
	call	KC_error	;clear keyboard downcode buffer
        ret





;***********************************************************************;
;*************  AUXILIARY DEVICE SPECIAL RECEIVE INTERRUPT  ************;
;***********************************************************************;
;									;
;   If an error occurs on the auxiliary device receive channel the	;
;   appropriate error flag  is  latched  in  the  global  variable 	;
;   aux_errors. 							;
;   									;
;   The variable aux_errors is a byte and defined as follows:		;
;	bit  5   overrun error						;
;	bit  6   framming error						;
;	bit  4   parity error						;
;									;
;   The ROM BIOS call 'get receive character status' is used to read 	;
;   and clear aux_errors.						;								;    
;									;
;------------------------------------------------------------------------



AUX_spec_int


;READ THE ERROR CONDITION
	mov	al,#1			;select read register 1
	out	#SIO_A_COM,al		;


	in	al,#SIO_A_STAT		;read the selected register


;LATCH THE APPROPRIATE ERROR BITS IN 'aux_errors'
	and	al,#70h			;throw away irrelevant bits
	orb	aux_errors,al		;latch the error bit(s)


;THROW AWAY THE DATA IN ERROR
        in      al,#SIO_A_DAT   	;read data from SIO


;RESET THE ERROR CONDITION
        mov     al,#030h        	;reset error condition
        out     #SIO_A_COM,al		;

        ret				;RETURN

    	end


$ 