	;Auto repeat rate
;
KD_mouse_ipt	BLOCK	1	;mouse queue input count
;
screen_active	BLOCK	1	;temporary
;
KD_datatop			;dum

; [bios.apricot.rom]sound.asm
	title	'[bios.apricot.rom]sound.asm'
        INCLUDE 'legal.asi'
;************************************************************************
;
; MODULE:               [bios.apricot.rom]sound.asm
; Programmer:           G. Kurth
; Implemented:          16-Feb-84
; Modifications:	VAX version 2/5/84 GK
;			ROM BIOS version 23-may-84 GK
;
;************************************************************************
;------------------------------------------------------------------------
; This module replaces the pascal sound module.
; It performs all the keyclick and bell processing functions
; and also supports the Config calls to make use of the other channels
; All output is performed internally.
;------------------------------------------------------------------------
;
        name    sound
        
        INCLUDE 'ioregs.asi'
        
        Global  CodebaseQQ, DatabaseQQ
        
        Assume  CS:CodebaseQQ, DS:DatabaseQQ
        
        section sound.data, align(2), class=DataQQ
;
        Global  CNF_click_vol, CNF_bell_vol, Bell_cnt
;
Bell_freq       BLOCK   2               ;Bell frequency
ch2_freq	BLOCK	2		;channel 2 frequency
ch3_freq	BLOCK	2		;channel 3 frequency
Bell_cnt        BLOCK   1               ;Bell timer count
Bell_period     BLOCK   1               ;Bell period
Click_stat      BLOCK   1               ;click status
ch2_atten	BLOCK	1		;channel 2 attenuation
ch3_atten	BLOCK	1		;channel 3 attenuation

;
        section sound.code, align(1), class=InstrQQ
;
; Sound register equates
;
Atten_1         equ     10010000b       ;channel 1 attenuation
Atten_2         equ     10110000b       ;channel 2 attenuation
Atten_3         equ     11010000b       ;channel 3 attenuation
Atten_N         equ     11110000b       ;Noise channel attenuation
Freq_1          equ     10000000b       ;channel 1 frequency
Freq_2          equ     10100000b       ;channel 2 frequency
Freq_3          equ     11000000b       ;channel 3 frequency
Noise_C         equ     11100000b       ;Noise channel control
;
;---------------------------------------------------------------------
; Sound_Init    -       Initialises sound generator
;
        Global  Sound_Init
;
Sound_Init
        pushf                           ;make sure we are alone!
        cli
        movb    al,#0Fh                 ;channel off
        movb    ah,#Atten_1             ;do channel 1
        call    Atten_out               ;preserves attenuation value
        movb    ah,#Atten_2             ;channel 2
        call    Atten_out
        movb    ah,#Atten_3             ;channel 3
        call    Atten_out
        movb    ah,#Atten_N             ;Noise
        call    Atten_out
        movw    Bell_freq,#78           ;Bell frequency = 800Hz
        xorw    ax,ax
        movb    Bell_cnt,al             ;zero out counts
        movb    Click_stat,al
        movb    Bell_period,#20         ;default bell count
        popf
        ret
;
;-----------------------------------------------------------------------------
; KC_bell       -       Sets off the bell using Bell_freq
;
        Global  KC_bell
;
KC_bell
        cmpb    CNF_bell_vol,#0fh       ;is volume off?
        je      KC_bell_x               ;yes - don't bother
        pushf                           ;make sure we are alone
        cli
        movb    al,Bell_period          ;get bell period
        movb    Bell_cnt,al             ;sound for 400ms
        movw    dx,Bell_freq            ;get bell frequency
        movb    ah,#Freq_1
        call    Freq_out                ;set up frequency
        movb    al,CNF_bell_vol         ;get bell volume
        movb    ah,#Atten_1
        call    Atten_out               ;set off the bell
        popf
KC_bell_x
        ret
;
;------------------------------------------------------------------------
; KC_click      -       Sets the click status on
;
        Global  KC_click
;
KC_click
        cmpb    CNF_click_vol,#0Fh      ;sero volume?
        je      KC_click_x              ;yes - don't set off
        movb    Click_stat,#1           ;set click status to 1
KC_click_x
        ret
;
;-----------------------------------------------------------------------
; Sound_Int     -       called every 20ms by the timer
;                       switches off the bell if done
;                       switches on or off the click
;
        Global  Sound_Int
;
Sound_Int
        pushf
        cli
        cmpb    Bell_cnt,#0             ;have we counted down already?
        jz      Sound_Int1              ;yes -skip
        decb    Bell_cnt                ;decrement count
        jnz     Sound_Int1              ;not zero yet
        movb    al,#0Fh                 ;full attenuation
        movb    ah,#Atten_1             ;to the bell channel
        call    Atten_out
Sound_Int1
        cmpb    click_stat,#1           ;check click status
        jb      Sound_Int3              ;zero - quit
        je      Sound_Int2              ;one - set off click
        movb    click_stat,#0           ;reset status
        movb    al,#0Fh                 ;set full attenuation
        movb    ah,#Atten_N             ;on noise channel
        call    Atten_out
        jmpsh   Sound_Int3              ;and quit
Sound_Int2                              ;set off click
        movb    click_stat,#2           ;set state to on
        movb    ah,#Noise_C             ;set up control
        movb    al,#6                   ;set click type to white noise, s/r 2048
        call    Atten_out               ;use attenuator call to set up type
        movb    ah,#Atten_N             ;and zoom up the attenuation
        movb    al,CNF_click_vol        ;to the level requested
        call    Atten_out
Sound_Int3
        popf
        ret                             ;all done
;
;------------------------------------------------------------------------------
; Sound_Config  -       Sound configurator
;               enter with data in registers:
;               AX = fail status 0FFFFh
;		CX = Command
;		DX = data
;               or DX:SI = pointer
;               returns with status in AX
;
        Global  Sound_Config
;
Sound_Config
        mov     bx,cx			;command in bx
        pushf                           ;make sure we are alone
        cli
        cmpw    bx,#000Ah                ;valid 0-A?
        ja      Sound_Con_x
        shlw    bx,#1                   ;convert to word pointer
        jmp     [cs:SOUND_CTAB][bx]     ;go to routines
;
SOUND_CTAB
        WORD    Set_init-CodebaseQQ	;0 - Init & return status
        WORD    Set_cvol-CodebaseQQ     ;1 - set click volume
        WORD    Set_bvol-CodebaseQQ     ;2 - set bell volume
        WORD    Set_ch2a-CodebaseQQ     ;3 - set channel 2 attenuation
        WORD    Set_ch3a-CodebaseQQ     ;4 - set channel 3 attenuation
        WORD    Set_ch2f-CodebaseQQ     ;5 - set channel 2 frequency
        WORD    Set_ch3f-codebaseQQ     ;6 - set channel 3 frequency
        WORD    Set_belf-CodebaseQQ     ;7 - set bell frequency
        WORD    Set_beld-CodebaseQQ     ;8 - set bell duration
	WORD	Set_bell-CodebaseQQ	;9 - sound bell
	WORD	Set_clik-CodebaseQQ	;A - sound click
;
Set_init			;initialise sound
	call	Sound_init
	jmpsh	Sound_con_ok		;return ok status
;
Set_cvol                        ;set up click volume
        xor     ax,ax
        movb    al,CNF_click_vol        ;get old volume
        cmp     dx,#000Fh               ;valid?
        ja      Sound_Con_x             ;no - return old
        movb    CNF_click_vol,dl        ;set up new
        xchg    ax,dx
        jmpsh   Sound_Con_x
;
Set_bvol                        ;set up bell volume
        xor     ax,ax
        movb    al,CNF_bell_vol         ;get old volume
        cmp     dx,#000Fh               ;valid?
        ja      Sound_Con_x             ;no - return old
        movb    CNF_bell_vol,dl         ;set up new
        xchg    ax,dx
        jmpsh   Sound_Con_x
;
Set_ch2a                        ;set channel 2 attenuation
	cmpw	dx,#000Fh		;valid?
	ja	Set_ch2r		;no - return current
        movb	ch2_atten,dl		;set up
	movb    ah,#Atten_2             ;set up channel 2
	mov	al,dl			;set up
	call	Atten_out		;set attenuation
Set_ch2r
	mov	al,ch2_atten		;get atten
	cbw
	jmpsh	Sound_con_x		;and return
;
;---------------------------------------------------------------------
; These are here to allow short jumps
Sound_Con_ok
        xorw    ax,ax                   ;return OK status
Sound_Con_x
        popf
        ret				;return status in ax
;--------------------------------------------------------------------
;
Set_ch3a                        ;set channel 3 attenuation
	cmpw	dx,#000Fh		;valid?
	ja	Set_ch3r		;no - return current
	movb	ch3_atten,dl		;set up
        movb    ah,#Atten_3             ;set up channel 3
	mov	al,dl
	call	Atten_out		;set attenuation
Set_ch3r
	mov	al,ch3_atten		;get atten
	cbw
	jmpsh	Sound_con_x		;and return
;
Set_ch2f                        ;set channel 2 frequency
	cmp	dx,#03FFh		;valid?
	ja	Set_ch2fr		;no - return current
        movw	ch2_freq,dx		;set up
	movb    ah,#Freq_2              ;set up channel 2
        call	Freq_out
Set_ch2fr
	movw	ax,ch2_freq		;return setting
	jmpsh	Sound_con_x
;
Set_ch3f                        ;set channel 3 frequency
	cmp	dx,#03FFh		;valid?
	ja	Set_ch3fr		;no - return current
        movw	ch3_freq,dx		;set up
	movb    ah,#Freq_3              ;set up channel 3
        call	Freq_out
Set_ch3fr
	movw	ax,ch3_freq		;return setting
	jmpsh	Sound_con_x
;
Set_belf                        ;set bell frequency
	cmp	dx,#03FFh		;valid?
	ja	Set_belfr		;no - return current
        movw	bell_freq,dx		;set up
	movb    ah,#Freq_1              ;set up channel 1
        call	Freq_out
Set_belfr
	movw	ax,bell_freq		;return setting
	jmpsh	Sound_con_x
;
;
Set_beld                        ;set bell duration
        xor	ax,ax
	mov	al,bell_period		;get current
	cmpb    dl,ah                   ;zero duration?
        jz      Sound_Con_x             ;don't let that through!
        cmpb	dh,ah			;greater than 255?
	jnz	Sound_con_x		;yes - return current
	movb    bell_period,dl          ;set up
	xchg	ax,dx
        jmpsh   Sound_Con_x		;and exit ok
;
Set_bell			;sound bell
	call	KC_bell
	jmpsh	Sound_con_ok
;
Set_clik			;sound click
	call	KC_click
	jmpsh	Sound_con_ok
;
;---------------------------------------------------------------------
; Atten_out     -       sends attenuation in AL to register in AH
;
Atten_out
        andb    al,#0Fh                 ;zap to right value
        orb     al,ah                   ;or in register
        out     #SOUND,al               ;send it
        movb    cl,#16                  ;wait at least 80 clocks
        shl     cx,cl
        ret
;
;--------------------------------------------------------------------
; Freq_out      -       sends frequency in DX to register in AH
;
Freq_out
        movb    al,dl                   ;get low stuff
        andb    al,#0Fh                 ;knock down
        orb     al,ah                   ;or in register
        out     #SOUND,al               ;send first byte
        movb    cl,#12                  ;wait a bit
        shl     cx,cl
        movb    cl,#4                   ;set up to work out next byte
        shr     dx,cl                   ;and shift down
        movb    al,dl
        andb    al,#3Fh                 ;clear top bits
        out     #SOUND,al               ;send second frequency byte
        movb    cl,#16                  ;wait again
        shl     cx,cl
        ret
;
;

        End


$ 