MODULE display_query; (*$DEBUG+*)

const

	DEBUG=0;	(* divisible by :         			*)
			(* 1 -                                    	*)
			(* 2 -                   			*)
			(* 4 - 						*)
			(* 8 -						*)

(*$INCLUDE:'SCREEN.H'*)
(*$INCLUDE:'DEFS.H'*)
(*$INCLUDE:'GEN-ROUT.H'*)
FUNCTION get_qbuf_rec(rec_no : integer; var cnt_matches : integer;
		      quest_buf : q_buf; num_match : n_match_buf) : result; EXTERN;


PROCEDURE p_month(month : char);
begin
    case month of
     'A' : write('Jan');
     'B' : write('Feb');
     'C' : write('Mar');
     'D' : write('Apr');
     'E' : write('Mar');
     'F' : write('Jun');
     'G' : write('Jul');
     'H' : write('Aug');
     'I' : write('Sep');
     'J' : write('Oct');
     'K' : write('Nov');
     'L' : write('Dec');
    otherwise
      begin
	writeln;
	writeln('Internal error : invalid month : ',month);
	closedown('d_query 1');
      end;
    end; (* end case *)
end;


PROCEDURE cnvrttoodds(odds : real; var odd1,odd2 : integer);		(* given 'odds' rets odd1,odd2  eg 0.5= 2/1 *)
var
  times : integer;
  temp : real;
begin
   temp:=1 / odds;
   times:=1;
   while (abs(round(temp)-temp) > setaccuracy) do
     begin
	temp:=temp+(1/odds);
	times:=times+1;
     end;
   odd1:=round(temp);
   odd2:=times;
   if (DEBUG>=1) then writeln('odd1,odd2=',odd1:5,odd2:5);
end;

PROCEDURE reverse(var f_str : str);
var
   b_str	: str;
   loop		: integer;
begin
   b_str:=null;
   for loop:=ord(f_str.len) downto 1 do
     concat(b_str,f_str[loop]);
   f_str:=b_str;
end;
   
FUNCTION int_to_asc(num : integer) : str;
var
   temp_str : str;
begin
   temp_str:=null;
   repeat
     concat(temp_str,chr(ord('0')+ (num mod 10)));
     num:=num div 10;
   until num<=0;
   reverse(temp_str);
   int_to_asc:=temp_str;
end;

PROCEDURE p_runners(runners : integer);
var
	temp : str;
begin
  temp:=int_to_asc(runners);
  write(temp);
end;

PROCEDURE p_odds(odds : real);
var
	odd1,odd2	: integer;
	oddstr,odd2str	: str;
begin
   cnvrttoodds(odds,odd1,odd2);
   oddstr:=int_to_asc(odd1);
   concat(oddstr,'-');
   odd2str:=int_to_asc(odd2);
   concat(oddstr,odd2str);
   write(oddstr);
end;

PROCEDURE p_grade(grade : char);
begin
   case grade of
    'F' : write('Fav');
    '2' : write('2nd Fav');
    'X' : write('Other');
   otherwise
    begin
	writeln('Internal error - invalid grade : ',grade);
	closedown('d_query 2');
    end;
   end; (* end case *)
end;

PROCEDURE p_crse_type(crs : char);
begin
  if crs='F' then write('Flat')
  else		  write('Hurdle');
end;


PROCEDURE end_page(var ending : boolean);
var
    dummy		: char;
begin
    printat(22,8,'Page full ... (press any key for next page, (ESC to quit)) : ');
    dummy:=cinput(ending);
end;

PROCEDURE d_p_query(t : result; q : q_buf;
		 num_match : n_match_buf; num_uniques : integer;
		 field_1_name,field_2_name : str;
		 field_1,field_2 : integer) [PUBLIC];
var
	loop,inner,start,cnt_matches,cnt  	: integer;
	temp					: result;
	ending					: boolean;
begin
    write(clearscrn,boldon);
    printmid(1,'Display results of Query.');
    printat(5,30,field_2_name);
    if field_1<>field_2 then start:=0 else start:=27;
    if field_1<>field_2 then printat(5,9,field_1_name);
    printat(5,54,'No.winners.');
    writeln;

    printat(6,start,null);
    for inner:=start to 70 do write('-');
    write(attriboff);
    writeln;
    cnt:=0;
    ending:=false;
    loop:=0;
    while ((loop<num_uniques) and (not ending)) do
      begin
       if (((loop mod 14)=0) and (loop<>0)) then
	  begin
	    end_page(ending);
	    cnt:=0;
	    write(clearscrn);

    	    write(clearscrn,boldon);
	    printmid(1,'Display results of Query.');

	    printat(5,30,field_2_name);
	    if field_1<>field_2 then printat(5,9,field_1_name);
	    printat(5,54,'No.winners.');
	    writeln;

	    printat(6,start,null);
	    for inner:=start to 70 do write('-');
	    writeln;
	    write(attriboff);
	  end;

      if (not ending) then
       begin
        temp:=get_qbuf_rec(loop,cnt_matches,q,num_match);
	if field_1<>field_2 then
	begin
	  printat(7+(loop mod 14),15,null);
	  case field_1 of
	    1 : p_month(temp.month);
	    2 : p_runners(temp.runners);
	    3 : printat(7+(loop mod 14),11,temp.course);
	    4 : write(temp.age);
	    5 : write(temp.handicap);
	    6 : p_crse_type(temp.crse_type);
	    7 : printat(7+(loop mod 14),3,temp.horse);
	    8 : printat(7+(loop mod 14),3,temp.jockey);
	    9 : p_odds(temp.odds);
	    10: p_grade(temp.grade);
	   otherwise
	    begin
		writeln; writeln('Internal error : invalid field_1 = ',field_1);
		closedown('disp_q 3');
	    end;
	   end; (* end case *)
	 end;

	  printat(7+(loop mod 14),35,null);
	  case field_2 of
	    1 : p_month(temp.month);
	    2 : p_runners(temp.runners);
	    3 : printat(7+(loop mod 14),33,temp.course);
	    4 : write(temp.age);
	    5 : write(temp.handicap);
	    6 : p_crse_type(temp.crse_type);
	    7 : printat(7+(loop mod 14),26,temp.horse);
	    8 : printat(7+(loop mod 14),26,temp.jockey);
	    9 : p_odds(temp.odds);
	    10: p_grade(temp.grade);
	   otherwise
	    begin
		writeln; writeln('Internal error : invalid field_2 = ',field_2);
		closedown('disp_q 4');
	    end;
	   end; (* end case *)

	printat(7+(loop mod 14),46,null);
	writeln(cnt_matches);
	loop:=loop+1;
       end;
      end;
    if ending then
	perror('Listing aborted - acknowledge ...')
    else
	perror('continue...');
end;

END.
