Module past_res_section; (*$DEBUG+*)

(* Date written  : 22/07/86
   Date updated  : 23/11/86
   Author 	 : A.Hausser

   Vers		 : 3.0a
   Update History:
      19/10/86 : It was decided that only one question can be entered at a time
		and that it is automatically processed interactively as soon as
		the query is complete. It was intended that the user could enter
		several questions & then process in batch; this however on close
		inspection poses all sorts of complications based on memory con-
		straints.
		 It is predicted that a typical user could reasonably enter 50
		records per week. Each query answer =30 bytes. A query could
		approx return a 100% of unique records of the file eg. query on
		jockey & horse. Assuming a standard data segment in memory &
		about 50K free then that leaves the user working for 33 weeks &
		then the memory is exhausted. This is a theoretical limit but
		it must be catered for. The solution is to build into the prog
		a routine such that if the query answers are greater than a set
		value then the program opens up a random access file as an over-
		flow (virtual memory ?). The speed of execution change on this
		boundary may well be considerable.
		Note. As long as the user sticks to sensible queries the limit 
		 should never be reached.




*)
const

(*$INCLUDE:'screen.h'*)
(*$INCLUDE:'defs.h'*)
(*$INCLUDE:'GEN-ROUT.H'*)

PROCEDURE add_results(var new_results : result_buf;
		      var num_new_results : num_result_add_range); EXTERN;
PROCEDURE get_q_template(var quest_template : result;
			 var temp_defined : boolean;
			 var field_1_name,field_2_name : str;
			 var field_1,field_2 : integer); EXTERN;
PROCEDURE process_r_q(var newfile,oldfile : text;
		added_results :result_buf; var num_added : num_result_add_range;
		quest_template : result; var quest_buf : q_buf;
		temp_defined : boolean; var num_match: n_match_buf;
		var num_uniques : integer); EXTERN;
PROCEDURE d_p_query(quest_template : result; quest_buf : q_buf;
		    num_match : n_match_buf; num_uniques : integer;
		    field_1_name,field_2_name : str;
		    field_1,field_2 : integer); EXTERN;
   

PROCEDURE print_menu;
begin
	write(clearscrn,boldon);
	printmid(1,'Past Winning Results Section.');
	write(attriboff);
	printat(7,12,'Options availiable : ');
	printat(10,20,'1... Add new race results to computer.');
	printat(11,20,'2... Setup query template for previous results.');
	printat(12,20,'3... Process New Results & Queries.');
	printat(13,20,'4... Display/Print answers to query.');
	printat(17,20,'5... Exit back to main menu.');
	printat(20,30,'Enter option : ');
end;

PROCEDURE get_option(var option : char);
var
	ending,ok : boolean;
	temp	: str;
begin
  ok:=false;
  while (not ok) do
    begin
	temp:=sinput(20,45,1,ending);
	if ending then temp[1]:='5';
        if ((temp[1]<'1') or (temp[1]>'5')) then
	   perror('Error - Enter 1 to 5 only.')
	else
	   ok:=true;
    end;
  option:=temp[1];
end;

PROCEDURE quit_nosave(var quit : boolean);		(* Asks user if wants to quit without saving new results *)
var
    ok,ending	: boolean;
begin
    printat(22,1,'WARNING: New results have not been saved - confirm quit without saving :');
    ok:=false;
    while (not ok) do
     begin
      quit:=binput(22,73,1,ending);
      if ending then perror('You must enter Y or N')
      else ok:=true;
     end;
end;

PROCEDURE alert_need_p;		(* tells user can not print results of query until process file *)
begin
	perror('You must calculate answers first, by Process New Results & Queries option.');
end;
 
PROCEDURE past_results [PUBLIC];
var

	quit					: boolean;
	added_results 		    		: result_buf;
	num_added 				: num_result_add_range;
	quest_template 				: result;
	quest_buf 				: q_buf;
	num_match	 			: n_match_buf;
	num_uniques 				: integer;
	option					: char;
	temp_defined,need_p_query		: boolean;
	loop					: integer;
	field_1_name,field_2_name		: str;
	field_1,field_2				: integer;
        newfile,oldfile				: text;

begin
  num_added:=0;	(* buffer array starts at 0 element *)
  temp_defined:=false;
  need_p_query:=true;      (* if defined template but not processed file then need_p_query=true - needs process queries *)
  num_uniques:=0;
  for loop:=0 to q_buf_range do
    num_match[loop]:=0;

  quit:=false;
  while (not quit) do
   begin
     print_menu;
     get_option(option);
     case option of
	'1' : add_results(added_results,num_added);
	'2' : begin
		get_q_template(quest_template,temp_defined,field_1_name,
				field_2_name,field_1,field_2);
		need_p_query:=true;
	      end;
	'3' : begin
		process_r_q(newfile,oldfile,added_results,num_added,
			    quest_template,quest_buf,
			    temp_defined,num_match,num_uniques);
		need_p_query:=false;
	      end;
	'4' : if need_p_query then alert_need_p
	      else d_p_query(quest_template,quest_buf,num_match,num_uniques,
				field_1_name,field_2_name,field_1,field_2);
	'5' : if (num_added>0) then quit_nosave(quit)
	      else quit:=true;
	otherwise perror('invalid option somehow')
     end;
   end;
end;

end.

