      SUBROUTINE BILINEAR(BIG)
C                            ANTHONY CARROLL FEB. 1986
C---------------------------------------------------------
C  THIS ROUTINE APPLIES A POINT LOAD AT SUCCESSIVE POINTS ALONG
C  THE BEAM. EACH TIME A LOAD IS APPLIED, THE LOAD FACTOR FOR
C  EACH STUD IS CALCULATED. THE STUD WITH THE MINIMUM LOAD FACTOR
C  IS THE NEXT STUD TO LOAD UP. WHEN A STUD LOADS UP IT IS GIVEN
C  AN APPROPRIATE STIFFNESS........READ COMMENTS AND REFER TO
C  SUBROUTINES CALLED FOR FURTHER DETAILS.
C---------------------------------------------------------
      IMPLICIT REAL*8(A-H,O-Z)
      INCLUDE 'STRESS2D.CCM'
      REAL*8 LOAD_FACT,KA,RATIO,SET_INITIAL
     * ,STIFF_INITIAL,force(maxstuds),NET_SHEAR
      INTEGER ACCURATE_RUNS

      RATIO=(1-(1/KA))             !RATIO OF SET TO SLIP

      STIFF_INITIAL=SSS(1)/150     !INITIAL STIFFNESS OF ALL STUDS
      IF(STIFF_INITIAL.EQ.0.0) STIFF_INITIAL = 100.0 !DEFAULT VALUE
      SET_INITIAL=.000000001      !INITIAL SET OF ALL STUDS


      DO 10 I=1,NSG                       !<>NOTA BENE<>
          SLIP_POS(I) = SET_INITIAL       !THIS MUST BE DONE ONCE EVER
          SLIP_NEG(I) = (-SET_INITIAL)    !IN WHOLE ANALYSIS
          SET_POS(I)=SET_INITIAL          !INITIALIZES SET RANGE OF
          SET_NEG(I)=0.0 - SET_INITIAL    !ALL STUDS.
 10   CONTINUE                            !


      DO 11 I = 1,NSG                   !MUST RETAIN COPY OF LOADS INITIALLY
 11          GLOAD_STORE(I) = GLOAD(I)  !APPLIED AS "GLOAD" CHANGES 
                                        !IN THE INCREMENTAL ANALYSIS.

          WRITE(7,612)RATIO  !ECHO RATIO OF SET TO SLIP


C
C LOOP 21 DOES A NUMBER OF LOAD APPLICATIONS RIGHT ACROSS THE BEAM
C WE JUST WANT TO SEE WHEN "STEADY STATE" CONDITIONS FOR SET_POS
C ,SLIP_POS ETC. OCCURS. "ACCURATE_RUNS" = # OF ACCURATE_RUNS!!
C
      ACCURATE_RUNS = 8        !REMOVE & PUT INTO "INDAT"
      DO 21 J = 1,ACCURATE_RUNS    !"OUTER" OUTER LOOP
                WRITE(7,621)J
                DO 22 JJ = 1,NSG                  !GLOAD RESTORED TO ITS
 22                   GLOAD(JJ) = GLOAD_STORE(JJ) !ORIGINAL VALUES



C            LOOP 20 APPLIES LOAD AT SUCCESSIVE NODES   
C           <>THIS IS THE MAIN OUTER LOOP  <>NEW LOADS
C
      DO 20 LOAD_NODE=1,NUM
          WRITE(7,600)LNOAD(LOAD_NODE)
            NET_SHEAR = 0.0
          INC_COUNTER = 0
          CALL INITIALIZE(STIFF_INITIAL)

 30   IF(GLOAD(LOAD_NODE).GT.0.0) THEN    !CHECKS FOR POSITIVE LOAD
                                          !<>MAIN INNER LOOP<>INCREMENTAL.
             INC_COUNTER=INC_COUNTER+1    !COUNTS # LOAD INCREMENTS APPLIED

      IF(TRI_LIN_ALL) THEN
        WRITE(7,601)GLOAD(LOAD_NODE)
        WRITE(7,602)INC_COUNTER
        DO 1000 II=1,NSG
             K=NSTUD(II)
 1000        WRITE(7,603)II,RKAS(K,1)   
      END IF

      IF(TRI_LIN_ALL) THEN
        do 1010 ii=1,nsg
        WRITE(7,*)ii,'set_pos',set_pos(ii),'slip_pos',slip_pos(ii)
 1010   WRITE(7,*)ii,'set_neg',set_neg(ii),'slip_neg',slip_neg(ii)
      END IF

 80          CALL FINITE2(BIG,LOAD_NODE)
             CALL SLIP_INCREMENT       !CALCS INCREMENTAL SLIP @ EACH STUD

      DO 90 I = 1,MAXSTUDS
         K = NSTUD(I)
      if((set_pos(i).gt.(set_initial+1e-10))    .or.
     * (set_neg(i).lt.(-set_initial-1e-10)))    then

         IF(((RKAS(K,1).EQ.SSS(I)) .AND.
     *   (((SLIP_INC(I).GT.0.0).AND.(SLIP_INC_STORE(I).LT.0.0)).OR.
     *   ((SLIP_INC(I).LT.0.0).AND.(SLIP_INC_STORE(I).GT.0.0))))) THEN

             IF(TRI_LIN_ALL)   WRITE(7,*)'REDOING CALCULATION: STUD',I

             RKAS(K,1) = SSS(I)*KA   !IF A STUD WAS STATICALLY LOADED & IT
             GOTO 80                 !CHANGED DIRN. OF SLIP IT MUST NOW HAVE
      END IF                         !CYCLIC STIFFNESS SO MUST REAPPLY LOAD.
      end if
 90   CONTINUE


      CALL LOAD_FACTOR(LOAD_FACT,I_STORE1,SET_INITIAL
     * ,STIFF_INITIAL,STIFF)

      IF(TRI_LIN_ALL)    THEN
          WRITE(7,604)LOAD_FACT
          WRITE(7,605)I_STORE1
          WRITE(7,610)STIFF   
      END IF


C___THE FOLLOWING IS THE SECOND LINE IN WHICH A STUD STIFFNESS CAN CHANGE___
      K=NSTUD(I_STORE1)   !THESE LINES ADJUST STIFFNESS OF THE PREVIOUSLY
      RKAS(K,1)=STIFF     !LOADED STUD TO THE APPROPRIATE VALUE.

    
C    LOOP 40 ADJUSTS SLIP_inc S OF ALL STUDS TO THE SLIP THAT WOULD OCCUR
C    IF ONLY THE LOAD NECESSARY FOR THE PREVIOUS STUD TO LOAD WERE APPLIED.
C    ....THE PRINCIPAL OF SUPERPOSITION APPLIED UP TO THAT POINT ONLY....
C
      DO 40 I=1,NSG
      SLIP_INC(I)=SLIP_INC(I)*LOAD_FACT
       IF(TRI_LIN_ALL)        WRITE(7,611)SLIP_INC(I),I    
 40   CONTINUE



      FRACTION=1-LOAD_FACT   !THE FRACTION OF LOAD THAT HAS YET TO BE APPLIED
      GLOAD(LOAD_NODE)=GLOAD(LOAD_NODE)*FRACTION   !LOAD APPLIED IN NEXT INCREM.

      IF(LOAD_FACT.EQ.1.0)   GLOAD(LOAD_NODE)=0.0  !IF ALL STUDS ARE LOADED
                      !^check                      !LOAD_FACT=1 =>APPLY FULL
                                                   !LOAD...EXIT "IF" BLOCK


C-------------------------------------------------------------------------
C      ALL ADJUSTMENTS TO SLIP_POS, SET_POS ETC. MAID IN FOLLOWING LINES
C-------------------------------------------------------------------------

C               SLIPS FOR ALL STUDS ARE ADJUSTED AS BELOW

      DO 100 I = 1,NSG

      if ((slip(i).lt.(slip_pos(i)+1e-15)).and.
     *(slip(i).gt.(slip_pos(i)-1e-15))) slip(i) = slip_pos(i)

        IF ((SLIP(I).eq.SLIP_POS(I)) .AND. (SLIP_INC(I).GT.0.0)) THEN
           SLIP_POS(I) = SLIP_POS(I) + SLIP_INC(I)
           SET_POS(I)  = SET_POS(I)  + SLIP_INC(I)*RATIO
          IF(TRI_LIN_ALL)        THEN
                 WRITE(7,*)' A NEW SLIP_POS(I)',SLIP_POS(I),'STUD',I
                 WRITE(7,*)' A NEW SET_POS(I)',SET_POS(I),'STUD',I
           END IF
      END IF

      if ((slip(i).lt.(slip_neg(i)+1e-15)).and.
     *(slip(i).gt.(slip_neg(i)-1e-15)))  slip(i) = slip_neg(i)
      IF ((SLIP(I).eq.SLIP_NEG(I)) .AND. (SLIP_INC(I).LT.0.0)) THEN
           SLIP_NEG(I) = SLIP_NEG(I) + SLIP_INC(I)
           SET_NEG(I)  = SET_NEG(I)  + SLIP_INC(I)*RATIO
          IF(TRI_LIN_ALL)        THEN
              WRITE(7,*)' B NEW SLIP_NEG(I)',SLIP_NEG(I),'STUD',I
              WRITE(7,*)' B NEW SET_NEG(I)',SET_NEG(I),'STUD',I
          END IF
      END IF

      IF((SET_POS(I).EQ.SET_INITIAL).AND.(SLIP(I).EQ.SET_POS(I))) THEN
           IF (SLIP_INC(I).GT.0.0) THEN
               SLIP_POS(I) = SLIP_POS(I) + SLIP_INC(I)
               SET_POS(I) = SET_POS(I) + SLIP_INC(I)*RATIO
             IF(TRI_LIN_ALL)        THEN
                WRITE(7,*)' C NEW SLIP_POS(I)',SLIP_POS(I),'STUD',I
                WRITE(7,*)' C NEW SET_POS(I)',SET_POS(I),'STUD',I
              END IF
           END IF
      END IF

      IF((SET_NEG(I).EQ.(-SET_INITIAL)).AND.(SLIP(I).EQ.SET_NEG(I)))THEN
           IF (SLIP_INC(I).LT.0.0) THEN
               SLIP_NEG(I) = SLIP_NEG(I) + SLIP_INC(I)
               SET_NEG(I)  = SET_NEG(I)  + SLIP_INC(I)*RATIO

              IF(TRI_LIN_ALL)        THEN
                 WRITE(7,*)' D NEW SLIP_POS(I)',SLIP_POS(I),'STUD',I
                 WRITE(7,*)' D NEW SET_POS(I)',SET_POS(I),'STUD',I
              END IF
           END IF
      END IF

         SLIP(I) = SLIP(I) + SLIP_INC(I)  !CALCS ACTUAL SLIP @ EACH STUD
         IF(TRI_LIN_ALL)   WRITE(7,*)' ACTUAL SLIP',SLIP(I),'STUD',I

 100  CONTINUE

      DO 70 I = 1,MAXSTUDS   !STORE LAST VALUE OF SLIP FOR COMPARISON
 70    SLIP_INC_STORE(I)=SLIP_INC(I) !WITH NEXT VALUE.

c        do 1020 ii=1,nsg
c        WRITE(7,*)ii,'set_pos',set_pos(ii),
c     *  'slip_pos',slip_pos(ii)
c 1020   WRITE(7,*)ii,'set_neg',set_neg(ii),
c     *  'slip_neg',slip_neg(ii)




      GOTO 30   !SENDS PROGRAM BACK TO CHECK IF APPLIED LOAD (GLOAD)=0.0

      END IF    !MAIN "IF" BLOCK IS EXITED ONLY IF GLOAD(LOAD_NODE)=0.0

       DO 110 IJ = 1,NSG
            STATIC = SSS(IJ)
            CYCLIC = STATIC*KA
                 K = NSTUD(IJ)
         STIFFNESS = RKAS(K,1)
c              write(8,*)STIFFNESS,STIFF_INITIAL,STATIC,CYCLIC
 622  FORMAT(10X,'STUD #',1X,I5,5X,'SHEAR FORCE',1x,F13.3)
      IF (STIFFNESS .EQ. STATIC)               THEN
      IF (SLIP(IJ).GT.0.0)  FORCE(IJ) = ((SLIP(IJ)-SET_INITIAL)*STATIC)
      IF (SLIP(IJ).LT.0.0)  FORCE(IJ)=((SLIP(IJ)+SET_INITIAL)*STATIC)
                                                END IF

      IF (STIFFNESS .EQ. CYCLIC)               THEN
      IF (SLIP(IJ).GT.0.0)  FORCE(IJ)=(SLIP(IJ)-SET_POS(IJ))*CYCLIC
      IF (SLIP(IJ).LT.0.0)  FORCE(IJ)=(SLIP(IJ)-SET_NEG(IJ))*CYCLIC
                                                END IF

      IF(STIFFNESS.EQ.STIFF_INITIAL) FORCE(IJ)=SLIP(IJ)*STIFF_INITIAL

              write(7,622)K,force(ij)
              NET_SHEAR = NET_SHEAR + FORCE(IJ)
 110  CONTINUE
              WRITE(7,623)NET_SHEAR
 623  FORMAT(/,10X,'NET SHEAR ON INTERFACE IS.....',F13.3,/)


 20   CONTINUE  !END OF MAIN LOOP WHICH APPLIES LOAD AT SUCCESSIVE POINTS
 21   CONTINUE
      RETURN    
 600  FORMAT(//,10X,'LOAD NOW AT NODE.....',I5,/)
 601  FORMAT(//,10X,'INCREMENT OF LOAD ie. gload....',F12.4)
 602  FORMAT(10X,'INCREMENT # ie. inc_counter....',I5)
 603  FORMAT(10X,'STUD #..',I6,6X,'STIFFNESS...',F12.4)
 604  FORMAT(/,10X,'LOAD FACTOR FOR NEXT STUD load_fact'
     * ,f14.11,/)
 605  FORMAT(10X,'# OF LAST STUD TO LOAD i_store1..',I6,/)
 610  FORMAT(10X,'STIFFNESS GIVEN TO LAST LOADED STUD stiff..',f12.4,/)
 611  FORMAT(10X,'MODIFIED SLIP_INC...',F14.11,8X,'STUD...',I4)
 612  FORMAT(/,10X,'RATIO OF SET TO SLIP...',F12.4,/)
 615  FORMAT(10X,'SET_POS(I)..',F14.11,8X,'STUD..',I4)
 620  FORMAT(10X,'SET_NEG(I)..',F14.11,8X,'STUD..',I4)
 621  FORMAT(1H ,//////,19X,'START OF RUN NUMBER',4X,I5,/////)
      END

$ 