C==========================================================
      SUBROUTINE BOUN(BIG)
C----------------------------------------------------------
C
C     (1)  Applies prescribed Dirichlet type boundary 
C          condition by adding  BIG to appropraite
C          diagonal terms of stiffness global matrix, 
C          (n.b. this matrix is stored in packed form).
C     (2)  Searches for missing node numbers and
C          if these occur then sets up dummy 
C          equations for these nodes.
C
C----------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 KA,KB,KC,KD,KE,KM
      INCLUDE 'STRESS2D.CCM'  

      A11=A(1,1)
   
      DO 200 N=1,NFIXZ
      KFIX=NFIX(N)
      NODE=KFIX/10000
      KODE=KFIX-10000*NODE
      K1=KODE/10
      K2=KODE-10*K1
      I=NVN*(NODE-1)
      IF(K1.EQ.1) A(I+1,1)=A(I+1,1)+BIG    !adds BIG to diagonal
      IF(K2.EQ.1) A(I+2,1)=A(I+2,1)+BIG    ! of stiffness matrix
      I1=I+1
       I2=I+2
 200  CONTINUE

C                                     search for missing node numbers
      DO 275 NODE=1,NODEZ
      DO 260 J=1,NELEMZ
      IF(LLTYP(J).EQ.1) THEN
      DO 270 I=1,8
      IF(NODE.EQ.LTOP(I,J))  GOTO 275
 270  CONTINUE
      ELSE
      DO 280 I=1,2
      IF(NODE.EQ.LTOP(I,J))GOTO 285
 280  CONTINUE
      ENDIF
 260  CONTINUE
      WRITE(6,601)NODE
      I=NVN*(NODE-1)
      DO 290 N=1,NVN
 290  A(I+N,1)=A11
 285  CONTINUE
 275  CONTINUE


      RETURN

 601  FORMAT(/,' NODE ',I5,' IS MISSING FROM TOPOLOGY LIST')
      END

$ 