C              scrap scrap scrap scrap scrap
C--------------------------------------------------------------
      PROGRAM BRIDGE
C                       ANTHONY CARROLL FEB. 1986
C--------------------------------------------------------------
C  FINITE ELEMENT ANALYSIS OF COMPOSITE BEAMS SUBJECT TO FATIGUE
C  ROLLING LOAD.  8-NODED ISOPARAMETRIC ELEMENTS ARE USED TO REPRESENT
C  THE MATERIALS FROM WHICH THE BEAM IS CONSTRUCTED; 2-NODED
C  SPRING ELEMENTS ARE USED TO REPRESENT THE STUDS ON THE INTERFACE 
C  BETWEEN THE MATERIALS USED.
C--------------------------------------------------------------
C     Files :
C            5  input data ;   6 OUTPUT DATA
C---------------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z) 
      real*8 LF,MLF,KA,KB,KC,KD,KE,KM
      INTEGER BS,STNO,LOAD_NODE
      INCLUDE 'STRESS2D.CCM'
      DIMENSION DSPLC(1000),LF(300),CSS(300),SHINC(300),
     1          AFCP(300),NODENO(1000),P(300),NELSTR(300),
     2          NFST(30),AFCRP(300),AFC(300),TFL(300),
     3          AXFOR(300),TAXFOR(300),NSPGR(300),shforst(300)

      NVN=2        ! 2 variables per node for above classes     

                                                    
      MXNOD=1000               ! set storage limits
      MXAI=NVN*MXNOD          !  FOR FINITE ELEMENT ANALYSIS
      MXAJ=200
      MXFIX=150
      MXMAT=10
      MXEL=300


       
      CALL INDAT(NODENO,NNG,NLC,NES,NELSTR,NOSP,NSPGR,NCON,afcp,
     .      SHFORST,NW,NERROR,MXITER,NSTAT,NGROUP)

      IF(ECHO) WRITE(6,601)
      IF(ECHO) WRITE(6,602)NVN,MXNOD,MXAI,MXAJ,MXMAT,MXFIX,MXEL

               
C        **********************************************************
             CALL FINITE1(big)
C        **********************************************************

      CALL UNILIN(MODE,BIG,NODENO,NNG)

      CALL BILINEAR(BIG)

         

C      CALL RASS(NVABZ,KWIDTH,NELEMZ,LMAT,PROR,LLTYP,LTOP,
C     * GX,B,GY,NGAUSS,KLASS,THETA,RKAS,A)
C      CALL FORCE(A,NVABZ,KWIDTH,DSPLC,NODENO,NNG,KOUNT,NWRITE,NW,NSTAT)
C      CALL STRESS(NES,NELSTR,NWRITE,AXFOR,NW,KOUNT,NSTAT)
C      CALL STUD(KOUNT1,DSPLC,NCON)

c     ***************************************************
c               for static case only next few lines
c      **************************************************
       
C      *******  END STATIC CASE ONLY HERE  *********          



      IF(UNI_LIN)  WRITE(6,1000)
 1000 FORMAT(///,2X,'START OF ACCURATE INCREMENTAL ANALYSIS')
      IF(UNI_LIN)  WRITE(6,72)
   72 FORMAT(//,27X,'ESTIMATED',8X,'ESTIMATED')
      IF(UNI_LIN)  WRITE(6,70)
   70 FORMAT(1X,'STUD',5X,'SHEAR',5X,'PERM',8X,'PEAK',
     * 10X,'MIN',6X,'RANGE',5X,'EXTRA',4X,'TOTAL')
      IF(UNI_LIN)  WRITE(6,71)
   71 FORMAT(2X,'NO.',5X,'FORCE',5X,'SET',9X,'LOAD',10X,'LOAD',15X,'SET'
     * ,6X,'SET')
      IF(UNI_LIN)  WRITE(6,1003)
 1003 FORMAT(2X,'K',7X,'SHFORST',3X,'PSET',8X,'SHPK',10X,'SHMN',7X,'R',
     * 7X,'FSET',5X,'TSET')

      DO I=1,NSG
        K=NSTUD(I)
C        IF(UNI_LIN)  WRITE(6,50)K,SHFORST(K),PSET(K),SHPK(K),SHMN(K),R(K),FSET(
K),PSET(K)
      END DO
C   50 FORMAT(1X,I3,2X,F9.2,2X,F8.6,1X,F12.4,1X,F11.4,1X,F9.2,2X,
C     * F8.6,3X,F8.6)


      stop
 601  FORMAT(//,'  THE CURRENT STORAGE LIMITATIONS ARE  .......')
 602  FORMAT(' NVN   =',I5,/,' MXNOD =',I5,/,' MXAI  =',I5,/,
     1       ' MXAJ  =',I5,/,' MXMAT =',I5,/,' MXFIX =',I5,/,
     2       ' MXEL  =',I5,//)
  
      END

$ 