C===============================================================
      SUBROUTINE GSTIFF2(BIG,LOAD_NODE)
C--------------------------------------------------------------
C
C     For each individual element...
C     (1) Extracts element data from global arrays
C     (2) Calls 'routines to compute element matrices
C     (3) Sets up the earthing parameter "BIG"
C
C----------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 KA,KB,KC,KD,KE,KM
      INCLUDE 'STRESS2D.CCM'     

      DIMENSION 
     .   X(8),Y(8),PRESS(8),LNODS(8),              
     .   XX(2),YY(2),PRESSS(2),LLNODS(2),DEL(16),
C     .   ELS(16,16),EF(16),ELSS(4,4),EFF(4),LDEST(2000)
     .   ELS(16,16),EF(16),ELSS(4,4),EFF(4),LDEST(NDOF*MAXNODES)

      DO 300 NEL=1,NELEMZ
       IF (LLTYP(NEL).NE.1) THEN
      MAT=LMAT(NEL)
      E=PROP(MAT,1)
      GNU=PROP(MAT,2)
      DO 44 I=1,2
      NODE=LTOP(I,NEL)
      LLNODS(I)=NODE
      PRESSS(I)=RLOAD(NODE)
      XX(I)=GX(NODE)
 44   YY(I)=GY(NODE)        
      RKX=RKAS(NEL,1)
      RKY=RKAS(NEL,2)                  
      CALL EL4(XX,YY,THETA,RKX,RKY,ELSS)          !assembles stiffness matrix
      CALL ASS4(A,B,NVABZ,KWIDTH,ELSS,EFF,LLNODS) !and force vector for springs
      ENDIF
 300  CONTINUE

      IF(NUM.LE.0) GOTO 333
C      DO 333 I=1,NUM
      NODE=LNOAD(LOAD_NODE)       ! This section applies point
      J=NVN*(NODE-1)              !   loading
      L=LDR(LOAD_NODE)
      IF(L.EQ.1) THEN
      B(J+1)=B(J+1)+GLOAD(LOAD_NODE)
      JPL1=J+1
      ELSE
      B(J+2)=B(J+2)+GLOAD(LOAD_NODE)
       JPL2=J+2
      ENDIF
 333  CONTINUE
      IF(NDISP.LE.0) GOTO 222
      DO 222 I=1,NDISP
         NODE=NNODE(I)
         J=NVN*(NODE-1)                   !This section applies
      IF(LLDIR(I).EQ.1) THEN              !nodal displacements
         A(J+1,1)=A(J+1,1)+BIG
         B(J+1)  =B(J+1)+A(J+1,1)*DSP(I)
      ELSE
         A(J+2,1)=A(J+2,1)+BIG
         B(J+2)  =B(J+2)+A(J+2,1)*DSP(I)   
      ENDIF
 222  CONTINUE

   
      IF(KSTOP.NE.0) THEN
            WRITE(6,601)
            STOP
            ENDIF
      RETURN
 601  FORMAT(//,' JOB ABORTED IN GSTIFF2 ...   ',/,
     1  ' DUE TO ERRORS DETECTED IN EL16/PRES16  ....  ')

      END

$ 