C
C
C     DEVELOPMENT PERIOD: JULY 1977 - JULY 1978
C
C     NAME: PATRICK J. CASEY, B.E.
C
C     DEPARTMENT: CIVIL ENGINEERING
C
C     PROGRAM IDENTITY: WAVREF FORTRAN
C
C     DESCRIPTION OF PROGRAM:
C                            THIS PROGRAM CALCULATES AND PLOTS THE PATHS
C     TRACED BY WAVE RAYS AS THEY MOVE IN WATER OF VARYING DEPTH. FOR
C     EVERY POINT ON THE RAY THE PROGRAM ESTIMATES THE WATER DEPTH, WAVE
C     SPEED AND THE ASSOCIATED CURVATURE FOR SUCCEEDING POINTS ON THE
C     RAY, EACH POINT BEING LOCATED BY AN ITERATIVE PROCEDURE. IT ALSO
C     CALCULATES THE REFRACTION COEFFICIENT AT ANY PRESCRIBED LOCATION
C     ON THE RAY,THE RELEVANT THEORY FOR ALL CALCULATIONS BEING THE AIRY
C     OR LINEAR WAVE THEORY.
C
C
C***********************************************************************
C
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*1 X
      LOGICAL*1 TERM
      COMMON/R1/DEPTH(5625),SZGRDX,SZGRDY,SZFETX,SZFETY,H
      COMMON/R2/DHDX,DHDY,DDXDHY,D2HDXS,D2HDYS
      COMMON/R3/AA,WAVLO,WAVLEN
      COMMON/R4/XN(100),YN(100),THETA(100),BETA(5625)
      COMMON/R5/FACT,STEP
      COMMON/R6/PI,G,PTIME,VEL,DCDX,DCDY,FF,DHDC,P,Q
      COMMON/R7/ASCALE,ABBA,BAAB,XCORD,ANGLE1
      COMMON/I1/N,MCOLS,NROWS
      COMMON/I2/NPOLY,MSPACE,NSPACE,NANS1,KT
      COMMON/I3/NPLOT,NANS4
      DIMENSION AKK(400),ADEPTH(75,75),BB(5625),XX(1)
      DIMENSION ZZ(100),QQ(100)

      TERM='03'X
        N=1
C
C     ------------------- INPUT OF GENERAL DATA ------------------------
C
C ****ENTER:
C            A) NUMBER OF GRID INTERSECTIONS ON THE DEPTH GRID IN THE X-
C               DIRECTION (INTEGER)
C            B) NUMBER OF GRID INTERSECTIONS ON THE DEPTH GRID IN THE Y-
C               DIRECTION (INTEGER)
C            C) SIZE OF A GRID LINE IN THE X-DIRECTION , MEASURED IN CMS
C               (REAL)
C            D) SIZE OF A GRID LINE IN THE Y-DIRECTION , MEASURED IN CMS
C               (REAL)
C            E) SIZE OF A GRID LINE IN THE X-DIRECTION , MEASURED IN
C               FEET (REAL)
C            F) SIZE OF A GRID LINE IN THE Y-DIRECTION , MEASURED IN
C               FEET (REAL)

C            G) PERIODIC TIME FOR THE WAVES IN SECONDS   !This is taken care
                                                       !of by the controlling  
                                  !command procedure (writing to #12) and is
                                              !not entered in the *.OPT file.

C            H) CONVERSION FACTOR FOR THE DEPTH GRID
C               OPTION:
C                     -IF THE DEPTH VALUES ARE GIVEN IN FEET , ENTER 1.0
C                     -IF GIVEN IN FATHOMS ENTER 6.0
C                     -IF GIVEN IN METRES ENTER 3.28
C            I) ORDER OF THE POLYNOMIAL EMPLOYED IN THE INTERPOLATION OF
C               THE DEPTH VALUES (INTEGER)
C               OPTION:
C                     -EITHER A FIRST OR SECOND ORDER POLYNOMIAL
C                      MAY BE USED , ENTER 1 OR 2 (INTEGER)
C            J) OPTION:
C                       1 IF NO PLOT OF THE COMPUTED RAYS IS REQUIRED
C                       2 IF A PLOT IS REQUIRED
C            K) OPTION:
C                       1 IF THE DEPTH GRID IS TO BE VARIED TO ALLOW FOR
C                       TIDAL CHANGES
C                       2 IF NO ALTERATIONS ARE TO BE MADE
C            L) OPTION:
C                       1 IF THE CALCULATION OF REFRACTION COEFFICIENTS
C                       IS REQUIRED
C                       2 IF REFRACTION COEFFICIENTS ARE NOT REQUIRED
C
C
      READ(12,*) PTIME

500   READ(55,*)MCOLS,NROWS,SZGRDX,SZGRDY,SZFETX,SZFETY,CONV1,
     1NPOLY,NPLOT,NANS,MCOEF
C
C     ------------------------------------------------------------------
C
C     ******************************************************************
C          READ GRID OF DEPTH VALUES FROM DISK DEFINED BY FILEDEF 8
C     ******************************************************************
      READ(8,*)((ADEPTH(I,J),I=1,MCOLS),J=1,NROWS)
!      WRITE(6,925)((ADEPTH(I,J),I=1,MCOLS),J=1,NROWS)
!  925 FORMAT(1H ,1X,12F3.0,//)
      DO 1 I=1,MCOLS
      DO 1 J=1,NROWS
      MM=((I-1)*NROWS)+J
1     BB(MM)=ADEPTH(I,J)
      IF(NPLOT.EQ.2)GO TO 2
      FACT=1.0
      GO TO 3
2     CONTINUE
C
C     ------------------ INPUT OF DATA FOR PLOTTER ---------------------
C
C ****ENTER:
C            A) OPTION:
C                      1 IF AN OVERLYING PLOT OF THE DEPTH GRID IS
C                      REQUIRED
C                      2 IF A STRAIGHT-LINE BORDER FOR THE PLOT IS
C                      REQUIRED
C            B) SCALING FACTOR FOR THE PLOT (REAL)
C
C
501   READ(55,*)NANS1,KFACT
C    
      FACT=KFACT/100.0
      JDIVISOR=100
      WRITE(7,872) KFACT,KFACT,JDIVISOR
872   FORMAT(1H ,'&',I4,',',I4,',',I4)
C     ------------------------------------------------------------------
C
3     LENGTH=MCOLS*NROWS
      DO 4 MM=1,LENGTH
4     DEPTH(MM)=BB(MM)*CONV1
      IF(MCOEF.EQ.2)GO TO 5
C
C
C ****ENTER:
C           A) OPTION:
C                     1 FOR CALCULATION OF REFRACTION COEFFICIENTS USING
C                     THE SNELL'S LAW APPROXIMATION,
C                     2 FOR CALCULATION OF REFRACTION COEFFICIENTS USING
C                     THE 'MUNK AND ARTHUR' METHOD.
C           B) OPTION:
C                     1 IF THE CALCULATED REFRACTION COEFFICIENTS ARE TO
C                     BE OUTPUTTED AT PRE-SELECTED STEPS(RATIO),
C                     2 IF THE CALCULATED REFRACTION COEFFICIENTS ARE TO
C                     BE OUTPUTTED AT EACH STEP ALONG THE RAY(DSFEET).
C
C
502   READ(55,*)NANS3,NANS4
5     IF(NANS.EQ.2)GO TO 7
C
C
C ****ENTER:
C            A) TIDAL CORRECTION FACTOR IN FEET  !This is taken care of by the
                                !controlling command procedure (writing to #13)
                                         !and is not entered in the *.OPT file.
C
C
503   READ(13,*)TIDLVU

      DO 6 MM=1,LENGTH
6     DEPTH(MM)=DEPTH(MM)+TIDLVU
7     MSPACE=MCOLS-1
      NSPACE=NROWS-1
      ABBA=MSPACE*SZGRDX
      BAAB=NSPACE*SZGRDY
      PI=3.141592653589793
      G=32.2
      RADIAN=57.29577951308232
      KLM=0
      NNN=0
      DD=2.*PI
      ASCALE=SZFETX/(SZGRDX*FACT)
      WAVLO=G*(PTIME**2)/DD
      SHOAL=WAVLO/2.0
      XCORD=(ABBA*FACT)+1.0
      RATIO=SZFETX/FACT
      DSFET1=0.25*RATIO
C
C
C ****ENTER:
C            A) 1 FOR INCREMENTED RAYS IN THE X-DIRECTION
C            B) 2 FOR INCREMENTED RAYS IN THE Y-DIRECTION
C            C) 3 FOR INCREMENTED RAYS ALONG THE WAVEFRONT IN DEEP WATER
C            D) 4 IF A CALCULATION FOR SINGLE RAYS IS REQUIRED
C            E) 5 IF THE EXECUTION IS TO BE TERMINATED
C
C
504   READ(55,*)KT
      IF(KT.GE.4)GO TO 11
C
C
C ****ENTER:
C            A) THE INITIAL ANGLE IN DEEP WATER , MEASURED IN DEGREES IN
C               AN ANTI-CLOCKWISE DIRECTION FROM THE X-AXIS
C            B) OUTER BOUND ON THE INCREMENTED RAYS IN THE X-DIRECTION ,
C               MEASURED IN GRID UNITS
C            C) UPPER BOUND ON THE INCREMENTED RAYS IN THE Y-DIRECTION ,
C               MEASURED IN GRID UNITS
C
C
505   READ(55,*)ANGLE1,XCO,YCO
600   WRITE(6,700)PTIME,WAVLO
      XEND=XCO*SZGRDX
      YEND=YCO*SZGRDY
      IF(KT.EQ.3)GO TO 8
C
C
C ****ENTER:
C           A) STEPPING INCREMENT FOR RAYS IN THE X-DIRECTION ,
C              MEASURED IN CMS.
C           B) STEPPING INCREMENT FOR RAYS IN THE Y-DIRECTION ,
C              MEASURED IN CMS.
C
C
506   READ(55,*)XSTEP,YSTEP
8     IF(KT.NE.3)GO TO 9
C
C
C ****ENTER:
C           A) INCREMENTED DISTANCE BETWEEN RAYS , ALONG THE WAVEFRONT ,
C              MEASURED IN CMS.
C
C
507   READ(55,*)SINC
      THETTA=ANGLE1/RADIAN
      AX=SINC/DSIN(THETTA)
      BY=SINC/DCOS(THETTA)
9     CONTINUE
C
C
C ****ENTER:
C           A) 1 IF THE INITIAL COORDINATES ARE TO BE SPECIFIED
C           B) 2 IF THE INITIAL COORDINATES ARE (0,0)
C
C
508   READ(55,*)LD
      N=1
      IF(LD.EQ.1)GO TO 11
      XN(N)=0.0
      XX(1)=XN(N)
10    YN(N)=0.0
      GO TO 14
C
C     ---------------- PLOT CALCULATIONS FOR SINGLE RAYS ---------------
C
C     ******************************************************************
C         READ IN DATA FOR SINGLE RAYS FROM DISK DEFINED BY FILEDEF 7
C     ******************************************************************
11    IF(KT.NE.4)GO TO 13
      NR=0
C
C
C ****ENTER:
C           A) THE NUMBER OF SINGLE RAYS FOR WHICH A CALCULATION IS
C              REQUIRED (INTEGER)
C
C
509   READ(77,*)NRAYS
12    NR=NR+1
      N=1
      IF(NR.GT.NRAYS) GO TO 44
C
C
C ****ENTER:
C           A) THE INITIAL CO-ORDINATES OF THE RAY , MEASURED IN CMS.
C              AND THE INITIAL ANGLE IN DEEP WATER , MEASURED IN
C              DEGREES IN AN ANTI-CLOCKWISE DIRECTION FROM THE POSITIVE
C              X-DIRECTION (REAL)
C
C
510   READ(77,*)XN(1),YN(1),ANGLE3
C
C     ------------------------------------------------------------------
C
      ANGLE1=ANGLE3
      GO TO 14
13    IF(KT.EQ.5)GO TO 44
C
C
C ****ENTER:
C           A) THE INITIAL CO-ORDINATES OF THE RAY , MEASURED IN CMS.
C
C
511   READ(55,*)XN(1),YN(1)
      XX(1)=XN(1)
14    NNN=NNN+1
      IF(NNN.GE.2.OR.NPLOT.EQ.1)GO TO 15
      WRITE (7,747)
747   FORMAT(1H ,'^150,450')
      CALL FACTOR(FACT)
!      CALL TITLE
15    THETA(1)=ANGLE1/RADIAN
      STEP=0.0
      ANGLE2=THETA(1)+PI
      IF(KT.EQ.4)GO TO 16
      IF(XN(1).GT.XEND.OR.YN(1).GT.YEND)GO TO 504
16    IF(NPOLY.GE.2)GO TO 17
      CALL DEPTH1
      GO TO 18
17    CALL DEPTH2
18    IF(KT.EQ.4)GO TO 601
      IF(H.LT.SHOAL)GO TO 39
601   CONTINUE
      WRITE(66,701)XN(1),YN(1)
      IF(NPLOT.EQ.1)GO TO 19
      ZZ(1)=XN(1)*100.0
      QQ(1)=YN(1)*100.0
      WRITE (7,748) ZZ(1),QQ(1)
748   FORMAT(1H ,'M',F8.1,','F8.1)
19    N=2
      M=2
      MM=2
      XN(N)=XN(1)
      YN(N)=YN(1)
      THETA(N)=THETA(1)
      IF(NANS3.EQ.1.OR.MCOEF.EQ.2)GO TO 20
      BETA(1)=1.0
      BETA(2)=BETA(1)
      AKR=1.0
C     WRITE(66,702)AKR
20    IF(NPOLY.GE.2)GO TO 21
C
C     ------------------------ START OF MAIN DO LOOP -------------------
C
      CALL DEPTH1
      GO TO 22
21    CALL DEPTH2
22    IF(H.LE.0.0)GO TO 605
      AA=DD*H
      CALL AWAVEL
      SHALOW=WAVLEN/2.0
      IF(WAVLEN.LT.DSFET1)GO TO 23
      DSFEET=WAVLEN
      GO TO 25
23    IF(H.LT.SHALOW)GO TO 24
      DSFEET=DSFET1
      GO TO 25
24    DSFEET=0.025*RATIO
25    DS=(DSFEET/SZFETX)*SZGRDX
      VEL=WAVLEN/PTIME
      FF=1.0-(((2.0*PI*VEL)/(G*PTIME))**2)
      DHDC=(VEL/(G*FF))+(H/VEL)
      DCDX=DHDX/DHDC
      DCDY=DHDY/DHDC
      IF(M.GT.2.OR.NANS3.EQ.1.OR.MCOEF.EQ.2)GO TO 26
      CALL REEFER
26    DCDN=(-DCDX*(DSIN(THETA(N))))+(DCDY*(DCOS(THETA(N))))
      AKK(N)=(-1./VEL)*DCDN
      DTHET1=AKK(N)*DSFEET
      AVTHE1=THETA(N)+(DTHET1/2.0)
      DELX=DS*DCOS(AVTHE1)
      DELY=DS*DSIN(AVTHE1)
      XN(N+1)=XN(N)+DELX
      IF(XN(N+1).LT.0.0)GO TO 606
      YN(N+1)=YN(N)+DELY
      IF(YN(N+1).LT.0.0)GO TO 607
      THETA(N+1)=AVTHE1
      IF(THETA(N+1).GE.ANGLE2)GO TO 604
      IF(N-3)27, 29, 28
  27      N=N+1
      M=M+1
      IF(N.GE.25)GO TO 603
      GO TO 20
28    IF(DABS(AKK(N)-AKK(N-1))-0.001)30,30,29
29    AVAKK=(AKK(N)+AKK(2))/2.0
      DTHET2=AVAKK*DSFEET
      ANTHE2=THETA(2)+DTHET2
      DELX2=DS*DCOS(ANTHE2)
      DELY2=DS*DSIN(ANTHE2)
      XN(N+1)=XN(2)+DELX2
      YN(N+1)=YN(2)+DELY2
      THETA(N+1)=ANTHE2
      GO TO 27
30    XN(2)=XN(N+1)
      YN(2)=YN(N+1)
      THETA(2)=THETA(2)+DTHET1
      MM=MM+1
31    IF(MCOEF.EQ.2)GO TO 35
      IF(NANS3.EQ.1)GO TO 33
      BTA=BETA(MM-1)*(4.-(2.*DSFEET*DSFEET*Q))/((P*DSFEET)+2.)
      BETA(MM)=BETA(MM-2)*((P*DSFEET)-2.)/((P*DSFEET)+2.)+BTA
      AKR=DSQRT(1.0/DABS(BETA(MM)))
      IF(NANS4.EQ.2)GO TO 32
      STEP=STEP+DSFEET
      IF(STEP.LE.RATIO)GO TO 35
      STEP=0.0
32    CONTINUE
      WRITE(66,702)AKR
      IF(NPLOT.EQ.1.OR.NANS4.EQ.2)GO TO 33
      Y11=YN(2)-(0.2*FACT)
C
      QQ11=Y11*100.0
      ZZ(2)=XN(2)*100.0
      WRITE(7,749) ZZ(2),QQ11
749   FORMAT(1H ,'M',F8.1,',',F8.1)
!      CALL NUMBER(XN(2), Y11, 0.4, AKR, 0.0, 3)
      QQ(2)=YN(2)*100.0
      WRITE(7,750) ZZ(2),QQ(2)
750   FORMAT(1H ,'M',F8.1,',',F8.1)
      GO TO 35
33    IF(NANS3.EQ.2)GO TO 35
      IF(NANS4.EQ.1)GO TO 34
      CALL RCOEFF
      GO TO 35
34    STEP=STEP+DSFEET
      IF(STEP.GE.RATIO)CALL RCOEFF
35    IF(XN(2).GT.ABBA)GO TO 608
      IF(XN(2).LT.0.0)GO TO 606
      IF(YN(2).GT.BAAB)GO TO 602
      IF(YN(2).LT.0.0)GO TO 607
      IF(THETA(2).GE.ANGLE2)GO TO 604
      IF(NPLOT.EQ.1)GO TO 36
      ZZ(2)=XN(2)*100.0
      QQ(2)=YN(2)*100.0
      WRITE(7,751) ZZ(2),QQ(2),TERM
751   FORMAT(1H ,'D',F8.1,',',F8.1,2A1)
36    N=2
      M=2
      GO TO 20
C
C     ------------------------ END OF MAIN DO LOOP ---------------------
C
602   WRITE(66,703)
      GO TO 37
603   WRITE(66,704)
      GO TO 37
604   WRITE(66,705)
      GO TO 37
605   WRITE(66,706)
      GO TO 37
606   WRITE(66,707)
      GO TO 37
607   WRITE(66,708)
      GO TO 37
608   WRITE(66,709)
37    IF(NPLOT.EQ.1.OR.NANS4.EQ.3)GO TO 38
      WRITE(66,702)AKR
      X22=XN(2)+(0.2*FACT)
      Y22=YN(2)+(0.2*FACT)
      ZZ(2)=XN(2)*100.0
      QQ(2)=YN(2)*100.0
      WRITE(7,752) ZZ(2),QQ(2)
752   FORMAT(1H ,'M',F8.1,',',F8.1)
!      CALL NUMBER(X22, Y22, 0.4, AKR, 0.0, 3)
      WRITE(7,752) ZZ(2),QQ(2)
38    ANGLEE=THETA(2)*RADIAN
      WRITE(66,710)XN(2),YN(2),ANGLEE
39    IF(KT-3)40,42,12
40    IF(KT.EQ.1)GO TO 41
      YN(1)=YN(1)+YSTEP
      IF(YN(1).GT.BAAB)GO TO 504
      N=1
      GO TO 14
41    XN(1)=XN(1)+XSTEP
      IF(XN(1).GT.ABBA)GO TO 504
      IF(LD.EQ.1)GO TO 14
      N=1
      GO TO 10
42    IF(KLM.EQ.1)GO TO 43
      XN(1)=XN(1)+AX
      IF(XN(1).GT.ABBA)GO TO 43
      N=1
      GO TO 10
43    YN(1)=YN(1)+BY
      IF(YN(1).GT.BAAB)GO TO 504
      XN(1)=XX(1)
      KLM=1
      N=1
      GO TO 14
44    IF(NPLOT.EQ.1)GO TO 609
      WRITE(7,753)
753   FORMAT(1H ,'M3000.0,0.0')
609   WRITE(66,711)
700   FORMAT(/7X,'PERIODIC TIME =',F6.2,12X,'DEEP WATER WAVELENGTH =',F
     110.3,/)
701   FORMAT(/9X,'********* INITIAL CO-ORDINATES OF RAY IN DEEP WATER :
     1-',/20X,'X(1)=',F7.3,' CMS.',6X,'Y(1)=',F7.3,' CMS.',/)
702   FORMAT(1X,'REFRACTION COEFFICIENT =',F12.5)
703   FORMAT(//1X,'RAY HAS GONE OFF THE TOP OF THE PLOT')
704   FORMAT(//1X,'AS THE ITERATION PROCESS IS NOT CONVERGING A NEW RAY
     1IS BEING STARTED')
705   FORMAT(//1X,'THE RAY HAS BEEN TURNED OVER ')
706   FORMAT(//1X,'THE RAY HAS NOW REACHED THE SHORELINE')
707   FORMAT(//1X,'RAY HAS GONE OFF THE LEFT SIDE OF PLOT')
708   FORMAT(//1X,'RAY HAS GONE OFF THE BOTTOM OF THE PLOT')
709   FORMAT(//1X,'RAY HAS GONE OFF THE RIGHT SIDE OF PLOT')
710   FORMAT(//1X,'FINAL CO-ORDINATES OF RAY ARE :-',/20X,'X(2)=',F7.3,'
     1 CMS.',10X,'Y(2)=',F7.3,' CMS.',/1X,'AND THE FINAL EXIT ANGLE=',F
     212.5,' DEGREES',//)
711   FORMAT(/////30X,'THE REFRACTION ANALYSIS IS NOW COMPLETED')
      CALL EXIT
C     DEBUG SUBCHK
      END
 
 
C     ------------------------------------------------------------------
C           SUBROUTINE DEPTH1 , CALCULATION OF INTERPOLATED DEPTH
C                      USING A FIRST ORDER POLYNOMIAL.
C     ------------------------------------------------------------------
      SUBROUTINE DEPTH1
      IMPLICIT REAL*8(A-H,O-Z)
      COMMON/R1/DEPTH(5625),SZGRDX,SZGRDY,SZFETX,SZFETY,H
      COMMON/R2/DHDX,DHDY,DDXDHY,D2HDXS,D2HDYS
      COMMON/R4/XN(100),YN(100),THETA(100),BETA(5625)
      COMMON/I1/N,MCOLS,NROWS
      DIMENSION NOA(100),NOL(100)
      I=1.+(XN(N)/SZGRDX)
      J=1.+(YN(N)/SZGRDY)
      M=((I-1)*NROWS)+J
      M1=((I-1)*NROWS)+(J+1)
      M2=(I*NROWS)+J
      M3=(I*NROWS)+(J+1)
      NOA(N)=I
      NOL(N)=J
      IF(N.EQ.1)GO TO 10
      IN=(NOA(N)-NOA(N-1))
      JN=(NOL(N)-NOL(N-1))
      IF(IN.EQ.0.AND.JN.EQ.0)GO TO 20
 10    A=DEPTH(M)
      B=(DEPTH(M2)-DEPTH(M))/SZFETX
      C=(DEPTH(M1)-DEPTH(M))/SZFETY
      D=(DEPTH(M3)+DEPTH(M)-DEPTH(M2)-DEPTH(M1))/(SZFETX*SZFETY)
20    XCOORD=SZFETX*(XN(N)/SZGRDX)
      YCOORD=SZFETY*(YN(N)/SZGRDY)
      I=I-1
      J=J-1
      DELTAX=XCOORD-(I*SZFETX)
      DELTAY=YCOORD-(J*SZFETY)
      H=A+(B*DELTAX)+(C*DELTAY)+(D*DELTAX*DELTAY)
C     tim1=h/3.28
C      tim2=xcoord/3.28
C      tim3=ycoord/3.28
C      WRITE(69,9)tim1,tim2,tim3
C   9  FORMAT(1H ,3X,'DEPTH=  ',E14.7,3x,e14.7,3x,e14.7)
      IF(IN.EQ.0.AND.JN.EQ.0)GO TO 30
      DHDX=B+(D*DELTAY)
      DHDY=C+(D*DELTAX)
      DDXDHY=D
      D2HDXS=0.
      D2HDYS=0.
30    RETURN
!      DEBUG SUBCHK
      END
 
C           :READ  DEPTH2   FORTRAN  A1 VM/370  3/15/79  21:04
C     ------------------------------------------------------------------
C           SUBROUTINE DEPTH2 , CALCULATION OF INTERPOLATED DEPTH
C                      USING A SECOND ORDER POLYNOMIAL.
C     ------------------------------------------------------------------
      SUBROUTINE DEPTH2
      IMPLICIT REAL*8(A-H,O-Z)
      COMMON/R1/DEPTH(5625),SZGRDX,SZGRDY,SZFETX,SZFETY,H
      COMMON/R2/DHDX,DHDY,DDXDHY,D2HDXS,D2HDYS
      COMMON/R4/XN(100),YN(100),THETA(100),BETA(5625)
      COMMON/I1/N,MCOLS,NROWS
      DIMENSION NOA(100),NOL(100)
      I=1.+(XN(N)/SZGRDX)
      J=2.+(YN(N)/SZGRDY)
      JJ=J-1
      I2=I+2
      J2=J+2
      IF(I2.GT.MCOLS.OR.J2.GT.NROWS)GO TO 30
      M=((I-1)*NROWS)+J
      M1=((I-1)*NROWS)+(J+1)
      M2=(I*NROWS)+J
      M3=(I*NROWS)+(J+1)
      M4=((I+1)*NROWS)+J
      M5=((I+1)*NROWS)+(J+1)
      M6=((I-1)*NROWS)+(J+2)
      M7=(I*NROWS)+(J+2)
      M8=((I-1)*NROWS)+(J-1)
      M9=(I*NROWS)+(J-1)
      NOA(N)=I
      NOL(N)=J
      IF(N.EQ.1)GO TO 10
      IN=(NOA(N)-NOA(N-1))
      JN=(NOL(N)-NOL(N-1))
      IF(IN.EQ.0.AND.JN.EQ.O)GO TO 20
10    A=DEPTH(M)
      B1=(DEPTH(M)-DEPTH(M4)-(2.*DEPTH(M8))-(2.*DEPTH(M1))+(2.*DEPTH(
     1M3))+(2.*DEPTH(M9)))/(2.*SZFETX)
      C1=(DEPTH(M1)-DEPTH(M8))/(2.*SZFETY)
      D1=(DEPTH(M3)-DEPTH(M9)+DEPTH(M8)-DEPTH(M1))/(2.*SZFETX*SZFETY)
      E1=(DEPTH(M4)-DEPTH(M9)-DEPTH(M3)+DEPTH(M1)+DEPTH(M8)-DEPTH(M))/
     1(2.*(SZFETX**2))
      F1=(DEPTH(M8)+DEPTH(M1)-(2.*DEPTH(M)))/(2.*(SZFETY**2))
      B2=(3.*DEPTH(M2)-(3.*DEPTH(M))-DEPTH(M5)+DEPTH(M1)-DEPTH(M6)+
     1DEPTH(M7))/(2.*SZFETX)
      C2=((4.*DEPTH(M1))-(3.*DEPTH(M))-DEPTH(M6))/(2.*SZFETY)
      D2=(DEPTH(M7)-DEPTH(M2)+DEPTH(M)-DEPTH(M6))/(2.*SZFETX*SZFETY)
      E2=(DEPTH(M5)-DEPTH(M2)+DEPTH(M)-DEPTH(M1)+DEPTH(M6)-DEPTH(M7))/
     1(2.*(SZFETX**2))
      F2=(DEPTH(M6)-(2.*DEPTH(M1))+DEPTH(M))/(2.*(SZFETY**2))
      B=(B1+B2)/2.0
      C=(C1+C2)/2.0
      D=(D1+D2)/2.0
      E=(E1+E2)/2.0
      F=(F1+F2)/2.0
20    XCOORD=SZFETX*(XN(N)/SZGRDX)
      YCOORD=SZFETY*(YN(N)/SZGRDY)
      I=I-1
      J=J-1
      DELTAX=XCOORD-(I*SZFETX)
      DELTAY=YCOORD-(J*SZFETY)
      H=A+(B*DELTAX)+(C*DELTAY)+(D*DELTAX*DELTAY)+(E*(DELTAX**2))+
     1(F*(DELTAY**2))
      IF(IN.EQ.0.AND.JN.EQ.0)GO TO 40
      DHDX=B+D*DELTAY+2.*E*DELTAX
      DHDY=C+D*DELTAX+2.*F*DELTAY
      DDXDHY=D
      D2HDXS=2.*E
      D2HDYS=2.*F
      GO TO 40
30    CALL DEPTH1
40    RETURN
!      DEBUG SUBCHK
      END
 
C      :READ  RCOEFF   FORTRAN  A1 VM/370  3/15/79  21:04
C     ------------------------------------------------------------------
C             SUBROUTINE RCOEFF , CALCULATION OF REFRACTION COEFFICIENTS
C             USING THE 'SNELL'S LAW APPROXIMATION'.
C     ------------------------------------------------------------------
      SUBROUTINE RCOEFF
      IMPLICIT REAL*8(A-H,O-Z)
      COMMON/R4/XN(100),YN(100),THETA(100),BETA(5625)
      COMMON/R5/FACT,STEP
      COMMON/I3/NPLOT,NANS4
      DIMENSION ZZ(100),QQ(100)
      ANG0=THETA(1)
      ANG1=THETA(2)
      BOB=DCOS(90.-ANG0)/DCOS(90.-ANG1)
      AKR=DSQRT(DABS(BOB))
      WRITE(66,10)AKR
10    FORMAT(/,10X,'REFRACTION COEFFICIENT =',F10.6)
      IF(NPLOT.EQ.1.OR.NANS4.EQ.2)GO TO 20
      Y11=YN(2)-(0.2*FACT)
      WRITE(66,*)XN(2),Y11,3
      ZZ(2)=XN(2)*100.0
      QQ11=Y11*100.0
      WRITE(7,755) ZZ(2),QQ11
755   FORMAT(1H ,'M',F8.1,',',F8.1)
!      CALL NUMBER(XN(2), Y11, 0.2, AKR, 0.0, 4)
      QQ(2)=YN(2)*100.0
      WRITE(7,756) ZZ(2),QQ(2)
756   FORMAT(1H ,'M',F8.1,',',F8.1)
20    STEP=0.0
      RETURN
!      DEBUG SUBCHK
      END
 
C     :READ  REEFER   FORTRAN  A1 VM/370  3/15/79  21:04
C     __________________________________________________________________
C             SUBROUTINE REEFER , CALCULATION OF REFRACTION COEFFICIENTS
C             USING THE 'MUNK & ARTHUR METHOD' FOR WAVE INTENSITY ALONG
C             THE REFRACTED RAY .
C     ------------------------------------------------------------------
      SUBROUTINE REEFER
      IMPLICIT REAL*8(A-H,O-Z)
      COMMON/R1/DEPTH(5625),SZGRDX,SZGRDY,SZFETX,SZFETY,H
      COMMON/R2/DHDX,DHDY,DDXDHY,D2HDXS,D2HDYS
      COMMON/R4/XN(100),YN(100),THETA(100),BETA(5625)
      COMMON/R6/PI,G,PTIME,VEL,DCDX,DCDY,FF,DHDC,P,Q
      EE=((2.0*PI/(G*PTIME))**2)*(2.0*VEL)
      D1=(((H/DHDC)-VEL)/(VEL**2))-(1.0/(G*DHDC*FF))
      D2=(-VEL/G)*(EE/DHDC)/(FF**2)
      D2CDHS=(D1+D2)/(DHDC**2)
      D2CDXS=(D2HDXS/DHDC)+((DHDX**2)*D2CDHS)
      D2CDYS=(D2HDYS/DHDC)+((DHDY**2)*D2CDHS)
      D2CDXY=(DDXDHY/DHDC)+(DHDX*DHDY*D2CDHS)
      P=(-DCOS(THETA(2))*DCDX/VEL)-(DSIN(THETA(2))*DCDY/VEL)
      Q1=((DSIN(THETA(2))**2)*D2CDXS/VEL)
      Q2=2.0*DSIN(THETA(2))*DCOS(THETA(2))*D2CDXY/VEL
      Q3=((DCOS(THETA(2))**2)*D2CDYS/VEL)
      Q=Q1-Q2+Q3
      RETURN
!      DEBUG SUBCHK
      END
C
C
C----------------------------------------------------------------------
C	SUBROUTINE TITLE , DATA FOR PLOT LABEL:
C		PERIODIC TIME SCALE ETC....
C----------------------------------------------------------------------
      SUBROUTINE TITLE
      IMPLICIT REAL*8(A-H,O-Z)
      COMMON/R1/DEPTH(5625),SZGRDX,SZGRDY,SZFETX,SZFETY,H
      COMMON/R5/FACT,STEP
      COMMON/R6/PI,G,PTIME,VEL,DCDX,DCDY,FF,DHDC,P,Q
      COMMON/R7/ASCALE,ABBA,BAAB,XCORD,ANGLE1
      COMMON/I2/NPOLY,MSPACE,NSPACE,NANS1,KT
      COMMON/I3/NPLOT,NANS4
      CALL SYMBOL(XCORD, 13.0, 0.4, 33HDEPARTMENT OF CIVIL ENGINEERING  
     1               , 0.0, 33)
      CALL SYMBOL(XCORD, 11.5, 0.4, 25HUNIVERSITY COLLEGE CORK 
     +   ,0.0,25)
      CALL SYMBOL(XCORD, 7.0, 0.3, 14HPERIODIC TIME   , 0.0, 14)
      CALL NUMBER(999., 999., 0.2, PTIME, 0., 2)
      CALL SYMBOL(999., 999., 0.2, 8H SECONDS  ,0., 8)
      CALL SYMBOL(XCORD, 5.5, 0.3, 6HSCALE:  , 0., 6)
      CALL SYMBOL(999., 999., 0.2, 10H1.0 CMS. : , 0., 10)
      CALL NUMBER(999., 999., 0.2, ASCALE, 0., 1)
      CALL SYMBOL(999., 999., 0.2, 5H FEET , 0., 5)
      CALL SYMBOL(XCORD, 8.5, 0.3, 16HSCALING FACTOR : , 0., 16)
      CALL NUMBER(999., 999., 0.2, FACT, 0., 3)
      CALL SYMBOL(XCORD, 10.0, 0.3, 21HORDER OF POLYNOMIAL   , 0., 21)
      ANPOLY=NPOLY
      CALL NUMBER(999., 999., 0.2, ANPOLY, 0., 0)
      CALL FACTOR(FACT)
      IF(NANS1.EQ.2)GO TO 10
!      CALL DASHG(0.0, 0.0, SZGRDX, SZGRDY, MSPACE, NSPACE, 0.25, 0.25)
      GO TO 20
!  10  CALL RECT(0.0, 0.0, BAAB, ABBA, 0.0, 3)
      IF(KT.GT.3) GO TO 20
   10   CONTINUE
      CALL SYMBOL(XCORD, 4.0, 0.3, 28HINITIAL ANGLE IN DEEP WATER 
     +  ,0.0, 28)
      CALL NUMBER(999., 999., 0.2, ANGLE1, 0., 2)
      CALL SYMBOL(999., 999., 0.2, 8H DEGREES , 0., 8)
   20 RETURN
C      DEBUG SUBCHK
      END
C
C-----------------------------------------------------------------------
C   	SUBROUTINE AWAVEL , CALCULATION OF WAVELENGTH FOR
C	THE INTERPOLATED DEPTH 'H' , USING NEWTON'S
C	ITERATIVE PROCEEDURE.
C	----------------------------------------------------------------
      SUBROUTINE AWAVEL
      IMPLICIT REAL*8(A-H,O-Z)
      COMMON/R3/AA,WAVLO,WAVLEN
      ANITL=350.0
      TOLER=0.0025
  2   B1=AA/ANITL
      AF=ANITL-(WAVLO*DTANH(B1))
      FDASH=1.0-(WAVLO*((-AA/(ANITL*ANITL))*(1.0+(DTANH(B1))**2)))
      WAVLEN=ANITL-(AF/FDASH)
      IF(DABS(WAVLEN-ANITL)-TOLER)4,4,3
  3   ANITL=WAVLEN
      GO TO 2
  4   RETURN
C      DEBUG SUBCHK
      END

$ 