      SUBROUTINE LOAD_FACTOR(LOAD_FACT,I_STORE,SET_INITIAL
     * ,STIFF_INITIAL,STIFF)
C                                         ANTHONY CARROLL MAR. 1986
C----------------------------------------------------------------------
C THIS ROUTINE (A)   CALCULATES THE MINIMUM OF THREE LOAD FACTORS
C                    AND LOCATES NEXT STUD TO LOAD
C              (B)   CALCULATES NEW STIFFNESS OF NEXT STUD TO LOAD
C----------------------------------------------------------------------
C INTERVAL 1:  SET_NEG(I) < SLIP(I) < SET_POS(I)
C INTERVAL 2:  SET_POS(I) < SLIP(I) < SLIP_POS(I)
C INTERVAL 3: SLIP_NEG(I) < SLIP(I) < SET_NEG(I)
C
C A STUD MUST BE IN ONE OF THE ABOVE INTERVALS
C   ..STEP(1) FIND INTERVAL THAT SLIP LIES IN BEFORE SLIP_INC IS APPLIED
C A STUD CAN HAVE +ve OR -ve INCREMENTAL SLIP
C   ..STEP(2) SLIP_INC +ve OR -ve?
C AFTER STEP(1) & STEP(2) LOAD FACTOR "LF" IS DEFINED FOR THE STUD 
C AS IS THE STUDS NEXT STIFFNESS.
C   ..STEP(3) CALCULATE "LF" FOR EACH STUD AND FIND MINIMUM OVERALL "LF"
C SET LOAD_FACT EQUAL TO THE MINIMUM LF AND THATS IT
C
C------------------------------------------------------------------------
C TYPE FILE "NOTATION.DAT" TO GET NOTATION FOR SLIP_POS,SET_POS etc.
C------------------------------------------------------------------------
      IMPLICIT REAL*8(A-H,O-Z)
      CHARACTER*50 SCRIPT,SCRIPT1
      INCLUDE 'STRESS2D.CCM'
      REAL*8 LOAD_FACT,LF,KA,REAL,SET_INITIAL
      
      LOAD_FACT = 1.0    !IF NO STUD LOADS FULL REMAINING LOAD IS APPLIED
                         !AND INCREMENTAL PROCEDURE STOPS
      I_STORE =0         !SAME IDEA AS ABOVE
      STIFF = 0.0
      SCRIPT = 'NO NEW LOAD FACTOR CALCULATED'

      DO 10 I=1,NSG
         LF = 2.0   !INITIALLY LF MUST BE .GT. LOAD_FACT

C  STUDS @ SET_POS/SET_NEG/SLIP_POS/SLIP_NEG CANNOT FORM LOAD_FACT
         IF ((SLIP(I).LT.(SET_POS(I)+1e-16))  .AND.
     *       (SLIP(I).GT.(SET_POS(I)-1E-16)))  GOTO 10
         IF ((SLIP(I).LT.(SET_NEG(I)+1E-16))  .AND.
     *       (SLIP(I).GT.(SET_NEG(I)-1E-16)))   GOTO 10
         IF ((SLIP(I).LT.(SLIP_POS(I)+1E-16)) .AND.
     *       (SLIP(I).GT.(SLIP_POS(I)-1E-16)))  GOTO 10
         IF ((SLIP(I).LT.(SLIP_NEG(I)+1E-16)) .AND.
     *       (SLIP(I).GT.(SLIP_NEG(I)-1E-16)))  GOTO 10

C     STUDS WITH SLIP(I) BETWEEN SET_POS(I) AND SET_NEG(I)
      IF ((SLIP(I).GT.SET_NEG(I)) .AND. (SLIP(I).LT.SET_POS(I))) THEN
          IF (SLIP_INC(I).GT.0.0) THEN
              LF = (SET_POS(I)-SLIP(I))/SLIP_INC(I)
              IF (SET_POS(I).GT.SET_INITIAL) STIFF_NEW = SSS(I)*KA
              IF (SET_POS(I).EQ.SET_INITIAL) STIFF_NEW = SSS(I)
             SCRIPT1='SET_NEG(I)<SLIP(I)<SET_POS(I) & SLIP(INC(I)>0.0'
              GOTO 20
          END IF
          IF (SLIP_INC(I).LT.0.0) THEN
              LF = ABS((SET_NEG(I)-SLIP(I))/SLIP_INC(I))
              IF (SET_NEG(I).LT.(-SET_INITIAL)) STIFF_NEW = SSS(I)*KA
              IF (SET_NEG(I).EQ.(-SET_INITIAL)) STIFF_NEW = SSS(I)
             SCRIPT1='SET_NEG(I)<SLIP(I)<SET_POS(I) & SLIP(INC(I)<0.0'
              GOTO 20
          END IF
      END IF

C     FOR STUDS WITH SLIP BETWEEN SET_POS(I) AND SLIP_POS(I)
      IF ((SLIP(I).GT.SET_POS(I)) .AND. (SLIP(I).LT.SLIP_POS(I))) THEN
          IF (SLIP_INC(I).GT.0.0) THEN
              LF = (SLIP_POS(I)-SLIP(I))/SLIP_INC(I)
              STIFF_NEW = SSS(I)
             SCRIPT1='SET_POS(I)<SLIP(I)<SLIP_POS(I) & SLIP(INC(I)>0.0'
              GOTO 20
          END IF
          IF (SLIP_INC(I).LT.0.0) THEN
              LF = ABS((SLIP(I)-SET_POS(I))/SLIP_INC(I))
              STIFF_NEW = STIFF_INITIAL
             SCRIPT1='SET_POS(I)<SLIP(I)<SLIP_POS(I) & SLIP(INC(I)<0.0'
              GOTO 20
          END IF
      END IF

C     FOR STUDS WITH SLIP BETWEEN SET_NEG(I) AND SLIP_NEG(I)
      IF ((SLIP(I).GT.SLIP_NEG(I)) .AND. (SLIP(I).LT.SET_NEG(I))) THEN
          IF (SLIP_INC(I).GT.0.0) THEN
              LF = ABS((SLIP(I)-SET_NEG(I))/SLIP_INC(I))
              STIFF_NEW = STIFF_INITIAL
             SCRIPT1='SLIP_NEG(I)<SLIP(I)<SET_NEG(I) & SLIP(INC(I)>0.0'
              GOTO 20
          END IF
          IF (SLIP_INC(I).LT.0.0) THEN
              LF = (SLIP_NEG(I)-SLIP(I))/SLIP_INC(I)
              STIFF_NEW = SSS(I)
             SCRIPT1='SLIP_NEG(I)<SLIP(I)<SET_NEG(I) & SLIP(INC(I)<0.0'
              GOTO 20
          END IF
      END IF

      GOTO 10  !VERY IMPORTANT TO BYPASS "20" UNLESS SENT BY "GOTO" STATEMENT

 20   IF (LF.LT.LOAD_FACT) THEN      !COMPARES LF'S TO GET MIN LF WHICH
          LOAD_FACT = LF             !LOAD_FACT IS SET EQUAL TO
          STIFF = STIFF_NEW          !STIFFNESSS OF NEXT STUD TO LOAD
          I_STORE = I                !NUMBER OF NEXT STUD TO LOAD
          SCRIPT = SCRIPT1
      END IF                         
 
 10   CONTINUE
      IF(TRI_LIN_ALL)    WRITE(7,600)SCRIPT,i_store
 600  FORMAT(/,10X,A50,4x,i5)
    
      RETURN
      END

$ 