$DEBUG
      DIMENSION PHI(91,2),HU(91),FAC1(91),FAC2(91)
      DIMENSION HK(92),F(92)
      DIMENSION H(10),U(10),RK(10),SIG(10),C(10)
      DATA NIO,MULT/10,10/
      CALL DOPEN(0,0,8,'Filename for output ?                   ',
     $           'UNKNOWN   ')
      NM=(NIO-1)*MULT+1
      NM1=NM-1
      RMULT=MULT
      WRITE(0,16)
      WRITE(8,16)
   16 FORMAT(' INPUT INCREMENT IN X-DIRECTION (M.) :')
      READ(0,*) DXIO
      WRITE(8,44) DXIO
   44 FORMAT(1x,F10.2)
      DX=DXIO/RMULT
      DX2=DX/2.
      WRITE(0,17) DX2,DXIO
      WRITE(8,17) DX2,DXIO
   17 FORMAT(' FOLLOWING INPUT DATA SHOULD BE ORDERED OUTWARDS FROM',
     $       ' SHORE'/
     $       ' FIRST VALUE ',F8.2,' METRES FROM SHORE,'/
     $       ' THEN EVERY ',F8.2,' METRES'//)
   37 WRITE(0,2) NIO
      WRITE(8,2) NIO
    2 FORMAT(' INPUT ',I2,' DEPTH VALUES (M.) :')
      READ(0,*)(H(I),I=1,NIO)
      WRITE(8,45)(H(I),I=1,NIO)
   45 FORMAT((1x,8F10.3))
      WRITE(0,9) NIO
      WRITE(8,9) NIO
    9 FORMAT(' INPUT ',I2,' VELOCITY VALUES (M./S.) :')
      READ(0,*)(U(I),I=1,NIO)
      WRITE(8,46)(U(I),I=1,NIO)
   46 FORMAT((1x,8F10.3))
   38 WRITE(0,10) NIO
      WRITE(8,10) NIO
   10 FORMAT(' INPUT ',I2,' SOURCE VALUES (Mass/S.) :')
      READ(0,*)(SIG(I),I=1,NIO)
      WRITE(8,47)(SIG(I),I=1,NIO)
   47 FORMAT((1x,4F20.14))
   43 WRITE(0,42)                           
      WRITE(8,42)
   42 FORMAT(' INPUT DECAY RATE (/S.) : '$)

      READ(0,*) DK                                                    

      WRITE(8,48) DK                                                   

   48 FORMAT(1x,F10.8)                                                  

    5 WRITE(0,3)                                                       

      WRITE(8,3)                                                       

    3 FORMAT(' DO YOU REQUIRE INTERNAL COMPUTATION OF ',
     $       'DIFFUSIVITIES (Y OR N) ?')
      READ(0,4)ADUM
    4 FORMAT(A1)
      WRITE(8,49) ADUM                                                 

   49 FORMAT(1x,A1)                                                     

      IF(ADUM.NE.'Y'.AND.ADUM.NE.'N') GO TO 5
      IF(ADUM.EQ.'Y') GO TO 6
C     Input diffusivities :
      WRITE(0,7) NIO                                                   

      WRITE(8,7) NIO                                                   

    7 FORMAT(' INPUT ',I2,' DIFFUSIVITY VALUES (SQ.M./S.) :')
      READ(0,*)(RK(I),I=1,NIO)
      WRITE(8,50)(RK(I),I=1,NIO)                                       

   50 FORMAT((1x,8F10.6))                                               

      GO TO 8
C     Compute diffusivities :
    6 WRITE(0,11)                                                      

      WRITE(8,11)                                                      

   11 FORMAT(' INPUT DIFFUSIVITY FACTOR'/
     $       ' (Diffusivity) = (Velocity) * (Depth) * ',
     $       '(Diffusivity factor) :')
      READ(0,*) DFAC
      WRITE(8,51) DFAC                                                 

   51 FORMAT(1x,F10.4)                                                  

      DO 12 I=1,NIO
   12 RK(I)=U(I)*H(I)*DFAC
    8 WRITE(0,28)                                                      

      WRITE(8,28)                                                      

   28 FORMAT(//' INPUT SCALING FACTOR FOR CONCENTRATION OUTPUT'/
     $  ' (Output value) = (True concentration) * (Scaling factor) :')
      READ(0,*) OFAC
      WRITE(8,52) OFAC                                                 

   52 FORMAT(1x,F20.0)                                                 

   36 WRITE(0,13)                                                      

      WRITE(8,13)                                                      

   13 FORMAT(' INPUT YMAX, YINCR :')
      READ(0,*) YMAX,YINCR
      WRITE(8,53) YMAX,YINCR                                           

   53 FORMAT(1x,2F10.2)                                                 

      IF(YMAX.LT.YINCR) GO TO 36
C     Output X-axis :
      DO 33 I=1,NIO
      RI=I-1
   33 C(I)=DX2+RI*DXIO
      WRITE(0,32)(C(I),I=1,NIO)                                        

      WRITE(8,32)(C(I),I=1,NIO)                                        

   32 FORMAT(//10(1x,F7.2)//)
C     Interpolate to model cells :
      NIOM1=NIO-1
      DO 14 I=1,NIOM1
      DO 15 J=1,MULT
      IM=(I-1)*MULT+J
      W2=J-1
      W2=W2/RMULT
      W1=1.-W2
      HDUM=H(I)*W1+H(I+1)*W2
      UDUM=U(I)*W1+U(I+1)*W2
      HU(IM)=HDUM*UDUM
      FAC1(IM)=UDUM              

      W2=J-1
      W2=(W2+0.5)/RMULT
      W1=1.-W2
      HDUM=H(I)*W1+H(I+1)*W2
      RKDUM=RK(I)*W1+RK(I+1)*W2
      HK(IM+1)=HDUM*RKDUM
   15 CONTINUE
   14 CONTINUE
      HU(NM)=H(NIO)*U(NIO)
      FAC1(NM)=U(NIO)            

C     Find min. value (velocity)/(diffusivity)
c     VDMIN=(HU(1)+HU(2))/(2.*HK(2))
      VDMIN=(HU(1)+HU(2))/(2.*HK(2)+(DX*DX*DK/8.))
      DO 18 I=2,NM1
C     DUM=(HU(I)+HU(I+1))/(2.*HK(I+1))
      DUM=(HU(I)+HU(I+1))/(2.*HK(I+1)+(DX*DX*DK/8.))
   18 IF(VDMIN.GT.DUM) VDMIN=DUM
      DYMAX=VDMIN*DX*DX/8.
      IF(YINCR.GT.DYMAX) GO TO 19
C     Set DY to YINCR :
      DY=YINCR
      IOUT=1
      GO TO 20
C     Set DY to largest increment of YINCR less than DYMAX :
   19 IOUT=YINCR/DYMAX+1.
      DUM=IOUT
      DY=YINCR/DUM
C     Initialise :
   20 NT=0
      NSTP=YMAX/YINCR+0.5
      NSTP=NSTP*IOUT
C     FAC=DY/(DX*DX)                                                  

      DO 21 I=1,NM
      DUM=DY*DK/(2.*FAC1(I))                                          

      FAC1(I)=(1.-DUM)/(1.+DUM)    

      FAC2(I)=DY/(DX*DX*(1.+DUM))  

      PHI(I,1)=0.
   21 PHI(I,2)=0.
      DO 23 I=1,NIO
      IM=(I-1)*MULT+1
   23 PHI(IM,1)=SIG(I)/DX
      F(1)=0.
      F(NM+1)=0.
      I1=1
      I2=2
      Y=0.
C     Return point :
   25 CONTINUE
C     Generate "fluxes" :
      DO 22 I=1,NM1
C  22 F(I+1)=-HK(I+1)*(PHI(I+1,I1)/HU(I+1)-PHI(I,I1)/HU(I))*FAC       

   22 F(I+1)=-HK(I+1)*(PHI(I+1,I1)/HU(I+1)-PHI(I,I1)/HU(I))           

C     Update PHI :
      DO 24 I=1,NM
C  24 PHI(I,I2)=PHI(I,I1)+F(I)-F(I+1)                                 

   24 PHI(I,I2)=PHI(I,I1)*FAC1(I)+(F(I)-F(I+1))*FAC2(I)               

      Y=Y+DY
      NT=NT+1
      I1=3-I1
      I2=3-I2
C     Test for output :
      IF((NT/IOUT)*IOUT.NE.NT) GO TO 25
C     Output :
   29 DO 26 I=1,NIO
      IM=(I-1)*MULT+1
      C(I)=(PHI(IM,I1)/HU(IM))*OFAC
      IF(ABS(C(I)).LE.999.999) GO TO 26
C     Change scale factor by 10 :
      OFAC=OFAC/10.
      WRITE(0,31) OFAC                                                 

      WRITE(8,31) OFAC                                                 

   31 FORMAT(/' ********* SCALING FACTOR CHANGED TO ',E10.4,
     $        ' *********'/)
      GO TO 29
   26 CONTINUE
      WRITE(0,35) Y                                                    

      WRITE(8,35) Y                                                    

   35 FORMAT(' Y = ',F9.2)                                             
 
      WRITE(0,30)(C(I),I=1,NIO)                                        

      WRITE(8,30)(C(I),I=1,NIO)                                        

   30 FORMAT(1x,10F8.3/)                                                

      IF(NT.NE.NSTP) GO TO 25
   40 WRITE(0,39)                                                      

      WRITE(8,39)                                                      

   39 FORMAT(//' INPUT INTEGER AS GIVEN BELOW :'//
     $         '   INTEGER                   FUNCTION'/
     $         '      0          EXIT'/
     $         '      1          RETURN TO INPUT NEW DEPTHS'/
     $         '      2          RETURN TO INPUT NEW SOURCES'/
     $         '      3          RETURN TO INPUT NEW DECAY RATE'/     
     $         '      4          RETURN TO INPUT NEW DIFFUSIVITIES'/  
     $         '      5          RETURN TO INPUT NEW SCALING FACTOR'/ 
     $         '      6          RETURN TO INPUT NEW YMAX, YINCR'//)  

      READ(0,*) IRET
      WRITE(8,54) IRET                                                 

   54 FORMAT(1x,I2)                                                     

      IF(IRET.EQ.0) GO TO 41
      IF(IRET.NE.1.AND.IRET.NE.2.AND.IRET.NE.3.AND.IRET.NE.4
     $   .AND.IRET.NE.5.AND.IRET.NE.6) GO TO 40                       

      GO TO (37,38,43,5,8,36) IRET                                    

   41 WRITE(0,34)                                                      

      WRITE(8,34)                                                      

   34 FORMAT(///)
      STOP
      END
C
      SUBROUTINE DOPEN(NIN,NOUT,NDEV,ANOT,STAT)
      CHARACTER*40 ANOT
      CHARACTER*10 STAT
      CHARACTER*20 FILNAM
      WRITE(NOUT,1) ANOT
    1 FORMAT(1x,A40$)
      READ(NIN,2) FILNAM
    2 FORMAT(A20)
      OPEN(NDEV,FILE=FILNAM,status='NEW')
      RETURN
      END
