C
C     15th dec 1981 at 1600
C
C
C
C     FILE ...... STREL16.FOR
C
C=========================================================
      SUBROUTINE EL16(X,Y,E,GNU,ELS,EF,NGAUSS,KEY,KLASS)
C-------------------------------------------------------------
C
C     For 8 noded isoparametric quadrilateral,
C     plane stress/plane strain/axisymmetric cases :-
C
C     (1) computes element stiffness matrix,
C         after calling appropriate  sub-routines.    
C
C-----------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION X(8),Y(8),ELS(16,16),EF(16)
      DIMENSION S(8),W(2,8),Q(2,8)
      DIMENSION AJ(2,2),BJ(2,2)
      DIMENSION GWTS(5),GABS(5)
      DIMENSION D(4,4),B(4,16),DB(4,16)
        

      IF(KLASS.EQ.1) THEN   
               ND=3              
               THICK=1.
               ENDIF
      IF(KLASS.EQ.2)THEN    
               ND=4    
               THICK=1.
               ENDIF
      IF(KLASS.EQ.3)THEN    
               ND=4  
               PI=3.14159265
               ENDIF


      CALL INT8(X,Y)
      CALL GAUSS(NGAUSS,GWTS,GABS)
      DO 20,J=1,16
        DO 10,I=1,16
          ELS(I,J)=0.
  10    continue
        EF(J)=0.
  20  continue


      DO 200 NETA=1,NGAUSS
      ETA=GABS(NETA)
      WETA=GWTS(NETA)
      DO 200 NXI=1,NGAUSS
      XI=GABS(NXI)
      WXI=GWTS(NXI)
      CALL SF8(XI,ETA,S)
      CALL SF8XI(XI,ETA,W)
      CALL JAC(W,X,Y,AJ,BJ,DETJ,KEY)
            IF(KEY.NE.0) THEN
            WRITE(6,601)(I,X(I),Y(I),I=1,8)            
            WRITE(6,602)XI,ETA 
            RETURN
            ENDIF
      CALL SF8XY(BJ,W,Q)
      IF(KLASS.EQ.1) CK=WETA*WXI*DETJ*THICK
      IF(KLASS.EQ.2) CK=WETA*WXI*DETJ*THICK
      IF(KLASS.EQ.3) THEN
                     RAD=0.
                     DO 30,K=1,8
                       RAD=RAD+S(K)*X(K)
  30                 continue
                     CK=2.*PI*RAD*WETA*WXI*DETJ
                     ENDIF
   
      CALL DMAT4(CK,E,GNU,D,KLASS)
      CALL BM16(B,Q,S,RAD,KLASS)
      DO 60,J=1,16
      DO 50,I=1,ND
      SUM=0.
      DO 40,K=1,ND
        SUM=SUM+D(K,I)*B(K,J)
  40  continue
      DB(I,J)=SUM
  50  continue
  60  continue

      DO 90,I=1,16
      DO 80,J=I,16
      SUM=0.
      DO 70,K=1,ND
      SUM=SUM+B(K,I)*DB(K,J)
  70  continue
      ELS(I,J)=ELS(I,J)+SUM
  80  continue
  90  continue

 200  CONTINUE

      DO 220,I=1,16
      DO 210,J=1,I
      ELS(I,J)=ELS(J,I)
  210 continue
  220 continue
   

      RETURN
 601  FORMAT(' GEOM DATA OF OFFENDING ELEMENT.....',/,
     1  (I5,2E11.3))
 602  FORMAT(' XI AND ETA ',2E11.3)
      END
C=============================================================
      SUBROUTINE PRES16(X,Y,KPRES,PRESS,EF,NGAUSS,KEY,KLASS)
C-------------------------------------------------------------
C
C    Computes force vector,for 8 noded isoparametric 
C    quadrilateral, due to pressure loading.
C
C---------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION X(8),Y(8),PRESS(8),EF(16)
      DIMENSION S(8),W(2,8),Q(2,8)
      DIMENSION AJ(2,2),BJ(2,2)
      DIMENSION GWTS(5),GABS(5)
      DIMENSION VECN(2),XIETA(2),LEJ(9)
      DATA LEJ/1,2,3,4,5,6,7,8,1/

      IF(KLASS.EQ.1)THEN    
            THICK=1.        
            ENDIF
      IF(KLASS.EQ.2)THEN    
            THICK=1.        
            ENDIF
      IF(KLASS.EQ.3)THEN    
            PI=3.14159265
            ENDIF


      CALL GAUSS(NGAUSS,GWTS,GABS)
      KSIDE=0
      SIGN=-1.
      DO 260,N=1,2
      NS1=1
      DO 250 NS=1,2
      RS1=NS1
      KSIDE=KSIDE+1
      I=2*KSIDE-1
      J=I+1
      K=LEJ(I+2)
         IF(DABS(PRESS(I)).LE.0.1E-6) GOTO 250
         IF(DABS(PRESS(K)).LE.0.1E-6) GOTO 250
         IF(DABS(PRESS(J)).LE.0.1E-6) PRESS(J)=0.5*(PRESS(I)+PRESS(K))

      DO 30,NG=1,NGAUSS
      WEIGHT=GWTS(NG)
      XIETA(NS)=GABS(NG)
      XIETA(NS+NS1)=SIGN*RS1
      XI=XIETA(1)
      ETA=XIETA(2)
      CALL SF8(XI,ETA,S)
      RAD=0.
      PLOAD=0.
      DO 10,K=1,8
          PLOAD=PLOAD+S(K)*PRESS(K)
          RAD=RAD+S(K)*X(K)
  10  continue
      IF(KLASS.EQ.1) CONST=THICK*WEIGHT*PLOAD
      IF(KLASS.EQ.2) CONST=THICK*WEIGHT*PLOAD
      IF(KLASS.EQ.3) CONST=2.*PI*RAD*WEIGHT*PLOAD
      CALL SF8XI(XI,ETA,W)
      CALL JAC(W,X,Y,AJ,BJ,DETJ,KEY)
            IF(KEY.NE.0) THEN
            WRITE(6,601)(M,X(M),Y(M),M=1,8)
            WRITE(6,602)XI,ETA
            RETURN
            ENDIF
      VECN(1)=-SIGN*AJ(NS,2)
      VECN(2)= SIGN*AJ(NS,1)
      CONST1=CONST*VECN(1)
      CONST2=CONST*VECN(2)
      KK=0
      DO 20,K=1,16,2
         KK=KK+1
         EF(K  )=EF(K  )+CONST1*S(KK)
         EF(K+1)=EF(K+1)+CONST2*S(KK) 
  20  continue
  30  continue
 250  NS1=-NS1
      SIGN=+1.
 260  continue

      RETURN

 600  FORMAT(10X,I5,5X,F13.4,5X,F13.4)
 601  FORMAT(' GEOM DATA OF OFFENDING ELEMENT .....',/,
     1  (I5,2E11.3))
 602  FORMAT(' XI AND ETA ',2E11.3)
      END
C=======================================================
      SUBROUTINE ASS16(A,B,NVABZ,KWIDTH,ELS,EF,LNODS)
C--------------------------------------------------------
C
C     For 8 noded element with 2 variables per node :-
C
C     (1) assembles the element stiffness matrix into 
C         the global stiffness matrix (packed form)
C     (2) assembles element force vector into the
C         global force vector
C
C--------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION ELS(16,16),EF(16),
     2     LNODS(8),LDEST(16),
     3     A(NVABZ,KWIDTH),B(NVABZ)

      CALL DEST16(LNODS,LDEST)
      DO 200 M=1,16
      I=LDEST(M)
      DO 100 N=1,16
      J=LDEST(N)
      IF(I.GT.J) GOTO 100
      J=J-I+1
      A(I,J)=A(I,J)+ELS(M,N)
 100  CONTINUE
 200  B(I)=B(I)+EF(M)

      RETURN

      END
C=======================================================
      SUBROUTINE DEST16(LNODS,LDEST)
C--------------------------------------------------------
C
C     Computes the element destination pointer list 
C     for an 8 noded element with 2 variables per node
C
C-------------------------------------------------------

      DIMENSION LNODS(8),LDEST(16)

      K=1
      DO 50 L=1,8
      NODE=LNODS(L)
      I=2*(NODE-1)
      DO 50 M=1,2
      LDEST(K)=I+M
 50   K=K+1
      RETURN
      END
C=============================================================
      SUBROUTINE STRES16(X,Y,U,V,E,GNU,LNODS,NEL,KEY,KLASS,
     1                   NES,NELSTR,NWRITE,KOUNT,NW,NSTAT)
C------------------------------------------------------------
C
C     For an 8 noded 16 variable isoparametric quadrilateral
C     element, by calling appropriate sub-routines :-
C
C     (1) computes Gauss point stresses
C     (2) smoothes and extrapolates these to the nodes
C     (3) prints nodal stresses
C
C-----------------------------------------------------------


      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION 
     .  X(8),Y(8),U(8),V(8),
     .  S(8),W(2,8),
     .  AJ(2,2),BJ(2,2),DUDX(2,2),
     .  EPS(4),D(4,4),
     .  SAM(4,4),CORN(4,4),ELSIG(4,8),
     .  GWTS(5),GABS(5),
     .  INT(9),LNODS(8),
     .  NELSTR(300)
      DATA INT/1,2,3,4,5,6,7,8,1/


      IF(KLASS.EQ.1) ND=3      
      IF(KLASS.EQ.2) ND=4      
      IF(KLASS.EQ.3) ND=4      
  

      CALL INT8(X,Y)     
      CALL GAUSS(2,GWTS,GABS)


      NSAM=1          
      DO 200 NETA=1,2 
      ETA=GABS(NETA)
      DO 200 NXI=1,2
      XI=GABS(NXI)
      
      CALL SF8(XI,ETA,S)
      CALL SF8XI(XI,ETA,W)
      CALL JAC(W,X,Y,AJ,BJ,DETJ,KEY) 
            IF(KEY.NE.0)THEN
            ENDIF
      CALL DUDX16(U,V,W,BJ,DUDX)
      IF(KLASS.EQ.1) THEN
            EPS(1)=DUDX(1,1)
            EPS(2)=DUDX(2,2)
            EPS(3)=DUDX(1,2)+DUDX(2,1)
            ENDIF
      IF(KLASS.EQ.2) THEN
            EPS(1)=DUDX(1,1)
            EPS(2)=DUDX(2,2)
            EPS(3)=0.
            EPS(4)=DUDX(1,2)+DUDX(2,1)
            ENDIF
       IF(KLASS.EQ.3) THEN
            RAD=0.
            UDISP=0.
            DO 60 K=1,8
            RAD=RAD + S(K)*X(K)
 60         UDISP=UDISP + S(K)*U(K)
            IF(RAD.LT.1.0E-06) RAD=1.0E-06
            EPS(1)=DUDX(1,1)
            EPS(2)=UDISP/RAD
            EPS(3)=DUDX(2,2)
            EPS(4)=DUDX(1,2)+DUDX(2,1)
            ENDIF

      CALL DMAT4(1.0,E,GNU,D,KLASS)

         DO 80 I=1,ND
         SUM=0.
         DO 70 K=1,ND
 70      SUM=SUM+D(I,K)*EPS(K)
 80      SAM(I,NSAM)=SUM
 200  NSAM=NSAM+1            

                             
      CALL SAM16(SAM,CORN,ND)
                             


      NC=1                   
      DO 330 NS=1,4          
      DO 320 I=1,ND          
 320  ELSIG(I,NC)=CORN(I,NS) 
 330  NC=NC+2

      DO 380 NC=1,8,2        
      I=INT(NC)              
      J=INT(NC+1)            
      K=INT(NC+2)
      DO 360 M=1,ND
 360  ELSIG(M,J)=0.5*(ELSIG(M,I)+ELSIG(M,K))
 380  CONTINUE

      IF (KOUNT.EQ.0.AND.NSTAT.EQ.1) THEN
      WRITE(6,600)
  600 FORMAT(//)
      DO 440 L=1,8           
 440  WRITE(6,601)NEL,LNODS(L),(ELSIG(I,L),I=1,ND)
      ELSE
c     TYPE *,'NWRITE=',NWRITE
c     TYPE *,'KOUNT=',KOUNT	
      IF (NWRITE.EQ.1.AND.NW.EQ.1) THEN
      DO 450 IJ=1,NES
        IF (NEL.EQ.NELSTR(IJ)) THEN
           WRITE(6,600)
           DO 460 L=1,8                                  
 460       WRITE(6,601)NEL,LNODS(L),(ELSIG(I,L),I=1,ND)  
	ENDIF
 450  CONTINUE
      ENDIF
      ENDIF

      RETURN 


 601  FORMAT(I4,I6,5X,4F10.1)
      END
C=============================================================
      SUBROUTINE DUDX16(U,V,W,BJ,DUDX)
C-------------------------------------------------------------
C
C     For an 8 noded 16 variable element,
C    
C     (1) Computes 2x2 array [DUDX] of 
C         displacement gradients.
C
C-----------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION 
     .  U(8),V(8),W(2,8),
     .  BJ(2,2),DUDX(2,2)

      D11=0.
      D12=0.
      D21=0.
      D22=0.

      DO 80 K=1,8
      D11=D11 + W(1,K)*U(K)
      D12=D12 + W(1,K)*V(K)
      D21=D21 + W(2,K)*U(K)
      D22=D22 + W(2,K)*V(K)
 80   CONTINUE
 
      DUDX(1,1)=BJ(1,1)*D11 + BJ(1,2)*D21
      DUDX(1,2)=BJ(1,1)*D12 + BJ(1,2)*D22
      DUDX(2,1)=BJ(2,1)*D11 + BJ(2,2)*D21
      DUDX(2,2)=BJ(2,1)*D12 + BJ(2,2)*D22
      RETURN
  
      END
C============================================================
      SUBROUTINE SAM16(SAM,CORN,ND)
C-----------------------------------------------------------
C  
C     For an 8 noded 16 variable isoparametric quadrilateral 
C     element :-
C
C     (1) extrapolates stresses at 4 Gauss points to 
C         the corner nodes,in order shown in fig.1
C     (2) re-orders these to normal nodal order,
C         as shown in fig.2
C
C-----------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION 
     .   SAM(4,4),CORN(4,4),SV(4),CV(4),
     .   E(4,4)
      DATA NTIMES/0/            



      IF(NTIMES.EQ.0) THEN
         NTIMES=1
         A=1. + 0.5*SQRT(3.)
         B=-0.5
         C=1. - 0.5*SQRT(3.)
                           
         E(1,1)=A          
         E(1,2)=B          
         E(1,3)=C          
         E(1,4)=B          
                           
         E(2,1)=B          
         E(2,2)=A          
         E(2,3)=B          
         E(2,4)=C          
                           
         E(3,1)=C          
         E(3,2)=B          
         E(3,3)=A          
         E(3,4)=B          
                           
         E(4,1)=B          
         E(4,2)=C          
         E(4,3)=B          
         E(4,4)=A          
                           
         ENDIF             


                           
      DO 170 I=1,ND        
        DO 110 J=1,4       
 110    SV(J)=SAM(I,J)     
          DO 140 J=1,4     
          SUM=0.    
             DO 130 K=1,4
 130         SUM=SUM + SV(K)*E(K,J)
 140      CV(J)=SUM

      CORN(I,1)=CV(1)
      CORN(I,2)=CV(2)
      CORN(I,3)=CV(4)
      CORN(I,4)=CV(3)
                     
                     
                          
 
170   CONTINUE                                  

      RETURN

      END
C=========================================================
      SUBROUTINE BIG16(ELS,BIG)
C-------------------------------------------------------
C
C     For an element with 16 varaibles :-
C
C     (1) Sets earthing parameter "BIG"
C
C-------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)

      DIMENSION ELS(16,16)

      STIFF=0.
      DO 50 I=1,16
      DIAG=ELS(I,I)
            IF(DIAG.GT.STIFF) THEN
            STIFF=DIAG
            ENDIF
 50   CONTINUE

      BIG=1.0E+10 * STIFF  

      RETURN

      END
