
C *                                                                            *

C *                              VAX SOURCE CODE                               *

C *                                                                            *

C *                                                                            *

C *   REVISION    :  Inclusion of implicit scheme for                          *

C *                  decay.                                JRH:26:06:1985      *

C *                  Output to disc file                   JRH:06:08:1985      *

C *                  Output terminal to device 6           JRH:06:08:1985      *

C *                  Minor mod.                            JRH:08:10:1985      *

C *                  Mod. to Format                    IHD/JRH:13:01:1986      :
*
C *                  Mod.to stability condition for DY IHD/JRH:13:01:1986      *

C *                                                                            *

C *   SOURCE      :  SDC1181.FOR                                               *

C *   ROUTINE NAME:  SDC1181                                                   *

C *   TYPE        :  MAIN                                                      *

C *                                                                            *

C *                                                                            *

C *                  NM ....... No. of model cells in X-direction              *

C *                  NIO ...... No. of input/output cells in X-direction       *

C *                  NM ....... (NIO-1)*MULT+1 (MULT is no. of model cells     *

C *                             per input/output cell)                         *

C *                                                                            *

C ******************************************************************************

C     DIMENSION at least NM :
      DIMENSION PHI(91,2),HU(91),FAC1(91),FAC2(91)                    ! &26/6/85

C     DIMENSION at least NM+1 :
      DIMENSION HK(92),F(92)
C     DIMENSION at least NIO :
      DIMENSION H(10),U(10),RK(10),SIG(10),C(10)
C
C     Set NIO, MULT :
      DATA NIO,MULT/10,10/
      CALL DOPEN(5,6,8,'Filename for output ?                   ',     ! @6/8/85

     $           'UNKNOWN   ')                                         ! @6/8/85

      NM=(NIO-1)*MULT+1
      NM1=NM-1
      RMULT=MULT
      WRITE(6,16)                                                      ! &6/8/85

      WRITE(8,16)                                                      ! @6/8/85

   16 FORMAT(' INPUT INCREMENT IN X-DIRECTION (M.) :')
      READ(5,*) DXIO
      WRITE(8,44) DXIO                                                 ! @6/8/85

   44 FORMAT(X,F10.2)                                                  ! &6/8/85

      DX=DXIO/RMULT
      DX2=DX/2.
      WRITE(6,17) DX2,DXIO                                             ! &6/8/85

      WRITE(8,17) DX2,DXIO                                             ! @6/8/85

   17 FORMAT(' FOLLOWING INPUT DATA SHOULD BE ORDERED OUTWARDS FROM',
     $       ' SHORE'/
     $       ' FIRST VALUE ',F8.2,' METRES FROM SHORE,'/
     $       ' THEN EVERY ',F8.2,' METRES'//)
   37 WRITE(6,2) NIO                                                   ! &6/8/85

      WRITE(8,2) NIO                                                   ! @6/8/85

    2 FORMAT(' INPUT ',I2,' DEPTH VALUES (M.) :')
      READ(5,*)(H(I),I=1,NIO)
      WRITE(8,45)(H(I),I=1,NIO)                                        ! @6/8/85

   45 FORMAT((X,8F10.3))                                               ! @6/8/85

      WRITE(6,9) NIO                                                   ! &6/8/85

      WRITE(8,9) NIO                                                   ! @6/8/85

    9 FORMAT(' INPUT ',I2,' VELOCITY VALUES (M./S.) :')
      READ(5,*)(U(I),I=1,NIO)
      WRITE(8,46)(U(I),I=1,NIO)                                        ! @6/8/85

   46 FORMAT((X,8F10.3))                                               ! @6/8/85

   38 WRITE(6,10) NIO                                                  ! &6/8/85

      WRITE(8,10) NIO                                                  ! @6/8/85

   10 FORMAT(' INPUT ',I2,' SOURCE VALUES (Mass/S.) :')
      READ(5,*)(SIG(I),I=1,NIO)
      WRITE(8,47)(SIG(I),I=1,NIO)                                      ! @6/8/85

   47 FORMAT((X,4F20.14))                                              ! @6/8/85

   43 WRITE(6,42)                                                      ! &6/8/85

      WRITE(8,42)                                                      ! @6/8/85

   42 FORMAT(' INPUT DECAY RATE (/S.) : '$)                           ! @26/6/85

      READ(5,*) DK                                                    ! @26/6/85

      WRITE(8,48) DK                                                   ! @6/8/85

   48 FORMAT(X,F10.8)                                                  ! @6/8/85

    5 WRITE(6,3)                                                       ! &6/8/85

      WRITE(8,3)                                                       ! @6/8/85

    3 FORMAT(' DO YOU REQUIRE INTERNAL COMPUTATION OF ',
     $       'DIFFUSIVITIES (Y OR N) ?')
      READ(5,4)ADUM
    4 FORMAT(A1)
      WRITE(8,49) ADUM                                                 ! @6/8/85

   49 FORMAT(X,A1)                                                     ! @6/8/85

      IF(ADUM.NE.'Y'.AND.ADUM.NE.'N') GO TO 5
      IF(ADUM.EQ.'Y') GO TO 6
C     Input diffusivities :
      WRITE(6,7) NIO                                                   ! &6/8/85

      WRITE(8,7) NIO                                                   ! @6/8/85

    7 FORMAT(' INPUT ',I2,' DIFFUSIVITY VALUES (SQ.M./S.) :')
      READ(5,*)(RK(I),I=1,NIO)
      WRITE(8,50)(RK(I),I=1,NIO)                                       ! @6/8/85

   50 FORMAT((X,8F10.6))                                               ! @6/8/85

      GO TO 8
C     Compute diffusivities :
    6 WRITE(6,11)                                                      ! &6/8/85

      WRITE(8,11)                                                      ! @6/8/85

   11 FORMAT(' INPUT DIFFUSIVITY FACTOR'/
     $       ' (Diffusivity) = (Velocity) * (Depth) * ',
     $       '(Diffusivity factor) :')
      READ(5,*) DFAC
      WRITE(8,51) DFAC                                                 ! @6/8/85

   51 FORMAT(X,F10.4)                                                  ! @6/8/85

      DO 12 I=1,NIO
   12 RK(I)=U(I)*H(I)*DFAC
    8 WRITE(6,28)                                                      ! &6/8/85

      WRITE(8,28)                                                      ! @6/8/85

   28 FORMAT(//' INPUT SCALING FACTOR FOR CONCENTRATION OUTPUT'/
     $  ' (Output value) = (True concentration) * (Scaling factor) :')
      READ(5,*) OFAC
      WRITE(8,52) OFAC                                                 ! @6/8/85

   52 FORMAT(X,F20.0)                                                 ! &8/10/85

   36 WRITE(6,13)                                                      ! &6/8/85

      WRITE(8,13)                                                      ! @6/8/85

   13 FORMAT(' INPUT YMAX, YINCR :')
      READ(5,*) YMAX,YINCR
      WRITE(8,53) YMAX,YINCR                                           ! @6/8/85

   53 FORMAT(X,2F10.2)                                                 ! @6/8/85

      IF(YMAX.LT.YINCR) GO TO 36
C     Output X-axis :
      DO 33 I=1,NIO
      RI=I-1
   33 C(I)=DX2+RI*DXIO
      WRITE(6,32)(C(I),I=1,NIO)                                        ! &6/8/85

      WRITE(8,32)(C(I),I=1,NIO)                                        ! @6/8/85

   32 FORMAT(//10(X,F7.2)//)
C     Interpolate to model cells :
      NIOM1=NIO-1
      DO 14 I=1,NIOM1
      DO 15 J=1,MULT
      IM=(I-1)*MULT+J
      W2=J-1
      W2=W2/RMULT
      W1=1.-W2
      HDUM=H(I)*W1+H(I+1)*W2
      UDUM=U(I)*W1+U(I+1)*W2
      HU(IM)=HDUM*UDUM
      FAC1(IM)=UDUM              ! Initially use FAC1 to store velocity @26/6/85

      W2=J-1
      W2=(W2+0.5)/RMULT
      W1=1.-W2
      HDUM=H(I)*W1+H(I+1)*W2
      RKDUM=RK(I)*W1+RK(I+1)*W2
      HK(IM+1)=HDUM*RKDUM
   15 CONTINUE
   14 CONTINUE
      HU(NM)=H(NIO)*U(NIO)
      FAC1(NM)=U(NIO)            ! Initially use FAC1 to store velocity @26/6/85

C     Find min. value (velocity)/(diffusivity)
c     VDMIN=(HU(1)+HU(2))/(2.*HK(2))
      VDMIN=(HU(1)+HU(2))/(2.*HK(2)+(DX*DX*DK/8.))
      DO 18 I=2,NM1
C     DUM=(HU(I)+HU(I+1))/(2.*HK(I+1))
      DUM=(HU(I)+HU(I+1))/(2.*HK(I+1)+(DX*DX*DK/8.))
   18 IF(VDMIN.GT.DUM) VDMIN=DUM
      DYMAX=VDMIN*DX*DX/8.
      IF(YINCR.GT.DYMAX) GO TO 19
C     Set DY to YINCR :
      DY=YINCR
      IOUT=1
      GO TO 20
C     Set DY to largest increment of YINCR less than DYMAX :
   19 IOUT=YINCR/DYMAX+1.
      DUM=IOUT
      DY=YINCR/DUM
C     Initialise :
   20 NT=0
      NSTP=YMAX/YINCR+0.5
      NSTP=NSTP*IOUT
C     FAC=DY/(DX*DX)                                                  ! &26/6/85

      DO 21 I=1,NM
      DUM=DY*DK/(2.*FAC1(I))                                          ! @26/6/85

      FAC1(I)=(1.-DUM)/(1.+DUM)    ! Mult. fac. for forward integration @26/6/85

      FAC2(I)=DY/(DX*DX*(1.+DUM))  ! Mult. fac. for forward integration @26/6/85

      PHI(I,1)=0.
   21 PHI(I,2)=0.
      DO 23 I=1,NIO
      IM=(I-1)*MULT+1
   23 PHI(IM,1)=SIG(I)/DX
      F(1)=0.
      F(NM+1)=0.
      I1=1
      I2=2
      Y=0.
C     Return point :
   25 CONTINUE
C     Generate "fluxes" :
      DO 22 I=1,NM1
C  22 F(I+1)=-HK(I+1)*(PHI(I+1,I1)/HU(I+1)-PHI(I,I1)/HU(I))*FAC       ! &26/6/85

   22 F(I+1)=-HK(I+1)*(PHI(I+1,I1)/HU(I+1)-PHI(I,I1)/HU(I))           ! &26/6/85

C     Update PHI :
      DO 24 I=1,NM
C  24 PHI(I,I2)=PHI(I,I1)+F(I)-F(I+1)                                 ! &26/6/85

   24 PHI(I,I2)=PHI(I,I1)*FAC1(I)+(F(I)-F(I+1))*FAC2(I)               ! @26/6/85

      Y=Y+DY
      NT=NT+1
      I1=3-I1
      I2=3-I2
C     Test for output :
      IF((NT/IOUT)*IOUT.NE.NT) GO TO 25
C     Output :
   29 DO 26 I=1,NIO
      IM=(I-1)*MULT+1
      C(I)=(PHI(IM,I1)/HU(IM))*OFAC
      IF(ABS(C(I)).LE.999.999) GO TO 26
C     Change scale factor by 10 :
      OFAC=OFAC/10.
      WRITE(6,31) OFAC                                                 ! &6/8/85

      WRITE(8,31) OFAC                                                 ! @6/8/85

   31 FORMAT(/' ********* SCALING FACTOR CHANGED TO ',E10.4,
     $        ' *********'/)
      GO TO 29
   26 CONTINUE
      WRITE(6,35) Y                                                    ! &6/8/85

      WRITE(8,35) Y                                                    ! @6/8/85

   35 FORMAT(' Y = ',F9.2)                                             ! 13/1/86
 
      WRITE(6,30)(C(I),I=1,NIO)                                        ! &6/8/85

      WRITE(8,30)(C(I),I=1,NIO)                                        ! @6/8/85

   30 FORMAT(X,10F8.3/)                                                ! @6/8/85

      IF(NT.NE.NSTP) GO TO 25
   40 WRITE(6,39)                                                      ! &6/8/85

      WRITE(8,39)                                                      ! @6/8/85

   39 FORMAT(//' INPUT INTEGER AS GIVEN BELOW :'//
     $         '   INTEGER                   FUNCTION'/
     $         '      0          EXIT'/
     $         '      1          RETURN TO INPUT NEW DEPTHS'/
     $         '      2          RETURN TO INPUT NEW SOURCES'/
     $         '      3          RETURN TO INPUT NEW DECAY RATE'/     ! @26/6/85

     $         '      4          RETURN TO INPUT NEW DIFFUSIVITIES'/  ! &26/6/85

     $         '      5          RETURN TO INPUT NEW SCALING FACTOR'/ ! &26/6/85

     $         '      6          RETURN TO INPUT NEW YMAX, YINCR'//)  ! &26/6/85

      READ(5,*) IRET
      WRITE(8,54) IRET                                                 ! @6/8/84

   54 FORMAT(X,I2)                                                     ! @6/8/84

      IF(IRET.EQ.0) GO TO 41
      IF(IRET.NE.1.AND.IRET.NE.2.AND.IRET.NE.3.AND.IRET.NE.4
     $   .AND.IRET.NE.5.AND.IRET.NE.6) GO TO 40                       ! &26/6/85

      GO TO (37,38,43,5,8,36) IRET                                    ! &26/6/85

   41 WRITE(6,34)                                                      ! &6/8/85

      WRITE(8,34)                                                      ! @6/8/85

   34 FORMAT(///)
      STOP
      END
C
      SUBROUTINE DOPEN(NIN,NOUT,NDEV,ANOT,STAT)
C ******************************************************************************

C *                                                                            *

C *                              VAX SOURCE CODE                               *

C *                                                                            *

C *   PROGRAM SET :  UTILITY                           REF:JRH:02:07:1985      *

C *                                                                            *

C *   REVISION    :  -------------                         JRH:--:--:1985      *

C *                                                                            *

C *   SOURCE      :  SDC1181.FOR                                               *

C *   ROUTINE NAME:  DOPEN                                                     *

C *   TYPE        :  SUBROUTINE                                                *

C *                                                                            *

C *   FUNCTION    :  Interactive routine for opening disc file.                *

C *                                                                            *

C ******************************************************************************

      CHARACTER*40 ANOT
      CHARACTER*10 STAT
      CHARACTER*20 FILNAM
      WRITE(NOUT,1) ANOT
    1 FORMAT(X,A40$)
      READ(NIN,2) FILNAM
    2 FORMAT(A20)
      OPEN(UNIT=NDEV,FILE=FILNAM,STATUS=STAT)
      RETURN
      END

$ 