C==========================================================================
       SUBROUTINE EL4(XX,YY,THETA,RKX,RKY,ELSS)
C---------------------------------------------------------------------------
C
C      COMPUTES THE STIFFNESS MATRIX FOR A 2 NODED LINKAGE ELEMENT
C                   BY CALLING APPROPRIATE SUBROUTINES
C
C--------------------------------------------------------------------------
       IMPLICIT REAL*8(A-H,O-Z)
       DIMENSION XX(2),YY(2),ELSS(4,4),S(2),W(2),BT(4,2),EFF(4), 
     *         AJ(2),BJ(2),D(2,2),B(2,4),DB(2,4),BTD(4,4)
C
       DO 10 I=1,4
       DO 10 J=1,4
 10    ELSS(I,J)=0.0
C
       CALL ANGL(THETA,B)
       CALL DMATMD(RKX,RKY,D)
C
       DO 70 I=1,2
       DO 70 J=1,4
       SUM=0.0
       DO 80 K=1,2
 80    SUM = SUM+D(I,K)*B(K,J)
 70    DB(I,J) = SUM
C
       DO 30 I=1,4
       DO 30 J=1,2
       BT(I,J)=B(J,I)
 30    CONTINUE
C
       DO 40 I=1,4
       DO 40 J=1,4
       SUM = 0.0
       DO  50 K=1,2
 50    SUM = SUM+BT(I,K)*DB(K,J)
 40    ELSS(I,J)=SUM
C
       DO 250 I=1,4
       DO 250 J=1,I
 250   ELSS(I,J)=ELSS(J,I)

       RETURN
       END
C=========================================================================
       SUBROUTINE ASS4(A,B,NVABZ,KWIDTH,ELSS,EFF,LLNODS)
C--------------------------------------------------------------------------
C      THE GLOBAL STIFFNESS MATRIX (PACKED FORM)
C
C      ASSEMBLES ELEMENT FORCE VECTOR INTO THE
C      GLOBAL FORCE VECTOR
C
C--------------------------------------------------------------------------
       IMPLICIT REAL*8(A-H,O-Z)
       DIMENSION A(NVABZ,KWIDTH),B(NVABZ)
       DIMENSION ELSS(4,4),EFF(4),LLNODS(2),LLDEST(4)
C
       DO 10 I=1,4
 10    EFF(I)=0.0
       CALL DEST4(LLNODS,LLDEST)
       DO 200 M=1,4
       I=LLDEST(M)
       DO 100 N=1,4
       J=LLDEST(N)
       IF(I.GT.J)GO TO 100
       J=J-I+1
       A(I,J)=A(I,J)+ELSS(M,N) 
 100   CONTINUE
 200   B(I)=B(I)+EFF(M)
       RETURN
       END
C==============================================================================
       SUBROUTINE DEST4(LLNODS,LLDEST)
C------------------------------------------------------------------------------
C
C      COMPUTES THE ELEMENT DESTINATION POINTER LIST
C      FOR A 2 NODED ELEMENT WITH 2 VARIABLES PER NODE
C
C------------------------------------------------------------------------------
       DIMENSION LLNODS(2),LLDEST(4)
C
       K=1
       DO 50 L=1,2
       NODE=LLNODS(L)
       I=2*(NODE-1)
       DO 50 M=1,2
       LLDEST(K)=I+M
 50    K=K+1
       RETURN
       END
C============================================================================
       SUBROUTINE STRES4(XX,YY,UU,VV,RKX,RKY,LLNODS,NEL,ELSS,
     1                   SHFOR,NWRITE,AXFOR,NW)
C----------------------------------------------------------------------------
C      CALCULATES SHEAR AND AXIAL FORCES AND STORES THEM
C
C----------------------------------------------------------------------------
       IMPLICIT REAL*8(A-H,O-Z)
       DIMENSION XX(2),YY(2),UU(2),VV(2),LLNODS(2),
     *           D(2,2),B(2,4),ETA(2),
     *           ELSIGMA(2,2),SIGMA(2),
     *           DISP(4),ELSS(4,4),SHFOR(300),
     *           AXFOR(300)
C
      DISP(1)=UU(1)
      DISP(2)=VV(1)
      DISP(3)=UU(2)
      DISP(4)=VV(2)
C
      CALL ANGL(THETA,B)
      CALL DMATMD(RKX,RKY,D)
C
      DO 10 I=1,2
 10   ETA(I)=0.0
C
      DO 20 I=1,2
      SUM=0.0
      DO 30 J=1,4
 30   SUM=SUM+B(I,J)*DISP(J)
 20   ETA(I)=SUM
C
      DO 40 I=1,2
 40   SIGMA(I)=0.0
C
      DO 50 I=1,2
      SUM=0.0
      DO 60 J=1,2
 60   SUM=SUM+D(I,J)*ETA(J)
 50   SIGMA(I)=SUM
C
      KK=1
      DO 70 I=1,2
      DO 80 N=1,2
 80   ELSIGMA(I,N)=SIGMA(KK)
 70   KK=KK+1
C
      DO 90 L=1,2
      SHFOR(NEL)=ELSIGMA(1,1)
      AXFOR(NEL)=ELSIGMA(2,1)
      IF (NWRITE.EQ.1.AND.NW.EQ.1) THEN
      WRITE(6,601)NEL,LLNODS(L),(ELSIGMA(I,L),I=1,2)
      ENDIF
 90   CONTINUE
      RETURN
 601  FORMAT(I4,I6,5X,2F10.3)
      END

$ 