      SUBROUTINE STRESS(NES,NELSTR,NWRITE,AXFOR,NW,NSTAT)
C---------------------------------------------------------
C
C     For each individual element :-
C     (1) Extracts element data from global arrays
C     (2) Calls appropriate 'routines to compute stresses 
C
C---------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 KA,KB,KC,KD,KE,KM
      INCLUDE 'STRESS2D.CCM'      

      DIMENSION
     .  X(8),Y(8),U(8),V(8),
     .  XX(2),YY(2),UU(2),VV(2),
     .  LNODS(8),LLNODS(2),ELS(16,16),ELSS(4,4),
     .  NELSTR(300),AXFOR(300)

      IF(KLASS.EQ.1) ND=3     ! plane stress
      IF(KLASS.EQ.2) ND=4     ! plane strain
      IF(KLASS.EQ.3) ND=4     ! axisymmetric


      IF (NWRITE.EQ.1.AND.NW.EQ.1.OR.KOUNT.EQ.0) THEN
      WRITE(6,601)(I,I=1,ND)
      ENDIF

      DO 300 NEL=1,NELEMZ
        MAT=LMAT(NEL)
        E=PROP(MAT,1)
        GNU=PROP(MAT,2)
        IF(LLTYP(NEL).EQ.1)THEN
          DO  40 I=1,8
          NODE=LTOP(I,NEL)
          LNODS(I)=NODE
          X(I)=GX(NODE)
          Y(I)=GY(NODE)
          KK=2*(NODE-1)
          KK1=KK+1
          KK2=KK+2
          U(I)=B(KK+1)
          V(I)=B(KK+2)
  40      CONTINUE


        CALL STRES16(X,Y,U,V,E,GNU,LNODS,NEL,KEY,KLASS,NES,
     1                 NELSTR,NWRITE,KOUNT,NW,NSTAT)
c            ****calculates stresses in each 8-noded element****
        ELSE
        DO 50 I=1,2
        NODE=LTOP(I,NEL)
        LLNODS(I)=NODE
        XX(I)=GX(NODE)
        YY(I)=GY(NODE)
        KK=2*(NODE-1)
        KK1=KK+1
        KK2=KK+2
        UU(I)=B(KK+1)
        VV(I)=B(KK+2)
 50     CONTINUE

      IF (NWRITE.EQ.1.AND.NW.EQ.1) THEN
        WRITE(6,600)
      ENDIF

      RKX=RKAS(NEL,1)
      RKY=RKAS(NEL,2)
      CALL EL4(XX,YY,THETA,RKX,RKY,ELSS)
      CALL STRES4(XX,YY,UU,VV,RKX,RKY,LLNODS,NEL,ELSS,SHFOR,
     1             NWRITE,AXFOR,NW)
c          ****calcuates spring forces****
      ENDIF
 300  CONTINUE
      RETURN


 600  FORMAT(//)
 601  FORMAT(///' ELEMENT STRESSES '/ 
     .          ' ---------------- '/
     .          ' ELEMENT NODE',20X,' COMPONENTS   '/
     .            14X,4I10)
      END

$ 