C
C     11th dec 1981 at 1245
C
C
C     FILE ..... STRINT8.FOR
C
C=============================================================
      SUBROUTINE INT8(X,Y)
C--------------------------------------------------------------
C
C     Where appropriate,interpolates 
C     geometry of midside nodes.
C
C-------------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION X(8),Y(8)
      DIMENSION INT(9)
      DATA INT/1,2,3,4,5,6,7,8,1/


      DO 100 K=2,8,2
      A=X(K)*X(K)+Y(K)*Y(K)
      IF(A.GT.1.0E-06) GOTO 100
      I=K-1
      J=INT(K+1)
      X(K)=0.5*(X(J)+X(I))
      Y(K)=0.5*(Y(J)+Y(I))
 100  CONTINUE
      RETURN

      END
C========================================================
      SUBROUTINE SF8(XI,ETA,S)
C--------------------------------------------------------
C
C     For curvilinear position (xi,eta) ...
C     (1)computes shape function array {s}
C
C--------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION S(8)

      P=XI
      Q=ETA
      S(1)=0.25*(1.-P)*(1.-Q)*(-P-Q-1.)
      S(3)=0.25*(1.+P)*(1.-Q)*(+P-Q-1.)
      S(5)=0.25*(1.+P)*(1.+Q)*(+P+Q-1.)
      S(7)=0.25*(1.-P)*(1.+Q)*(-P+Q-1.)
  
      S(2)=0.5*(1.-P*P)*(1.-Q)
      S(6)=0.5*(1.-P*P)*(1.+Q)
      S(4)=0.5*(1.-Q*Q)*(1.+P)
      S(8)=0.5*(1.-Q*Q)*(1.-P)
      RETURN

      END
C=====================================================
      SUBROUTINE SF8XI(XI,ETA,W)
C------------------------------------------------------
C
C     For curvilear position (xi,eta) ....
C     (1)computes curvilinear derivatives 
C        of shape functions & stores them in [W]
C
C--------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION W(2,8)

      P=XI
      Q=ETA
      W(1,1)=-0.25*(1.-Q)*(-2.*P-Q)
      W(1,3)= 0.25*(1.-Q)*(+2.*P-Q)
      W(1,5)= 0.25*(1.+Q)*(+2.*P+Q)
      W(1,7)=-0.25*(1.+Q)*(-2.*P+Q)
 
      W(2,1)=-0.25*(1.-P)*(-2.*Q-P)
      W(2,3)=-0.25*(1.+P)*(-2.*Q+P)
      W(2,5)= 0.25*(1.+P)*(+2.*Q+P)
      W(2,7)= 0.25*(1.-P)*(+2.*Q-P)
 
      W(1,2)=-P*(1.-Q)
      W(1,6)=-P*(1.+Q)
      W(2,2)=-0.5*(1.-P*P)
      W(2,6)= 0.5*(1.-P*P)
  
      W(1,4)= 0.5*(1.-Q*Q)
      W(1,8)=-0.5*(1.-Q*Q)
      W(2,4)=-Q*(1.+P)
      W(2,8)=-Q*(1.-P)
      RETURN

      END
C=============================================================
      SUBROUTINE JAC(W,X,Y,AJ,BJ,DETJ,KEY)
C--------------------------------------------------------------
C
C     Input consists of the Jacobian transformation matrix [J].
C
C     The 'routine then computes ..
C     (1)determinant of [J] 
C     (2)inverse of [J]
C
C---------------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION W(2,8),X(8),Y(8),AJ(2,2),BJ(2,2)
 
      DO 50 I=1,2
      GX=0.
      GY=0.
      DO 40 K=1,8
      GX=GX+W(I,K)*X(K)
 40   GY=GY+W(I,K)*Y(K)
      AJ(I,1)=GX
 50   AJ(I,2)=GY
      DETJ=AJ(1,1)*AJ(2,2)-AJ(1,2)*AJ(2,1)
            IF(DETJ.LT.1.E-06) THEN
            WRITE(6,601)DETJ
            KEY=1
            RETURN
            ENDIF
      REC=1./DETJ
      BJ(1,1)=REC*AJ(2,2)
      BJ(1,2)=-REC*AJ(1,2)
      BJ(2,1)=-REC*AJ(2,1)
      BJ(2,2)=REC*AJ(1,1)
      RETURN
  
 601  FORMAT(' DETJ =',E11.3)
      END
C=========================================================
      SUBROUTINE SF8XY(BJ,W,Q)
C----------------------------------------------------------
C
C     Computes ...
C     (1)Cartesian derivatives of the shape functions.
C
C----------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION W(2,8),Q(2,8)
      DIMENSION BJ(2,2)

      B11=BJ(1,1)
      B12=BJ(1,2)
      B21=BJ(2,1)
      B22=BJ(2,2)
      DO 100 J=1,8
      Q(1,J)=B11*W(1,J)+B12*W(2,J)
 100  Q(2,J)=B21*W(1,J)+B22*W(2,J)
      RETURN

      END
  



C============================================================
      SUBROUTINE DMAT4(CK,E,GNU,D,KLASS)
C------------------------------------------------------------
C
C     Input  ...    Material properties & constant(CK)
C     Output ...    CK*[D]
C
C     KLASS .. This classifies the analysis ...
C            =1 for plane stress
C            =2 for plane strain
C            =3 for axisymmetric
C
C--------------------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 LAMBDA
      DIMENSION D(4,4)


      IF(KLASS.EQ.1)THEN            ! plane stress
         DO 20 I=1,3                ! ------------
         D(3,I)=0.
 20      D(I,3)=0.
         CONST=CK*E/(1.-GNU*GNU)
         D(1,1)=CONST
         D(1,2)=CONST*GNU
         D(2,1)=D(1,2)
         D(2,2)=CONST
         D(3,3)=0.5*CONST*(1.-GNU)
         RETURN
         ENDIF

      IF(KLASS.EQ.2  .OR. KLASS.EQ.3)THEN          ! plane strain & 
         LAMBDA=CK*GNU*E/((1.+GNU)*(1.-2.*GNU))    ! axisymmetric 
         G=0.5*CK*E/(1.+GNU)                       ! ---------------
         DO 120 I=1,3
         DO 110 J=1,3
 110     D(I,J)=LAMBDA
         D(I,I)=LAMBDA+2.*G
         D(I,4)=0.
 120     D(4,I)=0.
         D(4,4)=G
         RETURN
         ENDIF

      END
C=========================================================
      SUBROUTINE BM16(B,Q,S,RAD,KLASS)
C------------------------------------------------------------
C
C     Sets up the [B] matrix using the Cartesian 
C     derivatives in [Q] matrix.
C
C     KLASS  .. classifies the analaysis 
C               (see below)
C
c----------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION Q(2,8),B(4,16),S(8)
     
      DO 10 J=1,16
      DO 10 I=1,4
 10   B(I,J)=0.

      IF(KLASS.EQ.1)THEN                  ! plane stress
         K=1                              ! ------------
         DO 140 J=1,8
         B(1,K  )=Q(1,J)
         B(2,K+1)=Q(2,J)
         B(3,K  )=Q(2,J)
         B(3,K+1)=Q(1,J)
 140     K=K+2
         ENDIF

      IF(KLASS.EQ.2)THEN                  ! plane strain
         K=1                              ! ------------
         DO 240 J=1,8
         B(1,K  )=Q(1,J)
         B(2,K+1)=Q(2,J)
         B(4,K  )=Q(2,J)
         B(4,K+1)=Q(1,J)
 240     K=K+2
         ENDIF

      IF(KLASS.EQ.3)THEN                  ! axisymmetric
         RECIP=0.                         ! ------------
         IF(RAD.GT.1.0E-10) RECIP=1./RAD
         K=1
         DO 340 J=1,8
         B(1,K  )=Q(1,J)
         B(2,K  )=RECIP*S(J)
         B(3,K+1)=Q(2,J)
         B(4,K  )=Q(2,J)
         B(4,K+1)=Q(1,J)
 340     K=K+2
         RETURN
         ENDIF
      END


$ 