C
C     12th Jan 1982 at 1510
C
C
C     FILE .... strsolv.for           
C
C===========================================================
      SUBROUTINE SOLV(NR)
C-----------------------------------------------------------
C
C     Solves the matrix equation set  [A]x=b
C     where [A(n,m)] is in packed form,
C            {x(n)} is uknown vector,
C            {b(n)} is a prescribed rhs vector
C     Here,m is semi-bandwidth+1
C          n is the number of equations
C
C     See  'routines (FORW,RESOLV,BACK) for
C     more details.
C
C-----------------------------------------------------------
      IMPLICIT REAL*8(A-H,O-Z)
      REAL*8 KA,KB,KC,KD,KE,KM
      INCLUDE 'STRESS2D.CCM'    
      
      IF(NR.EQ.1) THEN
                  CALL ASCALE(A,SC,NVABZ,KWIDTH)
                  CALL BSCALE(B,SC,NVABZ)
                  CALL FORW(A,B,C,NVABZ,KWIDTH)
                  ENDIF
      IF(NR.GT.1) THEN
                  CALL BSCALE(B,SC,NVABZ)
                  CALL RESOLV(A,B,C,NVABZ,KWIDTH)
                  ENDIF
      CALL BACK(A,B,C,NVABZ,KWIDTH)
      CALL BSCALE(B,SC,NVABZ)



      RETURN
      END

C--------------------------------------------------------------
      SUBROUTINE FORW(A,B,C,N,M)
C--------------------------------------------------------------
C
C     Transforms the matrix equations
C     [A]x=b to the form [U]x=d     
C     Here,both [A] and [U] are stored
C     in packed form;in array[A(n,m)].
C     Similarly,b and d share the storage 
C     array B(n).
C
C--------------------------------------------------------------
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(N,M),B(N),C(M)
      N1=N-1
      DO 200 NP=1,N1
      RPIV=1./A(NP,1)
      DO 50 J=1,M
 50   C(J)=RPIV*A(NP,J)
      DO 150 K=2,M
      I=K+NP-1
      IF(I.GT.N) GOTO 150
      APK=C(K)
      J=0
      DO 140 L=K,M
      J=J+1
 140  A(I,J)=A(I,J)-APK*A(NP,L)
      B(I)=B(I)-APK*B(NP)
 150  CONTINUE
 200  CONTINUE
      RETURN

      END
C----------------------------------------------------------
      SUBROUTINE RESOLV(A,B,C,N,M)
C----------------------------------------------------------
C
C     Applies Gaussian elimination to rhs vector {B}. 
C      
C---------------------------------------------------------

      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(N,M),B(N),C(M)

      N1=N-1
      DO 200 NP=1,N1
      RPIV=1./A(NP,1)
      DO 50 J=1,M
 50   C(J)=RPIV*A(NP,J)
      DO 150 K=2,M
      I=K+NP-1
      IF(I.GT.N) GOTO 150
      B(I)=B(I)-C(K)*B(NP)
 150  CONTINUE
 200  CONTINUE
      RETURN

      END
C-------------------------------------------------------
      SUBROUTINE BACK(A,B,C,N,M)
C-------------------------------------------------------
C
C     Back-substitution for 
C     equations [U]x=b
C
C----------------------------------------------------

      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION A(N,M),B(N),C(M)

      I=N+1
 100  I=I-1
      IF(I.EQ.0) RETURN
      SUM=0.
      J=I
      DO 200 K=2,M
      J=J+1
      IF(J.GT.N) GOTO 250
 200  SUM=SUM+A(I,K)*B(J)
 250  B(I)=(B(I)-SUM)/A(I,1)
      GOTO 100

      END

C=========================================================
      SUBROUTINE ASCALE(A,SC,N,M)
C--------------------------------------------------------
C
C     (1) Searches through [A] matrix to determine
C         the scaling factors {SC}.
C     (2) Scales [A] matrix
C
C-------------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION A(N,M),SC(N)



      DO 40 I=1,N                 ! determine scaling factors
      T=10.                       ! (powers of 10)
      DIAG=DABS(A(I,1))           ! ------------------------
      IF(DIAG.LT.1.0E-20) GOTO 40
      DO 30 L=2,82,2
      HH=T*T
      IF(DIAG.LT.HH)  GOTO 40
 30   T=10.0*T
               WRITE(6,334)I,IDIAG  ! error diagnostic
               STOP                 ! ----------------
 40   SC(I)=10.0/T
   


      DO 100 I=1,N                ! scale [A]
      SCALI=SC(I)                 ! using {SC}
      DO 80 J=I,N                 ! -----------
      JP=J-I+1                   
      IF(JP.GT.M)  GOTO 100       
 80   A(I,JP)=SCALI*A(I,JP)*SC(J) 
 100  CONTINUE                     
                                 
      RETURN



    
 334  FORMAT(//,' ERROR DIAGNOSTIC .......',/,
     .       ' DIAGONAL TERM OF ROW ',I3,/,
     .       ' IS OUTSIDE ADMISSIBLE RANGE AND IS =',E11.3)
 601  FORMAT(//,' SCALING FACTORS ',/,1H ,15(1H-))
 602  FORMAT(I5,E9.1,I5,E9.1,I5,E9.1,I5,E9.1,I5,E9.1)

      END
C======================================================
      SUBROUTINE BSCALE(B,SC,N)
C-----------------------------------------------------
C
C     Scales/descales the {B} vector using {SC}
C
C----------------------------------------------------

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION B(N),SC(N)

      DO 100 I=1,N
 100  B(I)=SC(I)*B(I)
      RETURN

      END








$ 