          SUBROUTINE STUDSLIP(LOAD_NODE)
C------------------------------------------------------------------     
C       CALCULATES POSITIVE AND NEGATIVE SLIPS @EACH STUD;
C       FOR A TRANSVERSAL OF LOAD IT STORES THE MAX. POSITIVE
C       AND MIN. NEGATIVE SLIP AT EACH STUD AND USES THESE TO
C       CALCULATE THE SHEAR FORCE ENVELOPES FOR THE STUD INTERFACE.
C------------------------------------------------------------------     

      IMPLICIT REAL*8(A-H,O-Z)
      INCLUDE 'STRESS2D.CCM'     !SLIP,SLIPP & SLIPN ARE IN CCM BLOCK
      REAL*8 FORCE(MAXSTUDS),NET_SHEAR
      DIMENSION ENVPOS(MAXSTUDS),ENVNEG(MAXSTUDS),SHEARPOS(MAXSTUDS),
     * SHEARNEG(MAXSTUDS)
      DO 10 I=1,NSG
                       SLIPP(I)=0.0          !IMPORTANT TO INITALIZE
                       SLIPN(I)=0.0          !THESE VALUES

C    ASIDE: NOTE ENVPOS & ENVNEG MUST NOT BE INITIALIZED

        K=NSTUD(I)                !ELEMENT # OF STUD CONNECTION
        NODE1=(LTOP(1,K)*2)-1     !NODE1 IS ON STEEL SIDE OF STUD etc.
        NODE2=(LTOP(2,K)*2)-1     ! "-1" GIVES "X" DISPL.S ONLY->ie B(X)
        SLIP(I)=B(NODE1)-B(NODE2) !STEEL MINUS CONC. DISPL

        FORCE(I) = SLIP(I)*SSS(I)
        NET_SHEAR = NET_SHEAR + FORCE(I)
        WRITE(6,600)K,FORCE(I)

 600  FORMAT(10X,'STUD #',1X,I5,5X,'SHEAR FORCE',F13.3)
 601  FORMAT(//)
C     NOTE:
C     "X" DISPLACEMENT IS POSITIVE WHEN A NODE IS DISPLACED TO THE LEFT;
C     THEREFORE A POSITIVE SLIP IS DEFINED TO OCCUR WHEN THE 'STEEL NODE'
C     OF THE STUD MOVES TO THE LEFT RELATIVE TO THE 'CONCRETE NODE'.
        
        IF(SLIP(I).GT.0.0) THEN          !POSITIVE SLIP?
          SLIPP(I)=SLIP(I)                           
          IF(SLIPP(I).GT.ENVPOS(I)) ENVPOS(I)=SLIPP(I) !ENVELOPE?
        END IF

        IF(SLIP(I).LT.0.0) THEN          !NEGATIVE SLIP?
          SLIPN(I)=SLIP(I)
          IF(SLIPN(I).LT.ENVNEG(I)) ENVNEG(I)=SLIPN(I) !ENVELOPE?
        END IF

        IF(UNI_LIN)  WRITE(6,*)'POSITIVE SLIP ...',SLIPP(I),'STUD',K
        IF(UNI_LIN)  WRITE(6,*)'NEGATIVE SLIP ...',SLIPN(I),'STUD',K
  10  CONTINUE
        WRITE(6,602)NET_SHEAR
        WRITE(6,601)
 602  FORMAT(/,10X,'NET SHEAR FORCE ON INTERFACE IS...',F13.3,/)
        NET_SHEAR = 0.0

      IF(LOAD_NODE.NE.NUM) GOTO 30

      IF(UNI_LIN) THEN
        DO 20 I=1,NSG
          K=NSTUD(I)
          IF(UNI_LIN)  WRITE(6,*)'MAX. POSITIVE SLIP',ENVPOS(I),'STUD',K
          IF(UNI_LIN)  WRITE(6,*)'MIN. NEGATIVE SLIP',ENVNEG(I),'STUD',K
  20    CONTINUE
      END IF

      DO 30 I=1,NSG
          K=NSTUD(I)

          SHEARPOS(I)=ENVPOS(I)*SSS(I)
          SHEARNEG(I)=ENVNEG(I)*SSS(I)
      IF(UNI_LIN)  WRITE(6,*)'MAX. POSITIVE SHEAR',SHEARPOS(I),'STUD',K
      IF(UNI_LIN)  WRITE(6,*)'MIN. NEGATIVE SHEAR',SHEARNEG(I),'STUD',K
  30  CONTINUE

      RETURN
      END

$ 