$!
$!            *%%* WHRREF.COM  *%%*
$!
$!   Command procedure to oversee the refraction analysis of
$!   Wexford harbour. It runs the program LABREFRCT.FOR
$!
$!  NOTES:--
$!            (i)    Enter actual wave period as the 'P1' parameter.
$!            (ii)   Enter (L or H) for P2 (low or high tide).
$!            (iii)  Enter the dirn. for P3 (e.g. SW,NE,WSW etc.)
$!            (iv)   Enter for P4 the code no. corresponding to the 
$!                   wave period used.
$!            (v)    Data are read from the following files --->
$!
$!                     (a) WHRDEPT.GRD             ! fine mesh depth grid
$!                     (b) WHR'P3''P4''P2'.RAY     ! ray co-ords. & init angles
$!                     (c) WHRREF.OPT              ! answers to program options
$!
$!---------------------------------------------------------------------------

$ IF P2.EQS."L" THEN GOTO LOTIDE
$ IF P2.EQS."H" THEN GOTO HITIDE
$!
$LOTIDE: TIDE="0.0"
$ GOTO SKIP
$!
$HITIDE: TIDE="5.7"
$SKIP:
$ OPEN/WRITE PERIOD PERIOD.DAT
$ WRITE PERIOD P1
$ CLOSE PERIOD
$!
$ OPEN/WRITE TIDVAR TIDE.DAT
$ WRITE TIDVAR TIDE
$ CLOSE TIDVAR
$!
$ ASSIGN SYS$COMMAND FOR005
$ ASSIGN/USER SCR:WHR'P3''P4''P2'.OUT FOR066
$ ASSIGN/USER WHRDEPT.GRD FOR008
$ ASSIGN/USER WHR'P3''P4''P2'.RAY FOR077
$ ASSIGN/USER WHRREF.OPT FOR055
$ ASSIGN/USER SCR:WHR'P3''P4''P2'.PLT FOR007
$ ASSIGN/USER PERIOD.DAT FOR012
$ ASSIGN/USER TIDE.DAT FOR013
$!
$ RUN LABREFRCT
$!
$! RUN KK
$!
$ DELETE PERIOD.DAT;*
$ DELETE TIDE.DAT;*
$!
$ EXIT

$ 